/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.items;

import com.magmaguy.elitemobs.api.EliteMobDeathEvent;
import com.magmaguy.elitemobs.config.ItemSettingsConfig;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;

public class DefaultDropsHandler
implements Listener {
    private final List<ItemStack> wornItems = new ArrayList<ItemStack>();

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onDeath(EliteMobDeathEvent event) {
        if (!(event.getEntity() instanceof LivingEntity)) {
            return;
        }
        if (!event.getEliteEntity().isVanillaLoot()) {
            return;
        }
        if (event.getEntityDeathEvent() == null) {
            return;
        }
        List droppedItems = event.getEntityDeathEvent().getDrops();
        int mobLevel = event.getEliteEntity().getLevel();
        if (mobLevel > ItemSettingsConfig.getMaxLevelForDefaultLootMultiplier()) {
            mobLevel = ItemSettingsConfig.getMaxLevelForDefaultLootMultiplier();
        }
        this.inventoryItemsConstructor((LivingEntity)event.getEntity());
        if (ItemSettingsConfig.getDefaultLootMultiplier() != 0.0) {
            for (ItemStack itemStack : droppedItems) {
                if (itemStack == null || itemStack.getType().equals((Object)Material.AIR)) continue;
                boolean itemIsWorn = false;
                for (ItemStack wornItem : this.wornItems) {
                    if (!wornItem.isSimilar(itemStack)) continue;
                    itemIsWorn = true;
                }
                if (itemIsWorn) continue;
                int i = 0;
                while ((double)i < (double)mobLevel * 0.1 * ItemSettingsConfig.getDefaultLootMultiplier()) {
                    event.getEntity().getLocation().getWorld().dropItem(event.getEntity().getLocation(), itemStack);
                    ++i;
                }
            }
        }
        mobLevel = (int)((double)event.getEliteEntity().getLevel() * ItemSettingsConfig.getDefaultExperienceMultiplier());
        int droppedXP = (int)((double)event.getEntityDeathEvent().getDroppedExp() + (double)event.getEntityDeathEvent().getDroppedExp() * 0.1 * (double)mobLevel);
        event.getEntityDeathEvent().setDroppedExp(0);
        ((ExperienceOrb)event.getEntity().getWorld().spawn(event.getEntity().getLocation(), ExperienceOrb.class)).setExperience(droppedXP);
    }

    private List<ItemStack> inventoryItemsConstructor(LivingEntity entity) {
        EntityEquipment equipment = entity.getEquipment();
        if (equipment.getItemInMainHand() != null && !equipment.getItemInMainHand().getType().equals((Object)Material.AIR)) {
            this.wornItems.add(equipment.getItemInMainHand());
        }
        if (equipment.getHelmet() != null) {
            this.wornItems.add(equipment.getHelmet());
        }
        if (equipment.getChestplate() != null) {
            this.wornItems.add(equipment.getChestplate());
        }
        if (equipment.getLeggings() != null) {
            this.wornItems.add(equipment.getLeggings());
        }
        if (equipment.getBoots() != null) {
            this.wornItems.add(equipment.getBoots());
        }
        return this.wornItems;
    }
}

