/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.events;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.adventurersguild.GuildRank;
import com.magmaguy.elitemobs.api.CustomEventStartEvent;
import com.magmaguy.elitemobs.config.EventsConfig;
import com.magmaguy.elitemobs.config.customevents.CustomEventsConfig;
import com.magmaguy.elitemobs.config.customevents.CustomEventsConfigFields;
import com.magmaguy.elitemobs.events.CustomEvent;
import com.magmaguy.elitemobs.mobconstructor.CustomSpawn;
import com.magmaguy.elitemobs.mobconstructor.custombosses.CustomBossEntity;
import com.magmaguy.elitemobs.utils.EventCaller;
import com.magmaguy.elitemobs.utils.WeightedProbability;
import com.magmaguy.magmacore.util.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class TimedEvent
extends CustomEvent
implements Listener {
    protected static List<TimedEvent> blueprintEvents = new ArrayList<TimedEvent>();
    protected static List<TimedEvent> timedEvents = new ArrayList<TimedEvent>();
    private static double nextEventTrigger = (double)System.currentTimeMillis() + 300000.0;
    private static double nextEventStartMinimum = System.currentTimeMillis();
    private final double localCooldown;
    private final double globalCooldown;
    private final double weight;
    private final String filename;
    private double nextLocalEventTrigger = 0.0;
    private CustomSpawn customSpawn;
    private boolean silentRetry = false;

    public TimedEvent(CustomEventsConfigFields customEventsConfigFields) {
        super(customEventsConfigFields);
        this.localCooldown = customEventsConfigFields.getLocalCooldown();
        this.globalCooldown = customEventsConfigFields.getGlobalCooldown();
        this.weight = customEventsConfigFields.getWeight();
        this.filename = customEventsConfigFields.getFilename();
    }

    public static void shutdown() {
        blueprintEvents.clear();
        timedEvents.clear();
    }

    public static void initializeBlueprintEvents() {
        if (!EventsConfig.isTimedEventsEnabled()) {
            return;
        }
        for (CustomEventsConfigFields customEventsConfigFields : CustomEventsConfig.getCustomEvents().values()) {
            if (!customEventsConfigFields.isEnabled() || customEventsConfigFields.getEventType() != CustomEvent.EventType.TIMED) continue;
            blueprintEvents.add(new TimedEvent(customEventsConfigFields));
        }
        TimedEvent.startEventPicker();
    }

    private static void startEventPicker() {
        new BukkitRunnable(){

            public void run() {
                if (Bukkit.getServer().getOnlinePlayers().isEmpty()) {
                    return;
                }
                boolean validPlayer = false;
                for (Player onlinePlayer : Bukkit.getServer().getOnlinePlayers()) {
                    if (GuildRank.isAtOrAboveGuildRank(onlinePlayer, 0, 0)) continue;
                    validPlayer = true;
                    break;
                }
                if (!validPlayer) {
                    return;
                }
                if ((double)System.currentTimeMillis() < nextEventTrigger) {
                    return;
                }
                TimedEvent.pickEvent();
            }
        }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 6000L, 1200L);
    }

    private static void pickEvent() {
        HashMap<String, Double> weighedProbabilities = new HashMap<String, Double>();
        for (TimedEvent timedEvent : blueprintEvents) {
            boolean isRunning = false;
            for (TimedEvent activeTimedEvent : timedEvents) {
                if (activeTimedEvent == null || !activeTimedEvent.getCustomEventsConfigFields().getFilename().equals(timedEvent.getCustomEventsConfigFields().getFilename())) continue;
                isRunning = true;
                break;
            }
            if (isRunning || !(timedEvent.nextLocalEventTrigger < (double)System.currentTimeMillis())) continue;
            weighedProbabilities.put(timedEvent.filename, timedEvent.weight);
        }
        String pickedEvent = WeightedProbability.pickWeighedProbability(weighedProbabilities);
        for (TimedEvent timedEvent : blueprintEvents) {
            if (!timedEvent.filename.equals(pickedEvent)) continue;
            timedEvent.nextLocalEventTrigger = (double)System.currentTimeMillis() + timedEvent.localCooldown * 60.0 * 1000.0;
            timedEvent.instantiateEvent();
            return;
        }
    }

    public void instantiateEvent() {
        Logger.info("Event " + this.getCustomEventsConfigFields().getFilename() + " has been queued!");
        TimedEvent timedEvent = new TimedEvent(this.customEventsConfigFields);
        CustomEventStartEvent customEventStartEvent = new CustomEventStartEvent(timedEvent);
        new EventCaller(customEventStartEvent);
        if (customEventStartEvent.isCancelled()) {
            return;
        }
        timedEvent.customSpawn = new CustomSpawn(this.customEventsConfigFields.getSpawnType(), this.customEventsConfigFields.getBossFilenames(), timedEvent);
        if (timedEvent.customSpawn.getCustomSpawnConfigFields() == null) {
            return;
        }
        timedEvent.customSpawn.setEvent(true);
        timedEvent.customSpawn.queueSpawn();
        this.setNextEventTrigger();
        timedEvents.add(timedEvent);
    }

    private void setNextEventTrigger() {
        this.setNextEventTrigger(this.globalCooldown);
    }

    private void setNextEventTrigger(double timeMinutes) {
        nextEventTrigger = (double)System.currentTimeMillis() + timeMinutes * 60.0 * 1000.0;
    }

    public void queueEvent() {
        this.primaryEliteMobs = this.customSpawn.getCustomBossEntities();
        this.setEventStartLocation(this.customSpawn.getSpawnLocation());
        for (CustomBossEntity customBossEntity : this.primaryEliteMobs) {
            if (customBossEntity.exists()) continue;
            if (!this.silentRetry) {
                Logger.info("Boss " + customBossEntity.getCustomBossesConfigFields().getFilename() + " for event " + this.getCustomEventsConfigFields().getFilename() + " wasn't considered to be valid. Trying spawn again .");
                Logger.info("Note: further failures will be silent. EliteMobs can only predict WorldGuard protections, so it will keep trying to spawn things until plugins preventing spawning allow it to do so. This might take a while.");
                this.silentRetry = true;
            }
            Bukkit.getScheduler().runTaskLater((Plugin)MetadataHandler.PLUGIN, () -> {
                this.customSpawn.setSpawnLocation(null);
                this.customSpawn.queueSpawn();
            }, 1L);
            return;
        }
        this.primaryEliteMobs.forEach(CustomBossEntity::announceSpawn);
        this.setNextEventTrigger(5.0);
        nextEventStartMinimum = (double)System.currentTimeMillis() + (double)(EventsConfig.getTimedEventMinimumCooldown() * 60) * 1000.0;
        this.start();
    }

    @Override
    public void startModifiers() {
        this.nextLocalEventTrigger = (double)System.currentTimeMillis() + this.localCooldown * 60000.0;
    }

    @Override
    public void eventWatchdog() {
    }

    @Override
    public void endModifiers() {
        timedEvents.remove(this);
    }

    @Generated
    public static List<TimedEvent> getBlueprintEvents() {
        return blueprintEvents;
    }

    @Generated
    public static double getNextEventTrigger() {
        return nextEventTrigger;
    }

    @Generated
    public static double getNextEventStartMinimum() {
        return nextEventStartMinimum;
    }
}

