/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.dungeons;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.commands.ReloadCommand;
import com.magmaguy.elitemobs.config.contentpackages.ContentPackagesConfigFields;
import com.magmaguy.elitemobs.config.customitems.CustomItemsConfig;
import com.magmaguy.elitemobs.config.customitems.CustomItemsConfigFields;
import com.magmaguy.elitemobs.dungeons.EMPackage;
import com.magmaguy.magmacore.menus.ContentPackage;
import com.magmaguy.magmacore.util.Logger;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class ItemsPackage
extends EMPackage {
    private final List<CustomItemsConfigFields> customItems = new ArrayList<CustomItemsConfigFields>();
    private boolean allFilesDownloaded = true;

    public ItemsPackage(ContentPackagesConfigFields contentPackagesConfigFields) {
        super(contentPackagesConfigFields);
        for (String customItemFilename : contentPackagesConfigFields.getCustomItemFilenames()) {
            if (CustomItemsConfig.getCustomItems().containsKey(customItemFilename)) {
                this.customItems.add(CustomItemsConfig.getCustomItems().get(customItemFilename));
                continue;
            }
            this.allFilesDownloaded = false;
        }
    }

    @Override
    protected ContentPackage.ContentState getContentState() {
        boolean allInstalled = true;
        boolean someInstalled = false;
        if (this.customItems.isEmpty()) {
            return ContentPackage.ContentState.NOT_DOWNLOADED;
        }
        for (CustomItemsConfigFields customItem : this.customItems) {
            if (!customItem.isEnabled()) {
                allInstalled = false;
            }
            if (!customItem.isEnabled()) continue;
            someInstalled = true;
        }
        if (allInstalled) {
            this.isInstalled = true;
            return ContentPackage.ContentState.INSTALLED;
        }
        if (someInstalled) {
            this.isInstalled = true;
            return ContentPackage.ContentState.PARTIALLY_INSTALLED;
        }
        if (this.allFilesDownloaded) {
            this.isDownloaded = true;
            return ContentPackage.ContentState.NOT_INSTALLED;
        }
        return ContentPackage.ContentState.NOT_DOWNLOADED;
    }

    private void handleInstallation(Player player, boolean enable) {
        player.closeInventory();
        String action = enable ? "Installing" : "Uninstalling";
        Logger.sendMessage((CommandSender)player, action + " " + this.customItems.size() + " items...");
        List<CompletableFuture> futures = this.customItems.stream().map(customItem -> customItem.setEnabledAndSave(enable)).toList();
        Logger.sendMessage((CommandSender)player, "Saving " + this.customItems.size() + " item files...");
        CompletableFuture<Void> allFutures = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
        ((CompletableFuture)allFutures.thenRun(() -> {
            Logger.sendMessage((CommandSender)player, "Reloading EliteMobs to apply item changes!");
            Bukkit.getScheduler().runTask((Plugin)MetadataHandler.PLUGIN, () -> ReloadCommand.reload((CommandSender)player));
        })).join();
    }

    @Override
    public void doInstall(Player player) {
        this.handleInstallation(player, true);
    }

    @Override
    public void doUninstall(Player player) {
        this.handleInstallation(player, false);
    }

    @Override
    public void baseInitialization() {
    }

    @Override
    public void initializeContent() {
    }
}

