/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.dungeons;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.api.DungeonInstallEvent;
import com.magmaguy.elitemobs.api.DungeonUninstallEvent;
import com.magmaguy.elitemobs.config.contentpackages.ContentPackagesConfigFields;
import com.magmaguy.elitemobs.dungeons.CombatContent;
import com.magmaguy.elitemobs.dungeons.EMPackage;
import com.magmaguy.elitemobs.utils.EventCaller;
import com.magmaguy.magmacore.util.ChatColorConverter;
import com.magmaguy.magmacore.util.Logger;
import java.io.File;
import org.apache.commons.io.FileUtils;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class DynamicDungeonPackage
extends EMPackage
implements CombatContent {
    private static final int MIN_LEVEL = 5;
    private static final int MAX_LEVEL = 200;

    public DynamicDungeonPackage(ContentPackagesConfigFields contentPackagesConfigFields) {
        super(contentPackagesConfigFields);
    }

    @Override
    public void doInstall(Player player) {
        DungeonInstallEvent event = new DungeonInstallEvent(this.contentPackagesConfigFields);
        new EventCaller(event);
        this.contentPackagesConfigFields.simpleInstall();
        player.sendMessage(ChatColorConverter.convert("&2Dynamic dungeon " + this.contentPackagesConfigFields.getFilename() + " installed!"));
        player.sendMessage(ChatColorConverter.convert("&6Dynamic dungeons must be accessed either through the &a/em &6menu or an NPC! NPCs for premade EliteMobs content can be found at the Adventurer's Guild Hub map."));
        player.sendMessage("Dynamic dungeons allow you to select the level before entering based on your guild rank!");
        player.sendMessage("Remember that instanced dungeons create a world when you join them and remove that world when you are done playing in them!");
        this.isInstalled = true;
    }

    @Override
    public void doUninstall(Player player) {
        DungeonUninstallEvent event = new DungeonUninstallEvent(this.contentPackagesConfigFields);
        new EventCaller(event);
        this.contentPackagesConfigFields.simpleUninstall();
        this.isInstalled = false;
    }

    @Override
    public void baseInitialization() {
        File file = new File(MetadataHandler.PLUGIN.getDataFolder().getAbsolutePath() + File.separatorChar + "world_blueprints" + File.separatorChar + this.contentPackagesConfigFields.getDungeonConfigFolderName());
        if (!file.exists()) {
            this.isDownloaded = false;
            this.isInstalled = false;
            return;
        }
        for (File worldFile : Bukkit.getWorldContainer().listFiles()) {
            if (!worldFile.getName().contains(file.getName()) || !worldFile.getName().matches(".*_\\d{1,2}$")) continue;
            try {
                FileUtils.deleteDirectory(worldFile);
                Logger.info("Removing previously instanced world " + worldFile.getName());
            }
            catch (Exception e) {
                Logger.warn("Failed to remove previously instanced world " + worldFile.getName());
            }
        }
        this.isDownloaded = true;
        this.isInstalled = this.contentPackagesConfigFields.isEnabled();
    }

    @Override
    public void initializeContent() {
    }

    @Override
    public int getLowestLevel() {
        return 5;
    }

    @Override
    public int getHighestLevel() {
        return 200;
    }
}

