/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.dungeons;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import lombok.Generated;

public class DungeonBossLockout
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<String, Long> lockouts = new HashMap<String, Long>();

    public static String createBossIdentifier(String filename, String spawnLocation) {
        String[] parts = spawnLocation.split(",");
        if (parts.length >= 4) {
            return filename + ":" + parts[1] + "," + parts[2] + "," + parts[3];
        }
        return filename + ":" + spawnLocation;
    }

    public void addLockout(String bossIdentifier, int lockoutMinutes) {
        long expirationTime = System.currentTimeMillis() + (long)lockoutMinutes * 60L * 1000L;
        this.lockouts.put(bossIdentifier, expirationTime);
    }

    public boolean isLockedOut(String bossIdentifier) {
        Long expirationTime = this.lockouts.get(bossIdentifier);
        if (expirationTime == null) {
            return false;
        }
        if (System.currentTimeMillis() >= expirationTime) {
            this.lockouts.remove(bossIdentifier);
            return false;
        }
        return true;
    }

    public long getRemainingLockoutMillis(String bossIdentifier) {
        Long expirationTime = this.lockouts.get(bossIdentifier);
        if (expirationTime == null) {
            return 0L;
        }
        long remaining = expirationTime - System.currentTimeMillis();
        if (remaining <= 0L) {
            this.lockouts.remove(bossIdentifier);
            return 0L;
        }
        return remaining;
    }

    public String getFormattedRemainingTime(String bossIdentifier) {
        long remainingMillis = this.getRemainingLockoutMillis(bossIdentifier);
        if (remainingMillis <= 0L) {
            return "0m";
        }
        long totalMinutes = remainingMillis / 60000L;
        long hours = totalMinutes / 60L;
        long minutes = totalMinutes % 60L;
        if (hours > 0L) {
            return hours + "h " + minutes + "m";
        }
        return minutes + "m";
    }

    public void cleanupExpiredLockouts() {
        long currentTime = System.currentTimeMillis();
        Iterator<Map.Entry<String, Long>> iterator = this.lockouts.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Long> entry = iterator.next();
            if (currentTime < entry.getValue()) continue;
            iterator.remove();
        }
    }

    @Generated
    public Map<String, Long> getLockouts() {
        return this.lockouts;
    }
}

