/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.commands;

import com.magmaguy.elitemobs.config.EconomySettingsConfig;
import com.magmaguy.elitemobs.economy.EconomyHandler;
import com.magmaguy.magmacore.util.ChatColorConverter;
import com.magmaguy.magmacore.util.Round;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CurrencyCommandsHandler {
    public static void payCommand(Player sender, String recipientName, double amount) {
        if (amount <= 0.0) {
            sender.sendMessage(ChatColorConverter.convert("&4[EliteMobs]Nice try."));
            return;
        }
        Player recipient = Bukkit.getPlayer((String)recipientName);
        if (recipient == null) {
            sender.sendMessage(ChatColorConverter.convert("&8[EliteMobs] &4Player " + recipientName + " is not online and can therefore not get a payment."));
            return;
        }
        double senderCurrency = EconomyHandler.checkCurrency(sender.getUniqueId());
        if (senderCurrency - amount < 0.0) {
            sender.sendMessage(ChatColorConverter.convert(EconomySettingsConfig.getEconomyPaymentInsufficientCurrency().replace("$currency_name", EconomySettingsConfig.getCurrencyName())));
            return;
        }
        double actuallyReceivedAmount = Round.twoDecimalPlaces(amount - amount * EconomySettingsConfig.getPlayerToPlayerTaxes());
        double taxes = Round.twoDecimalPlaces(amount * EconomySettingsConfig.getPlayerToPlayerTaxes());
        EconomyHandler.addCurrency(recipient.getUniqueId(), actuallyReceivedAmount);
        EconomyHandler.subtractCurrency(sender.getUniqueId(), amount);
        sender.sendMessage(ChatColorConverter.convert(EconomySettingsConfig.getEconomyPayMessage().replace("$amount_sent", "" + amount).replace("$amount_received", "" + actuallyReceivedAmount).replace("$taxes", "" + taxes).replace("$currency_name", EconomySettingsConfig.getCurrencyName()).replace("$receiver", recipient.getDisplayName())));
        sender.sendMessage(ChatColorConverter.convert(EconomySettingsConfig.getEconomyCurrencyLeftMessage().replace("$amount_left", String.valueOf(EconomyHandler.checkCurrency(sender.getUniqueId()))).replace("$currency_name", EconomySettingsConfig.getCurrencyName())));
        recipient.sendMessage(ChatColorConverter.convert(EconomySettingsConfig.getEconomyPaymentReceivedMessage().replace("$amount_sent", "" + amount).replace("$amount_received", "" + actuallyReceivedAmount).replace("$taxes", "" + taxes).replace("$sender", sender.getDisplayName()).replace("$currency_name", EconomySettingsConfig.getCurrencyName())));
        recipient.sendMessage(ChatColorConverter.convert(EconomySettingsConfig.getEconomyCurrencyLeftMessage().replace("$amount_left", String.valueOf(EconomyHandler.checkCurrency(recipient.getUniqueId()))).replace("$currency_name", EconomySettingsConfig.getCurrencyName())));
    }

    public static void addCommand(Player player, double amount) {
        EconomyHandler.addCurrency(player.getUniqueId(), amount);
    }

    public static void addCommand(CommandSender commandSender, String onlinePlayer, double amount) {
        Player player = Bukkit.getPlayer((String)onlinePlayer);
        if (player == null) {
            commandSender.sendMessage(ChatColorConverter.convert("&8[EliteMobs] &4Player " + onlinePlayer + " &4is not valid!"));
            return;
        }
        CurrencyCommandsHandler.addCommand(player, amount);
        commandSender.sendMessage(ChatColorConverter.convert("&8[EliteMobs] &2You have added " + amount + " to " + onlinePlayer));
        commandSender.sendMessage(ChatColorConverter.convert("&8[EliteMobs] &2They now have " + EconomyHandler.checkCurrency(player.getUniqueId())));
    }

    public static void addAllCommand(CommandSender commandSender, double amount) {
        for (Player player : Bukkit.getOnlinePlayers()) {
            CurrencyCommandsHandler.addCommand(player, amount);
        }
        commandSender.sendMessage(ChatColorConverter.convert("&8[EliteMobs] &2You have added " + amount + " to all online players."));
    }

    public static void subtractCommand(String playerName, double amount) {
        EconomyHandler.subtractCurrency(Bukkit.getPlayer((String)playerName).getUniqueId(), amount);
    }

    public static void subtractCommand(CommandSender commandSender, String onlinePlayer, int amount) {
        Player player = Bukkit.getPlayer((String)onlinePlayer);
        if (player == null) {
            commandSender.sendMessage(ChatColorConverter.convert("&8[EliteMobs] &4Player " + onlinePlayer + " &4is not valid!"));
            return;
        }
        CurrencyCommandsHandler.subtractCommand(onlinePlayer, amount);
        commandSender.sendMessage(ChatColorConverter.convert("&8[EliteMobs] &2You have subtracted " + amount + " from " + onlinePlayer));
        commandSender.sendMessage(ChatColorConverter.convert("&8[EliteMobs]They now have " + EconomyHandler.checkCurrency(player.getUniqueId())));
    }

    public static void setCommand(CommandSender commandSender, String onlinePlayer, double amount) {
        Player player = Bukkit.getPlayer((String)onlinePlayer);
        if (player == null) {
            commandSender.sendMessage(ChatColorConverter.convert("&8[EliteMobs] &4Player " + onlinePlayer + " &4is not valid!"));
            return;
        }
        EconomyHandler.setCurrency(player.getUniqueId(), amount);
        commandSender.sendMessage("You set " + onlinePlayer + "'s " + EconomySettingsConfig.getCurrencyName() + " to " + amount);
    }

    public static void checkCommand(CommandSender commandSender, String playerName) {
        Player player = Bukkit.getPlayer((String)playerName);
        if (player == null) {
            commandSender.sendMessage(ChatColorConverter.convert("&8[EliteMobs] &4Player " + playerName + " &4is not valid!"));
            return;
        }
        double money = EconomyHandler.checkCurrency(player.getUniqueId());
        commandSender.sendMessage(ChatColorConverter.convert("&8[EliteMobs]&f " + playerName + " &2has " + money + " " + EconomySettingsConfig.getCurrencyName()));
    }

    public static void walletCommand(Player player) {
        player.sendMessage(ChatColorConverter.convert(EconomySettingsConfig.getEconomyWalletCommand().replace("$balance", String.valueOf(EconomyHandler.checkCurrency(player.getUniqueId()))).replace("$currency_name", EconomySettingsConfig.getCurrencyName())));
    }
}

