/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.api;

import com.magmaguy.elitemobs.entitytracker.EntityTracker;
import com.magmaguy.elitemobs.mobconstructor.EliteEntity;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;

public class EliteMobTargetPlayerEvent
extends Event {
    private static final HandlerList handlers = new HandlerList();
    private final Entity entity;
    private final EliteEntity eliteEntity;
    private final Player player;
    private final EntityTargetLivingEntityEvent entityTargetLivingEntityEvent;

    public EliteMobTargetPlayerEvent(EliteEntity eliteEntity, Player player, EntityTargetLivingEntityEvent event) {
        this.entity = event.getEntity();
        this.eliteEntity = eliteEntity;
        this.player = player;
        this.entityTargetLivingEntityEvent = event;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    public Entity getEntity() {
        return this.entity;
    }

    public EliteEntity getEliteMobEntity() {
        return this.eliteEntity;
    }

    public Player getPlayer() {
        return this.player;
    }

    public EntityTargetLivingEntityEvent entityTargetLivingEntityEvent() {
        return this.entityTargetLivingEntityEvent;
    }

    public HandlerList getHandlers() {
        return handlers;
    }

    public static class EliteMobTargetPlayerEventFilter
    implements Listener {
        @EventHandler
        public void onMobTarget(EntityTargetLivingEntityEvent event) {
            LivingEntity livingEntity = event.getTarget();
            if (!(livingEntity instanceof Player)) {
                return;
            }
            Player player = (Player)livingEntity;
            EliteEntity eliteEntity = EntityTracker.getEliteMobEntity(event.getEntity());
            if (eliteEntity == null) {
                return;
            }
            if (player.getGameMode().equals((Object)GameMode.ADVENTURE) || player.getGameMode().equals((Object)GameMode.SURVIVAL)) {
                Bukkit.getServer().getPluginManager().callEvent((Event)new EliteMobTargetPlayerEvent(eliteEntity, player, event));
            }
        }
    }
}

