/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.magmacore.menus;

import com.magmaguy.magmacore.MagmaCore;
import com.magmaguy.magmacore.menus.AdvancedMenu;
import com.magmaguy.magmacore.menus.MenuButton;
import com.magmaguy.magmacore.util.ChatColorConverter;
import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class FirstTimeSetupMenu {
    private final List<Integer> archetypeSlots = List.of(Integer.valueOf(11), Integer.valueOf(15), Integer.valueOf(13));
    private final Player player;
    private final List<MenuButton> menuItems;
    private final MenuButton infoItem;

    public FirstTimeSetupMenu(Player player, String title, String subtitle, MenuButton infoButton, List<MenuButton> menuButtons) {
        this.animateTitle(player, title, subtitle);
        this.player = player;
        this.menuItems = menuButtons;
        this.infoItem = infoButton;
    }

    private void createMenu() {
        AdvancedMenu advancedMenu = new AdvancedMenu(this.player, this.menuItems.isEmpty() ? 9 : 18);
        advancedMenu.addAdvancedMenuItem(4, this.infoItem);
        for (int i = 0; i < this.menuItems.size(); ++i) {
            advancedMenu.addAdvancedMenuItem(this.archetypeSlots.get(i), this.menuItems.get(i));
        }
        advancedMenu.openInventory(this.player);
    }

    private void animateTitle(final Player player, final String title, final String subtitle) {
        new BukkitRunnable(){
            int counter = 0;

            public void run() {
                ++this.counter;
                if (this.counter > title.length() + subtitle.length() + 60) {
                    this.cancel();
                    FirstTimeSetupMenu.this.createMenu();
                    return;
                }
                String titleSequence = ChatColorConverter.convert(title.substring(0, Math.min(this.counter, title.length())));
                int subtitleCounter = Math.min(this.counter - title.length(), subtitle.length());
                String subtitleSequence = "";
                if (subtitleCounter > 0) {
                    subtitleSequence = ChatColorConverter.convert(subtitle.substring(0, subtitleCounter));
                }
                player.sendTitle(titleSequence, subtitleSequence, 0, 2, 2);
            }
        }.runTaskTimer((Plugin)MagmaCore.getInstance().getRequestingPlugin(), 0L, 1L);
    }
}

