/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.versionnotifier;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.dungeons.EMPackage;
import com.magmaguy.magmacore.util.ChatColorConverter;
import com.magmaguy.magmacore.util.Logger;
import com.magmaguy.magmacore.util.SpigotMessage;
import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import lombok.Generated;
import net.md_5.bungee.api.chat.BaseComponent;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class VersionChecker {
    private static final List<EMPackage> outdatedPackages = new ArrayList<EMPackage>();
    private static final boolean SHA1Updated = false;
    private static final int MAX_RETRY_ATTEMPTS = 3;
    private static final int RETRY_DELAY_SECONDS = 60;
    private static boolean pluginIsUpToDate = true;
    private static boolean connectionFailed = false;
    private static int connectionRetryCount = 0;

    private VersionChecker() {
    }

    public static boolean serverVersionOlderThan(int majorVersion, int minorVersion) {
        String[] splitVersion = Bukkit.getBukkitVersion().split("[.]");
        int actualMajorVersion = Integer.parseInt(splitVersion[1].split("-")[0]);
        int actualMinorVersion = 0;
        if (splitVersion.length > 2) {
            actualMinorVersion = Integer.parseInt(splitVersion[2].split("-")[0]);
        }
        if (actualMajorVersion < majorVersion) {
            return true;
        }
        if (splitVersion.length > 2) {
            return actualMajorVersion == majorVersion && actualMinorVersion < minorVersion;
        }
        return false;
    }

    private static void checkPluginVersion() {
        new BukkitRunnable(){

            public void run() {
                String currentVersion = MetadataHandler.PLUGIN.getDescription().getVersion();
                boolean snapshot = false;
                if (currentVersion.contains("SNAPSHOT")) {
                    snapshot = true;
                    currentVersion = currentVersion.split("-")[0];
                }
                String publicVersion = "";
                try {
                    publicVersion = VersionChecker.readStringFromURL("https://api.spigotmc.org/legacy/update.php?resource=40090");
                    Logger.info("Latest public release is " + publicVersion);
                    Logger.info("Your version is " + MetadataHandler.PLUGIN.getDescription().getVersion());
                }
                catch (IOException e) {
                    VersionChecker.handleConnectionError("plugin version check", e);
                    return;
                }
                if (Double.parseDouble(currentVersion.split("\\.")[0]) < Double.parseDouble(publicVersion.split("\\.")[0])) {
                    VersionChecker.outOfDateHandler();
                    return;
                }
                if (Double.parseDouble(currentVersion.split("\\.")[0]) == Double.parseDouble(publicVersion.split("\\.")[0])) {
                    if (Double.parseDouble(currentVersion.split("\\.")[1]) < Double.parseDouble(publicVersion.split("\\.")[1])) {
                        VersionChecker.outOfDateHandler();
                        return;
                    }
                    if (Double.parseDouble(currentVersion.split("\\.")[1]) == Double.parseDouble(publicVersion.split("\\.")[1]) && Double.parseDouble(currentVersion.split("\\.")[2]) < Double.parseDouble(publicVersion.split("\\.")[2])) {
                        VersionChecker.outOfDateHandler();
                        return;
                    }
                }
                if (!snapshot) {
                    Logger.info("You are running the latest version!");
                } else {
                    Logger.info("You are running a snapshot version! You can check for updates in the #releases channel on the EliteMobs Discord!");
                }
                pluginIsUpToDate = true;
            }
        }.runTaskAsynchronously((Plugin)MetadataHandler.PLUGIN);
    }

    private static void checkContentVersion() {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)MetadataHandler.PLUGIN, () -> {
            block2: {
                try {
                    String remoteVersions = VersionChecker.readStringFromURL("https://www.magmaguy.com/api/elitemobs_content");
                    connectionFailed = false;
                    connectionRetryCount = 0;
                    String[] lines = remoteVersions.split("\n");
                    VersionChecker.processContentVersionData(lines);
                }
                catch (IOException e) {
                    VersionChecker.handleConnectionError("content version check", e);
                    if (connectionRetryCount < 3 && (e instanceof UnknownHostException || e instanceof ConnectException || e instanceof SocketTimeoutException)) break block2;
                    Logger.info("Using local data for content version checks as remote server is unavailable.");
                }
            }
        });
    }

    private static void processContentVersionData(String[] lines) {
        for (EMPackage emPackage : EMPackage.getEmPackages().values()) {
            if (!emPackage.isInstalled() || !emPackage.getContentPackagesConfigFields().isDefaultDungeon()) continue;
            boolean containedInMetaPackage = false;
            for (EMPackage metaPackage : EMPackage.getEmPackages().values()) {
                if (metaPackage.getContentPackagesConfigFields().getContainedPackages() == null || metaPackage.getContentPackagesConfigFields().getContainedPackages().isEmpty() || !metaPackage.getContentPackagesConfigFields().getContainedPackages().contains(emPackage.getContentPackagesConfigFields().getFilename())) continue;
                containedInMetaPackage = true;
                break;
            }
            if (containedInMetaPackage) continue;
            boolean checked = false;
            for (String line : lines) {
                if (!line.startsWith(emPackage.getContentPackagesConfigFields().getFilename().replace(".yml", ""))) continue;
                String[] split = line.split(":");
                int remoteVersion = 0;
                try {
                    remoteVersion = Integer.parseInt(split[1].trim());
                }
                catch (Exception e) {
                    Logger.warn("Remote version substring: " + split[1].trim());
                    e.printStackTrace();
                }
                if (remoteVersion > emPackage.getContentPackagesConfigFields().getDungeonVersion()) {
                    emPackage.setOutOfDate(true);
                    outdatedPackages.add(emPackage);
                    Logger.warn("Content " + emPackage.getContentPackagesConfigFields().getName() + " is outdated! You should go download the updated version! Your version: " + emPackage.getContentPackagesConfigFields().getDungeonVersion() + " / remote version: " + remoteVersion + " / Link: " + emPackage.getContentPackagesConfigFields().getDownloadLink());
                }
                checked = true;
                break;
            }
            if (checked) continue;
            Logger.warn("Failed to check content " + emPackage.getContentPackagesConfigFields().getFilename() + " ! The remote server doesn't have a version listed for it, report it to the developer!");
        }
    }

    private static void handleConnectionError(String checkType, Exception e) {
        connectionFailed = true;
        if (e instanceof UnknownHostException || e instanceof ConnectException || e instanceof SocketTimeoutException) {
            if (++connectionRetryCount <= 3) {
                Logger.warn("Network error during " + checkType + ". Will retry in 60 seconds (Attempt " + connectionRetryCount + "/3)");
                Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)MetadataHandler.PLUGIN, () -> VersionChecker.checkContentVersion(), 1200L);
            } else {
                Logger.warn("Failed to connect for " + checkType + " after 3 attempts. Will continue without version checking. Error: " + e.getMessage());
            }
        } else {
            Logger.warn("Error during " + checkType + ": " + e.getMessage());
            if (e.getCause() != null) {
                Logger.warn("Caused by: " + e.getCause().getMessage());
            }
        }
    }

    private static String readStringFromURL(String url) throws IOException {
        try (Scanner scanner = new Scanner(new URL(url).openStream(), StandardCharsets.UTF_8);){
            scanner.useDelimiter("\\A");
            String string = scanner.hasNext() ? scanner.next() : "";
            return string;
        }
    }

    private static void outOfDateHandler() {
        Logger.warn("[EliteMobs] A newer version of this plugin is available for download!");
        pluginIsUpToDate = false;
    }

    public static void check() {
        VersionChecker.checkPluginVersion();
        VersionChecker.checkContentVersion();
    }

    @Generated
    public static boolean isSHA1Updated() {
        return false;
    }

    public static class VersionCheckerEvents
    implements Listener {
        @EventHandler
        public void onPlayerLogin(final PlayerJoinEvent event) {
            if (!event.getPlayer().hasPermission("elitemobs.versionnotification")) {
                return;
            }
            new BukkitRunnable(){

                public void run() {
                    if (!event.getPlayer().isOnline()) {
                        return;
                    }
                    if (connectionFailed && event.getPlayer().hasPermission("elitemobs.admin")) {
                        event.getPlayer().sendMessage(ChatColorConverter.convert("&8[EliteMobs] &eWarning: Could not connect to update servers. Version checking is currently unavailable. Check your internet connection or try again later."));
                    }
                    if (!pluginIsUpToDate) {
                        event.getPlayer().sendMessage(ChatColorConverter.convert("&cYour version of EliteMobs is outdated. &aYou can download the latest version from &3&n&ohttps://nightbreak.io/plugin/elitemobs/"));
                    }
                    if (!outdatedPackages.isEmpty()) {
                        Logger.sendSimpleMessage((CommandSender)event.getPlayer(), "&8&m-----------------------------------------------------");
                        Logger.sendMessage((CommandSender)event.getPlayer(), "&cThe following dungeons are outdated:");
                        for (EMPackage emPackage : outdatedPackages) {
                            String name = emPackage.getContentPackagesConfigFields().getName();
                            String link = emPackage.getContentPackagesConfigFields().getDownloadLink();
                            if (link != null && !link.isEmpty()) {
                                event.getPlayer().spigot().sendMessage((BaseComponent)SpigotMessage.hoverLinkMessage("&c- " + name, ChatColorConverter.convert("&9Click to go to download link!"), link));
                                continue;
                            }
                            event.getPlayer().sendMessage(ChatColorConverter.convert("&c- " + name + " &7(no download link available)"));
                        }
                        event.getPlayer().spigot().sendMessage(new BaseComponent[]{SpigotMessage.simpleMessage("&8[EliteMobs]&f You can download the update at "), SpigotMessage.hoverLinkMessage("&9&nhttps://nightbreak.io/plugin/elitemobs/#content", "Click for Nightbreak link", "https://nightbreak.io/plugin/elitemobs/#content"), SpigotMessage.simpleMessage(" !")});
                        event.getPlayer().spigot().sendMessage(new BaseComponent[]{SpigotMessage.simpleMessage("&2Updating is quick & easy! "), SpigotMessage.hoverLinkMessage("&9&nClick here", "Click for wiki link", "https://nightbreak.io/plugin/elitemobs/#setup"), SpigotMessage.simpleMessage(" &2for info on how to install updates and "), SpigotMessage.hoverLinkMessage("&9&nhere", "Discord support link", "https://discord.gg/9f5QSka"), SpigotMessage.simpleMessage(" &2for the support room.")});
                        Logger.sendSimpleMessage((CommandSender)event.getPlayer(), "&8&m-----------------------------------------------------");
                    }
                }
            }.runTaskLater((Plugin)MetadataHandler.PLUGIN, 60L);
        }
    }
}

