/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.quests.objectives;

import com.magmaguy.elitemobs.api.EliteMobDeathEvent;
import com.magmaguy.elitemobs.config.custombosses.CustomBossesConfig;
import com.magmaguy.elitemobs.mobconstructor.EliteEntity;
import com.magmaguy.elitemobs.mobconstructor.custombosses.CustomBossEntity;
import com.magmaguy.elitemobs.quests.objectives.KillObjective;
import com.magmaguy.elitemobs.quests.objectives.QuestObjectives;
import lombok.Generated;

public class CustomKillObjective
extends KillObjective {
    private final String customBossFilename;

    public CustomKillObjective(String customBossFilename, int targetKillAmount, int questLevel) {
        super(targetKillAmount, CustomBossesConfig.getCustomBosses().get(customBossFilename).getCleanName(questLevel * 10));
        this.customBossFilename = customBossFilename;
    }

    @Override
    public void checkProgress(EliteMobDeathEvent event, QuestObjectives questObjectives) {
        EliteEntity eliteEntity = event.getEliteEntity();
        if (!(eliteEntity instanceof CustomBossEntity)) {
            return;
        }
        CustomBossEntity customBossEntity = (CustomBossEntity)eliteEntity;
        String filename = customBossEntity.getCustomBossesConfigFields().getFilename();
        if (customBossEntity.getPhaseBossEntity() != null) {
            filename = customBossEntity.getPhaseBossEntity().getPhase1Config().getFilename();
        }
        if (!filename.equals(this.customBossFilename)) {
            return;
        }
        this.progressObjective(questObjectives);
    }

    @Generated
    public String getCustomBossFilename() {
        return this.customBossFilename;
    }
}

