/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.powers.scripts;

import com.magmaguy.elitemobs.entitytracker.EntityTracker;
import com.magmaguy.elitemobs.mobconstructor.EliteEntity;
import com.magmaguy.elitemobs.powers.scripts.EliteScript;
import com.magmaguy.elitemobs.powers.scripts.ScriptActionData;
import com.magmaguy.elitemobs.powers.scripts.ScriptRelativeVector;
import com.magmaguy.elitemobs.powers.scripts.ScriptZone;
import com.magmaguy.elitemobs.powers.scripts.caching.ScriptTargetsBlueprint;
import com.magmaguy.elitemobs.utils.ConfigurationLocation;
import com.magmaguy.magmacore.util.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class ScriptTargets {
    private final ScriptTargetsBlueprint targetBlueprint;
    private final EliteScript eliteScript;
    private final ScriptZone scriptZone;
    private List anonymousTargets = null;
    private ScriptRelativeVector scriptRelativeVector = null;

    public ScriptTargets(ScriptTargetsBlueprint targetBlueprint, EliteScript eliteScript) {
        this.targetBlueprint = targetBlueprint;
        this.eliteScript = eliteScript;
        this.scriptZone = eliteScript.getScriptZone();
    }

    public List getAnonymousTargets(boolean locations, ScriptActionData scriptActionData) {
        if (this.anonymousTargets != null) {
            return this.anonymousTargets;
        }
        if (locations) {
            return this.getTargetLocations(scriptActionData).stream().toList();
        }
        return this.getTargetEntities(scriptActionData).stream().toList();
    }

    public void setAnonymousTargets(List anonymousTargets) {
        if (this.getTargetBlueprint().isTrack() || this.eliteScript.getScriptZone().getZoneBlueprint().getAnimationDuration().getValue() > 1) {
            return;
        }
        this.anonymousTargets = anonymousTargets;
    }

    public Location processLocationFromString(EliteEntity eliteEntity, String locationString, ScriptActionData scriptActionData) {
        if (locationString == null) {
            Logger.warn("Failed to get location target in script " + this.targetBlueprint.getScriptName() + " in " + this.eliteScript.getFileName());
            return null;
        }
        Location parsedLocation = ConfigurationLocation.serialize(locationString);
        if (parsedLocation.getWorld() == null && locationString.split(",")[0].equalsIgnoreCase("same_as_boss")) {
            parsedLocation.setWorld(eliteEntity.getLocation().getWorld());
        }
        this.addOffsets(parsedLocation, scriptActionData);
        return parsedLocation;
    }

    protected void cacheTargets(ScriptActionData scriptActionData) {
        if (this.getTargetBlueprint().isTrack()) {
            if (this.eliteScript.getScriptZone().isValid() && this.eliteScript.getScriptZone().getZoneBlueprint().getAnimationDuration().getValue() > 0) {
                this.getTargetBlueprint().setTrack(false);
            } else {
                return;
            }
        }
        boolean animatedScriptZone = false;
        if (this.eliteScript.getScriptZone().isValid()) {
            scriptActionData.setShapesCachedByTarget(this.eliteScript.getScriptZone().generateShapes(scriptActionData, true));
            if (this.eliteScript.getScriptZone().getZoneBlueprint().getAnimationDuration().getValue() > 0) {
                animatedScriptZone = true;
            }
            this.anonymousTargets = null;
        }
        if (!animatedScriptZone) {
            this.anonymousTargets = new ArrayList<Location>(this.getTargetLocations(scriptActionData));
        }
        if (!this.getTargetBlueprint().isTrack() && this.targetBlueprint.getScriptRelativeVectorBlueprint() != null) {
            this.scriptRelativeVector = new ScriptRelativeVector(this.targetBlueprint.getScriptRelativeVectorBlueprint(), this.eliteScript, null);
            this.scriptRelativeVector.cacheVector(scriptActionData);
        }
    }

    protected Collection<LivingEntity> getTargetEntities(ScriptActionData scriptActionData) {
        if (this.getTargetBlueprint().isTrack() && this.anonymousTargets != null && (this.anonymousTargets.isEmpty() || this.anonymousTargets.get(0) instanceof LivingEntity)) {
            return this.anonymousTargets;
        }
        Location eliteEntityLocation = scriptActionData.getEliteEntity().getLocation();
        if (this.targetBlueprint == null) {
            Logger.warn("An action tried to run with an invalid target! Check which on it is by reading the startup logs and fix it! No target will be acquired for now.");
            return new ArrayList<LivingEntity>();
        }
        switch (this.targetBlueprint.getTargetType()) {
            case ALL_PLAYERS: {
                return new ArrayList<LivingEntity>(Bukkit.getOnlinePlayers());
            }
            case WORLD_PLAYERS: {
                return new ArrayList<LivingEntity>(eliteEntityLocation.getWorld().getPlayers());
            }
            case NEARBY_PLAYERS: {
                return eliteEntityLocation.getWorld().getNearbyEntities(eliteEntityLocation, (double)this.targetBlueprint.getRange().getValue().floatValue(), (double)this.targetBlueprint.getRange().getValue().floatValue(), (double)this.targetBlueprint.getRange().getValue().floatValue(), entity -> entity.getType() == EntityType.PLAYER).stream().map(Player.class::cast).collect(Collectors.toSet());
            }
            case NEARBY_MOBS: {
                return eliteEntityLocation.getWorld().getNearbyEntities(eliteEntityLocation, (double)this.targetBlueprint.getRange().getValue().floatValue(), (double)this.targetBlueprint.getRange().getValue().floatValue(), (double)this.targetBlueprint.getRange().getValue().floatValue(), entity -> entity.getType() != EntityType.PLAYER && entity instanceof LivingEntity && !entity.getUniqueId().equals(scriptActionData.getEliteEntity().getUnsyncedLivingEntity().getUniqueId())).stream().map(LivingEntity.class::cast).collect(Collectors.toSet());
            }
            case NEARBY_ELITES: {
                return eliteEntityLocation.getWorld().getNearbyEntities(eliteEntityLocation, (double)this.targetBlueprint.getRange().getValue().floatValue(), (double)this.targetBlueprint.getRange().getValue().floatValue(), (double)this.targetBlueprint.getRange().getValue().floatValue(), entity -> EntityTracker.isEliteMob(entity) && !entity.getUniqueId().equals(scriptActionData.getEliteEntity().getUnsyncedLivingEntity().getUniqueId())).stream().map(LivingEntity.class::cast).collect(Collectors.toSet());
            }
            case DIRECT_TARGET: {
                return new ArrayList<LivingEntity>(List.of(scriptActionData.getDirectTarget()));
            }
            case SELF: 
            case SELF_SPAWN: {
                return new ArrayList<LivingEntity>(List.of(scriptActionData.getEliteEntity().getUnsyncedLivingEntity()));
            }
            case ZONE_FULL: 
            case ZONE_BORDER: 
            case INHERIT_SCRIPT_ZONE_FULL: 
            case INHERIT_SCRIPT_ZONE_BORDER: {
                return this.eliteScript.getScriptZone().getZoneEntities(scriptActionData, this.targetBlueprint);
            }
            case INHERIT_SCRIPT_TARGET: {
                if (scriptActionData.getInheritedScriptActionData() != null) {
                    try {
                        return scriptActionData.getInheritedScriptActionData().getScriptTargets().getAnonymousTargets(false, scriptActionData.getInheritedScriptActionData());
                    }
                    catch (Exception Ex) {
                        Logger.warn("Failed to get entity from INHERIT_SCRIPT_TARGET because the script inherits a location, not an entity");
                        break;
                    }
                }
                Logger.warn("Failed to get INHERIT_SCRIPT_TARGET because the script is not called by another script!");
                return new ArrayList<LivingEntity>();
            }
        }
        Logger.warn("Could not find default target for script in " + this.eliteScript.getFileName());
        return null;
    }

    protected Collection<Location> getTargetLocations(ScriptActionData scriptActionData) {
        Object e;
        if (this.anonymousTargets != null && !this.anonymousTargets.isEmpty() && (e = this.anonymousTargets.get(0)) instanceof Location) {
            Location location = (Location)e;
            return this.anonymousTargets;
        }
        Collection<Location> newLocations = null;
        switch (this.getTargetBlueprint().getTargetType()) {
            case ALL_PLAYERS: 
            case WORLD_PLAYERS: 
            case NEARBY_PLAYERS: 
            case NEARBY_MOBS: 
            case NEARBY_ELITES: 
            case DIRECT_TARGET: 
            case SELF: {
                return this.getTargetEntities(scriptActionData).stream().map(targetEntity -> this.addOffsets(targetEntity.getLocation(), scriptActionData)).collect(Collectors.toSet());
            }
            case SELF_SPAWN: {
                return new ArrayList<Location>(List.of(this.addOffsets(scriptActionData.getEliteEntity().getSpawnLocation(), scriptActionData)));
            }
            case LOCATION: {
                return new ArrayList<Location>(List.of(this.getLocation(scriptActionData.getEliteEntity(), scriptActionData)));
            }
            case LOCATIONS: {
                return this.getLocations(scriptActionData.getEliteEntity(), scriptActionData);
            }
            case LANDING_LOCATION: {
                return new ArrayList<Location>(List.of(scriptActionData.getLandingLocation().clone()));
            }
            case ZONE_FULL: 
            case ZONE_BORDER: {
                newLocations = this.getLocationFromZone(scriptActionData);
                break;
            }
            case INHERIT_SCRIPT_ZONE_FULL: 
            case INHERIT_SCRIPT_ZONE_BORDER: {
                newLocations = this.getLocationFromZone(scriptActionData.getInheritedScriptActionData());
                break;
            }
            case INHERIT_SCRIPT_TARGET: {
                return scriptActionData.getInheritedScriptActionData().getScriptTargets().getAnonymousTargets(true, scriptActionData.getInheritedScriptActionData());
            }
            case ACTION_TARGET: {
                return new ArrayList<Location>();
            }
            default: {
                Logger.warn("Failed to get target type in script " + this.getTargetBlueprint().getScriptName() + " ! Type was: " + this.getTargetBlueprint().getTargetType());
            }
        }
        if (this.targetBlueprint.getCoverage().getValue().floatValue() < 1.0f) {
            newLocations.removeIf(targetLocation -> ThreadLocalRandom.current().nextDouble() > (double)this.targetBlueprint.getCoverage().getValue().floatValue());
        }
        return newLocations;
    }

    private Collection<Location> getLocationFromZone(ScriptActionData scriptActionData) {
        if (scriptActionData.getScriptZone() == null) {
            Logger.warn("Your script " + this.targetBlueprint.getScriptName() + " uses " + this.targetBlueprint.getTargetType().toString() + " but does not have a valid Zone defined!");
            return new ArrayList<Location>();
        }
        return this.addOffsets(this.eliteScript.getScriptZone().getZoneLocations(scriptActionData, this), scriptActionData);
    }

    private Collection<Location> getLocations(EliteEntity eliteEntity, ScriptActionData scriptActionData) {
        return this.targetBlueprint.getLocations().stream().map(rawLocation -> this.processLocationFromString(eliteEntity, (String)rawLocation, scriptActionData)).collect(Collectors.toSet());
    }

    private Location getLocation(EliteEntity eliteEntity, ScriptActionData scriptActionData) {
        return this.processLocationFromString(eliteEntity, this.targetBlueprint.getLocation(), scriptActionData);
    }

    private Location addOffsets(Location originalLocation, ScriptActionData scriptActionData) {
        Location location = originalLocation.clone().add(this.targetBlueprint.getOffset().getValue());
        if (this.targetBlueprint.getScriptRelativeVectorBlueprint() == null) {
            return location;
        }
        this.scriptRelativeVector = new ScriptRelativeVector(this.targetBlueprint.getScriptRelativeVectorBlueprint(), this.eliteScript, location);
        location.add(this.scriptRelativeVector.getVector(scriptActionData));
        return location;
    }

    private Collection<Location> addOffsets(Collection<Location> locations, ScriptActionData scriptActionData) {
        if (this.targetBlueprint.getOffset().getValue().length() == 0.0 && this.scriptRelativeVector == null) {
            return locations;
        }
        locations.forEach(entry -> this.addOffsets((Location)entry, scriptActionData));
        return locations;
    }

    @Generated
    public ScriptTargetsBlueprint getTargetBlueprint() {
        return this.targetBlueprint;
    }

    @Generated
    public EliteScript getEliteScript() {
        return this.eliteScript;
    }

    @Generated
    public ScriptZone getScriptZone() {
        return this.scriptZone;
    }

    @Generated
    public ScriptRelativeVector getScriptRelativeVector() {
        return this.scriptRelativeVector;
    }
}

