/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.powers;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.api.EliteMobDamagedByPlayerEvent;
import com.magmaguy.elitemobs.config.MobCombatSettingsConfig;
import com.magmaguy.elitemobs.config.powers.PowersConfig;
import com.magmaguy.elitemobs.powers.meta.MajorPower;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Giant;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class ZombieBloat
extends MajorPower
implements Listener {
    public ZombieBloat() {
        super(PowersConfig.getPower("zombie_bloat.yml"));
    }

    @EventHandler
    public void onHit(final EliteMobDamagedByPlayerEvent event) {
        ZombieBloat zombieBloat = (ZombieBloat)event.getEliteMobEntity().getPower(this);
        if (zombieBloat == null) {
            return;
        }
        if (zombieBloat.isInGlobalCooldown()) {
            return;
        }
        if (ThreadLocalRandom.current().nextDouble() > 0.2) {
            return;
        }
        zombieBloat.doGlobalCooldown(200);
        new BukkitRunnable(){
            final LivingEntity eventZombie;
            int timer;
            {
                this.eventZombie = (LivingEntity)event.getEntity();
                this.timer = 0;
            }

            public void run() {
                if (this.timer > 40) {
                    ZombieBloat.this.bloatEffect(this.eventZombie);
                    this.cancel();
                }
                if (this.timer == 21) {
                    this.eventZombie.setAI(false);
                }
                if (MobCombatSettingsConfig.isEnableWarningVisualEffects()) {
                    this.eventZombie.getWorld().spawnParticle(Particle.TOTEM_OF_UNDYING, new Location(this.eventZombie.getWorld(), this.eventZombie.getLocation().getX(), this.eventZombie.getLocation().getY() + this.eventZombie.getHeight(), this.eventZombie.getLocation().getZ()), 20, (double)(this.timer / 24), (double)this.timer / 9.0, (double)this.timer / 24.0, 0.1);
                }
                ++this.timer;
            }
        }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 0L, 1L);
    }

    private void bloatEffect(final LivingEntity eventZombie) {
        final Giant giant = (Giant)eventZombie.getWorld().spawnEntity(eventZombie.getLocation(), EntityType.GIANT);
        giant.setAI(false);
        List nearbyEntities = giant.getNearbyEntities(4.0, 15.0, 4.0);
        ArrayList<LivingEntity> nearbyValidLivingEntities = new ArrayList<LivingEntity>();
        if (nearbyEntities.size() > 0) {
            for (Entity entity : nearbyEntities) {
                if (!(entity instanceof LivingEntity) || entity.equals(eventZombie)) continue;
                nearbyValidLivingEntities.add((LivingEntity)entity);
            }
        }
        Location entityLocation = eventZombie.getLocation();
        for (LivingEntity livingEntity : nearbyValidLivingEntities) {
            Location livingEntityLocation = livingEntity.getLocation();
            Vector toLivingEntityVector = livingEntityLocation.subtract(entityLocation).toVector();
            Vector normalizedVector = toLivingEntityVector.normalize();
            normalizedVector = normalizedVector.multiply(new Vector(2, 0, 2)).add(new Vector(0, 1, 0));
            try {
                livingEntity.setVelocity(normalizedVector);
            }
            catch (Exception e) {
                livingEntity.setVelocity(new Vector(0.0, 1.5, 0.0));
            }
        }
        this.livingEntityEffect(nearbyValidLivingEntities);
        new BukkitRunnable(){

            public void run() {
                giant.remove();
                eventZombie.setAI(true);
            }
        }.runTaskLater((Plugin)MetadataHandler.PLUGIN, 10L);
    }

    private void livingEntityEffect(final List<LivingEntity> livingEntities) {
        if (livingEntities.size() == 0) {
            return;
        }
        if (!MobCombatSettingsConfig.isEnableWarningVisualEffects()) {
            return;
        }
        new BukkitRunnable(){
            int counter = 0;

            public void run() {
                if ((double)this.counter > 30.0) {
                    this.cancel();
                }
                for (LivingEntity livingEntity : livingEntities) {
                    if (livingEntity == null || livingEntity.isDead() || !livingEntity.isValid()) continue;
                    livingEntity.getWorld().spawnParticle(Particle.CLOUD, new Location(livingEntity.getWorld(), livingEntity.getLocation().getX(), livingEntity.getLocation().getY() + livingEntity.getHeight() - 1.0, livingEntity.getLocation().getZ()), 0, 0.0, 0.0, 0.0);
                }
                ++this.counter;
            }
        }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 0L, 1L);
    }
}

