/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.powers;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.api.EliteMobDamagedByPlayerEvent;
import com.magmaguy.elitemobs.config.powers.PowersConfig;
import com.magmaguy.elitemobs.mobconstructor.EliteEntity;
import com.magmaguy.elitemobs.mobconstructor.custombosses.CustomBossEntity;
import com.magmaguy.elitemobs.powers.meta.BossPower;
import com.magmaguy.elitemobs.powers.meta.ElitePower;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class SummonEmbers
extends BossPower
implements Listener {
    public SummonEmbers() {
        super(PowersConfig.getPower("summon_embers.yml"));
    }

    @EventHandler
    public void onDamage(EliteMobDamagedByPlayerEvent event) {
        SummonEmbers summonEmbers = (SummonEmbers)event.getEliteMobEntity().getPower(this);
        if (summonEmbers == null) {
            return;
        }
        if (!SummonEmbers.eventIsValid(event, (ElitePower)summonEmbers)) {
            return;
        }
        if (ThreadLocalRandom.current().nextDouble() > 0.25) {
            return;
        }
        summonEmbers.doGlobalCooldown(400, event.getEliteMobEntity());
        this.doSummonParticles(event.getEliteMobEntity());
    }

    private void doSummonParticles(final EliteEntity eliteEntity) {
        eliteEntity.getLivingEntity().setAI(false);
        new BukkitRunnable(){
            int counter = 0;

            public void run() {
                ++this.counter;
                if (!eliteEntity.isValid()) {
                    this.cancel();
                    return;
                }
                eliteEntity.getLivingEntity().getWorld().spawnParticle(Particle.FLAME, eliteEntity.getLivingEntity().getLocation().add(new Vector(0, 1, 0)), 50, 1.0E-4, 1.0E-4, 1.0E-4);
                if (this.counter < 60) {
                    return;
                }
                this.cancel();
                SummonEmbers.this.doSummon(eliteEntity);
                eliteEntity.getLivingEntity().setAI(true);
            }
        }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 0L, 1L);
    }

    private void doSummon(EliteEntity eliteEntity) {
        for (int i = 0; i < 10; ++i) {
            Location spawnLocation = eliteEntity.getLivingEntity().getLocation();
            CustomBossEntity.createCustomBossEntity("ember.yml").spawn(spawnLocation, eliteEntity.getLevel(), false);
            double x = ThreadLocalRandom.current().nextDouble() - 0.5;
            double z = ThreadLocalRandom.current().nextDouble() - 0.5;
            eliteEntity.getLivingEntity().setVelocity(new Vector(x, 0.5, z));
        }
    }
}

