/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.powers;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.config.powers.PowersConfig;
import com.magmaguy.elitemobs.events.BossCustomAttackDamage;
import com.magmaguy.elitemobs.explosionregen.Explosion;
import com.magmaguy.elitemobs.mobconstructor.EliteEntity;
import com.magmaguy.elitemobs.powers.meta.CombatEnterScanPower;
import com.magmaguy.elitemobs.utils.EnderDragonPhaseSimplifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.block.Block;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Vector;

public class EnderDragonShockwave
extends CombatEnterScanPower {
    private final int radius = 30;
    private final ArrayList<PieBlock> realBlocks = new ArrayList();
    private ArrayList<PieBlock> pieBlocks = new ArrayList();
    private int warningPhaseCounter = 0;
    private int damagePhaseCounter = 0;

    public EnderDragonShockwave() {
        super(PowersConfig.getPower("ender_dragon_shockwave.yml"));
    }

    @Override
    protected void finishActivation(final EliteEntity eliteEntity) {
        this.bukkitTask = new BukkitRunnable(){

            public void run() {
                EnderDragon.Phase phase;
                if (EnderDragonShockwave.this.doExit(eliteEntity) || EnderDragonShockwave.this.isInCooldown(eliteEntity)) {
                    return;
                }
                if (eliteEntity.getLivingEntity().getType().equals((Object)EntityType.ENDER_DRAGON) && !EnderDragonPhaseSimplifier.isLanded(phase = ((EnderDragon)eliteEntity.getLivingEntity()).getPhase())) {
                    return;
                }
                EnderDragonShockwave.this.doPower(eliteEntity);
            }
        }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 0L, 10L);
    }

    private void doPower(final EliteEntity eliteEntity) {
        this.doCooldown(eliteEntity);
        new BukkitRunnable(){
            int counter = 0;

            public void run() {
                if (eliteEntity.isValid() && eliteEntity.getLivingEntity().getType().equals((Object)EntityType.ENDER_DRAGON)) {
                    ((EnderDragon)eliteEntity.getLivingEntity()).setPhase(EnderDragon.Phase.SEARCH_FOR_BREATH_ATTACK_TARGET);
                }
                if (EnderDragonShockwave.this.doExit(eliteEntity) || eliteEntity.getLivingEntity().getType().equals((Object)EntityType.ENDER_DRAGON) && !EnderDragonPhaseSimplifier.isLanded(((EnderDragon)eliteEntity.getLivingEntity()).getPhase())) {
                    this.cancel();
                    return;
                }
                if (this.counter == 0) {
                    EnderDragonShockwave.this.setAffectedBlocks();
                    EnderDragonShockwave.this.generateRealCircle(eliteEntity);
                    EnderDragonShockwave.this.warningPhaseCounter = 0;
                    EnderDragonShockwave.this.damagePhaseCounter = 0;
                }
                if (this.counter < 60) {
                    EnderDragonShockwave.this.doWarningPhase(eliteEntity);
                }
                if (this.counter > 60) {
                    EnderDragonShockwave.this.doDamagePhase(eliteEntity);
                }
                if (this.counter >= 180) {
                    this.cancel();
                }
                ++this.counter;
            }
        }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 0L, 1L);
    }

    private void setAffectedBlocks() {
        this.pieBlocks = new ArrayList();
        double rotation = ThreadLocalRandom.current().nextDouble(2.0);
        Vector relative0 = new Vector(0, 0, 0);
        for (int x = -30; x < 30; ++x) {
            for (int z = -30; z < 30; ++z) {
                double distance;
                if (x > 0 && z > 0 || (distance = relative0.distance(new Vector(x, 0, z))) > 30.0) continue;
                this.pieBlocks.add(new PieBlock((int)Math.ceil(distance), new Vector(x, 0, z).rotateAroundY(rotation)));
            }
        }
    }

    private void generateRealCircle(EliteEntity eliteEntity) {
        block0: for (PieBlock pieBlock : this.pieBlocks) {
            Location rawPieBlock = eliteEntity.getLivingEntity().getLocation().clone().add(pieBlock.vector);
            for (int y = 0; y > -10; --y) {
                Location tempLocation = rawPieBlock.clone();
                tempLocation.setY(rawPieBlock.getY() + (double)y);
                if (tempLocation.getBlock().isPassable()) continue;
                Vector newVector = pieBlock.vector.clone();
                newVector.setY(newVector.getY() + (double)y);
                this.realBlocks.add(new PieBlock(pieBlock.distance, newVector));
                continue block0;
            }
        }
    }

    private void doWarningPhase(EliteEntity eliteEntity) {
        Iterator pieBlockIterator = ((ArrayList)this.realBlocks.clone()).iterator();
        while (pieBlockIterator.hasNext()) {
            PieBlock pieBlock = (PieBlock)pieBlockIterator.next();
            if (pieBlock.distance >= this.warningPhaseCounter) continue;
            Location rawPieBlock = eliteEntity.getLivingEntity().getLocation().clone().add(pieBlock.vector);
            pieBlockIterator.remove();
            if (rawPieBlock.getBlock().isPassable()) continue;
            rawPieBlock.getWorld().spawnParticle(Particle.SOUL, rawPieBlock.clone().add(0.5, 1.0, 0.5), 1, 0.1, 0.1, 0.1, 0.1);
        }
        ++this.warningPhaseCounter;
    }

    private void doDamagePhase(EliteEntity eliteEntity) {
        ArrayList<Block> blockList = new ArrayList<Block>();
        Iterator<PieBlock> pieBlockIterator = this.realBlocks.iterator();
        while (pieBlockIterator.hasNext()) {
            Location rawPieBlock;
            if (eliteEntity.getLivingEntity() == null) {
                return;
            }
            PieBlock pieBlock = pieBlockIterator.next();
            if (pieBlock.distance >= this.damagePhaseCounter || (rawPieBlock = eliteEntity.getLivingEntity().getLocation().clone().add(pieBlock.vector)).getBlock().isPassable()) continue;
            for (Entity entity : rawPieBlock.getWorld().getNearbyEntities(new BoundingBox(rawPieBlock.getX(), rawPieBlock.getY(), rawPieBlock.getZ(), rawPieBlock.getX() + 1.0, rawPieBlock.getY() + 3.0, rawPieBlock.getZ() + 1.0))) {
                if (entity.getType().equals((Object)EntityType.FALLING_BLOCK)) continue;
                entity.setVelocity(entity.getLocation().clone().subtract(eliteEntity.getLivingEntity().getLocation()).toVector().setY(1).normalize().multiply(3));
                if (!entity.getType().equals((Object)EntityType.PLAYER)) continue;
                BossCustomAttackDamage.dealCustomDamage(eliteEntity.getLivingEntity(), (LivingEntity)entity, 20.0);
            }
            if (rawPieBlock.getBlock().getType().getBlastResistance() >= 7.0f) continue;
            blockList.add(rawPieBlock.getBlock());
            pieBlockIterator.remove();
        }
        ++this.damagePhaseCounter;
        Explosion.generateFakeExplosion(blockList, (Entity)eliteEntity.getLivingEntity());
    }

    @Override
    protected void finishDeactivation(EliteEntity eliteEntity) {
    }

    private class PieBlock {
        public Integer distance;
        public Vector vector;

        public PieBlock(Integer distance, Vector vector) {
            this.distance = distance;
            this.vector = vector;
        }
    }
}

