/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.menus;

import com.magmaguy.elitemobs.api.utils.EliteItemManager;
import com.magmaguy.elitemobs.config.DefaultConfig;
import com.magmaguy.elitemobs.config.EconomySettingsConfig;
import com.magmaguy.elitemobs.config.menus.premade.SellMenuConfig;
import com.magmaguy.elitemobs.economy.EconomyHandler;
import com.magmaguy.elitemobs.items.ItemWorthCalculator;
import com.magmaguy.elitemobs.items.customenchantments.SoulbindEnchantment;
import com.magmaguy.elitemobs.menus.EliteMenu;
import com.magmaguy.elitemobs.menus.SharedShopElements;
import com.magmaguy.magmacore.util.ChatColorConverter;
import com.magmaguy.magmacore.util.ItemStackGenerator;
import com.magmaguy.magmacore.util.Round;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class SellMenu
extends EliteMenu
implements Listener {
    private static final List<Integer> validSlots = SellMenuConfig.storeSlots;
    public static Set<Inventory> inventories = new HashSet<Inventory>();

    private static double calculateShopValue(Inventory shopInventory, Player player) {
        double itemWorth = 0.0;
        for (Integer validSlot : validSlots) {
            ItemStack itemStack = shopInventory.getItem(validSlot.intValue());
            if (itemStack == null) continue;
            itemWorth += ItemWorthCalculator.determineResaleWorth(itemStack, player) * (double)itemStack.getAmount();
        }
        return itemWorth;
    }

    private static ItemStack updateConfirmButton(double itemWorth) {
        ItemStack clonedConfirmButton = SellMenuConfig.confirmButton.clone();
        ArrayList<String> lore = new ArrayList<String>();
        for (String string : clonedConfirmButton.getItemMeta().getLore()) {
            lore.add(string.replace("$currency_amount", "" + itemWorth).replace("$currency_name", EconomySettingsConfig.getCurrencyName()));
        }
        ItemMeta clonedMeta = clonedConfirmButton.getItemMeta();
        clonedMeta.setLore(lore);
        clonedConfirmButton.setItemMeta(clonedMeta);
        return clonedConfirmButton;
    }

    public void constructSellMenu(Player player) {
        Object menuName = SellMenuConfig.shopName;
        if (DefaultConfig.useResourcePackModels()) {
            menuName = ChatColor.WHITE + "\uf801\udb80\udc5b\uf805          " + (String)menuName;
        }
        Inventory sellInventory = Bukkit.createInventory((InventoryHolder)player, (int)54, (String)menuName);
        for (int i = 0; i < 54; ++i) {
            if (i == SellMenuConfig.infoSlot) {
                sellInventory.setItem(i, SellMenuConfig.infoButton);
                continue;
            }
            if (i == SellMenuConfig.cancelSlot) {
                sellInventory.setItem(i, SellMenuConfig.cancelButton);
                continue;
            }
            if (i == SellMenuConfig.confirmSlot) {
                ItemStack clonedConfirmButton = SellMenuConfig.confirmButton.clone();
                ArrayList<String> lore = new ArrayList<String>();
                for (String string : SellMenuConfig.confirmButton.getItemMeta().getLore()) {
                    lore.add(string.replace("$currency_amount", "0").replace("$currency_name", EconomySettingsConfig.getCurrencyName()));
                }
                SellMenuConfig.confirmButton.getItemMeta().setLore(lore);
                ItemMeta clonedMeta = clonedConfirmButton.getItemMeta();
                clonedMeta.setLore(lore);
                clonedConfirmButton.setItemMeta(clonedMeta);
                sellInventory.setItem(i, clonedConfirmButton);
                continue;
            }
            if (validSlots.contains(i) || !DefaultConfig.isUseGlassToFillMenuEmptySpace()) continue;
            sellInventory.setItem(i, ItemStackGenerator.generateItemStack(Material.GLASS_PANE));
        }
        player.openInventory(sellInventory);
        SellMenu.createEliteMenu(sellInventory, inventories);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!SellMenu.isEliteMenu(event, inventories)) {
            return;
        }
        event.setCancelled(true);
        Player player = (Player)event.getWhoClicked();
        ItemStack currentItem = event.getCurrentItem();
        Inventory shopInventory = event.getView().getTopInventory();
        Inventory playerInventory = event.getView().getBottomInventory();
        if (!SharedShopElements.itemNullPointerPrevention(event)) {
            return;
        }
        if (SellMenu.isBottomMenu(event)) {
            if (!EliteItemManager.isEliteMobsItem(event.getCurrentItem())) {
                event.getWhoClicked().sendMessage(ChatColorConverter.convert(EconomySettingsConfig.getShopSaleInstructions()));
                return;
            }
            if (!SoulbindEnchantment.isValidSoulbindUser(currentItem.getItemMeta(), player)) {
                player.sendMessage(ChatColorConverter.convert(EconomySettingsConfig.getShopSaleOthersItems()));
                return;
            }
            int firstEmptySlot = -1;
            for (int i : validSlots) {
                if (shopInventory.getItem(i) != null) continue;
                firstEmptySlot = i;
                break;
            }
            if (firstEmptySlot == -1) {
                return;
            }
            shopInventory.setItem(firstEmptySlot, currentItem);
            playerInventory.clear(event.getSlot());
            event.getInventory().setItem(SellMenuConfig.confirmSlot, SellMenu.updateConfirmButton(SellMenu.calculateShopValue(shopInventory, player)));
        } else {
            if (currentItem.equals((Object)SellMenuConfig.infoButton)) {
                return;
            }
            if (event.getSlot() == SellMenuConfig.confirmSlot) {
                int amount = (int)validSlots.stream().filter(validSlot -> shopInventory.getItem(validSlot.intValue()) != null).count();
                double totalItemValue = 0.0;
                for (Integer validSlot2 : validSlots) {
                    ItemStack itemStack = shopInventory.getItem(validSlot2.intValue());
                    if (itemStack == null) continue;
                    double itemValue = ItemWorthCalculator.determineResaleWorth(itemStack, player) * (double)itemStack.getAmount();
                    EconomyHandler.addCurrency(player.getUniqueId(), itemValue);
                    totalItemValue += itemValue;
                    if (amount < 4) {
                        player.sendMessage(ChatColorConverter.convert(EconomySettingsConfig.getShopSellMessage().replace("$item_name", itemStack.getItemMeta().getDisplayName()).replace("$currency_amount", "" + Round.twoDecimalPlaces(itemValue)).replace("$currency_name", EconomySettingsConfig.getCurrencyName())));
                    }
                    shopInventory.clear(validSlot2.intValue());
                }
                if (amount >= 3) {
                    player.sendMessage(ChatColorConverter.convert(EconomySettingsConfig.getShopBatchSellMessage().replace("$currency_amount", "" + totalItemValue).replace("$currency_name", EconomySettingsConfig.getCurrencyName())));
                }
                player.sendMessage(ChatColorConverter.convert(EconomySettingsConfig.getShopCurrentBalance().replace("$currency_amount", "" + EconomyHandler.checkCurrency(player.getUniqueId())).replace("$currency_name", EconomySettingsConfig.getCurrencyName())));
                SellMenu.updateConfirmButton(0.0);
                return;
            }
            if (event.getSlot() == SellMenuConfig.cancelSlot) {
                event.getWhoClicked().closeInventory();
                return;
            }
            if (!validSlots.contains(event.getSlot())) {
                return;
            }
            playerInventory.addItem(new ItemStack[]{event.getCurrentItem()});
            shopInventory.clear(event.getSlot());
            event.getInventory().setItem(SellMenuConfig.confirmSlot, SellMenu.updateConfirmButton(SellMenu.calculateShopValue(shopInventory, player)));
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        if (inventories.contains(event.getInventory())) {
            inventories.remove(event.getInventory());
            EliteMenu.cancel(event.getPlayer(), event.getView().getTopInventory(), event.getView().getBottomInventory(), SellMenuConfig.storeSlots);
        }
    }
}

