/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.menus;

import com.magmaguy.elitemobs.api.utils.EliteItemManager;
import com.magmaguy.elitemobs.config.CustomModelsConfig;
import com.magmaguy.elitemobs.config.DefaultConfig;
import com.magmaguy.elitemobs.config.EconomySettingsConfig;
import com.magmaguy.elitemobs.config.ItemSettingsConfig;
import com.magmaguy.elitemobs.config.menus.premade.ScrapperMenuConfig;
import com.magmaguy.elitemobs.items.customenchantments.RepairEnchantment;
import com.magmaguy.elitemobs.items.customenchantments.SoulbindEnchantment;
import com.magmaguy.elitemobs.menus.EliteMenu;
import com.magmaguy.elitemobs.utils.CustomModelAdder;
import com.magmaguy.magmacore.util.ChatColorConverter;
import com.magmaguy.magmacore.util.ItemStackGenerator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ScrapperMenu
extends EliteMenu {
    private static final List<Integer> validSlots = ScrapperMenuConfig.storeSlots;
    public static Set<Inventory> inventories = new HashSet<Inventory>();

    public void constructScrapMenu(Player player) {
        Object menuName = ScrapperMenuConfig.shopName;
        if (DefaultConfig.useResourcePackModels()) {
            menuName = ChatColor.WHITE + "\uf801\udb80\udc2b\uf805         " + (String)menuName;
        }
        Inventory scrapInventory = Bukkit.createInventory((InventoryHolder)player, (int)54, (String)menuName);
        for (int i = 0; i < 54; ++i) {
            if (i == ScrapperMenuConfig.infoSlot) {
                ItemStack infoButton = ScrapperMenuConfig.infoButton;
                if (DefaultConfig.useResourcePackModels()) {
                    infoButton.setType(Material.PAPER);
                    CustomModelAdder.addCustomModel(infoButton, CustomModelsConfig.goldenQuestionMark);
                    ItemMeta itemMeta = infoButton.getItemMeta();
                    ArrayList parsedLore = new ArrayList();
                    itemMeta.getLore().forEach(entry -> parsedLore.add(entry.replace("$chance", "" + ScrapperMenuConfig.scrapChance * 100.0)));
                    itemMeta.setLore((List)parsedLore);
                    infoButton.setItemMeta(itemMeta);
                }
                scrapInventory.setItem(i, infoButton);
                continue;
            }
            if (i == ScrapperMenuConfig.cancelSlot) {
                scrapInventory.setItem(i, ScrapperMenuConfig.cancelButton);
                continue;
            }
            if (i == ScrapperMenuConfig.confirmSlot) {
                ItemStack clonedConfirmButton = ScrapperMenuConfig.confirmButton.clone();
                ArrayList<String> lore = new ArrayList<String>();
                for (String string : ScrapperMenuConfig.confirmButton.getItemMeta().getLore()) {
                    lore.add(string.replace("$chance", "" + ScrapperMenuConfig.scrapChance * 100.0));
                }
                ScrapperMenuConfig.confirmButton.getItemMeta().setLore(lore);
                ItemMeta clonedMeta = clonedConfirmButton.getItemMeta();
                clonedMeta.setLore(lore);
                clonedConfirmButton.setItemMeta(clonedMeta);
                scrapInventory.setItem(i, clonedConfirmButton);
                continue;
            }
            if (validSlots.contains(i) || !DefaultConfig.isUseGlassToFillMenuEmptySpace()) continue;
            scrapInventory.setItem(i, ItemStackGenerator.generateItemStack(Material.GLASS_PANE));
        }
        player.openInventory(scrapInventory);
        ScrapperMenu.createEliteMenu(scrapInventory, inventories);
    }

    public static class ScrapperMenuEvents
    implements Listener {
        @EventHandler(ignoreCancelled=true)
        public void onInventoryInteract(InventoryClickEvent event) {
            if (!EliteMenu.isEliteMenu(event, inventories)) {
                return;
            }
            event.setCancelled(true);
            Player player = (Player)event.getWhoClicked();
            ItemStack currentItem = event.getCurrentItem();
            Inventory shopInventory = event.getView().getTopInventory();
            Inventory playerInventory = event.getView().getBottomInventory();
            if (currentItem == null) {
                return;
            }
            if (EliteMenu.isBottomMenu(event)) {
                if (!EliteItemManager.isEliteMobsItem(event.getCurrentItem())) {
                    event.getWhoClicked().sendMessage(ChatColorConverter.convert(EconomySettingsConfig.getShopSaleInstructions()));
                    return;
                }
                if (!SoulbindEnchantment.isValidSoulbindUser(currentItem.getItemMeta(), player)) {
                    player.sendMessage(ChatColorConverter.convert(EconomySettingsConfig.getShopSaleOthersItems()));
                    return;
                }
                for (int slot : ScrapperMenuConfig.storeSlots) {
                    if (shopInventory.getItem(slot) != null) continue;
                    shopInventory.setItem(slot, currentItem);
                    playerInventory.clear(event.getSlot());
                    break;
                }
            } else if (EliteMenu.isTopMenu(event)) {
                if (currentItem.equals((Object)ScrapperMenuConfig.infoButton)) {
                    return;
                }
                if (event.getSlot() == ScrapperMenuConfig.confirmSlot) {
                    int successes = 0;
                    int failures = 0;
                    for (Integer validSlot : validSlots) {
                        ItemStack itemStack = shopInventory.getItem(validSlot.intValue());
                        if (itemStack == null) continue;
                        ItemStack scrapItem = RepairEnchantment.generateScrap(itemStack, player, null);
                        for (int i = 0; i < itemStack.getAmount(); ++i) {
                            if (ThreadLocalRandom.current().nextDouble() > ScrapperMenuConfig.scrapChance) {
                                ++failures;
                                continue;
                            }
                            player.getWorld().dropItem(player.getLocation(), scrapItem);
                            ++successes;
                        }
                        itemStack.setAmount(0);
                    }
                    if (successes > 0) {
                        player.sendMessage(ChatColorConverter.convert(ItemSettingsConfig.getScrapSucceededMessage().replace("$amount", "" + successes)));
                    }
                    if (failures > 0) {
                        player.sendMessage(ChatColorConverter.convert(ItemSettingsConfig.getScrapFailedMessage().replace("$amount", "" + failures)));
                    }
                    return;
                }
                if (event.getSlot() == ScrapperMenuConfig.cancelSlot) {
                    player.closeInventory();
                    return;
                }
                if (!validSlots.contains(event.getSlot())) {
                    return;
                }
                EliteMenu.moveItemDown(event.getView().getTopInventory(), event.getSlot(), (HumanEntity)player);
            }
        }

        @EventHandler
        public void onClose(InventoryCloseEvent event) {
            if (inventories.contains(event.getInventory())) {
                inventories.remove(event.getInventory());
                EliteMenu.cancel(event.getPlayer(), event.getView().getTopInventory(), event.getView().getBottomInventory(), validSlots);
            }
        }
    }
}

