/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.items.itemconstructor;

import com.magmaguy.elitemobs.config.ItemSettingsConfig;
import com.magmaguy.elitemobs.config.enchantments.EnchantmentsConfig;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemQualityColorizer {
    public static ItemQuality getItemQuality(ItemStack itemStack) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        int enchantmentCount = 0;
        if (!itemMeta.getEnchants().isEmpty()) {
            for (Enchantment enchantment : itemMeta.getEnchants().keySet()) {
                enchantmentCount += itemMeta.getEnchantLevel(enchantment);
            }
        }
        double enchantPercentage = 0.0;
        if (ItemQualityColorizer.maxRankCalculator(itemStack) > 0) {
            enchantPercentage = enchantmentCount * 100 / ItemQualityColorizer.maxRankCalculator(itemStack);
        }
        if (enchantPercentage > 100.0) {
            return ItemQuality.LIGHT_BLUE;
        }
        if (enchantPercentage > 80.0) {
            return ItemQuality.GOLD;
        }
        if (enchantPercentage > 64.0) {
            return ItemQuality.PURPLE;
        }
        if (enchantPercentage > 48.0) {
            return ItemQuality.BLUE;
        }
        if (enchantPercentage > 32.0) {
            return ItemQuality.GREEN;
        }
        if (enchantPercentage > 16.0) {
            return ItemQuality.WHITE;
        }
        return ItemQuality.GRAY;
    }

    public static void dropQualityColorizer(ItemStack itemStack) {
        if (ItemSettingsConfig.isDoMmorpgColors()) {
            ItemMeta itemMeta = itemStack.getItemMeta();
            int enchantmentCount = 0;
            if (!itemMeta.getEnchants().isEmpty()) {
                for (Enchantment enchantment : itemMeta.getEnchants().keySet()) {
                    enchantmentCount += itemMeta.getEnchantLevel(enchantment);
                }
            }
            double enchantPercentage = 0.0;
            if (ItemQualityColorizer.maxRankCalculator(itemStack) > 0) {
                enchantPercentage = enchantmentCount * 100 / ItemQualityColorizer.maxRankCalculator(itemStack);
            }
            if (enchantPercentage > 100.0) {
                ItemQualityColorizer.colorizeBoldNameAndLore(ChatColor.DARK_AQUA, itemMeta);
            } else {
                itemMeta = enchantPercentage > 80.0 ? ItemQualityColorizer.colorizeNameAndLore(ChatColor.GOLD, itemMeta) : (enchantPercentage > 64.0 ? ItemQualityColorizer.colorizeNameAndLore(ChatColor.DARK_PURPLE, itemMeta) : (enchantPercentage > 48.0 ? ItemQualityColorizer.colorizeNameAndLore(ChatColor.BLUE, itemMeta) : (enchantPercentage > 32.0 ? ItemQualityColorizer.colorizeNameAndLore(ChatColor.GREEN, itemMeta) : (enchantPercentage > 16.0 ? ItemQualityColorizer.colorizeNameAndLore(ChatColor.WHITE, itemMeta) : ItemQualityColorizer.colorizeNameAndLore(ChatColor.GRAY, itemMeta)))));
            }
            itemStack.setItemMeta(itemMeta);
        }
    }

    private static ItemMeta colorizeNameAndLore(ChatColor chatColor, ItemMeta itemMeta) {
        itemMeta.setDisplayName(chatColor + itemMeta.getDisplayName());
        ArrayList<CallSite> list = new ArrayList<CallSite>();
        if (itemMeta.getLore() != null) {
            for (String string : itemMeta.getLore()) {
                if (string.isEmpty()) continue;
                String colorizedString = chatColor + ChatColor.ITALIC + string;
                list.add((CallSite)((Object)colorizedString));
            }
            itemMeta.setLore(list);
        }
        return itemMeta;
    }

    private static ItemMeta colorizeBoldNameAndLore(ChatColor chatColor, ItemMeta itemMeta) {
        if (itemMeta.getDisplayName().equals(ChatColor.stripColor((String)itemMeta.getDisplayName()))) {
            itemMeta.setDisplayName(chatColor + ChatColor.BOLD + itemMeta.getDisplayName());
        }
        ArrayList<CallSite> list = new ArrayList<CallSite>();
        if (itemMeta.getLore() != null && !itemMeta.getLore().isEmpty()) {
            for (String string : itemMeta.getLore()) {
                if (string.isEmpty()) continue;
                String colorizedString = chatColor + ChatColor.BOLD + ChatColor.ITALIC + string;
                list.add((CallSite)((Object)colorizedString));
            }
            itemMeta.setLore(list);
        }
        return itemMeta;
    }

    private static int maxRankCalculator(ItemStack itemStack) {
        int maxRank = 0;
        Material material = itemStack.getType();
        switch (material) {
            case DIAMOND_SWORD: 
            case GOLDEN_SWORD: 
            case IRON_SWORD: 
            case STONE_SWORD: 
            case WOODEN_SWORD: {
                maxRank += EnchantmentsConfig.getEnchantment(Enchantment.BANE_OF_ARTHROPODS).getMaxLevel();
                maxRank += EnchantmentsConfig.getEnchantment(Enchantment.FIRE_ASPECT).getMaxLevel();
                maxRank += EnchantmentsConfig.getEnchantment(Enchantment.KNOCKBACK).getMaxLevel();
                maxRank += EnchantmentsConfig.getEnchantment(Enchantment.FORTUNE).getMaxLevel();
                maxRank += EnchantmentsConfig.getEnchantment(Enchantment.MENDING).getMaxLevel();
                maxRank += EnchantmentsConfig.getEnchantment(Enchantment.SHARPNESS).getMaxLevel();
                maxRank += EnchantmentsConfig.getEnchantment(Enchantment.SMITE).getMaxLevel();
                maxRank += EnchantmentsConfig.getEnchantment(Enchantment.SWEEPING_EDGE).getMaxLevel();
                maxRank += EnchantmentsConfig.getEnchantment(Enchantment.UNBREAKING).getMaxLevel();
                break;
            }
            case BOW: {
                maxRank += EnchantmentsConfig.getEnchantment(Enchantment.FLAME).getMaxLevel();
                maxRank += EnchantmentsConfig.getEnchantment(Enchantment.INFINITY).getMaxLevel();
                maxRank += EnchantmentsConfig.getEnchantment(Enchantment.MENDING).getMaxLevel();
                maxRank += EnchantmentsConfig.getEnchantment(Enchantment.POWER).getMaxLevel();
                maxRank += EnchantmentsConfig.getEnchantment(Enchantment.PUNCH).getMaxLevel();
                maxRank += EnchantmentsConfig.getEnchantment(Enchantment.UNBREAKING).getMaxLevel();
                break;
            }
            case DIAMOND_PICKAXE: 
            case GOLDEN_PICKAXE: 
            case IRON_PICKAXE: 
            case STONE_PICKAXE: 
            case WOODEN_PICKAXE: 
            case DIAMOND_SHOVEL: 
            case GOLDEN_SHOVEL: 
            case IRON_SHOVEL: 
            case STONE_SHOVEL: 
            case WOODEN_SHOVEL: {
                maxRank += EnchantmentsConfig.getEnchantment(Enchantment.EFFICIENCY).getMaxLevel();
                maxRank += EnchantmentsConfig.getEnchantment(Enchantment.FORTUNE).getMaxLevel();
                maxRank += EnchantmentsConfig.getEnchantment(Enchantment.MENDING).getMaxLevel();
                maxRank += EnchantmentsConfig.getEnchantment(Enchantment.SILK_TOUCH).getMaxLevel();
                maxRank += EnchantmentsConfig.getEnchantment(Enchantment.UNBREAKING).getMaxLevel();
                break;
            }
            case DIAMOND_HOE: 
            case GOLDEN_HOE: 
            case IRON_HOE: 
            case STONE_HOE: 
            case WOODEN_HOE: {
                maxRank += EnchantmentsConfig.getEnchantment(Enchantment.MENDING).getMaxLevel();
                maxRank += EnchantmentsConfig.getEnchantment(Enchantment.UNBREAKING).getMaxLevel();
                break;
            }
            case DIAMOND_AXE: 
            case GOLDEN_AXE: 
            case IRON_AXE: 
            case STONE_AXE: 
            case WOODEN_AXE: {
                maxRank += EnchantmentsConfig.getEnchantment(Enchantment.BANE_OF_ARTHROPODS).getMaxLevel();
                maxRank += EnchantmentsConfig.getEnchantment(Enchantment.EFFICIENCY).getMaxLevel();
                maxRank += EnchantmentsConfig.getEnchantment(Enchantment.FORTUNE).getMaxLevel();
                maxRank += EnchantmentsConfig.getEnchantment(Enchantment.MENDING).getMaxLevel();
                maxRank += EnchantmentsConfig.getEnchantment(Enchantment.SHARPNESS).getMaxLevel();
                maxRank += EnchantmentsConfig.getEnchantment(Enchantment.SILK_TOUCH).getMaxLevel();
                maxRank += EnchantmentsConfig.getEnchantment(Enchantment.SMITE).getMaxLevel();
                maxRank += EnchantmentsConfig.getEnchantment(Enchantment.UNBREAKING).getMaxLevel();
                break;
            }
            case CHAINMAIL_HELMET: 
            case DIAMOND_HELMET: 
            case GOLDEN_HELMET: 
            case IRON_HELMET: 
            case LEATHER_HELMET: {
                maxRank += EnchantmentsConfig.getEnchantment(Enchantment.UNBREAKING).getMaxLevel();
                maxRank += EnchantmentsConfig.getEnchantment(Enchantment.MENDING).getMaxLevel();
                maxRank += EnchantmentsConfig.getEnchantment(Enchantment.RESPIRATION).getMaxLevel();
                maxRank += EnchantmentsConfig.getEnchantment(Enchantment.PROTECTION).getMaxLevel();
                maxRank += EnchantmentsConfig.getEnchantment(Enchantment.BLAST_PROTECTION).getMaxLevel();
                maxRank += EnchantmentsConfig.getEnchantment(Enchantment.FIRE_PROTECTION).getMaxLevel();
                maxRank += EnchantmentsConfig.getEnchantment(Enchantment.PROJECTILE_PROTECTION).getMaxLevel();
                maxRank += EnchantmentsConfig.getEnchantment(Enchantment.THORNS).getMaxLevel();
                maxRank += EnchantmentsConfig.getEnchantment(Enchantment.AQUA_AFFINITY).getMaxLevel();
                break;
            }
            case CHAINMAIL_CHESTPLATE: 
            case DIAMOND_CHESTPLATE: 
            case GOLDEN_CHESTPLATE: 
            case IRON_CHESTPLATE: 
            case LEATHER_CHESTPLATE: {
                maxRank += EnchantmentsConfig.getEnchantment(Enchantment.UNBREAKING).getMaxLevel();
                maxRank += EnchantmentsConfig.getEnchantment(Enchantment.MENDING).getMaxLevel();
                maxRank += EnchantmentsConfig.getEnchantment(Enchantment.PROTECTION).getMaxLevel();
                maxRank += EnchantmentsConfig.getEnchantment(Enchantment.BLAST_PROTECTION).getMaxLevel();
                maxRank += EnchantmentsConfig.getEnchantment(Enchantment.FIRE_PROTECTION).getMaxLevel();
                maxRank += EnchantmentsConfig.getEnchantment(Enchantment.PROJECTILE_PROTECTION).getMaxLevel();
                maxRank += EnchantmentsConfig.getEnchantment(Enchantment.THORNS).getMaxLevel();
            }
        }
        if (material.equals((Object)Material.CHAINMAIL_LEGGINGS) || material.equals((Object)Material.DIAMOND_LEGGINGS) || material.equals((Object)Material.GOLDEN_LEGGINGS) || material.equals((Object)Material.IRON_LEGGINGS) || material.equals((Object)Material.LEATHER_LEGGINGS)) {
            maxRank += EnchantmentsConfig.getEnchantment(Enchantment.UNBREAKING).getMaxLevel();
            maxRank += EnchantmentsConfig.getEnchantment(Enchantment.MENDING).getMaxLevel();
            maxRank += EnchantmentsConfig.getEnchantment(Enchantment.PROTECTION).getMaxLevel();
            maxRank += EnchantmentsConfig.getEnchantment(Enchantment.BLAST_PROTECTION).getMaxLevel();
            maxRank += EnchantmentsConfig.getEnchantment(Enchantment.FIRE_PROTECTION).getMaxLevel();
            maxRank += EnchantmentsConfig.getEnchantment(Enchantment.PROJECTILE_PROTECTION).getMaxLevel();
            maxRank += EnchantmentsConfig.getEnchantment(Enchantment.THORNS).getMaxLevel();
        } else if (material.equals((Object)Material.CHAINMAIL_BOOTS) || material.equals((Object)Material.DIAMOND_BOOTS) || material.equals((Object)Material.GOLDEN_BOOTS) || material.equals((Object)Material.IRON_BOOTS) || material.equals((Object)Material.LEATHER_BOOTS)) {
            maxRank += EnchantmentsConfig.getEnchantment(Enchantment.UNBREAKING).getMaxLevel();
            maxRank += EnchantmentsConfig.getEnchantment(Enchantment.MENDING).getMaxLevel();
            maxRank += EnchantmentsConfig.getEnchantment(Enchantment.PROTECTION).getMaxLevel();
            maxRank += EnchantmentsConfig.getEnchantment(Enchantment.BLAST_PROTECTION).getMaxLevel();
            maxRank += EnchantmentsConfig.getEnchantment(Enchantment.FEATHER_FALLING).getMaxLevel();
            maxRank += EnchantmentsConfig.getEnchantment(Enchantment.FIRE_PROTECTION).getMaxLevel();
            maxRank += EnchantmentsConfig.getEnchantment(Enchantment.PROJECTILE_PROTECTION).getMaxLevel();
            maxRank += EnchantmentsConfig.getEnchantment(Enchantment.THORNS).getMaxLevel();
            maxRank += EnchantmentsConfig.getEnchantment(Enchantment.DEPTH_STRIDER).getMaxLevel();
            maxRank += EnchantmentsConfig.getEnchantment(Enchantment.FROST_WALKER).getMaxLevel();
        } else if (material.equals((Object)Material.SHEARS)) {
            EnchantmentsConfig.getEnchantment(Enchantment.EFFICIENCY).getMaxLevel();
            EnchantmentsConfig.getEnchantment(Enchantment.MENDING).getMaxLevel();
            EnchantmentsConfig.getEnchantment(Enchantment.UNBREAKING).getMaxLevel();
        } else if (material.equals((Object)Material.FISHING_ROD)) {
            maxRank += EnchantmentsConfig.getEnchantment(Enchantment.UNBREAKING).getMaxLevel();
            maxRank += EnchantmentsConfig.getEnchantment(Enchantment.MENDING).getMaxLevel();
            maxRank += EnchantmentsConfig.getEnchantment(Enchantment.LUCK_OF_THE_SEA).getMaxLevel();
            maxRank += EnchantmentsConfig.getEnchantment(Enchantment.LURE).getMaxLevel();
        } else if (material.equals((Object)Material.SHIELD)) {
            maxRank += EnchantmentsConfig.getEnchantment(Enchantment.UNBREAKING).getMaxLevel();
            maxRank += EnchantmentsConfig.getEnchantment(Enchantment.MENDING).getMaxLevel();
        }
        return maxRank;
    }

    public static enum ItemQuality {
        LIGHT_BLUE,
        GOLD,
        PURPLE,
        BLUE,
        GREEN,
        WHITE,
        GRAY;

    }
}

