/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.config.customitems;

import com.magmaguy.elitemobs.config.CustomConfigFields;
import com.magmaguy.elitemobs.config.LegacyValueConverter;
import com.magmaguy.elitemobs.items.customitems.CustomItem;
import com.magmaguy.magmacore.util.Logger;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.bukkit.Material;

public class CustomItemsConfigFields
extends CustomConfigFields {
    private Material material = Material.WOODEN_SWORD;
    private String name = "Default name";
    private List<String> lore = new ArrayList<String>();
    private List<String> enchantments = new ArrayList<String>();
    private List<String> potionEffects = new ArrayList<String>();
    private String dropWeight = "dynamic";
    private CustomItem.Scalability scalability = CustomItem.Scalability.SCALABLE;
    private CustomItem.ItemType itemType = CustomItem.ItemType.CUSTOM;
    private String customModelID = null;
    private String permission = "";
    private int level = 0;
    private boolean soulbound = true;
    private boolean showSource = true;

    public CustomItemsConfigFields(String fileName, boolean isEnabled, Material material, String name, List<String> lore) {
        super(fileName, isEnabled);
        this.material = material;
        this.name = name;
        this.lore = lore;
    }

    public CustomItemsConfigFields(String fileName, boolean isEnabled) {
        super(fileName, isEnabled);
    }

    @Override
    public void processConfigFields() {
        this.isEnabled = this.processBoolean("isEnabled", this.isEnabled, true, true);
        this.material = this.processEnum("material", this.material, Material.WOODEN_SWORD, Material.class, true);
        this.name = this.translatable(this.filename, "name", this.processString("name", this.name, "Default name", true));
        this.lore = this.translatable(this.filename, "lore", this.processStringList("lore", this.lore, new ArrayList<String>(), true));
        this.enchantments = this.processStringList("enchantments", this.enchantments, null, false);
        this.potionEffects = this.processStringList("potionEffects", this.potionEffects, null, false);
        this.dropWeight = this.processString("dropWeight", this.dropWeight, "dynamic", false);
        this.scalability = this.processEnum("scalability", this.scalability, CustomItem.Scalability.SCALABLE, CustomItem.Scalability.class, false);
        this.itemType = this.processEnum("itemType", this.itemType, CustomItem.ItemType.CUSTOM, CustomItem.ItemType.class, false);
        this.customModelID = this.processString("customModelV2", this.customModelID, null, false);
        this.permission = this.processString("permission", this.permission, "", false);
        this.level = this.processInt("level", this.level, 0, false);
        this.soulbound = this.processBoolean("soulbound", this.soulbound, true, false);
        this.showSource = this.processBoolean("showSource", this.showSource, this.showSource, false);
        this.updatePostProcessor();
    }

    private void updatePostProcessor() {
        ArrayList<String> newEnchantments = new ArrayList<String>();
        for (String enchantment : this.enchantments) {
            if (!enchantment.contains(",")) {
                Logger.warn("Invalid format for enchantment in file " + this.filename + " for enchantment " + enchantment + " : missing ',' for valid level after the enchantment name");
                continue;
            }
            String[] split = enchantment.split(",");
            String result = LegacyValueConverter.parseEnchantment(split[0]);
            if (result.equals(split[0])) {
                newEnchantments.add(enchantment);
                continue;
            }
            newEnchantments.add(result + "," + split[1]);
        }
        this.enchantments = newEnchantments;
        ArrayList<String> newPotionEffects = new ArrayList<String>();
        for (String potionEffect2 : this.potionEffects) {
            if (!potionEffect2.contains(",")) {
                Logger.warn("Invalid format for potion effect in file " + this.filename + " for potion effect " + potionEffect2 + " : missing ',' for valid level after the potion effect name");
                continue;
            }
            String[] split = potionEffect2.split(",");
            String result = LegacyValueConverter.parsePotionEffect(split[0]);
            if (result.equals(split[0])) {
                newPotionEffects.add(potionEffect2);
                continue;
            }
            StringBuilder newString = new StringBuilder();
            newString.append(result + ",");
            for (int i = 1; i < split.length; ++i) {
                newString.append(split[i]);
                if (i == split.length - 1) continue;
                newString.append(",");
            }
            newPotionEffects.add(newString.toString());
        }
        this.potionEffects = newPotionEffects;
        this.potionEffects.forEach(potionEffect -> {
            if (potionEffect.contains("INSTANT_DAMAGE")) {
                Logger.warn("Item " + this.filename + " contains HARM/INSTANT_DAMAGE potion effect, which heals undead mobs (Minecraft vanilla mechanic) and often times confuses players and admins. It is recommended you switch this potion effect with something else, like STRENGTH if you want more damage.");
            }
        });
    }

    @Generated
    public Material getMaterial() {
        return this.material;
    }

    @Generated
    public void setMaterial(Material material) {
        this.material = material;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public List<String> getLore() {
        return this.lore;
    }

    @Generated
    public void setLore(List<String> lore) {
        this.lore = lore;
    }

    @Generated
    public List<String> getEnchantments() {
        return this.enchantments;
    }

    @Generated
    public void setEnchantments(List<String> enchantments) {
        this.enchantments = enchantments;
    }

    @Generated
    public List<String> getPotionEffects() {
        return this.potionEffects;
    }

    @Generated
    public void setPotionEffects(List<String> potionEffects) {
        this.potionEffects = potionEffects;
    }

    @Generated
    public String getDropWeight() {
        return this.dropWeight;
    }

    @Generated
    public void setDropWeight(String dropWeight) {
        this.dropWeight = dropWeight;
    }

    @Generated
    public CustomItem.Scalability getScalability() {
        return this.scalability;
    }

    @Generated
    public void setScalability(CustomItem.Scalability scalability) {
        this.scalability = scalability;
    }

    @Generated
    public CustomItem.ItemType getItemType() {
        return this.itemType;
    }

    @Generated
    public void setItemType(CustomItem.ItemType itemType) {
        this.itemType = itemType;
    }

    @Generated
    public String getCustomModelID() {
        return this.customModelID;
    }

    @Generated
    public void setCustomModelID(String customModelID) {
        this.customModelID = customModelID;
    }

    @Generated
    public String getPermission() {
        return this.permission;
    }

    @Generated
    public void setPermission(String permission) {
        this.permission = permission;
    }

    @Generated
    public int getLevel() {
        return this.level;
    }

    @Generated
    public void setLevel(int level) {
        this.level = level;
    }

    @Generated
    public boolean isSoulbound() {
        return this.soulbound;
    }

    @Generated
    public void setSoulbound(boolean soulbound) {
        this.soulbound = soulbound;
    }

    @Generated
    public boolean isShowSource() {
        return this.showSource;
    }

    @Generated
    public void setShowSource(boolean showSource) {
        this.showSource = showSource;
    }
}

