/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.quests.menus;

import com.magmaguy.elitemobs.config.DefaultConfig;
import com.magmaguy.elitemobs.config.menus.premade.CustomQuestMenuConfig;
import com.magmaguy.elitemobs.config.menus.premade.DynamicQuestMenuConfig;
import com.magmaguy.elitemobs.entitytracker.EntityTracker;
import com.magmaguy.elitemobs.mobconstructor.mobdata.aggressivemobs.EliteMobProperties;
import com.magmaguy.elitemobs.npcs.NPCEntity;
import com.magmaguy.elitemobs.playerdata.database.PlayerData;
import com.magmaguy.elitemobs.quests.CustomQuest;
import com.magmaguy.elitemobs.quests.DynamicQuest;
import com.magmaguy.elitemobs.quests.Quest;
import com.magmaguy.elitemobs.quests.QuestTracking;
import com.magmaguy.elitemobs.quests.menus.QuestBookMenu;
import com.magmaguy.elitemobs.quests.menus.QuestInventoryMenu;
import com.magmaguy.elitemobs.quests.objectives.DynamicKillObjective;
import com.magmaguy.elitemobs.quests.objectives.KillObjective;
import com.magmaguy.elitemobs.quests.objectives.Objective;
import com.magmaguy.elitemobs.thirdparty.geyser.GeyserDetector;
import com.magmaguy.elitemobs.utils.BookMaker;
import com.magmaguy.elitemobs.utils.DialogMaker;
import com.magmaguy.magmacore.util.ChatColorConverter;
import com.magmaguy.magmacore.util.SpigotMessage;
import com.magmaguy.magmacore.util.VersionChecker;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import lombok.Generated;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.entity.Player;

public class QuestMenu {
    private QuestMenu() {
    }

    public static void generateCustomQuestMenu(List<CustomQuest> customQuestList, Player player, NPCEntity npcEntity) {
        QuestMenu.generateQuestMenu(customQuestList, player, npcEntity);
    }

    public static void generateDynamicQuestMenu(List<DynamicQuest> dynamicQuests, Player player, NPCEntity npcEntity) {
        QuestMenu.generateQuestMenu(dynamicQuests, player, npcEntity);
    }

    public static void generateQuestMenu(List<? extends Quest> quests, Player player, NPCEntity npcEntity) {
        if (!PlayerData.getUseBookMenus(player.getUniqueId()) || GeyserDetector.bedrockPlayer(player) || DefaultConfig.isOnlyUseBedrockMenus()) {
            QuestInventoryMenu.generateInventoryQuestEntries(quests, player, npcEntity);
        } else if (VersionChecker.serverVersionOlderThan((int)21, (int)6)) {
            QuestMenu.generateBookQuestEntries(quests, player, npcEntity);
        } else {
            QuestMenu.generateDialogMenu(quests, player, npcEntity);
        }
    }

    public static void generateDialogMenu(List<? extends Quest> quests, Player player, NPCEntity npcEntity) {
        DialogMaker.sendQuestMessage(quests, player, npcEntity);
    }

    public static void generateBookQuestEntries(List<? extends Quest> quests, Player player, NPCEntity npcEntity) {
        BookMaker.generateBook(player, QuestMenu.generateBookQuestEntriesComponents(quests, player, npcEntity));
    }

    /*
     * WARNING - void declaration
     */
    public static TextComponent[] generateBookQuestEntriesComponents(List<? extends Quest> quests, Player player, NPCEntity npcEntity) {
        ArrayList<TextComponent[]> textComponents = new ArrayList<TextComponent[]>();
        int counter = 0;
        for (Quest quest : quests) {
            TextComponent[] iteratedTextComponent = QuestBookMenu.generateQuestEntry(quest, player, npcEntity);
            counter += iteratedTextComponent.length;
            textComponents.add(iteratedTextComponent);
        }
        TextComponent[] allQuests = new TextComponent[counter];
        boolean bl = false;
        Iterator iterator = textComponents.iterator();
        while (iterator.hasNext()) {
            TextComponent[] textComponentsArray;
            TextComponent[] textComponentArray = textComponentsArray = (TextComponent[])iterator.next();
            int n = textComponentArray.length;
            for (int i = 0; i < n; ++i) {
                void var6_8;
                TextComponent textComponent;
                allQuests[var6_8] = textComponent = textComponentArray[i];
                ++var6_8;
            }
        }
        return allQuests;
    }

    private static TextComponent generateHeader(Quest quest) {
        if (quest instanceof CustomQuest) {
            return SpigotMessage.simpleMessage((String)CustomQuestMenuConfig.getHeaderTextLines().replace("$questName", quest.getQuestName()));
        }
        return SpigotMessage.simpleMessage((String)DynamicQuestMenuConfig.getHeaderTextLines().replace("$questName", quest.getQuestName()));
    }

    private static List<TextComponent> generateBody(Quest quest) {
        ArrayList<TextComponent> body = new ArrayList<TextComponent>();
        if (quest instanceof CustomQuest) {
            for (String splitString : ((CustomQuest)quest).getCustomQuestsConfigFields().getQuestLore()) {
                body.add(new TextComponent(ChatColorConverter.convert((String)splitString)));
            }
        } else if (quest instanceof DynamicQuest) {
            body.add(new TextComponent(DynamicQuestMenuConfig.getDefaultLoreTextLines().replace("$amount", "" + quest.getQuestObjectives().getObjectives().get(0).getTargetAmount()).replace("$name", EliteMobProperties.getPluginData(((DynamicKillObjective)quest.getQuestObjectives().getObjectives().get(0)).getEntityType()).getName(quest.getQuestLevel() * 10))));
        }
        return body;
    }

    private static TextComponent generateFixedSummary(Quest quest) {
        TextComponent fixedSummary = new TextComponent();
        if (quest instanceof CustomQuest) {
            fixedSummary.setText(CustomQuestMenuConfig.getObjectivesLine());
        } else if (quest instanceof DynamicQuest) {
            fixedSummary.setText(DynamicQuestMenuConfig.getObjectivesLine());
        }
        return fixedSummary;
    }

    private static List<TextComponent> generateSummary(Quest quest) {
        ArrayList<TextComponent> textComponents;
        block3: {
            block2: {
                textComponents = new ArrayList<TextComponent>();
                if (!(quest instanceof CustomQuest)) break block2;
                for (Objective objective : quest.getQuestObjectives().getObjectives()) {
                    textComponents.add(new TextComponent(SpigotMessage.commandHoverMessage((String)CustomQuestMenuConfig.getObjectiveLine(objective), (String)"", (String)"")));
                }
                break block3;
            }
            if (!(quest instanceof DynamicQuest)) break block3;
            for (Objective objective : quest.getQuestObjectives().getObjectives()) {
                if (!(objective instanceof KillObjective)) continue;
                textComponents.add(new TextComponent(SpigotMessage.commandHoverMessage((String)DynamicQuestMenuConfig.getKillQuestDefaultSummaryLine(objective), (String)"", (String)"")));
            }
        }
        return textComponents;
    }

    private static TextComponent generateFixedRewards(Quest quest) {
        TextComponent questRewards = new TextComponent();
        if (quest instanceof CustomQuest) {
            questRewards.setText(CustomQuestMenuConfig.getRewardsLine());
        } else if (quest instanceof DynamicQuest) {
            questRewards.setText(DynamicQuestMenuConfig.getRewardsLine());
        }
        return questRewards;
    }

    private static List<TextComponent> generateRewards(Quest quest) {
        if (quest instanceof CustomQuest) {
            return CustomQuestMenuConfig.getRewardsDefaultSummaryLine(quest.getQuestObjectives().getQuestReward());
        }
        return DynamicQuestMenuConfig.getRewardsDefaultSummaryLine(quest.getQuestObjectives().getQuestReward());
    }

    private static TextComponent generateAccept(Quest quest, NPCEntity npcEntity) {
        if (!quest.isAccepted()) {
            return QuestMenu.initialQuestAccept(quest);
        }
        if (npcEntity != null && quest.getQuestObjectives().isOver() && (quest instanceof DynamicQuest || quest instanceof CustomQuest && quest.getQuestTaker().equals(npcEntity.getNPCsConfigFields().getFilename()))) {
            return QuestMenu.questAcceptComplete(quest);
        }
        return QuestMenu.questAcceptAlreadyAccepted(quest);
    }

    private static TextComponent initialQuestAccept(Quest quest) {
        if (quest instanceof CustomQuest) {
            return SpigotMessage.commandHoverMessage((String)CustomQuestMenuConfig.getAcceptTextLines(), (String)CustomQuestMenuConfig.getAcceptHoverLines(), (String)CustomQuestMenuConfig.getAcceptCommandLines().replace("$questID", quest.getQuestID().toString()));
        }
        return SpigotMessage.commandHoverMessage((String)DynamicQuestMenuConfig.getAcceptTextLines(), (String)DynamicQuestMenuConfig.getAcceptHoverLines(), (String)DynamicQuestMenuConfig.getAcceptCommandLines().replace("$questID", quest.getQuestID().toString()));
    }

    private static TextComponent questAcceptAlreadyAccepted(Quest quest) {
        if (quest instanceof CustomQuest) {
            String npcName = "";
            if (CustomQuestMenuConfig.getAcceptedTextLines().contains("$npcName")) {
                for (NPCEntity npcEntity : EntityTracker.getNpcEntities().values()) {
                    if (!npcEntity.getNPCsConfigFields().getFilename().equals(quest.getQuestTaker())) continue;
                    npcName = npcEntity.getNPCsConfigFields().getName();
                    break;
                }
            }
            return SpigotMessage.commandHoverMessage((String)CustomQuestMenuConfig.getAcceptedTextLines().replace("$npcName", npcName), (String)CustomQuestMenuConfig.getAcceptedHoverLines(), (String)CustomQuestMenuConfig.getAcceptedCommandLines().replace("$questID", quest.getQuestID().toString()));
        }
        return SpigotMessage.commandHoverMessage((String)DynamicQuestMenuConfig.getAcceptedTextLines(), (String)DynamicQuestMenuConfig.getAcceptedHoverLines(), (String)DynamicQuestMenuConfig.getAcceptedCommandLines().replace("$questID", quest.getQuestID().toString()));
    }

    private static TextComponent generateTrack(Player player, Quest quest) {
        if (!((CustomQuest)quest).getCustomQuestsConfigFields().isTrackable()) {
            return new TextComponent();
        }
        if (!CustomQuestMenuConfig.isUseQuestTracking()) {
            return new TextComponent();
        }
        if (!quest.isAccepted()) {
            return new TextComponent();
        }
        if (!QuestTracking.isTracking(player)) {
            return SpigotMessage.commandHoverMessage((String)CustomQuestMenuConfig.getTrackTextLines(), (String)CustomQuestMenuConfig.getTrackHoverLines(), (String)CustomQuestMenuConfig.getTrackCommandLines().replace("$questID", "" + quest.getQuestID()));
        }
        return SpigotMessage.commandHoverMessage((String)CustomQuestMenuConfig.getUntrackTextLines(), (String)CustomQuestMenuConfig.getUntrackHoverLines(), (String)CustomQuestMenuConfig.getUntrackCommandLines().replace("$questID", "" + quest.getQuestID()));
    }

    private static TextComponent questAcceptComplete(Quest quest) {
        if (quest instanceof CustomQuest) {
            return SpigotMessage.commandHoverMessage((String)CustomQuestMenuConfig.getCompletedTextLines(), (String)CustomQuestMenuConfig.getCompletedHoverLines(), (String)CustomQuestMenuConfig.getCompletedCommandLines().replace("$questID", quest.getQuestID().toString()));
        }
        return SpigotMessage.commandHoverMessage((String)DynamicQuestMenuConfig.getCompletedTextLines(), (String)DynamicQuestMenuConfig.getCompletedHoverLines(), (String)DynamicQuestMenuConfig.getCompletedCommandLines().replace("$questID", quest.getQuestID().toString()));
    }

    public static TextComponent[] generateQuestEntry(Player player, NPCEntity npcEntity) {
        if (PlayerData.getQuests(player.getUniqueId()) == null) {
            return new TextComponent[0];
        }
        return QuestMenu.generateBookQuestEntriesComponents(PlayerData.getQuests(player.getUniqueId()), player, npcEntity);
    }

    public static class QuestText {
        private final TextComponent header;
        private final List<TextComponent> body;
        private final TextComponent fixedSummary;
        private final List<TextComponent> summary;
        private final TextComponent fixedRewards;
        private final List<TextComponent> rewards;
        private final TextComponent accept;
        private TextComponent track;

        public QuestText(Quest quest, NPCEntity npcEntity, Player player) {
            this.header = QuestMenu.generateHeader(quest);
            this.body = QuestMenu.generateBody(quest);
            this.fixedSummary = QuestMenu.generateFixedSummary(quest);
            this.summary = QuestMenu.generateSummary(quest);
            this.fixedRewards = QuestMenu.generateFixedRewards(quest);
            this.rewards = QuestMenu.generateRewards(quest);
            this.accept = QuestMenu.generateAccept(quest, npcEntity);
            this.track = null;
            if (quest instanceof CustomQuest) {
                this.track = QuestMenu.generateTrack(player, quest);
            }
        }

        @Generated
        public TextComponent getHeader() {
            return this.header;
        }

        @Generated
        public List<TextComponent> getBody() {
            return this.body;
        }

        @Generated
        public TextComponent getFixedSummary() {
            return this.fixedSummary;
        }

        @Generated
        public List<TextComponent> getSummary() {
            return this.summary;
        }

        @Generated
        public TextComponent getFixedRewards() {
            return this.fixedRewards;
        }

        @Generated
        public List<TextComponent> getRewards() {
            return this.rewards;
        }

        @Generated
        public TextComponent getAccept() {
            return this.accept;
        }

        @Generated
        public TextComponent getTrack() {
            return this.track;
        }
    }
}

