/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.quests.menus;

import com.magmaguy.elitemobs.config.DefaultConfig;
import com.magmaguy.elitemobs.npcs.NPCEntity;
import com.magmaguy.elitemobs.quests.CustomQuest;
import com.magmaguy.elitemobs.quests.Quest;
import com.magmaguy.elitemobs.quests.menus.QuestMenu;
import java.util.ArrayList;
import java.util.Iterator;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

public class QuestBookMenu {
    private QuestBookMenu() {
    }

    public static TextComponent[] generateQuestEntry(Quest quest, Player player, NPCEntity npcEntity) {
        QuestMenu.QuestText questText = new QuestMenu.QuestText(quest, npcEntity, player);
        ArrayList<TextComponent> elements = new ArrayList<TextComponent>();
        elements.add(questText.getHeader());
        if (quest instanceof CustomQuest && !quest.getQuestObjectives().isOver()) {
            elements.addAll(questText.getBody());
        }
        elements.add(questText.getFixedSummary());
        elements.addAll(questText.getSummary());
        elements.add(questText.getFixedRewards());
        elements.addAll(questText.getRewards());
        elements.add(questText.getAccept());
        if (quest instanceof CustomQuest) {
            elements.add(questText.getTrack());
        }
        ArrayList<TextComponent> pagesList = new ArrayList<TextComponent>();
        int pageIndex = 0;
        int characterCount = 0;
        int characterLimit = DefaultConfig.getCharacterLimitForBookMenuPages();
        for (TextComponent textComponent : elements) {
            characterCount += ChatColor.stripColor((String)textComponent.getText()).length();
            textComponent.setText(ChatColor.BLACK + textComponent.getText().replace("" + ChatColor.WHITE, "" + ChatColor.BLACK).replace("" + ChatColor.YELLOW, "" + ChatColor.GOLD));
            if (pagesList.isEmpty()) {
                textComponent.addExtra("\n");
                pagesList.add(textComponent);
                continue;
            }
            if (characterCount > characterLimit) {
                characterCount = 0;
                characterCount += ChatColor.stripColor((String)textComponent.getText()).length();
                ++pageIndex;
                textComponent.addExtra("\n");
                pagesList.add(textComponent);
                continue;
            }
            textComponent.addExtra("\n");
            ((TextComponent)pagesList.get(pageIndex)).addExtra((BaseComponent)textComponent);
        }
        TextComponent[] pages = new TextComponent[pagesList.size()];
        int pageCounter = 0;
        Iterator iterator = pagesList.iterator();
        while (iterator.hasNext()) {
            TextComponent textComponent;
            pages[pageCounter] = textComponent = (TextComponent)iterator.next();
            ++pageCounter;
        }
        return pages;
    }
}

