/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.powers.scripts;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.api.ScriptZoneEnterEvent;
import com.magmaguy.elitemobs.api.ScriptZoneLeaveEvent;
import com.magmaguy.elitemobs.entitytracker.EntityTracker;
import com.magmaguy.elitemobs.mobconstructor.EliteEntity;
import com.magmaguy.elitemobs.powers.scripts.EliteScript;
import com.magmaguy.elitemobs.powers.scripts.ScriptActionData;
import com.magmaguy.elitemobs.powers.scripts.ScriptTargets;
import com.magmaguy.elitemobs.powers.scripts.caching.ScriptTargetsBlueprint;
import com.magmaguy.elitemobs.powers.scripts.caching.ScriptZoneBlueprint;
import com.magmaguy.elitemobs.powers.scripts.enums.TargetType;
import com.magmaguy.elitemobs.utils.EventCaller;
import com.magmaguy.elitemobs.utils.shapes.Cone;
import com.magmaguy.elitemobs.utils.shapes.Cuboid;
import com.magmaguy.elitemobs.utils.shapes.Cylinder;
import com.magmaguy.elitemobs.utils.shapes.Dome;
import com.magmaguy.elitemobs.utils.shapes.RotatingRay;
import com.magmaguy.elitemobs.utils.shapes.Shape;
import com.magmaguy.elitemobs.utils.shapes.Sphere;
import com.magmaguy.elitemobs.utils.shapes.StaticRay;
import com.magmaguy.elitemobs.utils.shapes.TranslatingRay;
import com.magmaguy.magmacore.util.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.LivingEntity;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ScriptZone {
    private final ScriptZoneBlueprint zoneBlueprint;
    private final ScriptTargets targets;
    private final boolean isValid;
    private ScriptTargets finalTargets = null;
    private ScriptTargets targets2 = null;
    private ScriptTargets finalTargets2 = null;
    private boolean zoneListener = false;
    private Set<LivingEntity> entitiesInZone;
    private ZoneListenerTask zoneListenerTask = null;

    public ScriptZone(ScriptZoneBlueprint zoneBlueprint, EliteScript eliteScript) {
        this.zoneBlueprint = zoneBlueprint;
        this.targets = new ScriptTargets(zoneBlueprint.getTarget(), eliteScript);
        if (zoneBlueprint.getFinalTarget() != null) {
            this.finalTargets = new ScriptTargets(zoneBlueprint.getFinalTarget(), eliteScript);
        }
        if (zoneBlueprint.getTarget2() != null) {
            this.targets2 = new ScriptTargets(zoneBlueprint.getTarget2(), eliteScript);
        }
        if (zoneBlueprint.getFinalTarget2() != null) {
            this.finalTargets2 = new ScriptTargets(zoneBlueprint.getFinalTarget2(), eliteScript);
        }
        this.isValid = zoneBlueprint.getTarget() != null;
    }

    public void startZoneListener(EliteEntity eliteEntity) {
        if (!this.zoneListener) {
            return;
        }
        if (this.zoneListenerTask != null) {
            this.zoneListenerTask.cancel();
        }
        this.entitiesInZone = new HashSet<LivingEntity>();
        ScriptActionData scriptActionData = new ScriptActionData(eliteEntity, this.targets, this);
        this.zoneListenerTask = new ZoneListenerTask(eliteEntity, scriptActionData);
        this.zoneListenerTask.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 1L, 1L);
    }

    public void zoneEnterEvent(EliteEntity eliteEntity, LivingEntity livingEntity) {
        new EventCaller(new ScriptZoneEnterEvent(eliteEntity, livingEntity));
    }

    public void zoneLeaveEvent(EliteEntity eliteEntity, LivingEntity livingEntity) {
        new EventCaller(new ScriptZoneLeaveEvent(eliteEntity, livingEntity));
    }

    protected Collection<LivingEntity> getZoneEntities(ScriptActionData scriptActionData, ScriptTargetsBlueprint blueprintFromRequestingTarget) {
        try {
            switch (blueprintFromRequestingTarget.getTargetType()) {
                case ZONE_FULL: 
                case ZONE_BORDER: {
                    return this.getEntitiesInArea(this.generateShapes(scriptActionData, false), blueprintFromRequestingTarget.getTargetType());
                }
                case INHERIT_SCRIPT_ZONE_FULL: 
                case INHERIT_SCRIPT_ZONE_BORDER: {
                    return this.getEntitiesInArea(this.generateShapes(scriptActionData.getInheritedScriptActionData(), false), blueprintFromRequestingTarget.getTargetType());
                }
            }
            Logger.warn((String)("Couldn't parse target type '" + blueprintFromRequestingTarget.getTargetType() + "' in script zone."));
            return Collections.emptyList();
        }
        catch (Exception e) {
            Logger.warn((String)("Error retrieving zone entities: " + e.getMessage()));
            return Collections.emptyList();
        }
    }

    protected Collection<Location> getZoneLocations(ScriptActionData scriptActionData, ScriptTargets actionTarget) {
        try {
            switch (actionTarget.getTargetBlueprint().getTargetType()) {
                case ZONE_FULL: {
                    return this.consolidateLists(this.generateShapes(scriptActionData, false).stream().map(Shape::getLocations).collect(Collectors.toSet()));
                }
                case ZONE_BORDER: {
                    return this.consolidateLists(this.generateShapes(scriptActionData, false).stream().map(Shape::getEdgeLocations).collect(Collectors.toSet()));
                }
                case INHERIT_SCRIPT_ZONE_FULL: {
                    return this.consolidateLists(this.generateShapes(scriptActionData.getInheritedScriptActionData(), false).stream().map(Shape::getLocations).collect(Collectors.toSet()));
                }
                case INHERIT_SCRIPT_ZONE_BORDER: {
                    return this.consolidateLists(this.generateShapes(scriptActionData.getInheritedScriptActionData(), false).stream().map(Shape::getEdgeLocations).collect(Collectors.toSet()));
                }
            }
            Logger.warn((String)("Couldn't parse target type '" + actionTarget.getTargetBlueprint().getTargetType() + "' in script zone."));
            return Collections.emptyList();
        }
        catch (Exception e) {
            Logger.warn((String)("Error retrieving zone locations: " + e.getMessage()));
            return Collections.emptyList();
        }
    }

    private Collection<Location> consolidateLists(Collection<Collection<Location>> originalLocations) {
        ArrayList<Location> parsedLocations = new ArrayList<Location>();
        originalLocations.forEach(parsedLocations::addAll);
        return parsedLocations;
    }

    public List<Shape> generateShapes(ScriptActionData scriptActionData, boolean force) {
        try {
            if (!force && scriptActionData.getShapesCachedByTarget() != null) {
                return scriptActionData.getShapesCachedByTarget();
            }
            ArrayList<Shape> shapes = new ArrayList<Shape>();
            block12: for (Location shapeTargetLocation : this.targets.getTargetLocations(scriptActionData)) {
                switch (this.zoneBlueprint.getShapeTypeEnum()) {
                    case CYLINDER: {
                        shapes.add(new Cylinder(shapeTargetLocation, this.zoneBlueprint.getRadius().getValue().floatValue(), this.zoneBlueprint.getHeight().getValue().floatValue(), this.zoneBlueprint.getBorderRadius().getValue().floatValue()));
                        break;
                    }
                    case SPHERE: {
                        shapes.add(new Sphere(this.zoneBlueprint.getRadius().getValue().floatValue(), shapeTargetLocation, this.zoneBlueprint.getBorderRadius().getValue().floatValue()));
                        break;
                    }
                    case DOME: {
                        shapes.add(new Dome(this.zoneBlueprint.getRadius().getValue().floatValue(), shapeTargetLocation, this.zoneBlueprint.getBorderRadius().getValue().floatValue()));
                        break;
                    }
                    case CONE: {
                        if (this.targets2 == null) {
                            Logger.warn((String)("Script for boss '" + scriptActionData.getEliteEntity().getName() + "' has a CONE but no set target2 for the cone!"));
                            continue block12;
                        }
                        ArrayList<Location> target2Locations = new ArrayList<Location>(this.targets2.getTargetLocations(scriptActionData));
                        if (target2Locations.isEmpty()) continue block12;
                        Location secondPoint = (Location)target2Locations.get(0);
                        shapes.add(new Cone(shapeTargetLocation, secondPoint, this.zoneBlueprint.getRadius().getValue().floatValue(), this.zoneBlueprint.getBorderRadius().getValue().floatValue()));
                        break;
                    }
                    case STATIC_RAY: {
                        if (this.targets2 == null) {
                            Logger.warn((String)("Script for boss '" + scriptActionData.getEliteEntity().getName() + "' has a STATIC_RAY but no set target2 for the ray!"));
                            continue block12;
                        }
                        for (Location location : this.targets2.getTargetLocations(scriptActionData)) {
                            if (!this.rayLocationValidator(shapeTargetLocation, location)) continue;
                            shapes.add(new StaticRay(this.zoneBlueprint.isIgnoresSolidBlocks(), this.zoneBlueprint.getPointRadius().getValue().floatValue(), shapeTargetLocation, location));
                        }
                        continue block12;
                    }
                    case ROTATING_RAY: {
                        if (this.targets2 == null) {
                            Logger.warn((String)("Script for boss '" + scriptActionData.getEliteEntity().getName() + "' has a ROTATING_RAY but no set target2 for the ray!"));
                            continue block12;
                        }
                        for (Location target2Location : this.targets2.getTargetLocations(scriptActionData)) {
                            if (!this.rayLocationValidator(shapeTargetLocation, target2Location)) continue;
                            shapes.add(new RotatingRay(this.zoneBlueprint.isIgnoresSolidBlocks(), this.zoneBlueprint.getPointRadius().getValue().floatValue(), shapeTargetLocation, target2Location, this.zoneBlueprint.getPitchPreRotation().getValue().floatValue(), this.zoneBlueprint.getYawPreRotation().getValue().floatValue(), this.zoneBlueprint.getPitchRotation().getValue().floatValue(), this.zoneBlueprint.getYawRotation().getValue().floatValue(), this.zoneBlueprint.getAnimationDuration().getValue()));
                        }
                        continue block12;
                    }
                    case TRANSLATING_RAY: {
                        ArrayList<Location> finalTargetsList;
                        ArrayList<Location> finalTargetsList2;
                        if (this.targets2 == null) {
                            Logger.warn((String)("Script for boss '" + scriptActionData.getEliteEntity().getName() + "' has a TRANSLATING_RAY but no set target2 for the ray!"));
                            continue block12;
                        }
                        Location targetLocationEnd = null;
                        if (this.finalTargets != null && !(finalTargetsList2 = new ArrayList<Location>(this.finalTargets.getTargetLocations(scriptActionData))).isEmpty()) {
                            targetLocationEnd = (Location)finalTargetsList2.get(0);
                        }
                        Location target2LocationEnd = null;
                        if (this.finalTargets2 != null && !(finalTargetsList = new ArrayList<Location>(this.finalTargets2.getTargetLocations(scriptActionData))).isEmpty()) {
                            target2LocationEnd = (Location)finalTargetsList.get(0);
                        }
                        for (Location location : this.targets2.getTargetLocations(scriptActionData)) {
                            if (!this.rayLocationValidator(shapeTargetLocation, location)) continue;
                            shapes.add(new TranslatingRay(this.zoneBlueprint.isIgnoresSolidBlocks(), this.zoneBlueprint.getPointRadius().getValue().floatValue(), shapeTargetLocation, targetLocationEnd, location, target2LocationEnd, this.zoneBlueprint.getAnimationDuration().getValue()));
                        }
                        continue block12;
                    }
                    case CUBOID: {
                        shapes.add(new Cuboid(this.zoneBlueprint.getX().getValue(), this.zoneBlueprint.getY().getValue(), this.zoneBlueprint.getZ().getValue(), this.zoneBlueprint.getXBorder().getValue(), this.zoneBlueprint.getYBorder().getValue(), this.zoneBlueprint.getZBorder().getValue(), shapeTargetLocation));
                        break;
                    }
                    default: {
                        Logger.warn((String)("Unsupported shape type '" + this.zoneBlueprint.getShapeTypeEnum() + "' in script zone."));
                    }
                }
            }
            return shapes;
        }
        catch (Exception e) {
            Logger.warn((String)("Error generating shapes: " + e.getMessage()));
            e.printStackTrace();
            return Collections.emptyList();
        }
    }

    private boolean rayLocationValidator(Location location1, Location location2) {
        return location1 != null && location2 != null && location1.getWorld().equals(location2.getWorld());
    }

    private Collection<LivingEntity> getEntitiesInArea(List<Shape> shapes, TargetType targetType) {
        HashSet<LivingEntity> validatedEntities = new HashSet<LivingEntity>();
        for (Shape shape : shapes) {
            Collection<LivingEntity> collection;
            if (this.zoneBlueprint.getFilter() != null) {
                switch (this.zoneBlueprint.getFilter()) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case PLAYER: {
                        collection = this.filterByPlayer(shape.getCenter());
                        break;
                    }
                    case ELITE: {
                        collection = this.filterByElite(shape.getCenter());
                        break;
                    }
                    case LIVING: {
                        collection = this.filterByLiving(shape.getCenter());
                        break;
                    }
                }
            } else {
                collection = this.filterByLiving(shape.getCenter());
            }
            Collection<LivingEntity> livingEntities = collection;
            for (LivingEntity livingEntity : livingEntities) {
                boolean contains = targetType.equals((Object)TargetType.ZONE_FULL) ? shape.contains(livingEntity) : shape.borderContains(livingEntity.getLocation());
                if (!contains) continue;
                validatedEntities.add(livingEntity);
            }
        }
        return validatedEntities;
    }

    private Collection<LivingEntity> filterByPlayer(Location center) {
        World world = center.getWorld();
        if (world != null) {
            return new ArrayList<LivingEntity>(world.getPlayers());
        }
        Logger.warn((String)"World is null in filterByPlayer.");
        return Collections.emptyList();
    }

    private Collection<LivingEntity> filterByElite(Location center) {
        World world = center.getWorld();
        if (world != null) {
            return world.getEntities().stream().filter(entity -> entity instanceof LivingEntity).filter(entity -> EntityTracker.getEliteMobEntity(entity) != null).map(entity -> (LivingEntity)entity).collect(Collectors.toList());
        }
        Logger.warn((String)"World is null in filterByElite.");
        return Collections.emptyList();
    }

    private Collection<LivingEntity> filterByLiving(Location center) {
        World world = center.getWorld();
        if (world != null) {
            return world.getLivingEntities();
        }
        Logger.warn((String)"World is null in filterByLiving.");
        return Collections.emptyList();
    }

    @Generated
    public ScriptZoneBlueprint getZoneBlueprint() {
        return this.zoneBlueprint;
    }

    @Generated
    public boolean isValid() {
        return this.isValid;
    }

    @Generated
    public void setZoneListener(boolean zoneListener) {
        this.zoneListener = zoneListener;
    }

    private class ZoneListenerTask
    extends BukkitRunnable {
        private final EliteEntity eliteEntity;
        private final ScriptActionData scriptActionData;

        public ZoneListenerTask(EliteEntity eliteEntity, ScriptActionData scriptActionData) {
            this.eliteEntity = eliteEntity;
            this.scriptActionData = scriptActionData;
        }

        public void run() {
            try {
                if (this.eliteEntity.getLivingEntity() == null || !this.eliteEntity.getLivingEntity().isValid()) {
                    this.cancel();
                    return;
                }
                Collection<LivingEntity> newEntities = ScriptZone.this.getEntitiesInArea(ScriptZone.this.generateShapes(this.scriptActionData, false), TargetType.ZONE_FULL);
                for (LivingEntity livingEntity : newEntities) {
                    if (ScriptZone.this.entitiesInZone.contains(livingEntity)) continue;
                    ScriptZone.this.zoneEnterEvent(this.eliteEntity, livingEntity);
                }
                for (LivingEntity livingEntity : ScriptZone.this.entitiesInZone) {
                    if (newEntities.contains(livingEntity)) continue;
                    ScriptZone.this.zoneLeaveEvent(this.eliteEntity, livingEntity);
                }
                ScriptZone.this.entitiesInZone = new HashSet<LivingEntity>(newEntities);
            }
            catch (Exception e) {
                Logger.warn((String)("Error in ZoneListenerTask: " + e.getMessage()));
                this.cancel();
            }
        }
    }
}

