/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.powers.scripts;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.api.EliteDamageEvent;
import com.magmaguy.elitemobs.api.PlayerDamagedByEliteMobEvent;
import com.magmaguy.elitemobs.api.internal.RemovalReason;
import com.magmaguy.elitemobs.collateralminecraftchanges.LightningSpawnBypass;
import com.magmaguy.elitemobs.entitytracker.EntityTracker;
import com.magmaguy.elitemobs.instanced.MatchInstance;
import com.magmaguy.elitemobs.mobconstructor.EliteEntity;
import com.magmaguy.elitemobs.mobconstructor.custombosses.CustomBossEntity;
import com.magmaguy.elitemobs.pathfinding.Navigation;
import com.magmaguy.elitemobs.playerdata.ElitePlayerInventory;
import com.magmaguy.elitemobs.powers.meta.CustomSummonPower;
import com.magmaguy.elitemobs.powers.scripts.EliteScript;
import com.magmaguy.elitemobs.powers.scripts.FallingEntityDataPair;
import com.magmaguy.elitemobs.powers.scripts.ScriptActionData;
import com.magmaguy.elitemobs.powers.scripts.ScriptConditions;
import com.magmaguy.elitemobs.powers.scripts.ScriptListener;
import com.magmaguy.elitemobs.powers.scripts.ScriptParticles;
import com.magmaguy.elitemobs.powers.scripts.ScriptRelativeVector;
import com.magmaguy.elitemobs.powers.scripts.ScriptTargets;
import com.magmaguy.elitemobs.powers.scripts.caching.ScriptActionBlueprint;
import com.magmaguy.elitemobs.powers.scripts.enums.ActionType;
import com.magmaguy.elitemobs.powers.scripts.enums.TargetType;
import com.magmaguy.magmacore.util.AttributeManager;
import com.magmaguy.magmacore.util.ChatColorConverter;
import com.magmaguy.magmacore.util.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.block.Block;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.Firework;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.Event;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class ScriptAction {
    private static final Set<Player> invulnerablePlayers = ConcurrentHashMap.newKeySet();
    private final ScriptActionBlueprint blueprint;
    private final ScriptTargets scriptTargets;
    private final ScriptConditions scriptConditions;
    private final ScriptParticles scriptParticles;
    private final Map<String, EliteScript> eliteScriptMap;
    private final EliteScript eliteScript;
    private final ScriptTargets finalScriptTargets;
    private static final ThreadLocal<Integer> scriptDamageDepth = ThreadLocal.withInitial(() -> 0);
    private static final int MAX_SCRIPT_DAMAGE_DEPTH = 3;

    public ScriptAction(ScriptActionBlueprint blueprint, Map<String, EliteScript> eliteScriptMap, EliteScript eliteScript) {
        this.blueprint = blueprint;
        this.scriptTargets = new ScriptTargets(blueprint.getScriptTargets(), eliteScript);
        this.finalScriptTargets = blueprint.getFinalTarget() != null ? new ScriptTargets(blueprint.getFinalTarget(), eliteScript) : null;
        this.scriptConditions = new ScriptConditions(blueprint.getConditionsBlueprint(), eliteScript, true);
        this.scriptParticles = new ScriptParticles(blueprint.getScriptParticlesBlueprint());
        this.eliteScriptMap = eliteScriptMap;
        this.eliteScript = eliteScript;
    }

    public void runScript(EliteEntity eliteEntity, LivingEntity directTarget, Event event) {
        if (this.blueprint.getActionType() == null) {
            Logger.warn((String)("Script '" + this.blueprint.getScriptName() + "' in file '" + this.blueprint.getScriptFilename() + "' does not have a valid action! Every action must define a valid action for the script to work."));
            return;
        }
        ScriptActionData scriptActionData = new ScriptActionData(eliteEntity, directTarget, this.scriptTargets, this.eliteScript.getScriptZone(), event);
        this.scriptTask(scriptActionData);
    }

    public void runScript(ScriptActionData previousScriptActionData) {
        if (this.blueprint.getActionType() == null) {
            Logger.warn((String)("Script '" + this.blueprint.getScriptName() + "' in file '" + this.blueprint.getScriptFilename() + "' does not have a valid action! Every action must define a valid action for the script to work."));
            return;
        }
        ScriptActionData scriptActionData = new ScriptActionData(this.scriptTargets, this.eliteScript.getScriptZone(), previousScriptActionData);
        this.scriptTask(scriptActionData);
    }

    public void runScript(ScriptActionData previousScriptActionData, Location landingLocation) {
        ScriptActionData scriptActionData = new ScriptActionData(this.scriptTargets, this.eliteScript.getScriptZone(), previousScriptActionData, landingLocation);
        this.scriptTask(scriptActionData);
    }

    private void scriptTask(final ScriptActionData scriptActionData) {
        this.scriptTargets.cacheTargets(scriptActionData);
        if (this.finalScriptTargets != null) {
            this.finalScriptTargets.cacheTargets(scriptActionData);
        }
        if (this.blueprint.getWait().getValue() > 0) {
            new BukkitRunnable(){

                public void run() {
                    ScriptAction.this.runScriptTask(scriptActionData);
                }
            }.runTaskLater((Plugin)MetadataHandler.PLUGIN, (long)this.blueprint.getWait().getValue().intValue());
        } else {
            this.runScriptTask(scriptActionData);
        }
    }

    private void runScriptTask(final ScriptActionData scriptActionData) {
        if (this.blueprint.getRepeatEvery().getValue() > 0) {
            new BukkitRunnable(){
                int counter = 0;

                public void run() {
                    ++this.counter;
                    if (ScriptAction.this.blueprint.getConditionsBlueprint() != null && !ScriptAction.this.scriptConditions.meetsActionConditions(scriptActionData)) {
                        this.cancel();
                        return;
                    }
                    if (ScriptAction.this.blueprint.getTimes().getValue() > 0 && this.counter > ScriptAction.this.blueprint.getTimes().getValue()) {
                        this.cancel();
                        return;
                    }
                    if (ScriptAction.this.blueprint.getTimes().getValue() < 0 && !scriptActionData.getEliteEntity().isValid()) {
                        this.cancel();
                        return;
                    }
                    ScriptAction.this.runActions(scriptActionData);
                }
            }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 0L, (long)this.blueprint.getRepeatEvery().getValue().intValue());
        } else {
            if (this.blueprint.getConditionsBlueprint() != null && !this.scriptConditions.meetsActionConditions(scriptActionData)) {
                return;
            }
            this.runActions(scriptActionData);
        }
    }

    private void runActions(ScriptActionData scriptActionData) {
        if (this.blueprint.getActionType() == null) {
            Logger.warn((String)("Failed to determine action type in script '" + this.blueprint.getScriptName() + "' for file '" + this.blueprint.getScriptFilename() + "'"));
            return;
        }
        switch (this.blueprint.getActionType()) {
            case TELEPORT: {
                this.runTeleport(scriptActionData);
                break;
            }
            case MESSAGE: {
                this.runMessage(scriptActionData);
                break;
            }
            case ACTION_BAR_MESSAGE: {
                this.runActionBarMessage(scriptActionData);
                break;
            }
            case TITLE_MESSAGE: {
                this.runTitleMessage(scriptActionData);
                break;
            }
            case BOSS_BAR_MESSAGE: {
                this.runBossBarMessage(scriptActionData);
                break;
            }
            case POTION_EFFECT: {
                this.runPotionEffect(scriptActionData);
                break;
            }
            case DAMAGE: {
                this.runDamage(scriptActionData);
                break;
            }
            case SET_ON_FIRE: {
                this.runSetOnFire(scriptActionData);
                break;
            }
            case VISUAL_FREEZE: {
                this.runVisualFreeze(scriptActionData);
                break;
            }
            case PLACE_BLOCK: {
                this.runPlaceBlock(scriptActionData);
                break;
            }
            case RUN_COMMAND_AS_PLAYER: {
                this.runPlayerCommand(scriptActionData);
                break;
            }
            case RUN_COMMAND_AS_CONSOLE: {
                this.runConsoleCommand(scriptActionData);
                break;
            }
            case STRIKE_LIGHTNING: {
                this.runStrikeLightning(scriptActionData);
                break;
            }
            case SPAWN_PARTICLE: {
                this.runSpawnParticle(scriptActionData);
                break;
            }
            case SET_MOB_AI: {
                this.runSetMobAI(scriptActionData);
                break;
            }
            case SET_MOB_AWARE: {
                this.runSetMobAware(scriptActionData);
                break;
            }
            case PLAY_SOUND: {
                this.runPlaySound(scriptActionData);
                break;
            }
            case PUSH: {
                this.runPush(scriptActionData);
                break;
            }
            case SUMMON_REINFORCEMENT: {
                this.runSummonReinforcement(scriptActionData);
                break;
            }
            case RUN_SCRIPT: {
                this.runAdditionalScripts(scriptActionData);
                break;
            }
            case SPAWN_FIREWORKS: {
                this.runSpawnFireworks(scriptActionData);
                break;
            }
            case MAKE_INVULNERABLE: {
                this.runMakeInvulnerable(scriptActionData);
                break;
            }
            case TAG: {
                this.runTag(scriptActionData);
                break;
            }
            case UNTAG: {
                this.runUntag(scriptActionData);
                break;
            }
            case SET_TIME: {
                this.runSetTime(scriptActionData);
                break;
            }
            case SET_WEATHER: {
                this.runSetWeather(scriptActionData);
                break;
            }
            case PLAY_ANIMATION: {
                this.runPlayAnimation(scriptActionData);
                break;
            }
            case SPAWN_FALLING_BLOCK: {
                this.runSpawnFallingBlock(scriptActionData);
                break;
            }
            case MODIFY_DAMAGE: {
                this.runModifyDamage(scriptActionData);
                break;
            }
            case SUMMON_ENTITY: {
                this.runSummonEntity(scriptActionData);
                break;
            }
            case NAVIGATE: {
                this.runNavigate(scriptActionData);
                break;
            }
            case SCALE: {
                this.runScale(scriptActionData);
                break;
            }
            case SET_FACING: {
                this.setFacing(scriptActionData);
                break;
            }
            case HEAL: {
                this.runHeal(scriptActionData);
                break;
            }
            case REMOVE_ELITE: {
                this.runRemoveElite(scriptActionData);
                break;
            }
            default: {
                Logger.warn((String)("Unknown action type '" + this.blueprint.getActionType() + "' in script '" + this.blueprint.getScriptName() + "' for file '" + this.blueprint.getScriptFilename() + "'"));
            }
        }
        if (!this.blueprint.getActionType().equals((Object)ActionType.RUN_SCRIPT)) {
            this.runAdditionalScripts(scriptActionData);
        }
    }

    protected Collection<LivingEntity> getTargets(ScriptActionData scriptActionData) {
        Collection<LivingEntity> livingTargets = this.scriptConditions.validateEntities(scriptActionData, this.scriptTargets.getTargetEntities(scriptActionData));
        this.scriptTargets.setAnonymousTargets(new ArrayList<LivingEntity>(livingTargets));
        if (this.blueprint.isDebug()) {
            livingTargets.forEach(livingTarget -> Logger.showLocation((Location)livingTarget.getLocation()));
        }
        return livingTargets;
    }

    protected Collection<Location> getLocationTargets(ScriptActionData scriptActionData) {
        Collection<Location> locationTargets = this.scriptConditions.validateLocations(scriptActionData, this.scriptTargets.getTargetLocations(scriptActionData));
        this.scriptTargets.setAnonymousTargets(new ArrayList<Location>(locationTargets));
        if (this.blueprint.isDebug()) {
            locationTargets.forEach(Logger::showLocation);
        }
        return locationTargets;
    }

    protected Collection<Location> getFinalLocationTargets(ScriptActionData scriptActionData) {
        if (this.finalScriptTargets == null) {
            return Collections.emptyList();
        }
        Collection<Location> locationTargets = this.scriptConditions.validateLocations(scriptActionData, this.finalScriptTargets.getTargetLocations(scriptActionData));
        this.finalScriptTargets.setAnonymousTargets(new ArrayList<Location>(locationTargets));
        if (this.blueprint.isDebug()) {
            locationTargets.forEach(Logger::showLocation);
        }
        return locationTargets;
    }

    private void runTeleport(ScriptActionData scriptActionData) {
        Collection<LivingEntity> targets = this.getTargets(scriptActionData);
        Collection<Location> destinations = this.getFinalLocationTargets(scriptActionData);
        if (destinations.isEmpty()) {
            Logger.warn((String)("Failed to get teleport destination for script '" + this.blueprint.getScriptName() + "' because there is no set FinalTarget!"));
            return;
        }
        Location destination = destinations.iterator().next();
        targets.forEach(target -> {
            try {
                MatchInstance.MatchInstanceEvents.teleportBypass = true;
                target.teleport(destination);
            }
            catch (Exception e) {
                Logger.warn((String)("Failed to teleport entity '" + target.getName() + "' in script '" + this.blueprint.getScriptName() + "': " + e.getMessage()));
            }
            finally {
                MatchInstance.MatchInstanceEvents.teleportBypass = false;
            }
        });
    }

    private void runMessage(ScriptActionData scriptActionData) {
        String message = ChatColorConverter.convert((String)this.blueprint.getSValue());
        this.getTargets(scriptActionData).forEach(target -> target.sendMessage(message));
    }

    private void runTitleMessage(ScriptActionData scriptActionData) {
        if (this.blueprint.getTitle().isEmpty() && this.blueprint.getSubtitle().isEmpty()) {
            Logger.warn((String)("TITLE_MESSAGE action does not have any titles or subtitles for script '" + this.blueprint.getScriptName() + "' in file '" + this.blueprint.getScriptFilename() + "'"));
            return;
        }
        this.getTargets(scriptActionData).forEach(target -> {
            if (target instanceof Player) {
                Player player = (Player)target;
                player.sendTitle(this.blueprint.getTitle(), this.blueprint.getSubtitle(), this.blueprint.getFadeIn().getValue().intValue(), this.blueprint.getDuration().getValue().intValue(), this.blueprint.getFadeOut().getValue().intValue());
            } else {
                Logger.warn((String)("TITLE_MESSAGE actions must target players! Problematic script: '" + this.blueprint.getScriptName() + "' in file '" + this.blueprint.getScriptFilename() + "'"));
            }
        });
    }

    private void runActionBarMessage(ScriptActionData scriptActionData) {
        if (this.blueprint.getSValue().isEmpty()) {
            Logger.warn((String)("ACTION_BAR_MESSAGE action does not have a sValue for script '" + this.blueprint.getScriptName() + "' in file '" + this.blueprint.getScriptFilename() + "'"));
            return;
        }
        String message = this.blueprint.getSValue();
        this.getTargets(scriptActionData).forEach(target -> {
            if (target instanceof Player) {
                Player player = (Player)target;
                player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)message));
            } else {
                Logger.warn((String)("ACTION_BAR_MESSAGE actions must target players! Problematic script: '" + this.blueprint.getScriptName() + "' in file '" + this.blueprint.getScriptFilename() + "'"));
            }
        });
    }

    private void runBossBarMessage(ScriptActionData scriptActionData) {
        if (this.blueprint.getSValue().isEmpty()) {
            Logger.warn((String)("BOSS_BAR_MESSAGE action does not have a valid sValue for script '" + this.blueprint.getScriptName() + "' in file '" + this.blueprint.getScriptFilename() + "'"));
            return;
        }
        BossBar bossBar = Bukkit.createBossBar((String)this.blueprint.getSValue(), (BarColor)this.blueprint.getBarColor(), (BarStyle)this.blueprint.getBarStyle(), (BarFlag[])new BarFlag[0]);
        this.getTargets(scriptActionData).forEach(target -> {
            if (target instanceof Player) {
                Player player = (Player)target;
                bossBar.addPlayer(player);
                if (this.blueprint.getDuration().getValue() > 0) {
                    Bukkit.getScheduler().runTaskLater((Plugin)MetadataHandler.PLUGIN, () -> ((BossBar)bossBar).removeAll(), (long)this.blueprint.getDuration().getValue().intValue());
                }
            } else {
                Logger.warn((String)("BOSS_BAR_MESSAGE actions must target players! Problematic script: '" + this.blueprint.getScriptName() + "' in file '" + this.blueprint.getScriptFilename() + "'"));
            }
        });
    }

    private void runPotionEffect(ScriptActionData scriptActionData) {
        PotionEffect effect = new PotionEffect(this.blueprint.getPotionEffectType(), this.blueprint.getDuration().getValue().intValue(), this.blueprint.getAmplifier().getValue().intValue());
        this.getTargets(scriptActionData).forEach(target -> {
            if (target.isValid()) {
                target.addPotionEffect(effect);
            }
        });
    }

    private void runAdditionalScripts(ScriptActionData scriptActionData) {
        if (this.blueprint.getScripts() == null || this.blueprint.getScripts().isEmpty()) {
            if (this.blueprint.getActionType().equals((Object)ActionType.RUN_SCRIPT)) {
                Logger.warn((String)("No scripts found to run in RUN_SCRIPT action in script '" + this.blueprint.getScriptName() + "' in file '" + this.blueprint.getScriptFilename() + "'"));
            }
            return;
        }
        if (this.blueprint.isOnlyRunOneScript()) {
            String scriptName = this.blueprint.getScripts().get(ThreadLocalRandom.current().nextInt(this.blueprint.getScripts().size()));
            EliteScript script = this.eliteScriptMap.get(scriptName);
            if (script != null) {
                script.check(scriptActionData.getEliteEntity(), scriptActionData.getDirectTarget(), scriptActionData);
            } else {
                Logger.warn((String)("Failed to find script '" + scriptName + "' for script '" + this.blueprint.getScriptName() + "' in file '" + this.blueprint.getScriptFilename() + "'"));
            }
        } else {
            for (String scriptName : this.blueprint.getScripts()) {
                EliteScript script = this.eliteScriptMap.get(scriptName);
                if (script != null) {
                    script.check(scriptActionData.getEliteEntity(), scriptActionData.getDirectTarget(), scriptActionData);
                    continue;
                }
                Logger.warn((String)("Failed to find script '" + scriptName + "' for script '" + this.blueprint.getScriptName() + "' in file '" + this.blueprint.getScriptFilename() + "'"));
            }
        }
    }

    public static void shutdown() {
        invulnerablePlayers.forEach(player -> player.setInvulnerable(false));
        invulnerablePlayers.clear();
        scriptDamageDepth.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runDamage(ScriptActionData scriptActionData) {
        int currentDepth = scriptDamageDepth.get();
        if (currentDepth >= 3) {
            Logger.warn((String)("Maximum script damage depth (3) reached in script '" + this.blueprint.getScriptName() + "' in file '" + this.blueprint.getScriptFilename() + "'. Preventing infinite recursion."));
            return;
        }
        double damageAmount = this.blueprint.getAmount().getValue().floatValue();
        double multiplier = this.blueprint.getMultiplier().getValue().floatValue();
        try {
            scriptDamageDepth.set(currentDepth + 1);
            this.getTargets(scriptActionData).forEach(target -> {
                if (target instanceof Player) {
                    PlayerDamagedByEliteMobEvent.PlayerDamagedByEliteMobEventFilter.setSpecialMultiplier(multiplier);
                    if (scriptActionData.getEliteEntity().getLivingEntity() != null) {
                        target.damage(damageAmount, (Entity)scriptActionData.getEliteEntity().getLivingEntity());
                    } else {
                        target.damage(damageAmount);
                    }
                } else if (scriptActionData.getEliteEntity().getLivingEntity() != null) {
                    target.damage(damageAmount, (Entity)scriptActionData.getEliteEntity().getLivingEntity());
                } else {
                    target.damage(damageAmount);
                }
            });
        }
        finally {
            scriptDamageDepth.set(currentDepth);
            if (currentDepth == 0) {
                scriptDamageDepth.remove();
            }
        }
    }

    private void runSetOnFire(ScriptActionData scriptActionData) {
        int duration = this.blueprint.getDuration().getValue();
        this.getTargets(scriptActionData).forEach(target -> target.setFireTicks(duration));
    }

    private void runVisualFreeze(ScriptActionData scriptActionData) {
        int freezeTicks = this.blueprint.getAmount().getValue().intValue();
        this.getTargets(scriptActionData).forEach(target -> target.setFreezeTicks(target.getFreezeTicks() + freezeTicks));
    }

    private void runPlaceBlock(ScriptActionData scriptActionData) {
        this.getLocationTargets(scriptActionData).forEach(location -> {
            Block block = location.getBlock();
            if (this.blueprint.getDuration().getValue() > 0) {
                EntityTracker.addTemporaryBlock(block, this.blueprint.getDuration().getValue(), this.blueprint.getMaterial());
            } else {
                block.setType(this.blueprint.getMaterial());
            }
        });
    }

    private void runPlayerCommand(ScriptActionData scriptActionData) {
        String command = this.parseCommand(scriptActionData.getEliteEntity(), this.blueprint.getSValue());
        this.getTargets(scriptActionData).forEach(target -> {
            if (target instanceof Player) {
                Player player = (Player)target;
                player.performCommand(command);
            } else {
                Logger.warn((String)("RUN_COMMAND_AS_PLAYER action must target players! Problematic script: '" + this.blueprint.getScriptName() + "' in file '" + this.blueprint.getScriptFilename() + "'"));
            }
        });
    }

    private void runConsoleCommand(ScriptActionData scriptActionData) {
        String command = this.parseCommand(scriptActionData.getEliteEntity(), this.blueprint.getSValue());
        Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command);
    }

    private String parseCommand(EliteEntity eliteEntity, String commandTemplate) {
        Player player = eliteEntity.getLivingEntity() instanceof Player ? (Player)eliteEntity.getLivingEntity() : null;
        String playerName = player != null ? player.getName() : "Unknown";
        Location playerLocation = player != null ? player.getLocation() : new Location(null, 0.0, 0.0, 0.0);
        return commandTemplate.replace("$playerName", playerName).replace("$playerX", String.valueOf(playerLocation.getX())).replace("$playerY", String.valueOf(playerLocation.getY())).replace("$playerZ", String.valueOf(playerLocation.getZ())).replace("$bossName", eliteEntity.getName()).replace("$bossX", String.valueOf(eliteEntity.getLocation().getX())).replace("$bossY", String.valueOf(eliteEntity.getLocation().getY())).replace("$bossZ", String.valueOf(eliteEntity.getLocation().getZ())).replace("$bossLevel", String.valueOf(eliteEntity.getLevel())).replace("$bossWorldName", eliteEntity.getLocation().getWorld().getName());
    }

    private void runStrikeLightning(ScriptActionData scriptActionData) {
        this.getLocationTargets(scriptActionData).forEach(LightningSpawnBypass::strikeLightningIgnoreProtections);
    }

    private void runSpawnParticle(ScriptActionData scriptActionData) {
        boolean needsCentering = switch (scriptActionData.getTargetType()) {
            case TargetType.ZONE_FULL, TargetType.ZONE_BORDER, TargetType.INHERIT_SCRIPT_ZONE_FULL, TargetType.INHERIT_SCRIPT_ZONE_BORDER, TargetType.LOCATION, TargetType.LOCATIONS, TargetType.LANDING_LOCATION -> true;
            default -> false;
        };
        this.getLocationTargets(scriptActionData).forEach(location -> {
            Location targetLocation = needsCentering ? location.clone().add(0.5, 0.0, 0.5) : location;
            this.scriptParticles.visualize(scriptActionData, targetLocation, this.eliteScript);
        });
    }

    private void runSetMobAI(ScriptActionData scriptActionData) {
        boolean aiEnabled = this.blueprint.getBValue();
        int duration = this.blueprint.getDuration().getValue();
        this.getTargets(scriptActionData).forEach(target -> {
            target.setAI(aiEnabled);
            if (duration > 0) {
                Bukkit.getScheduler().runTaskLater((Plugin)MetadataHandler.PLUGIN, () -> target.setAI(!aiEnabled), (long)duration);
            }
        });
    }

    private void runSetMobAware(ScriptActionData scriptActionData) {
        boolean aware = this.blueprint.getBValue();
        int duration = this.blueprint.getDuration().getValue();
        this.getTargets(scriptActionData).forEach(target -> {
            if (target instanceof Mob) {
                Mob mob = (Mob)target;
                mob.setAware(aware);
                if (duration > 0) {
                    Bukkit.getScheduler().runTaskLater((Plugin)MetadataHandler.PLUGIN, () -> mob.setAware(!aware), (long)duration);
                }
            } else {
                Logger.warn((String)("SET_MOB_AWARE action must target mobs! Problematic script: '" + this.blueprint.getScriptName() + "' in file '" + this.blueprint.getScriptFilename() + "'"));
            }
        });
    }

    private void runPlaySound(ScriptActionData scriptActionData) {
        String sound = this.blueprint.getSValue();
        float volume = this.blueprint.getVolume().getValue().floatValue();
        float pitch = this.blueprint.getPitch().getValue().floatValue();
        this.getLocationTargets(scriptActionData).forEach(location -> {
            try {
                location.getWorld().playSound(location, sound, volume, pitch);
            }
            catch (Exception e) {
                Logger.warn((String)("Failed to play sound '" + sound + "' at location '" + location + "' in script '" + this.blueprint.getScriptName() + "': " + e.getMessage()));
            }
        });
    }

    private void runPush(final ScriptActionData scriptActionData) {
        Vector velocity;
        Vector vector = velocity = this.blueprint.getScriptRelativeVectorBlueprint() != null ? new ScriptRelativeVector(this.blueprint.getScriptRelativeVectorBlueprint(), this.eliteScript, scriptActionData.getEliteEntity().getLocation()).getVector(scriptActionData) : this.blueprint.getVValue();
        if (velocity == null || !this.isFiniteVector(velocity)) {
            velocity = new Vector(0, 0, 0);
        }
        final boolean additive = this.blueprint.getBValue() != null && this.blueprint.getBValue() != false;
        final Vector localFinalVelocity = velocity;
        new BukkitRunnable(){

            public void run() {
                Vector finalVelocity = localFinalVelocity;
                ScriptAction.this.getTargets(scriptActionData).forEach(target -> {
                    if (additive) {
                        target.setVelocity(target.getVelocity().add(finalVelocity));
                    } else {
                        target.setVelocity(finalVelocity);
                    }
                });
            }
        }.runTaskLater((Plugin)MetadataHandler.PLUGIN, 1L);
    }

    private boolean isFiniteVector(Vector vector) {
        return Double.isFinite(vector.getX()) && Double.isFinite(vector.getY()) && Double.isFinite(vector.getZ());
    }

    private void runSummonReinforcement(ScriptActionData scriptActionData) {
        this.getLocationTargets(scriptActionData).forEach(location -> {
            CustomBossEntity customBossEntity = CustomSummonPower.summonReinforcement(scriptActionData.getEliteEntity(), location, this.blueprint.getSValue(), this.blueprint.getDuration().getValue());
            if (customBossEntity != null && customBossEntity.getLivingEntity() != null) {
                Vector velocity;
                Vector vector = velocity = this.blueprint.getScriptRelativeVectorBlueprint() != null ? new ScriptRelativeVector(this.blueprint.getScriptRelativeVectorBlueprint(), this.eliteScript, customBossEntity.getLivingEntity().getLocation()).getVector(scriptActionData) : this.blueprint.getVValue();
                if (velocity != null) {
                    customBossEntity.getLivingEntity().setVelocity(velocity);
                }
            }
        });
    }

    private void runSpawnFireworks(ScriptActionData scriptActionData) {
        if (this.blueprint.getFireworkEffects().isEmpty()) {
            Logger.warn((String)("No colors set for fireworks in script '" + this.blueprint.getScriptName() + "' in file '" + this.blueprint.getScriptFilename() + "'"));
            return;
        }
        this.getLocationTargets(scriptActionData).forEach(location -> {
            try {
                Firework firework = (Firework)location.getWorld().spawn(location, Firework.class);
                firework.setPersistent(false);
                FireworkMeta fireworkMeta = firework.getFireworkMeta();
                List<FireworkEffect.Type> types = this.blueprint.getFireworkEffectTypes();
                List<List> colorsList = this.blueprint.getFireworkEffects().stream().map(colors -> colors.stream().map(ScriptActionBlueprint.FireworkColor::getColor).toList()).toList();
                if (types == null || types.isEmpty()) {
                    types = List.of(this.blueprint.getFireworkEffectType());
                }
                for (int i = 0; i < types.size(); ++i) {
                    FireworkEffect.Type type = types.get(i);
                    List colors2 = i < colorsList.size() ? colorsList.get(i) : colorsList.get(colorsList.size() - 1);
                    FireworkEffect effect = FireworkEffect.builder().with(type).withColor((Iterable)colors2).flicker(this.blueprint.isFlicker()).trail(this.blueprint.isWithTrail()).build();
                    fireworkMeta.addEffect(effect);
                }
                fireworkMeta.setPower(this.blueprint.getPower().getValue().intValue());
                if (this.blueprint.getVValue() != null) {
                    firework.setVelocity(this.blueprint.getVValue());
                    firework.setShotAtAngle(true);
                }
                firework.setFireworkMeta(fireworkMeta);
            }
            catch (Exception e) {
                Logger.warn((String)("Failed to spawn fireworks at location '" + location + "' in script '" + this.blueprint.getScriptName() + "': " + e.getMessage()));
            }
        });
    }

    private void runMakeInvulnerable(ScriptActionData scriptActionData) {
        boolean invulnerable = this.blueprint.isInvulnerable();
        int duration = this.blueprint.getDuration().getValue();
        this.getTargets(scriptActionData).forEach(target -> {
            target.setInvulnerable(invulnerable);
            if (target instanceof Player) {
                Player player = (Player)target;
                if (invulnerable) {
                    invulnerablePlayers.add(player);
                } else {
                    invulnerablePlayers.remove(player);
                }
            }
            if (duration > 0) {
                Bukkit.getScheduler().runTaskLater((Plugin)MetadataHandler.PLUGIN, () -> {
                    target.setInvulnerable(!invulnerable);
                    if (target instanceof Player) {
                        Player player = (Player)target;
                        if (invulnerable) {
                            invulnerablePlayers.remove(player);
                        } else {
                            invulnerablePlayers.add(player);
                        }
                    }
                }, (long)duration);
            }
        });
    }

    private void runTag(ScriptActionData scriptActionData) {
        List<String> tags = this.blueprint.getTags();
        int duration = this.blueprint.getDuration().getValue();
        this.getTargets(scriptActionData).forEach(target -> {
            Player player;
            ElitePlayerInventory playerInventory;
            EliteEntity bossEntity = EntityTracker.getEliteMobEntity((Entity)target);
            if (bossEntity != null) {
                bossEntity.addTags(tags);
            }
            if (target instanceof Player && (playerInventory = ElitePlayerInventory.getPlayer(player = (Player)target)) != null) {
                playerInventory.addTags(tags);
            }
            if (duration > 0) {
                Bukkit.getScheduler().runTaskLater((Plugin)MetadataHandler.PLUGIN, () -> {
                    Player player;
                    ElitePlayerInventory playerInventory;
                    if (bossEntity != null) {
                        bossEntity.removeTags(tags);
                    }
                    if (target instanceof Player && (playerInventory = ElitePlayerInventory.getPlayer(player = (Player)target)) != null) {
                        playerInventory.removeTags(tags);
                    }
                }, (long)duration);
            }
        });
    }

    private void runUntag(ScriptActionData scriptActionData) {
        List<String> tags = this.blueprint.getTags();
        int duration = this.blueprint.getDuration().getValue();
        this.getTargets(scriptActionData).forEach(target -> {
            Player player;
            ElitePlayerInventory playerInventory;
            EliteEntity bossEntity = EntityTracker.getEliteMobEntity((Entity)target);
            if (bossEntity != null) {
                bossEntity.removeTags(tags);
            }
            if (target instanceof Player && (playerInventory = ElitePlayerInventory.getPlayer(player = (Player)target)) != null) {
                playerInventory.removeTags(tags);
            }
            if (duration > 0) {
                Bukkit.getScheduler().runTaskLater((Plugin)MetadataHandler.PLUGIN, () -> {
                    Player player;
                    ElitePlayerInventory playerInventory;
                    if (bossEntity != null) {
                        bossEntity.addTags(tags);
                    }
                    if (target instanceof Player && (playerInventory = ElitePlayerInventory.getPlayer(player = (Player)target)) != null) {
                        playerInventory.addTags(tags);
                    }
                }, (long)duration);
            }
        });
    }

    private void runSetTime(ScriptActionData scriptActionData) {
        long time = this.blueprint.getTime().getValue().intValue();
        this.getLocationTargets(scriptActionData).forEach(location -> {
            try {
                location.getWorld().setTime(time);
            }
            catch (Exception e) {
                Logger.warn((String)("Failed to set time in world '" + location.getWorld().getName() + "' in script '" + this.blueprint.getScriptName() + "': " + e.getMessage()));
            }
        });
    }

    private void runSetWeather(ScriptActionData scriptActionData) {
        int duration = this.blueprint.getDuration().getValue();
        this.getTargets(scriptActionData).forEach(target -> {
            final World world = target.getWorld();
            try {
                switch (this.blueprint.getWeatherType()) {
                    case CLEAR: {
                        world.setStorm(false);
                        world.setThundering(false);
                        world.setWeatherDuration(duration > 0 ? duration : 6000);
                        break;
                    }
                    case PRECIPITATION: {
                        world.setStorm(true);
                        world.setThundering(false);
                        world.setWeatherDuration(duration > 0 ? duration : 6000);
                        if (duration <= 0) break;
                        new BukkitRunnable(){

                            public void run() {
                                world.setStorm(false);
                            }
                        }.runTaskLater((Plugin)MetadataHandler.PLUGIN, (long)(duration + 1));
                        break;
                    }
                    case THUNDER: {
                        world.setStorm(true);
                        world.setThundering(true);
                        world.setThunderDuration(duration > 0 ? duration : 6000);
                        new BukkitRunnable(){

                            public void run() {
                                world.setStorm(false);
                                world.setThundering(false);
                            }
                        }.runTaskLater((Plugin)MetadataHandler.PLUGIN, (long)(duration + 1));
                    }
                }
            }
            catch (Exception e) {
                Logger.warn((String)("Failed to set weather in world '" + world.getName() + "' in script '" + this.blueprint.getScriptName() + "': " + e.getMessage()));
            }
        });
    }

    private void runPlayAnimation(ScriptActionData scriptActionData) {
        this.getTargets(scriptActionData).forEach(target -> {
            CustomBossEntity customBossEntity;
            EliteEntity eliteEntity = EntityTracker.getEliteMobEntity((Entity)target);
            if (eliteEntity instanceof CustomBossEntity && (customBossEntity = (CustomBossEntity)eliteEntity).getCustomModel() != null) {
                customBossEntity.getCustomModel().playAnimationByName(this.blueprint.getSValue());
            }
        });
    }

    private void runSpawnFallingBlock(ScriptActionData scriptActionData) {
        this.getLocationTargets(scriptActionData).forEach(location -> {
            try {
                Vector velocity;
                FallingBlock fallingBlock = location.getWorld().spawnFallingBlock(location, this.blueprint.getMaterial().createBlockData());
                fallingBlock.setDropItem(false);
                fallingBlock.setHurtEntities(false);
                Vector vector = velocity = this.blueprint.getScriptRelativeVectorBlueprint() != null ? new ScriptRelativeVector(this.blueprint.getScriptRelativeVectorBlueprint(), this.eliteScript, (Location)location).getVector(scriptActionData) : this.blueprint.getVValue();
                if (velocity != null) {
                    fallingBlock.setVelocity(velocity);
                }
                ScriptListener.fallingBlocks.put(fallingBlock, new FallingEntityDataPair(this, scriptActionData));
            }
            catch (Exception e) {
                Logger.warn((String)("Failed to spawn falling block at location '" + location + "' in script '" + this.blueprint.getScriptName() + "': " + e.getMessage()));
            }
        });
    }

    private void runModifyDamage(ScriptActionData scriptActionData) {
        Event event = scriptActionData.getEvent();
        if (event instanceof EliteDamageEvent) {
            EliteDamageEvent eliteDamageEvent = (EliteDamageEvent)event;
            double newDamage = eliteDamageEvent.getDamage() * (double)this.blueprint.getMultiplier().getValue().floatValue();
            eliteDamageEvent.setDamage(newDamage);
        }
    }

    private void runSummonEntity(ScriptActionData scriptActionData) {
        EntityType entityType;
        try {
            entityType = EntityType.valueOf((String)this.blueprint.getSValue().toUpperCase());
        }
        catch (IllegalArgumentException e) {
            Logger.warn((String)("Invalid entity type '" + this.blueprint.getSValue() + "' in script '" + this.blueprint.getScriptName() + "' in file '" + this.blueprint.getScriptFilename() + "'"));
            return;
        }
        this.getLocationTargets(scriptActionData).forEach(location -> {
            Vector velocity = this.blueprint.getScriptRelativeVectorBlueprint() != null ? new ScriptRelativeVector(this.blueprint.getScriptRelativeVectorBlueprint(), this.eliteScript, (Location)location).getVector(scriptActionData) : this.blueprint.getVValue();
            try {
                Entity entity;
                if (scriptActionData.getEliteEntity().getLivingEntity() != null && Projectile.class.isAssignableFrom(entityType.getEntityClass())) {
                    entity = scriptActionData.getEliteEntity().getLivingEntity().launchProjectile(entityType.getEntityClass().asSubclass(Projectile.class), velocity);
                    ((Projectile)entity).setShooter((ProjectileSource)scriptActionData.getEliteEntity().getLivingEntity());
                    if (entity instanceof Fireball) {
                        Fireball fireball = (Fireball)entity;
                        fireball.setDirection(velocity);
                    }
                } else {
                    entity = location.getWorld().spawn(location, entityType.getEntityClass());
                    if (velocity != null) {
                        entity.setVelocity(velocity);
                    }
                }
                if (this.blueprint.getDuration().getValue() != null && entity != null) {
                    new BukkitRunnable(){

                        public void run() {
                            if (entity != null && entity.isValid()) {
                                entity.remove();
                            }
                        }
                    }.runTaskLater((Plugin)MetadataHandler.PLUGIN, (long)this.blueprint.getDuration().getValue().intValue());
                }
                if (!this.blueprint.getLandingScripts().isEmpty()) {
                    final FallingEntityDataPair dataPair = new FallingEntityDataPair(this, scriptActionData);
                    new BukkitRunnable(){
                        final int maxTicks = 6000;
                        int counter = 0;

                        public void run() {
                            if (!entity.isValid() || entity.isOnGround() || this.counter > 6000) {
                                ScriptListener.runEvent(dataPair, entity.getLocation());
                                this.cancel();
                            }
                            ++this.counter;
                        }
                    }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 1L, 1L);
                }
            }
            catch (Exception e) {
                Logger.warn((String)("Failed to summon entity at location '" + location + "' in script '" + this.blueprint.getScriptName() + "': " + e.getMessage()));
            }
        });
    }

    private void runNavigate(ScriptActionData scriptActionData) {
        Collection<LivingEntity> targets = this.getTargets(scriptActionData);
        Collection<Location> destinations = this.getFinalLocationTargets(scriptActionData);
        if (destinations.isEmpty()) {
            Logger.warn((String)("Failed to get navigation destination for script '" + this.blueprint.getScriptName() + "' because there is no set FinalTarget!"));
            return;
        }
        Location destination = destinations.iterator().next();
        double speed = this.blueprint.getVelocity().getValue().floatValue();
        boolean avoidObstacles = this.blueprint.getBValue();
        int duration = this.blueprint.getDuration().getValue();
        targets.forEach(target -> {
            EliteEntity eliteEntity = EntityTracker.getEliteMobEntity((Entity)target);
            if (eliteEntity instanceof CustomBossEntity) {
                CustomBossEntity customBossEntity = (CustomBossEntity)eliteEntity;
                Navigation.navigateTo(customBossEntity, speed, destination, avoidObstacles, duration);
            }
        });
    }

    private void runScale(ScriptActionData scriptActionData) {
        double scaleValue = this.blueprint.getScale().getValue().floatValue();
        int duration = this.blueprint.getDuration().getValue();
        this.getTargets(scriptActionData).forEach(target -> {
            AttributeInstance attribute = AttributeManager.getAttributeInstance((LivingEntity)target, (String)"generic_scale");
            if (attribute != null) {
                attribute.setBaseValue(scaleValue);
                if (duration > 0) {
                    Bukkit.getScheduler().runTaskLater((Plugin)MetadataHandler.PLUGIN, () -> attribute.setBaseValue(1.0), (long)duration);
                }
            }
        });
    }

    private void setFacing(ScriptActionData scriptActionData) {
        Vector direction;
        Vector vector = direction = this.blueprint.getScriptRelativeVectorBlueprint() != null ? new ScriptRelativeVector(this.blueprint.getScriptRelativeVectorBlueprint(), this.eliteScript, scriptActionData.getEliteEntity().getLocation()).getVector(scriptActionData) : this.blueprint.getVValue();
        if (direction == null) {
            Logger.warn((String)("Tried to set direction in " + this.getBlueprint().getScriptFilename() + " but no configuration for vvalue or relative vector are set in " + this.blueprint.getScriptName() + " !"));
            return;
        }
        this.getTargets(scriptActionData).forEach(target -> {
            Location location = target.getLocation();
            location.setDirection(direction);
            target.teleport(location);
        });
    }

    private void runHeal(ScriptActionData scriptActionData) {
        double healAmount = this.blueprint.getAmount().getValue().floatValue();
        this.getTargets(scriptActionData).forEach(target -> {
            EliteEntity eliteEntity = EntityTracker.getEliteMobEntity((Entity)target);
            if (eliteEntity != null) {
                eliteEntity.heal(healAmount);
            } else {
                double maxHp = AttributeManager.getAttributeBaseValue((LivingEntity)target, (String)"generic_max_health");
                double newHp = Math.min(target.getHealth() + healAmount, maxHp);
                target.setHealth(newHp);
            }
        });
    }

    private void runRemoveElite(ScriptActionData scriptActionData) {
        this.getTargets(scriptActionData).forEach(target -> {
            EliteEntity eliteEntity = EntityTracker.getEliteMobEntity((Entity)target);
            if (eliteEntity != null) {
                eliteEntity.remove(RemovalReason.OTHER);
            }
        });
    }

    @Generated
    public static Set<Player> getInvulnerablePlayers() {
        return invulnerablePlayers;
    }

    @Generated
    public ScriptActionBlueprint getBlueprint() {
        return this.blueprint;
    }

    @Generated
    public Map<String, EliteScript> getEliteScriptMap() {
        return this.eliteScriptMap;
    }
}

