/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.playerdata;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.items.potioneffects.ElitePotionEffect;
import com.magmaguy.elitemobs.playerdata.PlayerItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class ElitePlayerInventory {
    public static HashMap<UUID, ElitePlayerInventory> playerInventories = new HashMap();
    public final PlayerItem helmet;
    public final PlayerItem chestplate;
    public final PlayerItem leggings;
    public final PlayerItem boots;
    public final PlayerItem mainhand;
    public final PlayerItem offhand;
    private final Player player;
    private final HashSet<String> customMetadata = new HashSet();
    private boolean isUpdateLock = false;

    public ElitePlayerInventory(Player player) {
        this.player = player;
        this.helmet = new PlayerItem(player.getInventory().getHelmet(), PlayerItem.EquipmentSlot.HELMET, player);
        this.chestplate = new PlayerItem(player.getInventory().getChestplate(), PlayerItem.EquipmentSlot.CHESTPLATE, player);
        this.leggings = new PlayerItem(player.getInventory().getLeggings(), PlayerItem.EquipmentSlot.LEGGINGS, player);
        this.boots = new PlayerItem(player.getInventory().getBoots(), PlayerItem.EquipmentSlot.BOOTS, player);
        this.mainhand = new PlayerItem(player.getInventory().getItemInMainHand(), PlayerItem.EquipmentSlot.MAINHAND, player);
        this.offhand = new PlayerItem(player.getInventory().getItemInOffHand(), PlayerItem.EquipmentSlot.OFFHAND, player);
        playerInventories.put(player.getUniqueId(), this);
    }

    public static ElitePlayerInventory getPlayer(Player player) {
        return playerInventories.get(player.getUniqueId());
    }

    public static void initialize() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            playerInventories.put(player.getUniqueId(), new ElitePlayerInventory(player));
        }
    }

    public double getEliteDamage(boolean update) {
        if (this.isUpdateLock) {
            update = false;
        }
        double eliteDamage = this.helmet.getEliteDamage(this.player.getInventory().getHelmet(), update) + this.chestplate.getEliteDamage(this.player.getInventory().getChestplate(), update) + this.leggings.getEliteDamage(this.player.getInventory().getLeggings(), update) + this.boots.getEliteDamage(this.player.getInventory().getBoots(), update) + this.mainhand.getEliteDamage(this.player.getInventory().getItemInMainHand(), update) + this.offhand.getEliteDamage(this.player.getInventory().getItemInOffHand(), update);
        this.updateLock();
        return eliteDamage;
    }

    public double getEliteDefense(boolean update) {
        if (this.isUpdateLock) {
            update = false;
        }
        double defense = this.helmet.getEliteDefense(this.player.getInventory().getHelmet(), update) + this.chestplate.getEliteDefense(this.player.getInventory().getChestplate(), update) + this.leggings.getEliteDefense(this.player.getInventory().getLeggings(), update) + this.boots.getEliteDefense(this.player.getInventory().getBoots(), update) + this.mainhand.getEliteDefense(this.player.getInventory().getItemInMainHand(), update) + this.offhand.getEliteDefense(this.player.getInventory().getItemInOffHand(), update);
        this.updateLock();
        return defense;
    }

    public double getEliteProjectileProtection(boolean update) {
        if (this.isUpdateLock) {
            update = false;
        }
        double eliteProjectileProtection = (this.helmet.getProtectionProjectile(this.player.getInventory().getHelmet(), update) + this.chestplate.getProtectionProjectile(this.player.getInventory().getChestplate(), update) + this.leggings.getProtectionProjectile(this.player.getInventory().getLeggings(), update) + this.boots.getProtectionProjectile(this.player.getInventory().getBoots(), update) + this.mainhand.getProtectionProjectile(this.player.getInventory().getItemInMainHand(), update) + this.offhand.getProtectionProjectile(this.player.getInventory().getItemInOffHand(), update)) / 6.0;
        this.updateLock();
        return eliteProjectileProtection;
    }

    public double getEliteBlastProtection(boolean update) {
        if (this.isUpdateLock) {
            update = false;
        }
        double eliteBlastProtection = (this.helmet.getBlastProtection(this.player.getInventory().getHelmet(), update) + this.chestplate.getBlastProtection(this.player.getInventory().getChestplate(), update) + this.leggings.getBlastProtection(this.player.getInventory().getLeggings(), update) + this.boots.getBlastProtection(this.player.getInventory().getBoots(), update) + this.mainhand.getBlastProtection(this.player.getInventory().getItemInMainHand(), update) + this.offhand.getBlastProtection(this.player.getInventory().getItemInOffHand(), update)) / 6.0;
        this.updateLock();
        return eliteBlastProtection;
    }

    private boolean updateLock() {
        this.isUpdateLock = true;
        Bukkit.getScheduler().runTaskLater((Plugin)MetadataHandler.PLUGIN, () -> {
            this.isUpdateLock = false;
        }, 1L);
        return true;
    }

    public int getWeaponLevel(boolean update) {
        if (this.isUpdateLock) {
            update = false;
        }
        int weaponLevel = this.mainhand.getTier(this.player.getInventory().getItemInMainHand(), update);
        this.updateLock();
        return weaponLevel;
    }

    public int getFullPlayerTier(boolean update) {
        if (this.isUpdateLock) {
            update = false;
        }
        int fullPlayerTier = (int)((double)(this.helmet.getTier(this.player.getInventory().getHelmet(), update) + this.chestplate.getTier(this.player.getInventory().getChestplate(), update) + this.leggings.getTier(this.player.getInventory().getLeggings(), update) + this.boots.getTier(this.player.getInventory().getBoots(), update) + this.mainhand.getTier(this.player.getInventory().getItemInMainHand(), update)) / 5.0);
        this.updateLock();
        return fullPlayerTier;
    }

    public int getNaturalMobSpawnLevel(boolean update) {
        if (this.isUpdateLock) {
            update = false;
        }
        if (this.player.getGameMode().equals((Object)GameMode.SPECTATOR)) {
            return 0;
        }
        int naturalMobSpawnLevel = (int)((double)(this.helmet.getTier(this.player.getInventory().getHelmet(), update) + this.chestplate.getTier(this.player.getInventory().getChestplate(), update) + this.leggings.getTier(this.player.getInventory().getLeggings(), update) + this.boots.getTier(this.player.getInventory().getBoots(), update) + this.mainhand.getTier(this.player.getInventory().getItemInMainHand(), update)) / 5.0 * 1.0);
        this.updateLock();
        return naturalMobSpawnLevel;
    }

    public ArrayList<ElitePotionEffect> getContinuousPotionEffects(boolean update) {
        if (this.isUpdateLock) {
            update = false;
        }
        ArrayList<ElitePotionEffect> elitePotionEffects = new ArrayList<ElitePotionEffect>();
        elitePotionEffects.addAll(this.helmet.getContinuousPotionEffects(this.player.getInventory().getHelmet(), update));
        elitePotionEffects.addAll(this.chestplate.getContinuousPotionEffects(this.player.getInventory().getChestplate(), update));
        elitePotionEffects.addAll(this.leggings.getContinuousPotionEffects(this.player.getInventory().getLeggings(), update));
        elitePotionEffects.addAll(this.boots.getContinuousPotionEffects(this.player.getInventory().getBoots(), update));
        elitePotionEffects.addAll(this.mainhand.getContinuousPotionEffects(this.player.getInventory().getItemInMainHand(), update));
        elitePotionEffects.addAll(this.offhand.getContinuousPotionEffects(this.player.getInventory().getItemInOffHand(), update));
        this.updateLock();
        return elitePotionEffects;
    }

    public ArrayList<ElitePotionEffect> getOnHitPotionEffects(boolean update) {
        if (this.isUpdateLock) {
            update = false;
        }
        ArrayList<ElitePotionEffect> elitePotionEffects = new ArrayList<ElitePotionEffect>();
        elitePotionEffects.addAll(this.helmet.getOnHitPotionEffects(this.player.getInventory().getHelmet(), update));
        elitePotionEffects.addAll(this.chestplate.getOnHitPotionEffects(this.player.getInventory().getChestplate(), update));
        elitePotionEffects.addAll(this.leggings.getOnHitPotionEffects(this.player.getInventory().getLeggings(), update));
        elitePotionEffects.addAll(this.boots.getOnHitPotionEffects(this.player.getInventory().getBoots(), update));
        elitePotionEffects.addAll(this.mainhand.getOnHitPotionEffects(this.player.getInventory().getItemInMainHand(), update));
        elitePotionEffects.addAll(this.offhand.getOnHitPotionEffects(this.player.getInventory().getItemInOffHand(), update));
        this.updateLock();
        return elitePotionEffects;
    }

    public double getCritChance(boolean update) {
        if (this.isUpdateLock) {
            update = false;
        }
        double critChance = this.mainhand.getCritChance(this.player.getInventory().getItemInMainHand(), update);
        this.updateLock();
        return critChance;
    }

    public double getLightningChance(boolean update) {
        if (this.isUpdateLock) {
            update = false;
        }
        double lightningChance = this.mainhand.getLightningChance(this.player.getInventory().getItemInMainHand(), update);
        this.updateLock();
        return lightningChance;
    }

    public double getHunterChance(boolean update) {
        if (this.isUpdateLock) {
            update = false;
        }
        double hunterChance = this.helmet.getHunterChance(this.player.getInventory().getHelmet(), update) + this.chestplate.getHunterChance(this.player.getInventory().getChestplate(), update) + this.leggings.getHunterChance(this.player.getInventory().getLeggings(), update) + this.boots.getHunterChance(this.player.getInventory().getBoots(), update);
        this.updateLock();
        return hunterChance;
    }

    public double getPlasmaBootsLevel(boolean update) {
        if (this.isUpdateLock) {
            update = false;
        }
        double plasmaBootsLevel = this.boots.getPlasmaBootsLevel(this.player.getInventory().getBoots(), update);
        this.updateLock();
        return plasmaBootsLevel;
    }

    public double getEarthquakeLevel(boolean update) {
        if (this.isUpdateLock) {
            update = false;
        }
        double earthquakeLevel = this.helmet.getEarthquakeLevel(this.player.getInventory().getHelmet(), update) + this.chestplate.getEarthquakeLevel(this.player.getInventory().getChestplate(), update) + this.leggings.getEarthquakeLevel(this.player.getInventory().getLeggings(), update) + this.boots.getEarthquakeLevel(this.player.getInventory().getBoots(), update);
        this.updateLock();
        return earthquakeLevel;
    }

    public double baseDamage() {
        if (this.getWeaponLevel(true) == 0) {
            return 1.0;
        }
        return this.getWeaponLevel(false);
    }

    public double getLoudStrikesBonusMultiplier(boolean update) {
        if (this.isUpdateLock) {
            update = false;
        }
        double loudStrikesBonusMultiplier = this.helmet.getLoudStrikesBonus(this.player.getInventory().getHelmet(), update) + this.chestplate.getLoudStrikesBonus(this.player.getInventory().getChestplate(), update) + this.leggings.getLoudStrikesBonus(this.player.getInventory().getLeggings(), update) + this.boots.getLoudStrikesBonus(this.player.getInventory().getBoots(), update) + this.mainhand.getLoudStrikesBonus(this.player.getInventory().getItemInMainHand(), update) + this.offhand.getLoudStrikesBonus(this.player.getInventory().getItemInOffHand(), update);
        this.updateLock();
        return loudStrikesBonusMultiplier;
    }

    public boolean hasTag(String string) {
        return this.customMetadata.contains(string);
    }

    public HashSet<String> getTags() {
        return this.customMetadata;
    }

    public void addTags(List<String> string) {
        this.customMetadata.addAll(string);
    }

    public void removeTags(List<String> string) {
        this.customMetadata.removeAll(string);
    }

    public static class ElitePlayerInventoryEvents
    implements Listener {
        @EventHandler
        public void onPlayerLogin(PlayerLoginEvent event) {
            playerInventories.put(event.getPlayer().getUniqueId(), new ElitePlayerInventory(event.getPlayer()));
        }

        @EventHandler
        public void onPlayerLogout(PlayerQuitEvent event) {
            playerInventories.remove(event.getPlayer().getUniqueId());
        }
    }
}

