/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.mobconstructor;

import com.magmaguy.elitemobs.EliteMobs;
import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.adventurersguild.GuildRank;
import com.magmaguy.elitemobs.config.ValidWorldsConfig;
import com.magmaguy.elitemobs.config.custombosses.CustomBossesConfig;
import com.magmaguy.elitemobs.config.custombosses.CustomBossesConfigFields;
import com.magmaguy.elitemobs.config.customspawns.CustomSpawnConfig;
import com.magmaguy.elitemobs.config.customspawns.CustomSpawnConfigFields;
import com.magmaguy.elitemobs.dungeons.EliteMobsWorld;
import com.magmaguy.elitemobs.events.MoonPhaseDetector;
import com.magmaguy.elitemobs.events.TimedEvent;
import com.magmaguy.elitemobs.mobconstructor.custombosses.CustomBossEntity;
import com.magmaguy.elitemobs.playerdata.database.PlayerData;
import com.magmaguy.elitemobs.thirdparty.worldguard.WorldGuardFlagChecker;
import com.magmaguy.magmacore.instance.MatchInstance;
import com.magmaguy.magmacore.util.Logger;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.GameRule;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Zombie;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class CustomSpawn {
    private final CustomSpawnConfigFields customSpawnConfigFields;
    private final ArrayList<CustomBossEntity> customBossEntities = new ArrayList();
    private boolean isEvent = false;
    private World world;
    private TimedEvent timedEvent;
    private int allTries = 0;
    private Location spawnLocation;
    private boolean keepTrying = true;

    public CustomSpawn(String customSpawnConfig, List<String> customBossesFilenames, TimedEvent timedEvent) {
        this.customSpawnConfigFields = CustomSpawnConfig.getCustomEvent(customSpawnConfig);
        this.timedEvent = timedEvent;
        if (this.customSpawnConfigFields == null) {
            Logger.warn((String)("Invalid custom spawn detected for file " + customSpawnConfig + " in event " + timedEvent.getCustomEventsConfigFields().getFilename()));
            return;
        }
        customBossesFilenames.forEach(bossString -> {
            CustomBossesConfigFields customBossesConfigFields = CustomBossesConfig.getCustomBoss(bossString);
            if (customBossesConfigFields == null) {
                Logger.warn((String)("Attempted to pass invalid boss into CustomSpawn: " + bossString));
                return;
            }
            CustomBossEntity customBossEntity = new CustomBossEntity(customBossesConfigFields);
            this.customBossEntities.add(customBossEntity);
            customBossEntity.setCustomSpawn(this);
        });
    }

    public CustomSpawn(String customSpawnConfig, CustomBossEntity customBossEntity) {
        this.customSpawnConfigFields = CustomSpawnConfig.getCustomEvent(customSpawnConfig);
        if (this.customSpawnConfigFields == null) {
            Logger.warn((String)("Invalid custom spawn detected for file " + customSpawnConfig));
            return;
        }
        this.customBossEntities.add(customBossEntity);
    }

    public static int getHighestValidBlock(Location location, int highestYLevel) {
        int height = location.getBlockY() - 1;
        while (height < 256) {
            Location locationAbove;
            Location tempLocation;
            if (++height > highestYLevel) {
                return -1;
            }
            Location floorLocation = new Location(location.getWorld(), location.getX(), (double)(height - 1), location.getZ());
            if (floorLocation.getBlock().isPassable() || !(tempLocation = new Location(location.getWorld(), location.getX(), (double)height, location.getZ())).getBlock().getType().isAir() || !(locationAbove = new Location(location.getWorld(), location.getX(), (double)(height + 1), location.getZ())).getBlock().getType().isAir()) continue;
            return height;
        }
        return -100;
    }

    public void queueSpawn() {
        if (this.spawnLocation == null) {
            new BukkitRunnable(){

                public void run() {
                    CustomSpawn.this.generateCustomSpawn();
                }
            }.runTaskAsynchronously((Plugin)MetadataHandler.PLUGIN);
        } else {
            this.spawn();
        }
    }

    private void spawn() {
        new BukkitRunnable(){

            public void run() {
                if (CustomSpawn.this.spawnLocation == null) {
                    Bukkit.getScheduler().runTaskLater((Plugin)MetadataHandler.PLUGIN, () -> CustomSpawn.this.generateCustomSpawn(), 1L);
                    this.cancel();
                    return;
                }
                LivingEntity testEntity = (LivingEntity)CustomSpawn.this.spawnLocation.getWorld().spawn(CustomSpawn.this.spawnLocation, Zombie.class);
                if (!testEntity.isValid()) {
                    CustomSpawn.this.spawnLocation = null;
                    Bukkit.getScheduler().runTaskLater((Plugin)MetadataHandler.PLUGIN, () -> CustomSpawn.this.generateCustomSpawn(), 1L);
                    this.cancel();
                    return;
                }
                testEntity.remove();
                if (!CustomSpawn.this.keepTrying) {
                    this.cancel();
                }
                if (Objects.requireNonNull(CustomSpawn.this.spawnLocation.getWorld()).getTime() < CustomSpawn.this.customSpawnConfigFields.getEarliestTime() || CustomSpawn.this.spawnLocation.getWorld().getTime() > CustomSpawn.this.customSpawnConfigFields.getLatestTime()) {
                    return;
                }
                if (CustomSpawn.this.customSpawnConfigFields.getMoonPhase() != null && !MoonPhaseDetector.detectMoonPhase(CustomSpawn.this.spawnLocation.getWorld()).equals((Object)CustomSpawn.this.customSpawnConfigFields.getMoonPhase())) {
                    return;
                }
                for (CustomBossEntity customBossEntity : CustomSpawn.this.customBossEntities) {
                    if (customBossEntity.exists()) continue;
                    customBossEntity.spawn(CustomSpawn.this.spawnLocation, CustomSpawn.this.isEvent);
                }
                this.cancel();
                if (CustomSpawn.this.timedEvent != null) {
                    CustomSpawn.this.timedEvent.queueEvent();
                }
            }
        }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 0L, 1L);
    }

    private void generateCustomSpawn() {
        if (this.timedEvent != null && (double)System.currentTimeMillis() < TimedEvent.getNextEventStartMinimum()) {
            Bukkit.getScheduler().scheduleAsyncDelayedTask((Plugin)MetadataHandler.PLUGIN, this::generateCustomSpawn, 1200L);
            return;
        }
        int maxTries = 100;
        int tries = 0;
        while (tries < maxTries && this.spawnLocation == null) {
            if (!this.keepTrying) {
                return;
            }
            ++tries;
            ++this.allTries;
            this.spawnLocation = this.generateRandomSpawnLocation();
            if (this.spawnLocation == null) continue;
        }
        if (this.spawnLocation == null) {
            if (this.keepTrying) {
                new BukkitRunnable(){

                    public void run() {
                        CustomSpawn.this.generateCustomSpawn();
                    }
                }.runTaskLaterAsynchronously((Plugin)MetadataHandler.PLUGIN, 1200L);
            } else {
                this.customBossEntities.forEach(customBossEntity -> {
                    if (customBossEntity.summoningEntity != null) {
                        customBossEntity.summoningEntity.removeReinforcement((CustomBossEntity)customBossEntity);
                    }
                });
            }
        } else {
            this.spawn();
        }
    }

    public Location generateRandomSpawnLocation() {
        if (this.customSpawnConfigFields == null) {
            Logger.warn((String)"Something tried to spawn but has invalid custom spawn config fields! This isn't good.", (boolean)true);
            Logger.warn((String)"Bosses: ");
            this.getCustomBossEntities().forEach(customBossEntity -> {
                if (customBossEntity != null && customBossEntity.getName() != null) {
                    Logger.warn((String)customBossEntity.getCustomBossesConfigFields().getName());
                }
            });
            if (this.timedEvent != null) {
                Logger.warn((String)("Event: " + this.timedEvent.getCustomEventsConfigFields().getFilename()));
                this.timedEvent.end();
            }
            return null;
        }
        if (Bukkit.getOnlinePlayers().isEmpty()) {
            this.keepTrying = false;
            if (this.timedEvent != null) {
                this.timedEvent.end();
            }
            return null;
        }
        ArrayList<Player> validPlayers = new ArrayList<Player>();
        if (this.world == null) {
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (!PlayerData.isInMemory(player.getUniqueId()) || GuildRank.isAtOrAboveGuildRank(player, 0, 0)) continue;
                Location playerLocation = player.getLocation();
                if (!ValidWorldsConfig.getValidWorlds().contains(playerLocation.getWorld().getName())) continue;
                boolean isInMatch = false;
                for (MatchInstance instance : MatchInstance.getInstances()) {
                    if (!instance.isInRegion(playerLocation)) continue;
                    isInMatch = true;
                    break;
                }
                if (isInMatch || this.timedEvent != null && EliteMobsWorld.isEliteMobsWorld(player.getWorld().getUID()) || Boolean.FALSE.equals(playerLocation.getWorld().getGameRuleValue(GameRule.DO_MOB_SPAWNING)) || !this.customSpawnConfigFields.getValidWorlds().isEmpty() && !this.customSpawnConfigFields.getValidWorlds().contains(playerLocation.getWorld()) || !this.customSpawnConfigFields.getValidWorldEnvironments().isEmpty() && !this.customSpawnConfigFields.getValidWorldEnvironments().contains(Objects.requireNonNull(playerLocation.getWorld()).getEnvironment()) || GuildRank.getActiveGuildRank(player) == 0) continue;
                validPlayers.add(player);
            }
        } else {
            validPlayers.addAll(this.world.getPlayers());
        }
        if (validPlayers.isEmpty()) {
            return null;
        }
        Player selectedPlayer = (Player)validPlayers.get(ThreadLocalRandom.current().nextInt(validPlayers.size()));
        Vector randomizedVector = new Vector(ThreadLocalRandom.current().nextInt(24, 128), 0, ThreadLocalRandom.current().nextInt(24, 128));
        if (ThreadLocalRandom.current().nextBoolean()) {
            randomizedVector.setX(randomizedVector.getX() * -1.0);
        }
        if (ThreadLocalRandom.current().nextBoolean()) {
            randomizedVector.setY(randomizedVector.getY() * -1.0);
        }
        Location location = selectedPlayer.getLocation().clone().add(randomizedVector);
        location.setY((double)ThreadLocalRandom.current().nextInt(0, 256));
        World world = location.getWorld();
        if (!this.customSpawnConfigFields.getValidBiomesStrings().isEmpty() && !this.customSpawnConfigFields.getValidBiomesStrings().contains(location.getBlock().getBiome())) {
            return null;
        }
        if (this.customSpawnConfigFields.isSurfaceSpawn()) {
            location = Objects.requireNonNull(location.getWorld()).getHighestBlockAt(location).getLocation().add(new Vector(0.5, 1.0, 0.5));
        } else if (this.customSpawnConfigFields.isUndergroundSpawn()) {
            int highestBlockYAt = Objects.requireNonNull(location.getWorld()).getHighestBlockYAt(location);
            if (location.getY() > (double)highestBlockYAt || location.getY() > (double)highestBlockYAt / 2.0) {
                for (y = (int)location.getY(); y > -64; --y) {
                    tempLocation = location.clone();
                    tempLocation.setY((double)y);
                    if (location.getBlock().getType().equals((Object)Material.VOID_AIR)) {
                        return null;
                    }
                    if (y < this.customSpawnConfigFields.getLowestYLevel()) {
                        return null;
                    }
                    groundBlock = location.clone().subtract(new Vector(0, 1, 0)).getBlock();
                    if (!groundBlock.getType().isSolid() || !tempLocation.getBlock().getType().isAir() || !tempLocation.add(new Vector(0, 1, 0)).getBlock().getType().isAir()) continue;
                    location = tempLocation;
                    break;
                }
            } else {
                for (y = (int)location.getY(); y < highestBlockYAt; ++y) {
                    tempLocation = location.clone();
                    tempLocation.setY((double)y);
                    if (location.getBlock().getType().equals((Object)Material.VOID_AIR)) {
                        return null;
                    }
                    if (y < this.customSpawnConfigFields.getLowestYLevel()) {
                        return null;
                    }
                    groundBlock = location.clone().subtract(new Vector(0, 1, 0)).getBlock();
                    if (!groundBlock.getType().isSolid() || !tempLocation.getBlock().getType().isAir() || !tempLocation.add(new Vector(0, 1, 0)).getBlock().getType().isAir()) continue;
                    location = tempLocation;
                    break;
                }
            }
        } else {
            location.setY((double)CustomSpawn.getHighestValidBlock(location, CustomSpawn.getHighestValidBlock(location, this.customSpawnConfigFields.getHighestYLevel())));
        }
        assert (world != null);
        for (Player player : world.getPlayers()) {
            if (!(player.getLocation().distanceSquared(location) < Math.pow(24.0, 2.0))) continue;
            return null;
        }
        if (location.getY() > 127.0 && world.getEnvironment().equals((Object)World.Environment.NETHER)) {
            return null;
        }
        if (location.getY() == -100.0 || location.getY() > (double)this.customSpawnConfigFields.getHighestYLevel() || location.getY() < (double)this.customSpawnConfigFields.getLowestYLevel()) {
            return null;
        }
        if (EliteMobs.worldGuardIsEnabled) {
            if (!WorldGuardFlagChecker.doEventFlag(location)) {
                return null;
            }
            if (!WorldGuardFlagChecker.doEliteMobsSpawnFlag(location)) {
                return null;
            }
            if (!WorldGuardFlagChecker.doMobSpawnFlag(location)) {
                return null;
            }
        }
        if (!this.customSpawnConfigFields.isCanSpawnInLight() && location.getBlock().getLightLevel() > 8) {
            return null;
        }
        return location;
    }

    @Generated
    public CustomSpawnConfigFields getCustomSpawnConfigFields() {
        return this.customSpawnConfigFields;
    }

    @Generated
    public ArrayList<CustomBossEntity> getCustomBossEntities() {
        return this.customBossEntities;
    }

    @Generated
    public boolean isEvent() {
        return this.isEvent;
    }

    @Generated
    public void setEvent(boolean isEvent) {
        this.isEvent = isEvent;
    }

    @Generated
    public World getWorld() {
        return this.world;
    }

    @Generated
    public void setWorld(World world) {
        this.world = world;
    }

    @Generated
    public Location getSpawnLocation() {
        return this.spawnLocation;
    }

    @Generated
    public void setSpawnLocation(Location spawnLocation) {
        this.spawnLocation = spawnLocation;
    }

    @Generated
    public void setKeepTrying(boolean keepTrying) {
        this.keepTrying = keepTrying;
    }
}

