/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.menus;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.api.utils.EliteItemManager;
import com.magmaguy.elitemobs.config.DefaultConfig;
import com.magmaguy.elitemobs.config.menus.premade.RepairMenuConfig;
import com.magmaguy.elitemobs.items.customenchantments.RepairEnchantment;
import com.magmaguy.elitemobs.menus.EliteMenu;
import com.magmaguy.magmacore.util.ItemStackGenerator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;

public class RepairMenu
extends EliteMenu {
    private static final int eliteItemInputSlot = RepairMenuConfig.eliteItemInputSlot;
    private static final int scrapItemInputSlot = RepairMenuConfig.eliteScrapInputSlot;
    private static final int outputSlot = RepairMenuConfig.outputSlot;
    private static final int eliteItemInformationInputSlot = RepairMenuConfig.eliteItemInputInformationSlot;
    private static final int eliteScrapInformationInputSlot = RepairMenuConfig.eliteScrapInputInformationSlot;
    private static final int informationOutputSlot = RepairMenuConfig.outputInformationSlot;
    public static Set<Inventory> inventories = new HashSet<Inventory>();

    private static void calculateOutput(Inventory repairInventory) {
        if (repairInventory.getItem(RepairMenuConfig.eliteScrapInputSlot) == null || repairInventory.getItem(RepairMenuConfig.eliteItemInputSlot) == null) {
            repairInventory.setItem(RepairMenuConfig.outputSlot, null);
            return;
        }
        int scrapLevel = RepairEnchantment.getRepairLevel(repairInventory.getItem(RepairMenuConfig.eliteScrapInputSlot));
        ItemStack outputItem = repairInventory.getItem(RepairMenuConfig.eliteItemInputSlot).clone();
        int baselineRepair = 100;
        int newDamage = baselineRepair * scrapLevel;
        Damageable damageable = (Damageable)outputItem.getItemMeta();
        int damage = Math.min(Math.max(damageable.getDamage() - newDamage, 0), damageable.getDamage());
        damageable.setDamage(damage);
        outputItem.setItemMeta((ItemMeta)damageable);
        repairInventory.setItem(outputSlot, outputItem);
    }

    public void constructRepairMenu(Player player) {
        Object menuName = RepairMenuConfig.shopName;
        if (DefaultConfig.useResourcePackModels()) {
            menuName = ChatColor.WHITE + "\uf801\udb80\udc2a\uf805           " + (String)menuName;
        }
        Inventory repairInventory = Bukkit.createInventory((InventoryHolder)player, (int)54, (String)menuName);
        for (int i = 0; i < repairInventory.getSize(); ++i) {
            if (i == RepairMenuConfig.infoSlot) {
                ItemStack infoButton = RepairMenuConfig.infoButton;
                if (DefaultConfig.useResourcePackModels()) {
                    infoButton.setType(Material.PAPER);
                    ItemMeta itemMeta = infoButton.getItemMeta();
                    itemMeta.setCustomModelData(Integer.valueOf(MetadataHandler.signatureID));
                    infoButton.setItemMeta(itemMeta);
                }
                repairInventory.setItem(i, infoButton);
                continue;
            }
            if (i == RepairMenuConfig.cancelSlot) {
                repairInventory.setItem(i, RepairMenuConfig.cancelButton);
                continue;
            }
            if (i == eliteItemInformationInputSlot) {
                repairInventory.setItem(i, RepairMenuConfig.eliteItemInputInfoButton);
                continue;
            }
            if (i == eliteScrapInformationInputSlot) {
                repairInventory.setItem(i, RepairMenuConfig.eliteScrapInputInfoButton);
                continue;
            }
            if (i == informationOutputSlot) {
                repairInventory.setItem(i, RepairMenuConfig.outputInfoButton);
                continue;
            }
            if (i == RepairMenuConfig.confirmSlot) {
                ItemStack clonedConfirmButton = RepairMenuConfig.confirmButton.clone();
                ArrayList<String> lore = new ArrayList<String>();
                for (String string : RepairMenuConfig.confirmButton.getItemMeta().getLore()) {
                    lore.add(string);
                }
                RepairMenuConfig.confirmButton.getItemMeta().setLore(lore);
                ItemMeta clonedMeta = clonedConfirmButton.getItemMeta();
                clonedMeta.setLore(lore);
                clonedConfirmButton.setItemMeta(clonedMeta);
                repairInventory.setItem(i, clonedConfirmButton);
                continue;
            }
            if (i == RepairMenuConfig.eliteItemInputSlot || i == RepairMenuConfig.eliteScrapInputSlot || i == RepairMenuConfig.outputSlot || !DefaultConfig.isUseGlassToFillMenuEmptySpace()) continue;
            repairInventory.setItem(i, ItemStackGenerator.generateItemStack((Material)Material.GLASS_PANE));
        }
        player.openInventory(repairInventory);
        RepairMenu.createEliteMenu(repairInventory, inventories);
    }

    public static class RepairMenuEvents
    implements Listener {
        @EventHandler
        public void onInteract(InventoryClickEvent event) {
            if (!EliteMenu.isEliteMenu(event, inventories)) {
                return;
            }
            event.setCancelled(true);
            Player player = (Player)event.getWhoClicked();
            ItemStack currentItem = event.getCurrentItem();
            Inventory repairInventory = event.getView().getTopInventory();
            Inventory playerInventory = event.getView().getBottomInventory();
            if (currentItem == null) {
                return;
            }
            if (EliteMenu.isBottomMenu(event)) {
                int scrapLevel;
                if (RepairEnchantment.isRepairItem(currentItem) && repairInventory.getItem(scrapItemInputSlot) == null && (scrapLevel = RepairEnchantment.getRepairLevel(currentItem)) >= 0) {
                    EliteMenu.moveOneItemUp(scrapItemInputSlot, event);
                    RepairMenu.calculateOutput(repairInventory);
                    return;
                }
                if (EliteItemManager.isEliteMobsItem(currentItem) && currentItem.getItemMeta() instanceof Damageable && repairInventory.getItem(eliteItemInputSlot) == null) {
                    repairInventory.setItem(eliteItemInputSlot, currentItem);
                    playerInventory.remove(currentItem);
                    RepairMenu.calculateOutput(repairInventory);
                }
            } else if (EliteMenu.isTopMenu(event)) {
                if (currentItem == null) {
                    return;
                }
                if (event.getSlot() == scrapItemInputSlot || event.getSlot() == eliteItemInputSlot) {
                    player.getWorld().dropItem(player.getLocation(), currentItem);
                    repairInventory.remove(currentItem);
                    RepairMenu.calculateOutput(repairInventory);
                    return;
                }
                if (event.getSlot() == RepairMenuConfig.cancelSlot) {
                    player.closeInventory();
                    return;
                }
                if (event.getSlot() == RepairMenuConfig.confirmSlot && repairInventory.getItem(outputSlot) != null) {
                    repairInventory.setItem(RepairMenuConfig.eliteItemInputSlot, null);
                    repairInventory.setItem(RepairMenuConfig.eliteScrapInputSlot, null);
                    if (repairInventory.getItem(outputSlot) != null) {
                        player.getWorld().dropItem(player.getLocation(), repairInventory.getItem(outputSlot));
                        repairInventory.remove(repairInventory.getItem(outputSlot));
                    }
                    repairInventory.setItem(outputSlot, null);
                }
            }
        }

        @EventHandler
        public void onClose(InventoryCloseEvent event) {
            if (inventories.contains(event.getInventory())) {
                inventories.remove(event.getInventory());
                EliteMenu.cancel(event.getPlayer(), event.getView().getTopInventory(), event.getView().getBottomInventory(), new ArrayList<Integer>(List.of(Integer.valueOf(eliteItemInputSlot), Integer.valueOf(scrapItemInputSlot))));
            }
        }
    }
}

