/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.menus;

import com.magmaguy.elitemobs.config.DungeonsConfig;
import com.magmaguy.elitemobs.dungeons.EMPackage;
import com.magmaguy.elitemobs.dungeons.WorldInstancedDungeonPackage;
import com.magmaguy.elitemobs.instanced.MatchInstance;
import com.magmaguy.elitemobs.instanced.dungeons.DungeonInstance;
import com.magmaguy.elitemobs.menus.EliteMenu;
import com.magmaguy.magmacore.util.ChatColorConverter;
import com.magmaguy.magmacore.util.ItemStackGenerator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class InstancedDungeonBrowser
extends EliteMenu {
    private static final HashMap<Inventory, InstancedDungeonBrowser> inventories = new HashMap();
    private final List<Integer> difficultySlots = List.of(Integer.valueOf(2), Integer.valueOf(4), Integer.valueOf(6), Integer.valueOf(0), Integer.valueOf(8), Integer.valueOf(1), Integer.valueOf(3), Integer.valueOf(5), Integer.valueOf(7));
    private final List<Integer> validSlots = new ArrayList<Integer>(List.of(18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53));
    private final EMPackage emPackage;
    private List<DungeonInstance> instancesList;

    public InstancedDungeonBrowser(Player player, String instancedDungeonName) {
        EMPackage emPackage;
        this.emPackage = emPackage = EMPackage.getEmPackages().get(instancedDungeonName);
        if (!(emPackage instanceof WorldInstancedDungeonPackage)) {
            player.sendMessage("[EliteMobs] Not a valid instanced dungeon!");
            return;
        }
        HashSet dungeonInstances = new HashSet();
        DungeonInstance.getDungeonInstances().forEach(instance -> {
            if (instance.getContentPackagesConfigFields().getFilename().equals(instancedDungeonName)) {
                dungeonInstances.add(instance);
            }
        });
        this.instancesList = new ArrayList<DungeonInstance>(dungeonInstances);
        int slots = dungeonInstances.isEmpty() ? 9 : 54;
        Inventory inventory = Bukkit.createInventory((InventoryHolder)player, (int)slots);
        int difficultyCounter = 0;
        for (Map<String, Object> map : emPackage.getContentPackagesConfigFields().getDifficulties()) {
            ArrayList<String> description = new ArrayList<String>();
            for (String string : DungeonsConfig.getInstancedDungeonDescription()) {
                description.add(string.replace("$dungeonName", emPackage.getContentPackagesConfigFields().getName()));
            }
            inventory.setItem(this.difficultySlots.get(difficultyCounter).intValue(), ItemStackGenerator.generateItemStack((Material)Material.GREEN_STAINED_GLASS_PANE, (String)DungeonsConfig.getInstancedDungeonTitle().replace("$difficulty", "" + map.get("name")), description));
            ++difficultyCounter;
        }
        for (int i = 0; i < dungeonInstances.size(); ++i) {
            ItemStack itemStack = null;
            if (this.instancesList.get(i).getState().equals((Object)MatchInstance.InstancedRegionState.WAITING)) {
                itemStack = this.playerItem(this.instancesList.get(i));
            } else if (DungeonsConfig.isAllowSpectatorsInInstancedContent()) {
                itemStack = this.spectatorItem(this.instancesList.get(i));
            }
            if (itemStack == null) continue;
            inventory.setItem(this.validSlots.get(i).intValue(), itemStack);
        }
        player.openInventory(inventory);
        inventories.put(inventory, this);
    }

    private ItemStack spectatorItem(DungeonInstance dungeonInstance) {
        ArrayList<String> players = new ArrayList<String>();
        players.add(ChatColorConverter.convert((String)"&2Players:"));
        dungeonInstance.getPlayers().forEach(player -> players.add(player.getDisplayName()));
        return ItemStackGenerator.generateItemStack((Material)Material.ORANGE_STAINED_GLASS_PANE, (String)DungeonsConfig.getDungeonJoinAsSpectatorText().replace("$dungeonName", dungeonInstance.getContentPackagesConfigFields().getName()), players);
    }

    private ItemStack playerItem(DungeonInstance dungeonInstance) {
        ArrayList<String> players = new ArrayList<String>();
        players.add(ChatColorConverter.convert((String)"&2Players:"));
        dungeonInstance.getPlayers().forEach(player -> players.add(player.getDisplayName()));
        return ItemStackGenerator.generateItemStack((Material)Material.GREEN_STAINED_GLASS_PANE, (String)DungeonsConfig.getDungeonJoinAsPlayerText().replace("$dungeonName", dungeonInstance.getContentPackagesConfigFields().getName()), players);
    }

    @Generated
    public EMPackage getEmPackage() {
        return this.emPackage;
    }

    public static class InstancedDungeonBrowserEvents
    implements Listener {
        @EventHandler
        public void onInventoryInteract(InventoryClickEvent event) {
            if (!EliteMenu.isEliteMenu(event, inventories.keySet())) {
                return;
            }
            event.setCancelled(true);
            if (!EliteMenu.isTopMenu(event)) {
                return;
            }
            if (event.getCurrentItem() == null || event.getCurrentItem().getType().equals((Object)Material.AIR)) {
                return;
            }
            InstancedDungeonBrowser instancedDungeonBrowser = inventories.get(event.getInventory());
            event.getWhoClicked().closeInventory();
            if (instancedDungeonBrowser.difficultySlots.contains(event.getSlot())) {
                DungeonInstance.setupInstancedDungeon((Player)event.getWhoClicked(), instancedDungeonBrowser.getEmPackage().getContentPackagesConfigFields().getFilename(), (String)instancedDungeonBrowser.getEmPackage().getContentPackagesConfigFields().getDifficulties().get(instancedDungeonBrowser.difficultySlots.indexOf(event.getSlot())).get("name"));
            } else {
                DungeonInstance dungeonInstance = instancedDungeonBrowser.instancesList.get(instancedDungeonBrowser.validSlots.indexOf(event.getSlot()));
                switch (dungeonInstance.getState()) {
                    case ONGOING: 
                    case STARTING: {
                        if (!DungeonsConfig.isAllowSpectatorsInInstancedContent()) break;
                        dungeonInstance.addSpectator((Player)event.getWhoClicked(), false);
                        break;
                    }
                    case WAITING: {
                        dungeonInstance.addNewPlayer((Player)event.getWhoClicked());
                        break;
                    }
                    case COMPLETED: {
                        event.getWhoClicked().sendMessage("[EliteMobs] This match already ended! Can't join it!");
                    }
                }
            }
        }

        @EventHandler
        public void onClose(InventoryCloseEvent event) {
            inventories.remove(event.getInventory());
        }
    }
}

