/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.items.upgradesystem;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.config.enchantments.EnchantmentsConfigFields;
import com.magmaguy.elitemobs.items.EliteItemLore;
import com.magmaguy.elitemobs.items.ItemTagger;
import com.magmaguy.elitemobs.items.customenchantments.EnchantedSourceEnchantment;
import com.magmaguy.elitemobs.items.itemconstructor.EnchantmentGenerator;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class UpgradeSystem {
    private UpgradeSystem() {
    }

    public static ItemStack upgrade(ItemStack originalItemToUpgrade, ItemStack enchantedBook) {
        ItemStack itemToUpgrade = originalItemToUpgrade.clone();
        ItemMeta itemMeta = itemToUpgrade.getItemMeta();
        HashMap<NamespacedKey, Integer> currentEnchantments = ItemTagger.getItemEnchantments(itemToUpgrade);
        HashMap<NamespacedKey, Integer> bookEnchantments = ItemTagger.getItemEnchantments(enchantedBook);
        HashMap<NamespacedKey, Integer> newMap = new HashMap<NamespacedKey, Integer>();
        bookEnchantments.remove(new NamespacedKey((Plugin)MetadataHandler.PLUGIN, EnchantedSourceEnchantment.key));
        for (Map.Entry entrySet : bookEnchantments.entrySet()) {
            if (!currentEnchantments.containsKey(entrySet.getKey())) {
                newMap.put((NamespacedKey)entrySet.getKey(), (Integer)entrySet.getValue());
                continue;
            }
            newMap.put((NamespacedKey)entrySet.getKey(), (Integer)currentEnchantments.get(entrySet.getKey()) + (Integer)entrySet.getValue());
        }
        HashMap<NamespacedKey, Integer> vanillaEnchantmentsNamespaced = new HashMap<NamespacedKey, Integer>();
        HashMap<Enchantment, Integer> vanillaEnchantments = new HashMap<Enchantment, Integer>();
        for (Map.Entry entrySet : newMap.entrySet()) {
            Enchantment enchantment = Enchantment.getByKey((NamespacedKey)((NamespacedKey)entrySet.getKey()));
            if (enchantment == null) continue;
            vanillaEnchantments.put(enchantment, (Integer)entrySet.getValue());
            vanillaEnchantmentsNamespaced.put((NamespacedKey)entrySet.getKey(), (Integer)entrySet.getValue());
        }
        EnchantmentGenerator.generateEnchantments(itemMeta, vanillaEnchantments);
        ItemTagger.registerEnchantments(itemMeta, vanillaEnchantments);
        HashMap<String, Integer> customEnchantments = new HashMap<String, Integer>();
        for (Map.Entry entrySet : newMap.entrySet()) {
            if (vanillaEnchantments.containsKey(entrySet.getKey())) continue;
            customEnchantments.put(((NamespacedKey)entrySet.getKey()).getKey(), (Integer)entrySet.getValue());
        }
        ItemTagger.registerCustomEnchantments(itemMeta, customEnchantments);
        itemToUpgrade.setItemMeta(itemMeta);
        new EliteItemLore(itemToUpgrade, false);
        return itemToUpgrade;
    }

    public static boolean isValidUpgrade(ItemStack originalItemToUpgrade, ItemStack enchantedBook) {
        ItemStack finalItemStack = UpgradeSystem.upgrade(originalItemToUpgrade, enchantedBook);
        HashMap<EnchantmentsConfigFields, Integer> currentEnchantments = ItemTagger.getItemEnchantmentConfigFields(finalItemStack);
        for (Map.Entry entry : currentEnchantments.entrySet()) {
            if ((Integer)entry.getValue() <= ((EnchantmentsConfigFields)((Object)entry.getKey())).getMaxEnchantmentLevel()) continue;
            return false;
        }
        return true;
    }
}

