/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.items.customloottable;

import com.magmaguy.elitemobs.items.customloottable.CustomLootEntry;
import com.magmaguy.elitemobs.utils.ObjectSerializer;
import com.magmaguy.magmacore.util.Logger;
import java.io.Serializable;
import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class ItemStackCustomLootEntry
extends CustomLootEntry
implements Serializable {
    private final String serializedItemStack;

    public ItemStackCustomLootEntry(List<CustomLootEntry> entries, ItemStack itemStack) {
        this.serializedItemStack = ObjectSerializer.itemStackArrayToBase64(itemStack);
        entries.add(this);
    }

    public ItemStack generateItemStack() {
        try {
            return ObjectSerializer.itemStackArrayFromBase64(this.serializedItemStack);
        }
        catch (Exception ex) {
            Logger.warn((String)"Failed to serialize item stack from Custom Loot Table");
            return null;
        }
    }

    @Override
    public void directDrop(int itemTier, Player player) {
        ItemStack itemStack = this.generateItemStack();
        if (itemStack == null) {
            return;
        }
        for (int i = 0; i < this.getAmount(); ++i) {
            player.getInventory().addItem(new ItemStack[]{itemStack});
        }
    }

    @Override
    public ItemStack previewDrop(int itemTier, Player player) {
        return this.generateItemStack();
    }
}

