/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.items.customloottable;

import com.magmaguy.elitemobs.config.ItemSettingsConfig;
import com.magmaguy.elitemobs.instanced.MatchInstance;
import com.magmaguy.elitemobs.instanced.dungeons.DungeonInstance;
import com.magmaguy.elitemobs.items.customitems.CustomItem;
import com.magmaguy.elitemobs.items.customloottable.CustomLootEntry;
import com.magmaguy.elitemobs.items.customloottable.SharedLootTable;
import com.magmaguy.elitemobs.mobconstructor.EliteEntity;
import com.magmaguy.elitemobs.mobconstructor.custombosses.CustomBossEntity;
import com.magmaguy.elitemobs.playerdata.database.PlayerData;
import com.magmaguy.elitemobs.utils.MapListInterpreter;
import com.magmaguy.magmacore.util.Logger;
import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class EliteCustomLootEntry
extends CustomLootEntry
implements Serializable {
    private String filename = null;
    private String difficultyID = null;

    public EliteCustomLootEntry(List<CustomLootEntry> entries, String rawString, String configFilename) {
        if (!rawString.contains("filename=")) {
            this.parseLegacyFormat(rawString, configFilename);
        } else {
            this.parseNewFormat(rawString, configFilename);
        }
        if (this.filename == null) {
            return;
        }
        CustomItem customItem = CustomItem.getCustomItem(this.filename);
        if (customItem == null) {
            EliteCustomLootEntry.errorMessage(rawString, configFilename, "filename");
            return;
        }
        entries.add(this);
    }

    public EliteCustomLootEntry(List<CustomLootEntry> entries, Map<?, ?> configMap, String configFilename) {
        block14: for (Map.Entry<?, ?> mapEntry : configMap.entrySet()) {
            String key = (String)mapEntry.getKey();
            switch (key.toLowerCase(Locale.ROOT)) {
                case "filename": {
                    this.filename = MapListInterpreter.parseString(key, mapEntry.getValue(), configFilename);
                    continue block14;
                }
                case "chance": {
                    super.setChance(MapListInterpreter.parseDouble(key, mapEntry.getValue(), configFilename));
                    continue block14;
                }
                case "difficultyid": {
                    this.difficultyID = MapListInterpreter.parseString(key, mapEntry.getValue(), configFilename);
                    continue block14;
                }
                case "permission": {
                    super.setPermission(MapListInterpreter.parseString(key, mapEntry.getValue(), configFilename));
                    continue block14;
                }
                case "amount": {
                    this.setAmount(MapListInterpreter.parseInteger(key, mapEntry.getValue(), configFilename));
                    continue block14;
                }
            }
            Logger.warn((String)("Failed to read custom loot option " + key + " in " + configFilename));
        }
        entries.add(this);
    }

    private void parseLegacyFormat(String rawString, String configFilename) {
        String[] stringArray = rawString.split(":");
        try {
            this.filename = stringArray[0];
        }
        catch (Exception ex) {
            EliteCustomLootEntry.errorMessage(rawString, configFilename, "filename");
            return;
        }
        try {
            super.setChance(Double.parseDouble(stringArray[1]));
        }
        catch (Exception ex) {
            EliteCustomLootEntry.errorMessage(rawString, configFilename, "chance");
            return;
        }
        if (stringArray.length > 2) {
            try {
                super.setPermission(stringArray[2]);
            }
            catch (Exception ex) {
                EliteCustomLootEntry.errorMessage(rawString, configFilename, "permission");
            }
        }
    }

    private void parseNewFormat(String rawString, String configFilename) {
        block28: for (String string : rawString.split(":")) {
            String[] strings = string.split("=");
            switch (strings[0].toLowerCase(Locale.ROOT)) {
                case "filename": {
                    try {
                        this.filename = strings[1];
                    }
                    catch (Exception ex) {
                        EliteCustomLootEntry.errorMessage(rawString, configFilename, "filename");
                    }
                    continue block28;
                }
                case "amount": {
                    try {
                        super.setAmount(Integer.parseInt(strings[1]));
                    }
                    catch (Exception ex) {
                        EliteCustomLootEntry.errorMessage(rawString, configFilename, "amount");
                    }
                    continue block28;
                }
                case "chance": {
                    try {
                        super.setChance(Double.parseDouble(strings[1]));
                    }
                    catch (Exception ex) {
                        EliteCustomLootEntry.errorMessage(rawString, configFilename, "chance");
                    }
                    continue block28;
                }
                case "permission": {
                    try {
                        super.setPermission(strings[1]);
                    }
                    catch (Exception ex) {
                        EliteCustomLootEntry.errorMessage(rawString, configFilename, "permission");
                    }
                    continue block28;
                }
                case "itemlevel": {
                    try {
                        super.setItemLevel(Integer.parseInt(strings[1]));
                    }
                    catch (Exception ex) {
                        EliteCustomLootEntry.errorMessage(rawString, configFilename, "level");
                    }
                    continue block28;
                }
                case "wave": {
                    try {
                        super.setWave(Integer.parseInt(strings[1]));
                    }
                    catch (Exception ex) {
                        EliteCustomLootEntry.errorMessage(rawString, configFilename, "wave");
                    }
                    continue block28;
                }
            }
        }
    }

    private CustomItem generateCustomItem() {
        return CustomItem.getCustomItem(this.filename);
    }

    public ItemStack generateItemStack(int level, Player player, EliteEntity eliteEntity) {
        return this.generateCustomItem().generateItemStack(level, player, eliteEntity);
    }

    @Override
    public void locationDrop(int itemTier, Player player, Location location) {
        for (int i = 0; i < this.getAmount(); ++i) {
            this.generateCustomItem().dropPlayerLoot(player, itemTier, location, null);
        }
    }

    @Override
    public void locationDrop(int itemTier, Player player, Location location, EliteEntity eliteEntity) {
        if (this.isGroupLoot(itemTier, player, eliteEntity)) {
            return;
        }
        if (this.generateCustomItem() == null) {
            Logger.warn((String)("Invalid loot entry for boss " + eliteEntity.getName() + "! Entry: " + this.filename));
            if (eliteEntity instanceof CustomBossEntity) {
                CustomBossEntity customBossEntity = (CustomBossEntity)eliteEntity;
                Logger.warn((String)("Boss filename: " + customBossEntity.getCustomBossesConfigFields().getFilename()));
            }
            return;
        }
        for (int i = 0; i < this.getAmount(); ++i) {
            this.generateCustomItem().dropPlayerLoot(player, itemTier, location, eliteEntity);
        }
    }

    @Override
    public void directDrop(int itemTier, Player player) {
        String name = null;
        for (int i = 0; i < this.getAmount(); ++i) {
            ItemStack itemStack = this.generateCustomItem().generateItemStack(itemTier, player, null);
            if (itemStack == null) continue;
            player.getInventory().addItem(new ItemStack[]{itemStack});
            if (name != null || itemStack.getItemMeta() == null) continue;
            name = itemStack.getItemMeta().hasDisplayName() ? itemStack.getItemMeta().getDisplayName() : itemStack.getType().toString().replace("_", " ");
        }
        if (name != null) {
            player.sendMessage(ItemSettingsConfig.getDirectDropCustomLootMessage().replace("$itemName", this.getAmount() + "x " + name));
        }
    }

    @Override
    public void directDrop(int itemTier, Player player, EliteEntity eliteEntity) {
        if (this.isGroupLoot(itemTier, player, eliteEntity)) {
            return;
        }
        String name = null;
        for (int i = 0; i < this.getAmount(); ++i) {
            ItemStack itemStack = this.generateCustomItem().generateItemStack(itemTier, player, eliteEntity);
            if (itemStack == null) {
                return;
            }
            player.getInventory().addItem(new ItemStack[]{itemStack});
            if (name != null || itemStack.getItemMeta() == null) continue;
            name = itemStack.getItemMeta().hasDisplayName() ? itemStack.getItemMeta().getDisplayName() : itemStack.getType().toString().replace("_", " ");
        }
        if (name != null) {
            player.sendMessage(ItemSettingsConfig.getDirectDropCustomLootMessage().replace("$itemName", this.getAmount() + "x " + name));
        }
    }

    private boolean isGroupLoot(int itemTier, Player player, EliteEntity eliteEntity) {
        if (this.difficultyID == null) {
            return false;
        }
        MatchInstance matchInstance = PlayerData.getMatchInstance(player);
        String dungeonDifficultyID = null;
        if (matchInstance instanceof DungeonInstance) {
            DungeonInstance dungeonInstance = (DungeonInstance)matchInstance;
            dungeonDifficultyID = dungeonInstance.getDifficultyID();
        }
        if (dungeonDifficultyID == null) {
            return false;
        }
        if (!dungeonDifficultyID.equals(this.difficultyID)) {
            return true;
        }
        this.addGroupLoot(itemTier, eliteEntity);
        return true;
    }

    private void addGroupLoot(int itemTier, EliteEntity eliteEntity) {
        SharedLootTable sharedLootTable = SharedLootTable.getSharedLootTables().get(eliteEntity);
        String name = null;
        for (int i = 0; i < this.getAmount(); ++i) {
            CustomItem customItem = this.generateCustomItem();
            if (customItem == null) {
                Logger.warn((String)("Failed to generate a custom item for the boss " + eliteEntity.getName() + "! The configuration file for one of its loot items is not correctly configured."));
                return;
            }
            ItemStack itemStack = customItem.generateItemStack(itemTier, null, eliteEntity);
            if (sharedLootTable == null) {
                sharedLootTable = new SharedLootTable(eliteEntity);
            }
            if (itemStack == null) {
                Logger.warn((String)("A custom item for boss " + eliteEntity.getName() + " was null! This item will be skipped."));
                return;
            }
            sharedLootTable.addLoot(itemStack);
            if (name != null || itemStack.getItemMeta() == null) continue;
            name = itemStack.getItemMeta().hasDisplayName() ? itemStack.getItemMeta().getDisplayName() : itemStack.getType().toString().replace("_", " ");
        }
    }

    @Override
    public ItemStack previewDrop(int itemTier, Player player) {
        return this.generateItemStack(itemTier, player, null);
    }

    @Generated
    public String getFilename() {
        return this.filename;
    }
}

