/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.instanced;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.api.instanced.MatchDestroyEvent;
import com.magmaguy.elitemobs.api.instanced.MatchInstantiateEvent;
import com.magmaguy.elitemobs.api.instanced.MatchJoinEvent;
import com.magmaguy.elitemobs.api.instanced.MatchLeaveEvent;
import com.magmaguy.elitemobs.config.ArenasConfig;
import com.magmaguy.elitemobs.config.DefaultConfig;
import com.magmaguy.elitemobs.instanced.InstanceDeathLocation;
import com.magmaguy.elitemobs.instanced.InstancePlayerManager;
import com.magmaguy.elitemobs.playerdata.database.PlayerData;
import com.magmaguy.magmacore.util.ChatColorConverter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockDamageEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public abstract class MatchInstance {
    protected static final HashSet<MatchInstance> instances = new HashSet();
    protected final HashMap<Block, InstanceDeathLocation> deathBanners = new HashMap();
    protected final Map<Player, Location> previousPlayerLocations = new HashMap<Player, Location>();
    protected HashSet<Player> players = new HashSet();
    protected HashMap<Player, Integer> playerLives = new HashMap();
    protected HashSet<Player> participants = new HashSet();
    protected HashSet<Player> spectators = new HashSet();
    protected InstancedRegionState state = InstancedRegionState.WAITING;
    protected Location lobbyLocation = null;
    protected Location startLocation;
    protected Location exitLocation;
    protected int minPlayers;
    protected int maxPlayers;
    protected World world;
    protected String permission = null;
    protected boolean cancelled = false;

    public MatchInstance(Location startLocation, Location exitLocation, int minPlayers, int maxPlayers) {
        MatchInstantiateEvent matchInstantiateEvent = new MatchInstantiateEvent(this);
        if (matchInstantiateEvent.isCancelled()) {
            this.cancelled = true;
            return;
        }
        this.startLocation = startLocation;
        this.exitLocation = exitLocation;
        this.minPlayers = minPlayers;
        this.maxPlayers = maxPlayers;
        this.startWatchdogs();
        this.instanceMessages();
        instances.add(this);
    }

    public static void shutdown() {
        HashSet<MatchInstance> cloneInstance = new HashSet<MatchInstance>(instances);
        cloneInstance.forEach(MatchInstance::destroyMatch);
        instances.clear();
    }

    public static MatchInstance getPlayerInstance(Player player) {
        for (MatchInstance matchInstance : instances) {
            for (Player iteratedPlayer : matchInstance.players) {
                if (!iteratedPlayer.equals(player)) continue;
                return matchInstance;
            }
        }
        return null;
    }

    public static MatchInstance getSpectatorInstance(Player player) {
        for (MatchInstance matchInstance : instances) {
            for (Player iteratedPlayer : matchInstance.spectators) {
                if (!iteratedPlayer.equals(player)) continue;
                return matchInstance;
            }
        }
        return null;
    }

    public static MatchInstance getAnyPlayerInstance(Player player) {
        for (MatchInstance matchInstance : instances) {
            for (Player iteratedPlayer : matchInstance.players) {
                if (!iteratedPlayer.equals(player)) continue;
                return matchInstance;
            }
            for (Player iteratedPlayer : matchInstance.spectators) {
                if (!iteratedPlayer.equals(player)) continue;
                return matchInstance;
            }
        }
        return null;
    }

    public boolean addNewPlayer(Player player) {
        new MatchJoinEvent(this, player);
        return InstancePlayerManager.addNewPlayer(player, this);
    }

    public void removePlayer(Player player) {
        new MatchLeaveEvent(this, player);
        InstancePlayerManager.removePlayer(player, this);
    }

    public void playerDeath(Player player) {
        InstancePlayerManager.playerDeath(this, player);
    }

    public void revivePlayer(Player player, InstanceDeathLocation deathLocation) {
        InstancePlayerManager.revivePlayer(this, player, deathLocation);
    }

    public void addSpectator(Player player, boolean wasPlayer) {
        InstancePlayerManager.addSpectator(this, player, wasPlayer);
    }

    public void removeSpectator(Player player) {
        new MatchLeaveEvent(this, player);
        InstancePlayerManager.removeSpectator(this, player);
    }

    public void removeAnyKind(Player player) {
        new MatchLeaveEvent(this, player);
        InstancePlayerManager.removeAnyKind(this, player);
    }

    private void startWatchdogs() {
        new WatchdogTask().runTaskTimer((Plugin)MetadataHandler.PLUGIN, 0L, 1L);
    }

    public void countdownMatch() {
        if (this.state != InstancedRegionState.WAITING) {
            return;
        }
        if (this.players.size() < this.minPlayers) {
            this.announce(ArenasConfig.getNotEnoughPlayersMessage().replace("$amount", "" + this.minPlayers));
            return;
        }
        this.state = InstancedRegionState.STARTING;
        new CountdownTask().runTaskTimer((Plugin)MetadataHandler.PLUGIN, 0L, 20L);
    }

    private void playerWatchdog() {
        ((HashSet)this.players.clone()).forEach(player -> {
            if (!player.isOnline()) {
                this.removePlayer((Player)player);
            }
            if (!this.isInRegion(player.getLocation())) {
                MatchInstanceEvents.teleportBypass = true;
                player.teleport(this.startLocation);
            }
        });
    }

    private void spectatorWatchdog() {
        ((HashSet)this.spectators.clone()).forEach(player -> {
            if (!player.isOnline()) {
                this.removeSpectator((Player)player);
            }
            if (!this.isInRegion(player.getLocation())) {
                MatchInstanceEvents.teleportBypass = true;
                player.teleport(this.startLocation);
            }
        });
    }

    private void intruderWatchdog() {
        if (this.state != InstancedRegionState.ONGOING) {
            return;
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (this.players.contains(player) || this.spectators.contains(player) || player.hasPermission("elitemobs.*") || !this.isInRegion(player.getLocation())) continue;
            MatchInstanceEvents.teleportBypass = true;
            if (this.exitLocation != null) {
                player.teleport(this.exitLocation);
                continue;
            }
            if (PlayerData.getBackTeleportLocation(player) != null) {
                player.teleport(PlayerData.getBackTeleportLocation(player));
                continue;
            }
            if (DefaultConfig.getDefaultSpawnLocation() == null || DefaultConfig.getDefaultSpawnLocation().getWorld() == null) continue;
            player.teleport(DefaultConfig.getDefaultSpawnLocation());
        }
    }

    private void instanceMessages() {
        new BukkitRunnable(){

            public void run() {
                if (MatchInstance.this.state == InstancedRegionState.WAITING) {
                    MatchInstance.this.announce(ArenasConfig.getArenaStartHintMessage().replace("$count", "" + MatchInstance.this.minPlayers));
                }
            }
        }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 0L, 1200L);
    }

    protected void announce(String message) {
        this.participants.forEach(player -> player.sendMessage(ChatColorConverter.convert((String)message)));
    }

    private void startMessage(int counter, Player player) {
        player.sendTitle(ArenasConfig.getStartingTitle(), ArenasConfig.getStartingSubtitle().replace("$count", "" + (3 - counter)), 0, 20, 0);
    }

    protected abstract boolean isInRegion(Location var1);

    protected void startMatch() {
        this.state = InstancedRegionState.ONGOING;
        this.players.forEach(player -> {
            MatchInstanceEvents.teleportBypass = true;
            player.teleport(this.startLocation);
        });
        this.participants = (HashSet)this.players.clone();
    }

    protected void victory() {
        this.state = InstancedRegionState.COMPLETED_VICTORY;
        this.endMatch();
    }

    protected void defeat() {
        this.state = InstancedRegionState.COMPLETED_DEFEAT;
        this.endMatch();
    }

    protected void endMatch() {
        if (this.state != InstancedRegionState.COMPLETED_VICTORY && this.state != InstancedRegionState.COMPLETED_DEFEAT) {
            this.state = InstancedRegionState.COMPLETED;
        }
        new MatchDestroyEvent(this);
    }

    protected void destroyMatch() {
        this.state = InstancedRegionState.WAITING;
        HashSet<Player> copy = new HashSet<Player>(this.participants);
        copy.forEach(this::removeAnyKind);
        this.players.clear();
        this.spectators.clear();
        this.deathBanners.values().forEach(deathLocation -> deathLocation.clear(false));
        this.deathBanners.clear();
        new MatchDestroyEvent(this);
    }

    protected InstanceDeathLocation getDeathLocationByPlayer(Player player) {
        for (InstanceDeathLocation deathLocation : this.deathBanners.values()) {
            if (!deathLocation.getDeadPlayer().equals(player)) continue;
            return deathLocation;
        }
        return null;
    }

    @Generated
    public HashMap<Block, InstanceDeathLocation> getDeathBanners() {
        return this.deathBanners;
    }

    @Generated
    public Map<Player, Location> getPreviousPlayerLocations() {
        return this.previousPlayerLocations;
    }

    @Generated
    public HashSet<Player> getPlayers() {
        return this.players;
    }

    @Generated
    public HashSet<Player> getParticipants() {
        return this.participants;
    }

    @Generated
    public InstancedRegionState getState() {
        return this.state;
    }

    @Generated
    public String getPermission() {
        return this.permission;
    }

    @Generated
    public boolean isCancelled() {
        return this.cancelled;
    }

    public static enum InstancedRegionState {
        WAITING,
        STARTING,
        ONGOING,
        COMPLETED,
        COMPLETED_VICTORY,
        COMPLETED_DEFEAT;

    }

    private class WatchdogTask
    extends BukkitRunnable {
        private WatchdogTask() {
        }

        public void run() {
            MatchInstance.this.playerWatchdog();
            MatchInstance.this.spectatorWatchdog();
            MatchInstance.this.intruderWatchdog();
        }
    }

    private class CountdownTask
    extends BukkitRunnable {
        int counter = 0;

        private CountdownTask() {
        }

        public void run() {
            if (MatchInstance.this.players.size() < MatchInstance.this.minPlayers) {
                this.cancel();
                MatchInstance.this.endMatch();
                return;
            }
            ++this.counter;
            MatchInstance.this.players.forEach(player -> MatchInstance.this.startMessage(this.counter, (Player)player));
            MatchInstance.this.spectators.forEach(player -> MatchInstance.this.startMessage(this.counter, (Player)player));
            if (this.counter >= 3) {
                MatchInstance.this.startMatch();
                this.cancel();
            }
        }
    }

    public static class MatchInstanceEvents
    implements Listener {
        public static boolean teleportBypass = false;

        @EventHandler
        public void onPlayerLeave(PlayerQuitEvent event) {
            HashSet<MatchInstance> copy = new HashSet<MatchInstance>(instances);
            copy.forEach(instance -> instance.removeAnyKind(event.getPlayer()));
        }

        @EventHandler
        public void onPlayerBreakBlockEvent(BlockBreakEvent event) {
            for (MatchInstance matchInstance : instances) {
                if (!matchInstance.state.equals((Object)InstancedRegionState.ONGOING) || matchInstance.getDeathBanners().get(event.getBlock()) == null) continue;
                matchInstance.getDeathBanners().get(event.getBlock()).clear(true);
            }
        }

        @EventHandler
        public void onPlayerHitFlagEvent(BlockDamageEvent event) {
            for (MatchInstance matchInstance : instances) {
                if (!matchInstance.state.equals((Object)InstancedRegionState.ONGOING) || matchInstance.getDeathBanners().get(event.getBlock()) == null) continue;
                matchInstance.getDeathBanners().get(event.getBlock()).clear(true);
            }
        }

        @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
        public void onPlayerDamage(EntityDamageEvent event) {
            if (!event.getEntityType().equals((Object)EntityType.PLAYER)) {
                return;
            }
            Player player = (Player)event.getEntity();
            if (event.getFinalDamage() < player.getHealth()) {
                return;
            }
            MatchInstance matchInstance = PlayerData.getMatchInstance(player);
            if (matchInstance == null) {
                return;
            }
            if (matchInstance.state != InstancedRegionState.ONGOING) {
                matchInstance.removePlayer(player);
            }
            event.setCancelled(true);
            matchInstance.playerDeath(player);
        }

        @EventHandler(ignoreCancelled=true, priority=EventPriority.LOW)
        public void onPlayerTeleport(PlayerTeleportEvent event) {
            if (teleportBypass) {
                teleportBypass = false;
                return;
            }
            for (MatchInstance instance : instances) {
                if (instance.world == null || !instance.world.equals(event.getFrom()) && !instance.world.equals(event.getTo())) continue;
                event.setCancelled(true);
                return;
            }
            MatchInstance matchInstance = PlayerData.getMatchInstance(event.getPlayer());
            if (matchInstance == null) {
                return;
            }
            if (matchInstance.state == InstancedRegionState.WAITING) {
                matchInstance.removeAnyKind(event.getPlayer());
                return;
            }
            event.setCancelled(true);
        }
    }
}

