/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.config.translations;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.config.ConfigurationEngine;
import com.magmaguy.elitemobs.config.CustomConfigFields;
import com.magmaguy.elitemobs.config.DefaultConfig;
import com.magmaguy.magmacore.util.ChatColorConverter;
import com.magmaguy.magmacore.util.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class TranslationsConfigFields
extends CustomConfigFields {
    private final List<String> outdatedCustomKeys = new ArrayList<String>();
    private boolean saving = false;
    private File translationDataFile;
    private FileConfiguration translationData;
    private FileConfiguration premadeTranslationsConfiguration;
    private boolean customLanguage = false;

    public TranslationsConfigFields(String filename, boolean isEnabled) {
        super(filename, isEnabled);
        if (!DefaultConfig.getLanguage().equals(filename)) {
            return;
        }
        Object parsedFilename = filename.endsWith(".yml") ? filename : filename + ".yml";
        Path folder = Paths.get(MetadataHandler.PLUGIN.getDataFolder().getAbsolutePath(), "translations");
        Path realPath = folder.resolve((String)parsedFilename);
        if (!Files.exists(realPath, new LinkOption[0])) {
            try (InputStream in = MetadataHandler.PLUGIN.getResource("translations/" + (String)parsedFilename);){
                if (in != null) {
                    Files.createDirectories(realPath.getParent(), new FileAttribute[0]);
                    Files.copy(in, realPath, new CopyOption[0]);
                    Logger.info((String)("Copied bundled translation " + (String)parsedFilename));
                } else {
                    Logger.info((String)("No bundled translation for " + (String)parsedFilename + ", treating as custom"));
                    this.customLanguage = true;
                }
            }
            catch (IOException ex) {
                Logger.warn((String)("Error creating translation file " + (String)parsedFilename + ": " + ex.getMessage()));
                this.customLanguage = true;
            }
        }
        try {
            this.file = realPath.toFile();
            this.fileConfiguration = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(Files.newInputStream(realPath, new OpenOption[0]), StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            Logger.warn((String)("Could not load translation file " + (String)parsedFilename + ": " + e.getMessage()));
        }
    }

    @Override
    public void processConfigFields() {
        if (!DefaultConfig.getLanguage().equals(this.filename)) {
            return;
        }
        if (MetadataHandler.PLUGIN.getResource("translations/" + this.filename) == null) {
            return;
        }
        if (this.customLanguage) {
            return;
        }
        String languageDataFilename = this.filename.replace(".yml", ".translation_data");
        Path dataPath = Paths.get(MetadataHandler.PLUGIN.getDataFolder().getAbsolutePath(), "translations", languageDataFilename);
        if (!Files.exists(dataPath, new LinkOption[0])) {
            try {
                Files.createDirectories(dataPath.getParent(), new FileAttribute[0]);
                dataPath.toFile().createNewFile();
            }
            catch (Exception ex) {
                Logger.info((String)("Could not create data file " + languageDataFilename));
            }
        }
        this.translationDataFile = dataPath.toFile();
        try {
            this.translationData = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader((InputStream)new FileInputStream(this.translationDataFile), StandardCharsets.UTF_8));
        }
        catch (Exception ex) {
            Logger.warn((String)"Failed to read translation data!");
            return;
        }
        this.premadeTranslationsConfiguration = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(MetadataHandler.PLUGIN.getResource("translations/" + this.filename), StandardCharsets.UTF_8));
        for (String path : this.premadeTranslationsConfiguration.getKeys(true)) {
            Object premadeValue = this.premadeTranslationsConfiguration.get(path);
            if (!(premadeValue instanceof String) && !(premadeValue instanceof List)) continue;
            Object dataValue = this.translationData.get(path);
            Object liveValue = this.fileConfiguration.get(path);
            if (dataValue == null) {
                if (liveValue != null) {
                    this.outdatedCustomKeys.add(path);
                    Logger.info((String)("Skipped custom key " + path));
                } else {
                    this.fileConfiguration.set(path, premadeValue);
                }
            } else if (!premadeValue.equals(dataValue)) {
                if (!dataValue.equals(liveValue)) {
                    this.outdatedCustomKeys.add(path);
                    Logger.info((String)("Skipped custom key " + path));
                } else {
                    this.fileConfiguration.set(path, premadeValue);
                    Logger.info((String)("Auto-updated translation " + path));
                }
            }
            if (premadeValue.equals(dataValue)) continue;
            this.translationData.set(path, premadeValue);
        }
        try {
            this.translationData.save(this.translationDataFile);
            this.fileConfiguration.save(this.file);
        }
        catch (Exception ex) {
            Logger.warn((String)("Failed to save language files: " + ex.getMessage()));
        }
    }

    public void add(String filename, String key, Object value) {
        if (value == null) {
            return;
        }
        String filteredFilename = filename.replace(".yml", "");
        if (value instanceof String) {
            String s = this.fixConfigColors((String)((Object)value));
            if (s.isEmpty()) {
                return;
            }
            value = s;
        } else if (value instanceof List) {
            List<String> list = this.fixConfigColors(value);
            if (list.isEmpty()) {
                return;
            }
            value = list;
        }
        String realKey = filteredFilename + "." + key;
        if (this.fileConfiguration.get(realKey) != null) {
            return;
        }
        this.fileConfiguration.set(realKey, value);
        this.save();
    }

    private void save() {
        if (this.saving) {
            return;
        }
        this.saving = true;
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)MetadataHandler.PLUGIN, () -> {
            ConfigurationEngine.fileSaverCustomValues((FileConfiguration)this.fileConfiguration, (File)this.file);
            if (this.translationData != null) {
                ConfigurationEngine.fileSaverCustomValues((FileConfiguration)this.translationData, (File)this.translationDataFile);
            }
            this.saving = false;
        });
    }

    public Object get(String filename, String key) {
        String filteredFilename = filename.replace(".yml", "");
        Object obj = this.fileConfiguration.get(filteredFilename + "." + key);
        if (obj instanceof String) {
            return ChatColorConverter.convert((String)((String)obj));
        }
        if (obj instanceof List) {
            return ChatColorConverter.convert((List)((List)obj));
        }
        return obj;
    }

    private String fixConfigColors(String value) {
        if (value == null) {
            return null;
        }
        return value.replace("\u00a7", "&");
    }

    private List<String> fixConfigColors(List<String> values) {
        ArrayList<String> clean = new ArrayList<String>();
        values.forEach(s -> clean.add(this.fixConfigColors((String)s)));
        return clean;
    }
}

