/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.config;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.magmacore.util.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ConfigurationExporter {
    private ConfigurationExporter() {
    }

    public static void initializeConfigs() {
        new BukkitRunnable(){

            public void run() {
                Path configurationsPath = Paths.get(MetadataHandler.PLUGIN.getDataFolder().getAbsolutePath(), new String[0]);
                if (!Files.isDirectory(Paths.get(configurationsPath.normalize() + File.separatorChar + "exports", new String[0]), new LinkOption[0])) {
                    try {
                        Files.createDirectory(Paths.get(configurationsPath.normalize() + File.separatorChar + "exports", new String[0]), new FileAttribute[0]);
                    }
                    catch (Exception exception) {
                        Logger.warn((String)"Failed to create exports directory! Tell the dev!");
                        exception.printStackTrace();
                    }
                }
                try {
                    File rspFile = Paths.get(configurationsPath.normalize() + File.separatorChar + "exports" + File.separatorChar + "elitemobs_resource_pack.zip", new String[0]).toFile();
                    if (rspFile.exists()) {
                        rspFile.delete();
                    }
                    ConfigurationExporter.downloadFile("https://magmaguy.com/downloads/elitemobs_resource_pack.zip", Paths.get(configurationsPath.normalize() + File.separatorChar + "exports", new String[0]).toAbsolutePath().toString());
                }
                catch (Exception e) {
                    Logger.warn((String)"Failed to download official resource pack! Tell the dev!");
                    e.printStackTrace();
                }
            }
        }.runTaskAsynchronously((Plugin)MetadataHandler.PLUGIN);
    }

    public static void downloadFile(String fileURL, String saveFilePath) throws IOException {
        URL url = new URL(fileURL);
        HttpURLConnection httpConn = (HttpURLConnection)url.openConnection();
        int responseCode = httpConn.getResponseCode();
        if (responseCode == 200) {
            String fileName = "";
            String disposition = httpConn.getHeaderField("Content-Disposition");
            if (disposition != null) {
                int index = disposition.indexOf("filename=");
                if (index > 0) {
                    fileName = disposition.substring(index + 10, disposition.length() - 1);
                }
            } else {
                fileName = fileURL.substring(fileURL.lastIndexOf("/") + 1);
            }
            InputStream inputStream = httpConn.getInputStream();
            String saveFilePathWithName = saveFilePath + File.separatorChar + fileName;
            FileOutputStream outputStream = new FileOutputStream(saveFilePathWithName);
            int bytesRead = -1;
            byte[] buffer = new byte[4096];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, bytesRead);
            }
            outputStream.close();
            inputStream.close();
        } else {
            Logger.warn((String)("No file to download. Server replied HTTP code: " + responseCode));
        }
        httpConn.disconnect();
    }

    public static byte[] sha1CodeByteArray(File file) throws IOException, NoSuchAlgorithmException {
        FileInputStream fileInputStream = new FileInputStream(file);
        MessageDigest digest = MessageDigest.getInstance("SHA-1");
        DigestInputStream digestInputStream = new DigestInputStream(fileInputStream, digest);
        byte[] bytes = new byte[1024];
        while (digestInputStream.read(bytes) > 0) {
            digest = digestInputStream.getMessageDigest();
        }
        return digest.digest();
    }
}

