/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.commands;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.config.DefaultConfig;
import com.magmaguy.magmacore.command.AdvancedCommand;
import com.magmaguy.magmacore.command.CommandData;
import com.magmaguy.magmacore.command.arguments.ICommandArgument;
import com.magmaguy.magmacore.command.arguments.ListStringCommandArgument;
import com.magmaguy.magmacore.util.Logger;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.bukkit.command.CommandSender;

public class LanguageCommand
extends AdvancedCommand {
    private static final List<String> REMOTE_LANGUAGES = List.of("chineseSimplified.yml", "chineseTraditional.yml", "czech.yml", "dutch.yml", "french.yml", "german.yml", "hungarian.yml", "indonesian.yml", "italian.yml", "japanese.yml", "korean.yml", "polish.yml", "portugueseBrazilian.yml", "romanian.yml", "russian.yml", "spanish.yml", "turkish.yml", "vietnamese.yml");
    private final List<String> suggestions;

    public LanguageCommand() {
        super(List.of("language"));
        LinkedHashSet<String> langs = new LinkedHashSet<String>(REMOTE_LANGUAGES);
        Path folder = Paths.get(MetadataHandler.PLUGIN.getDataFolder().getAbsolutePath(), "translations");
        if (Files.isDirectory(folder, new LinkOption[0])) {
            try (DirectoryStream<Path> ds = Files.newDirectoryStream(folder, "*.yml");){
                for (Path p : ds) {
                    langs.add(p.getFileName().toString());
                }
            }
            catch (Exception e) {
                Logger.warn((String)("Could not list translations folder: " + e.getMessage()));
            }
        }
        langs.add("english.yml");
        this.suggestions = new ArrayList<String>(langs);
        this.addArgument("language", (ICommandArgument)new ListStringCommandArgument(this.suggestions, "<language.yml>"));
        this.setUsage("/em language <language.yml>");
        this.setPermission("elitemobs.language");
        this.setDescription("Sets the language for EliteMobs (fetches from remote if needed).");
    }

    public void execute(CommandData commandData) {
        Path folder;
        Path target;
        String langFile = commandData.getStringArgument("language");
        CommandSender sender = commandData.getCommandSender();
        if (!this.suggestions.contains(langFile)) {
            Logger.sendMessage((CommandSender)sender, (String)"Language not found. Valid options:");
            this.suggestions.forEach(s -> Logger.sendMessage((CommandSender)sender, (String)s));
            return;
        }
        if (!langFile.equals("english.yml") && !Files.exists(target = (folder = Paths.get(MetadataHandler.PLUGIN.getDataFolder().getAbsolutePath(), "translations")).resolve(langFile), new LinkOption[0])) {
            Logger.sendMessage((CommandSender)sender, (String)("&eDownloading " + langFile + "\u2026"));
            if (!this.downloadRemoteLanguage(langFile, target)) {
                Logger.sendMessage((CommandSender)sender, (String)("&cFailed to download " + langFile + ". Language not changed."));
                return;
            }
            Logger.sendMessage((CommandSender)sender, (String)("&2Downloaded " + langFile + " successfully."));
        }
        DefaultConfig.setLanguage(sender, langFile);
        Logger.sendMessage((CommandSender)sender, (String)("&2Language set to " + langFile + " ! &4Translations are managed remotely\u2014use at your own discretion!"));
    }

    private boolean downloadRemoteLanguage(String fileName, Path outPath) {
        String apiUrl = "https://magmaguy.com/api/elitemobs_translations/" + fileName;
        try {
            URL url = new URL(apiUrl);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(5000);
            conn.setReadTimeout(5000);
            if (conn.getResponseCode() != 200) {
                Logger.warn((String)("Download failed: HTTP " + conn.getResponseCode()));
                return false;
            }
            Files.createDirectories(outPath.getParent(), new FileAttribute[0]);
            try (InputStream in = conn.getInputStream();
                 OutputStream out = Files.newOutputStream(outPath, StandardOpenOption.CREATE_NEW);){
                int r;
                byte[] buf = new byte[4096];
                while ((r = in.read(buf)) != -1) {
                    out.write(buf, 0, r);
                }
            }
            conn.disconnect();
            return true;
        }
        catch (Exception ex) {
            Logger.warn((String)("Error downloading " + fileName + ": " + ex.getMessage()));
            return false;
        }
    }
}

