/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.combatsystem.displays;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.api.EliteMobDamagedByPlayerEvent;
import com.magmaguy.elitemobs.api.EliteMobHealEvent;
import com.magmaguy.elitemobs.api.internal.RemovalReason;
import com.magmaguy.elitemobs.config.MobCombatSettingsConfig;
import com.magmaguy.elitemobs.config.enchantments.premade.CriticalStrikesConfig;
import com.magmaguy.elitemobs.entitytracker.EntityTracker;
import com.magmaguy.elitemobs.items.customenchantments.CriticalStrikesEnchantment;
import com.magmaguy.elitemobs.mobconstructor.EliteEntity;
import com.magmaguy.elitemobs.utils.DialogArmorStand;
import com.magmaguy.elitemobs.utils.VisualDisplay;
import com.magmaguy.magmacore.util.Round;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.TextDisplay;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;

public class PopupDisplay
implements Listener {
    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onHit(EliteMobDamagedByPlayerEvent event) {
        if (!MobCombatSettingsConfig.isDisplayDamageOnHit()) {
            return;
        }
        Location mobLocation = event.getEliteMobEntity().getLocation();
        Vector offset = new Vector(ThreadLocalRandom.current().nextDouble(-2.0, 2.0), 0.0, ThreadLocalRandom.current().nextDouble(-2.0, 2.0));
        Object colorPrefix = "";
        if (event.getDamageModifier() < 1.0) {
            colorPrefix = (String)colorPrefix + MobCombatSettingsConfig.getResistTextColor();
            DialogArmorStand.createDialogArmorStand((Entity)event.getEliteMobEntity().getUnsyncedLivingEntity(), MobCombatSettingsConfig.getResistText(), offset.clone().subtract(new Vector(0.0, 0.2, 0.0)));
            mobLocation.getWorld().playSound(mobLocation, Sound.BLOCK_ANVIL_USE, 1.0f, 1.0f);
            if (MobCombatSettingsConfig.isDoResistEffect()) {
                this.resistArmorStandCreator(event.getEliteMobEntity(), event.getPlayer(), Material.SHIELD);
            }
        } else if (event.getDamageModifier() > 1.0) {
            colorPrefix = (String)colorPrefix + MobCombatSettingsConfig.getWeakTextColor();
            DialogArmorStand.createDialogArmorStand((Entity)event.getEliteMobEntity().getUnsyncedLivingEntity(), MobCombatSettingsConfig.getWeakText(), offset.clone().subtract(new Vector(0.0, 0.2, 0.0)));
            mobLocation.getWorld().playSound(mobLocation, Sound.ENTITY_ITEM_BREAK, 1.0f, 1.0f);
            if (MobCombatSettingsConfig.isDoWeakEffect()) {
                this.weakArmorStandCreator(event.getEliteMobEntity(), event.getPlayer(), Material.DIAMOND_SWORD);
            }
        }
        if (event.isCriticalStrike()) {
            colorPrefix = (String)colorPrefix + CriticalStrikesConfig.getCriticalHitColor();
            CriticalStrikesEnchantment.criticalStrikePopupMessage((Entity)event.getEliteMobEntity().getUnsyncedLivingEntity(), new Vector(0.0, 0.2, 0.0));
        }
        DialogArmorStand.createDialogArmorStand((Entity)event.getEliteMobEntity().getUnsyncedLivingEntity(), ChatColor.RED + (String)colorPrefix + ChatColor.BOLD + Round.twoDecimalPlaces((double)event.getDamage()), offset);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onHit(EliteMobHealEvent event) {
        if (!MobCombatSettingsConfig.isDisplayDamageOnHit()) {
            return;
        }
        if (!event.getEliteEntity().isValid()) {
            return;
        }
        Vector offset = new Vector(ThreadLocalRandom.current().nextDouble(-1.0, 1.0), 0.0, ThreadLocalRandom.current().nextDouble(-1.0, 1.0));
        if (event.isFullHeal()) {
            DialogArmorStand.createDialogArmorStand((Entity)event.getEliteEntity().getUnsyncedLivingEntity(), MobCombatSettingsConfig.getFullHealMessage(), offset.clone().subtract(new Vector(0.0, 0.2, 0.0)));
        } else {
            DialogArmorStand.createDialogArmorStand((Entity)event.getEliteEntity().getUnsyncedLivingEntity(), ChatColor.GREEN + event.getHealAmount() + " HP HEAL!", offset.clone().subtract(new Vector(0.0, 0.2, 0.0)));
        }
    }

    private void resistArmorStandCreator(final EliteEntity eliteEntity, final Player player, Material material) {
        if (!(eliteEntity.isValid() && player.isValid() && eliteEntity.getLocation().getWorld().equals(player.getWorld()))) {
            return;
        }
        final ArmorStand armorStand = VisualDisplay.generateTemporaryArmorStand(this.getResistLocation(player, eliteEntity), "Resist");
        armorStand.getEquipment().setItemInMainHand(new ItemStack(material));
        armorStand.addEquipmentLock(EquipmentSlot.HAND, ArmorStand.LockType.REMOVING_OR_CHANGING);
        armorStand.setRightArmPose(new EulerAngle(1.5707963267948966, 4.71238898038469, Math.PI));
        new BukkitRunnable(){
            int counter = 0;

            public void run() {
                if (!(this.counter <= 20 && eliteEntity.isValid() && player.isValid() && eliteEntity.getLocation().getWorld().equals(player.getWorld()))) {
                    EntityTracker.unregister((Entity)armorStand, RemovalReason.EFFECT_TIMEOUT);
                    this.cancel();
                    return;
                }
                try {
                    armorStand.teleport(PopupDisplay.this.getResistLocation(player, eliteEntity));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++this.counter;
            }
        }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 1L, 1L);
    }

    private Location getResistLocation(Player player, EliteEntity eliteEntity) {
        Vector armorsStandVector = player.getLocation().subtract(eliteEntity.getLocation()).toVector().normalize().multiply(1.5);
        Location armorStandLocation = eliteEntity.getLocation().add(armorsStandVector);
        armorStandLocation.setDirection(armorsStandVector);
        return armorStandLocation;
    }

    private void weakArmorStandCreator(final EliteEntity eliteEntity, final Player player, Material material) {
        if (!(eliteEntity.isValid() && player.isValid() && eliteEntity.getLocation().getWorld().equals(player.getWorld()))) {
            return;
        }
        final TextDisplay[] textDisplays = new TextDisplay[]{this.generateWeakArmorStand(player, eliteEntity, material, -1), this.generateWeakArmorStand(player, eliteEntity, material, 1)};
        new BukkitRunnable(){
            int counter = 0;

            public void run() {
                if (!(this.counter <= 10 && eliteEntity.isValid() && player.isValid() && eliteEntity.getLocation().getWorld().equals(player.getWorld()))) {
                    EntityTracker.unregister((Entity)textDisplays[0], RemovalReason.EFFECT_TIMEOUT);
                    EntityTracker.unregister((Entity)textDisplays[1], RemovalReason.EFFECT_TIMEOUT);
                    this.cancel();
                    return;
                }
                for (TextDisplay armorStand : textDisplays) {
                    armorStand.teleport(armorStand.getLocation().add(eliteEntity.getLocation().add(new Vector(0, 0, 0)).subtract(armorStand.getLocation()).toVector().normalize().multiply(0.4)));
                }
                ++this.counter;
            }
        }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 1L, 1L);
    }

    private TextDisplay generateWeakArmorStand(Player player, EliteEntity eliteEntity, Material material, int offset) {
        Vector armorsStandVector = player.getLocation().clone().add(new Vector(0, 2, 0)).subtract(eliteEntity.getLocation()).toVector().normalize().multiply(3.0).rotateAroundY(0.39269908169872414 * (double)offset);
        Location armorStandLocation = eliteEntity.getLocation().add(armorsStandVector);
        armorStandLocation.setDirection(armorsStandVector.multiply(-1));
        return VisualDisplay.generateTemporaryTextDisplay(armorStandLocation, "Weak");
    }
}

