/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.api;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.api.PlayerTeleportEvent;
import com.magmaguy.elitemobs.config.CombatTagConfig;
import com.magmaguy.elitemobs.utils.EventCaller;
import com.magmaguy.magmacore.util.ChatColorConverter;
import lombok.Generated;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class PlayerPreTeleportEvent
extends Event
implements Cancellable {
    private static final HandlerList handlers = new HandlerList();
    private final Location destination;
    private final Location originalLocation;
    private final Player player;
    private boolean isCancelled = false;

    public PlayerPreTeleportEvent(Player player, Location destination) {
        this.player = player;
        this.destination = destination.clone();
        this.originalLocation = player.getLocation().clone();
    }

    public static void teleportPlayer(Player player, Location destination) {
        if (destination.getWorld() == null) {
            return;
        }
        if (CombatTagConfig.isEnableTeleportTimer()) {
            new EventCaller(new PlayerPreTeleportEvent(player, destination));
        } else {
            PlayerTeleportEvent.teleportPlayer(player, destination);
        }
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    public void startTeleport() {
        new BukkitRunnable(){
            int timerLeft = 3;

            public void run() {
                ChatMessageType chatMessageType;
                if (!PlayerPreTeleportEvent.this.player.isValid()) {
                    this.cancel();
                    return;
                }
                if (PlayerPreTeleportEvent.this.player.getLocation().getX() != PlayerPreTeleportEvent.this.originalLocation.getX() || PlayerPreTeleportEvent.this.player.getLocation().getY() != PlayerPreTeleportEvent.this.originalLocation.getY() || PlayerPreTeleportEvent.this.player.getLocation().getZ() != PlayerPreTeleportEvent.this.originalLocation.getZ()) {
                    PlayerPreTeleportEvent.this.isCancelled = true;
                }
                ChatMessageType chatMessageType2 = chatMessageType = CombatTagConfig.isUseActionBarMessagesInsteadOfChat() ? ChatMessageType.ACTION_BAR : ChatMessageType.CHAT;
                if (PlayerPreTeleportEvent.this.isCancelled) {
                    PlayerPreTeleportEvent.this.player.spigot().sendMessage(chatMessageType, TextComponent.fromLegacyText((String)ChatColorConverter.convert((String)CombatTagConfig.getTeleportCancelled())));
                    this.cancel();
                    return;
                }
                PlayerPreTeleportEvent.this.player.spigot().sendMessage(chatMessageType, TextComponent.fromLegacyText((String)ChatColorConverter.convert((String)CombatTagConfig.getTeleportTimeLeft()).replace("$time", "" + this.timerLeft)));
                if (this.timerLeft == 0) {
                    PlayerTeleportEvent.teleportPlayer(PlayerPreTeleportEvent.this.player, PlayerPreTeleportEvent.this.destination);
                    this.cancel();
                    return;
                }
                --this.timerLeft;
            }
        }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 0L, 20L);
    }

    public HandlerList getHandlers() {
        return handlers;
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public void setCancelled(boolean b) {
        this.isCancelled = b;
    }

    @Generated
    public Location getDestination() {
        return this.destination;
    }

    @Generated
    public Location getOriginalLocation() {
        return this.originalLocation;
    }

    @Generated
    public Player getPlayer() {
        return this.player;
    }

    public static class PlayerPreTeleportEventEvents
    implements Listener {
        @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
        public void onTeleportEvent(PlayerPreTeleportEvent event) {
            event.startTeleport();
        }
    }
}

