/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.api;

import com.magmaguy.elitemobs.adventurersguild.GuildRank;
import com.magmaguy.elitemobs.api.EliteDamageEvent;
import com.magmaguy.elitemobs.collateralminecraftchanges.PlayerDeathMessageByEliteMob;
import com.magmaguy.elitemobs.config.MobCombatSettingsConfig;
import com.magmaguy.elitemobs.entitytracker.EntityTracker;
import com.magmaguy.elitemobs.mobconstructor.EliteEntity;
import com.magmaguy.elitemobs.mobconstructor.custombosses.CustomBossEntity;
import com.magmaguy.elitemobs.mobconstructor.mobdata.aggressivemobs.EliteMobProperties;
import com.magmaguy.elitemobs.playerdata.ElitePlayerInventory;
import com.magmaguy.elitemobs.utils.EventCaller;
import com.magmaguy.magmacore.util.AttributeManager;
import java.util.HashSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.EvokerFangs;
import org.bukkit.entity.Explosive;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.potion.PotionEffectType;

public class PlayerDamagedByEliteMobEvent
extends EliteDamageEvent {
    private static final HandlerList handlers = new HandlerList();
    private final Entity entity;
    private final EliteEntity eliteEntity;
    private final Player player;
    private final EntityDamageByEntityEvent entityDamageByEntityEvent;
    private final Projectile projectile;

    public PlayerDamagedByEliteMobEvent(EliteEntity eliteEntity, Player player, EntityDamageByEntityEvent event, Projectile projectile, double damage) {
        super(damage, (Event)event);
        this.entity = event.getEntity();
        this.eliteEntity = eliteEntity;
        this.player = player;
        this.entityDamageByEntityEvent = event;
        this.projectile = projectile;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    public Entity getEntity() {
        return this.entity;
    }

    public EliteEntity getEliteMobEntity() {
        return this.eliteEntity;
    }

    public Player getPlayer() {
        return this.player;
    }

    public Projectile getProjectile() {
        return this.projectile;
    }

    public EntityDamageByEntityEvent getEntityDamageByEntityEvent() {
        return this.entityDamageByEntityEvent;
    }

    @Override
    public HandlerList getHandlers() {
        return handlers;
    }

    public static class PlayerDamagedByEliteMobEventFilter
    implements Listener {
        private static boolean bypass = false;
        private static double specialMultiplier = 1.0;

        private static double eliteToPlayerDamageFormula(Player player, EliteEntity eliteEntity, EntityDamageByEntityEvent event) {
            CustomBossEntity customBossEntity;
            double baseDamage = EliteMobProperties.getBaselineDamage(eliteEntity.getLivingEntity().getType(), eliteEntity);
            if (eliteEntity.getLivingEntity() != null && player.isValid() && player.getLocation().getWorld().equals(eliteEntity.getLivingEntity().getWorld())) {
                if (eliteEntity.getLivingEntity().getType().equals((Object)EntityType.CREEPER)) {
                    Creeper creeper = (Creeper)eliteEntity.getLivingEntity();
                    double distance = player.getLocation().distance(eliteEntity.getLivingEntity().getLocation());
                    double distanceAttenuation = 1.0 - distance / (double)creeper.getExplosionRadius();
                    distanceAttenuation = distanceAttenuation < 0.0 ? 0.0 : distanceAttenuation;
                    baseDamage *= distanceAttenuation;
                } else if (eliteEntity.getLivingEntity().getType().equals((Object)EntityType.GHAST) && event.getDamager().getType().equals((Object)EntityType.FIREBALL)) {
                    double distance = player.getLocation().distance(eliteEntity.getLivingEntity().getLocation());
                    double distanceAttenuation = 1.0 - distance / (double)((Fireball)event.getDamager()).getYield();
                    distanceAttenuation = distanceAttenuation < 0.0 ? 0.0 : distanceAttenuation;
                    baseDamage *= distanceAttenuation;
                }
            }
            double bonusDamage = (double)eliteEntity.getLevel() * 0.5;
            ElitePlayerInventory elitePlayerInventory = ElitePlayerInventory.getPlayer(player);
            if (elitePlayerInventory == null) {
                return 0.0;
            }
            double damageReduction = elitePlayerInventory.getEliteDefense(true) * 0.5;
            if (event.getDamager() instanceof AbstractArrow) {
                damageReduction += elitePlayerInventory.getEliteProjectileProtection(true);
            }
            if (event.getDamager() instanceof Fireball || event.getDamager() instanceof Creeper) {
                damageReduction += elitePlayerInventory.getEliteBlastProtection(true);
            }
            double customBossDamageMultiplier = eliteEntity.getDamageMultiplier();
            double potionEffectDamageReduction = 0.0;
            if (player.hasPotionEffect(PotionEffectType.RESISTANCE)) {
                potionEffectDamageReduction = (double)(player.getPotionEffect(PotionEffectType.RESISTANCE).getAmplifier() + 1) * MobCombatSettingsConfig.getResistanceDamageMultiplier();
            }
            double finalDamage = eliteEntity instanceof CustomBossEntity && (customBossEntity = (CustomBossEntity)eliteEntity).isNormalizedCombat() ? Math.max(baseDamage + bonusDamage - damageReduction - potionEffectDamageReduction, 1.0) * customBossDamageMultiplier * specialMultiplier * MobCombatSettingsConfig.getNormalizedDamageToPlayerMultiplier() : Math.max(baseDamage + bonusDamage - damageReduction - potionEffectDamageReduction, 1.0) * customBossDamageMultiplier * specialMultiplier * MobCombatSettingsConfig.getDamageToPlayerMultiplier();
            if (specialMultiplier != 1.0) {
                specialMultiplier = 1.0;
            }
            double playerMaxHealth = AttributeManager.getAttributeBaseValue((LivingEntity)player, (String)"generic_max_health");
            finalDamage = Math.min(finalDamage, playerMaxHealth - 1.0);
            return finalDamage;
        }

        @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
        private void explosionEvent(EntityExplodeEvent event) {
            if (event.getEntity().getType().equals((Object)EntityType.CREEPER) && EntityTracker.isEliteMob(event.getEntity())) {
                HashSet potionEffects = new HashSet(((Creeper)event.getEntity()).getActivePotionEffects());
                potionEffects.forEach(potionEffectType -> ((Creeper)event.getEntity()).removePotionEffect(potionEffectType.getType()));
            }
        }

        @EventHandler
        public void onEliteDamagePlayer(EntityDamageByEntityEvent event) {
            Entity entity;
            if (event.isCancelled()) {
                bypass = false;
                if (!(event.getDamager() instanceof Explosive)) {
                    return;
                }
            }
            if (!((entity = event.getEntity()) instanceof Player)) {
                return;
            }
            Player player = (Player)entity;
            if (player.hasMetadata("NPC") || ElitePlayerInventory.getPlayer(player) == null) {
                return;
            }
            Projectile projectile = null;
            EliteEntity eliteEntity = null;
            if (event.getDamager() instanceof LivingEntity) {
                eliteEntity = EntityTracker.getEliteMobEntity(event.getDamager());
            } else if (event.getDamager() instanceof Projectile && ((Projectile)event.getDamager()).getShooter() instanceof LivingEntity) {
                eliteEntity = EntityTracker.getEliteMobEntity((Entity)((LivingEntity)((Projectile)event.getDamager()).getShooter()));
                projectile = (Projectile)event.getDamager();
            } else if (event.getDamager().getType().equals((Object)EntityType.EVOKER_FANGS) && ((EvokerFangs)event.getDamager()).getOwner() != null) {
                eliteEntity = EntityTracker.getEliteMobEntity((Entity)((EvokerFangs)event.getDamager()).getOwner());
            }
            if (eliteEntity == null || eliteEntity.getLivingEntity() == null) {
                return;
            }
            if (ThreadLocalRandom.current().nextDouble() < GuildRank.dodgeBonusValue(GuildRank.getGuildPrestigeRank(player), GuildRank.getActiveGuildRank(player)) / 100.0) {
                player.sendTitle(" ", "Dodged!");
                event.setCancelled(true);
                return;
            }
            boolean blocking = false;
            if (player.isBlocking()) {
                blocking = true;
                if (player.getInventory().getItemInOffHand().getType().equals((Object)Material.SHIELD)) {
                    ItemMeta itemMeta = player.getInventory().getItemInOffHand().getItemMeta();
                    Damageable damageable = (Damageable)itemMeta;
                    if (player.getInventory().getItemInOffHand().getItemMeta().hasEnchant(Enchantment.UNBREAKING) && (double)player.getInventory().getItemInOffHand().getItemMeta().getEnchantLevel(Enchantment.UNBREAKING) / 20.0 > ThreadLocalRandom.current().nextDouble()) {
                        damageable.setDamage(damageable.getDamage() + 5);
                    }
                    player.getInventory().getItemInOffHand().setItemMeta(itemMeta);
                    if (Material.SHIELD.getMaxDurability() < damageable.getDamage()) {
                        player.getInventory().setItemInOffHand(null);
                    }
                }
                if (event.getDamager() instanceof Projectile) {
                    bypass = false;
                    event.getDamager().remove();
                    return;
                }
            }
            double newDamage = PlayerDamagedByEliteMobEventFilter.eliteToPlayerDamageFormula(player, eliteEntity, event);
            if (blocking) {
                newDamage -= newDamage * MobCombatSettingsConfig.getBlockingDamageReduction();
            }
            for (EntityDamageEvent.DamageModifier modifier : EntityDamageEvent.DamageModifier.values()) {
                if (!event.isApplicable(modifier) || modifier == EntityDamageEvent.DamageModifier.ABSORPTION) continue;
                event.setDamage(modifier, 0.0);
            }
            if (bypass) {
                newDamage = event.getOriginalDamage(EntityDamageEvent.DamageModifier.BASE);
                bypass = false;
            }
            PlayerDamagedByEliteMobEvent playerDamagedByEliteMobEvent = new PlayerDamagedByEliteMobEvent(eliteEntity, player, event, projectile, newDamage);
            new EventCaller(playerDamagedByEliteMobEvent);
            newDamage = playerDamagedByEliteMobEvent.getDamage();
            if (playerDamagedByEliteMobEvent.isCancelled()) {
                bypass = false;
                return;
            }
            event.setDamage(EntityDamageEvent.DamageModifier.BASE, newDamage);
            if (player.getHealth() - event.getDamage() <= 0.0) {
                PlayerDeathMessageByEliteMob.addDeadPlayer(player, PlayerDeathMessageByEliteMob.initializeDeathMessage(player, eliteEntity));
            }
        }

        @Generated
        public static boolean isBypass() {
            return bypass;
        }

        @Generated
        public static void setBypass(boolean bypass) {
            PlayerDamagedByEliteMobEventFilter.bypass = bypass;
        }

        @Generated
        public static double getSpecialMultiplier() {
            return specialMultiplier;
        }

        @Generated
        public static void setSpecialMultiplier(double specialMultiplier) {
            PlayerDamagedByEliteMobEventFilter.specialMultiplier = specialMultiplier;
        }
    }
}

