/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.adventurersguild;

import com.magmaguy.elitemobs.adventurersguild.GuildRank;
import com.magmaguy.elitemobs.config.AdventurersGuildConfig;
import com.magmaguy.elitemobs.config.CustomModelsConfig;
import com.magmaguy.elitemobs.config.DefaultConfig;
import com.magmaguy.elitemobs.config.EconomySettingsConfig;
import com.magmaguy.elitemobs.config.SoundsConfig;
import com.magmaguy.elitemobs.config.menus.premade.GuildRankMenuConfig;
import com.magmaguy.elitemobs.economy.EconomyHandler;
import com.magmaguy.elitemobs.quests.playercooldowns.PlayerQuestCooldowns;
import com.magmaguy.elitemobs.utils.CustomModelAdder;
import com.magmaguy.magmacore.util.ChatColorConverter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class GuildRankMenuHandler
implements Listener {
    private static final HashSet<Inventory> inventories = new HashSet();
    private static final ArrayList<Integer> rankSlots = new ArrayList<Integer>(new ArrayList<Integer>(List.of(4, 11, 12, 13, 14, 15, 20, 21, 22, 23, 24, 29, 30, 31, 32, 33, 38, 39, 40, 41, 42)));
    private static final int prestigeRankSlot = 49;

    private static void selectUnlockedRank(Player player, int guildRank) {
        GuildRank.setActiveGuildRank(player, guildRank);
    }

    private static void selectRankToUnlock(Player player, int guildRank) {
        double price = GuildRankMenuHandler.tierPriceCalculator(guildRank, GuildRank.getGuildPrestigeRank(player));
        if (EconomyHandler.checkCurrency(player.getUniqueId()) < price) {
            player.sendMessage(GuildRankMenuConfig.getNotEnoughCurrencyMessage().replace("$neededAmount", "" + GuildRankMenuHandler.tierPriceCalculator(guildRank, GuildRank.getGuildPrestigeRank(player))).replace("$currentAmount", "" + EconomyHandler.checkCurrency(player.getUniqueId())).replace("$currencyName", EconomySettingsConfig.getCurrencyName()));
            return;
        }
        EconomyHandler.subtractCurrency(player.getUniqueId(), price);
        GuildRank.setActiveGuildRank(player, guildRank);
        GuildRank.setMaxGuildRank(player, guildRank);
        player.sendMessage(GuildRankMenuConfig.getUnlockMessage().replace("$rankName", GuildRank.getRankName(GuildRank.getGuildPrestigeRank(player), guildRank)).replace("$price", "" + GuildRankMenuHandler.tierPriceCalculator(guildRank, GuildRank.getGuildPrestigeRank(player))).replace("$currencyName", EconomySettingsConfig.getCurrencyName()));
        Bukkit.broadcastMessage((String)GuildRankMenuConfig.getBroadcastMessage().replace("$player", player.getDisplayName()).replace("$rankName", GuildRank.getRankName(GuildRank.getGuildPrestigeRank(player), guildRank)));
        if (!AdventurersGuildConfig.getOnRankUpCommand().isEmpty()) {
            for (String command : AdventurersGuildConfig.getOnRankUpCommand()) {
                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command.replace("$player", player.getName()).replace("$prestigeRank", "" + GuildRank.getActiveGuildRank(player)).replace("$activeRank", "" + GuildRank.getGuildPrestigeRank(player)));
            }
        }
        player.playSound(player.getLocation(), SoundsConfig.guildRankUpSound, 1.0f, 1.0f);
    }

    private static void selectPrestigeUnlock(Player player) {
        if (GuildRank.getGuildPrestigeRank(player) >= 10) {
            return;
        }
        if (GuildRank.getActiveGuildRank(player) != 10 + GuildRank.getGuildPrestigeRank(player)) {
            return;
        }
        if (EconomyHandler.checkCurrency(player.getUniqueId()) < (double)GuildRankMenuHandler.tierPriceCalculator(GuildRank.getGuildPrestigeRank(player) + 12, GuildRank.getGuildPrestigeRank(player))) {
            player.sendMessage(GuildRankMenuConfig.getNotEnoughCurrencyMessage().replace("$neededAmount", "" + GuildRankMenuHandler.tierPriceCalculator(GuildRank.getGuildPrestigeRank(player) + 12, GuildRank.getGuildPrestigeRank(player))).replace("$currentAmount", "" + EconomyHandler.checkCurrency(player.getUniqueId())).replace("$currencyName", EconomySettingsConfig.getCurrencyName()));
            return;
        }
        EconomyHandler.setCurrency(player.getUniqueId(), 0.0);
        GuildRank.setMaxGuildRank(player, 1);
        GuildRank.setActiveGuildRank(player, 1);
        GuildRank.setGuildPrestigeRank(player, GuildRank.getGuildPrestigeRank(player) + 1);
        PlayerQuestCooldowns.resetPlayerQuests(player);
        for (Player iteratedPlayer : Bukkit.getOnlinePlayers()) {
            iteratedPlayer.sendTitle(ChatColorConverter.convert((String)AdventurersGuildConfig.getPrestigeUnlockMessageTitle().replace("$player", player.getDisplayName()).replace("$tier", "" + GuildRank.getGuildPrestigeRank(player))), ChatColorConverter.convert((String)AdventurersGuildConfig.getPrestigeUnlockMessageSubtitle().replace("$player", player.getDisplayName()).replace("$tier", "" + GuildRank.getGuildPrestigeRank(player))));
        }
        player.closeInventory();
        if (!AdventurersGuildConfig.getOnPrestigeUpCommand().isEmpty()) {
            for (String command : AdventurersGuildConfig.getOnPrestigeUpCommand()) {
                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command.replace("$player", player.getName()).replace("$prestigeRank", "" + GuildRank.getActiveGuildRank(player)).replace("$activeRank", "" + GuildRank.getGuildPrestigeRank(player)));
            }
        }
        player.playSound(player.getLocation(), SoundsConfig.guildPrestigeSound, 1.0f, 1.0f);
    }

    public static Inventory initializeGuildRankMenu(Player player) {
        Object menuName = GuildRankMenuConfig.getMenuName();
        if (DefaultConfig.useResourcePackModels()) {
            menuName = ChatColor.WHITE + "\uf801\uda90\udefa\uf805           " + (String)menuName;
        }
        Inventory difficultyMenu = Bukkit.createInventory((InventoryHolder)player, (int)54, (String)menuName);
        difficultyMenu = GuildRankMenuHandler.populateInventory(difficultyMenu, player);
        inventories.add(difficultyMenu);
        player.openInventory(difficultyMenu);
        return difficultyMenu;
    }

    public static Inventory populateInventory(Inventory difficultyMenu, Player player) {
        for (int i = 0; i < 11 + GuildRank.getGuildPrestigeRank(player); ++i) {
            if (AdventurersGuildConfig.isDisableCommonerRank() && i == 0) continue;
            ItemStack itemStack = null;
            if (GuildRank.isAtOrAboveGuildRank(player, i)) {
                itemStack = GuildRankMenuHandler.difficultyItemStackConstructor(guildRankStatus.UNLOCKED, i, player, false);
            }
            if (GuildRank.getActiveGuildRank(player) < i && GuildRank.getMaxGuildRank(player) >= i) {
                itemStack = GuildRankMenuHandler.difficultyItemStackConstructor(guildRankStatus.UNLOCKED, i, player, false);
            }
            if (GuildRank.getActiveGuildRank(player) == i) {
                itemStack = GuildRankMenuHandler.difficultyItemStackConstructor(guildRankStatus.SELECTED, i, player, false);
            }
            if (GuildRank.getMaxGuildRank(player) < i) {
                itemStack = GuildRankMenuHandler.difficultyItemStackConstructor(guildRankStatus.LOCKED, i, player, false);
            }
            if (GuildRank.getMaxGuildRank(player) + 1 == i) {
                itemStack = GuildRankMenuHandler.difficultyItemStackConstructor(guildRankStatus.NEXT_UNLOCK, i, player, false);
            }
            difficultyMenu.setItem(rankSlots.get(i).intValue(), itemStack);
        }
        if (GuildRank.getGuildPrestigeRank(player) < 10) {
            if (GuildRank.getActiveGuildRank(player) < 10 + GuildRank.getGuildPrestigeRank(player)) {
                difficultyMenu.setItem(49, GuildRankMenuHandler.difficultyItemStackConstructor(guildRankStatus.PRESTIGE_LOCKED, GuildRank.getGuildPrestigeRank(player) + 1, player, true));
            } else {
                difficultyMenu.setItem(49, GuildRankMenuHandler.difficultyItemStackConstructor(guildRankStatus.PRESTIGE_NEXT_UNLOCK, GuildRank.getGuildPrestigeRank(player) + 1, player, true));
            }
        }
        return difficultyMenu;
    }

    private static ItemStack difficultyItemStackConstructor(guildRankStatus guildRankStatus2, int activeGuildRank, Player player, boolean isPrestigeSlot) {
        ItemStack itemStack = null;
        Object priceString = "";
        priceString = !isPrestigeSlot ? ((double)GuildRankMenuHandler.tierPriceCalculator(activeGuildRank, GuildRank.getGuildPrestigeRank(player)) > EconomyHandler.checkCurrency(player.getUniqueId()) ? "&c" + GuildRankMenuHandler.tierPriceCalculator(activeGuildRank, GuildRank.getGuildPrestigeRank(player)) : "&a" + GuildRankMenuHandler.tierPriceCalculator(activeGuildRank, GuildRank.getGuildPrestigeRank(player))) : ((double)GuildRankMenuHandler.tierPriceCalculator(GuildRank.getGuildPrestigeRank(player) + 12, GuildRank.getGuildPrestigeRank(player)) > EconomyHandler.checkCurrency(player.getUniqueId()) ? "&c" + GuildRankMenuHandler.tierPriceCalculator(GuildRank.getGuildPrestigeRank(player) + 12, GuildRank.getGuildPrestigeRank(player)) : "&a" + GuildRankMenuHandler.tierPriceCalculator(GuildRank.getGuildPrestigeRank(player) + 12, GuildRank.getGuildPrestigeRank(player)));
        switch (guildRankStatus2) {
            case UNLOCKED: {
                itemStack = GuildRankMenuHandler.constructButtonItemStack(activeGuildRank, GuildRankMenuConfig.getUnlockedButton().clone(), player, (String)priceString);
                CustomModelAdder.addCustomModel(itemStack, CustomModelsConfig.grayLock);
                break;
            }
            case LOCKED: {
                itemStack = GuildRankMenuHandler.constructButtonItemStack(activeGuildRank, GuildRankMenuConfig.getLockedButton().clone(), player, (String)priceString);
                CustomModelAdder.addCustomModel(itemStack, CustomModelsConfig.redLock);
                break;
            }
            case SELECTED: {
                itemStack = GuildRankMenuHandler.constructButtonItemStack(activeGuildRank, GuildRankMenuConfig.getCurrentButton().clone(), player, (String)priceString);
                CustomModelAdder.addCustomModel(itemStack, CustomModelsConfig.greenLock);
                break;
            }
            case NEXT_UNLOCK: {
                itemStack = GuildRankMenuHandler.constructButtonItemStack(activeGuildRank, GuildRankMenuConfig.getNextButton().clone(), player, (String)priceString);
                CustomModelAdder.addCustomModel(itemStack, CustomModelsConfig.yellowLock);
                break;
            }
            case PRESTIGE_LOCKED: {
                itemStack = GuildRankMenuHandler.constructButtonItemStack(activeGuildRank, GuildRankMenuConfig.getPrestigeLockedButton().clone(), player, (String)priceString);
                CustomModelAdder.addCustomModel(itemStack, CustomModelsConfig.redCrown);
                break;
            }
            case PRESTIGE_NEXT_UNLOCK: {
                itemStack = GuildRankMenuHandler.constructButtonItemStack(activeGuildRank, GuildRankMenuConfig.getPrestigeNextUnlockButton().clone(), player, (String)priceString);
                CustomModelAdder.addCustomModel(itemStack, CustomModelsConfig.yellowCrown);
            }
        }
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (guildRankStatus2.equals((Object)guildRankStatus.UNLOCKED) || guildRankStatus2.equals((Object)guildRankStatus.LOCKED) || guildRankStatus2.equals((Object)guildRankStatus.SELECTED) || guildRankStatus2.equals((Object)guildRankStatus.NEXT_UNLOCK)) {
            itemMeta.setDisplayName(GuildRank.getRankName(GuildRank.getGuildPrestigeRank(player), activeGuildRank));
        } else {
            itemMeta.setDisplayName(itemMeta.getDisplayName().replace("$rank", "" + (GuildRank.getGuildPrestigeRank(player) + 1)));
        }
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    private static ItemStack constructButtonItemStack(int activeGuildRank, ItemStack itemStack, Player player, String priceString) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        ArrayList<String> newLore = new ArrayList<String>();
        Iterator iterator = itemMeta.getLore().iterator();
        block14: while (iterator.hasNext()) {
            String string;
            switch (string = (String)iterator.next()) {
                case "$lootTier": {
                    if (GuildRankMenuHandler.lootTierString(activeGuildRank) == null) continue block14;
                    newLore.add(GuildRankMenuHandler.lootTierString(activeGuildRank));
                    continue block14;
                }
                case "$maxHealthIncrease": {
                    if (GuildRankMenuHandler.healthBonusString(GuildRank.getGuildPrestigeRank(player), activeGuildRank) == null) continue block14;
                    newLore.add(GuildRankMenuHandler.healthBonusString(GuildRank.getGuildPrestigeRank(player), activeGuildRank));
                    continue block14;
                }
                case "$chanceToCrit": {
                    if (GuildRankMenuHandler.critBonusString(GuildRank.getGuildPrestigeRank(player), activeGuildRank) == null) continue block14;
                    newLore.add(GuildRankMenuHandler.critBonusString(GuildRank.getGuildPrestigeRank(player), activeGuildRank));
                    continue block14;
                }
                case "$chanceToDodge": {
                    if (GuildRankMenuHandler.dodgeBonusString(GuildRank.getGuildPrestigeRank(player), activeGuildRank) == null) continue block14;
                    newLore.add(GuildRankMenuHandler.dodgeBonusString(GuildRank.getGuildPrestigeRank(player), activeGuildRank));
                    continue block14;
                }
                case "$currencyBonusMessage": {
                    if (GuildRank.getGuildPrestigeRank(player) <= 0) continue block14;
                    newLore.add(GuildRankMenuHandler.currencyBonusString(GuildRank.getGuildPrestigeRank(player)));
                    continue block14;
                }
            }
            if (string.contains("$previousRank")) {
                newLore.add(string.replace("$previousRank", GuildRank.getRankName(GuildRank.getGuildPrestigeRank(player), GuildRank.getMaxGuildRank(player) + 1)));
                continue;
            }
            if (string.contains("$price")) {
                newLore.add(ChatColorConverter.convert((String)string.replace("$price", priceString).replace("$currencyName", EconomySettingsConfig.getCurrencyName())));
                continue;
            }
            if (string.contains("$currentCurrency")) {
                newLore.add(string.replace("$currentCurrency", "" + EconomyHandler.checkCurrency(player.getUniqueId())).replace("$currencyName", EconomySettingsConfig.getCurrencyName()));
                continue;
            }
            newLore.add(string);
        }
        itemMeta.setLore(newLore);
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    private static String lootTierString(int activeGuildRank) {
        if (!AdventurersGuildConfig.isGuildLootLimiter()) {
            return null;
        }
        return GuildRankMenuConfig.getLootTierMessage().replace("$tier", "" + GuildRank.lootTierValue(activeGuildRank));
    }

    private static String currencyBonusString(int activeGuildRank) {
        return GuildRankMenuConfig.getCurrencyBonusMessage().replace("$amount", "" + GuildRank.currencyBonusMultiplier(activeGuildRank));
    }

    private static String healthBonusString(int prestigeLevel, int guildRank) {
        if (!AdventurersGuildConfig.isAddMaxHealth()) {
            return null;
        }
        if (prestigeLevel < 1) {
            return null;
        }
        return GuildRankMenuConfig.getHealthBonusMessage().replace("$amount", "" + GuildRank.healthBonusValue(prestigeLevel, guildRank));
    }

    private static String critBonusString(int prestigeLevel, int guildRank) {
        if (!AdventurersGuildConfig.isAddMaxHealth()) {
            return null;
        }
        if (prestigeLevel < 2) {
            return null;
        }
        return GuildRankMenuConfig.getCritBonusMessage().replace("$amount", "" + GuildRank.critBonusValue(prestigeLevel, guildRank));
    }

    private static String dodgeBonusString(int prestigeLevel, int guildRank) {
        if (!AdventurersGuildConfig.isAddMaxHealth()) {
            return null;
        }
        if (prestigeLevel < 3) {
            return null;
        }
        return GuildRankMenuConfig.getDodgeBonusMessage().replace("$amount", "" + GuildRank.dodgeBonusValue(prestigeLevel, guildRank));
    }

    private static int tierPriceCalculator(int tier, int prestigeLevel) {
        double eliteMobsToKillBeforeGuildRankUp = AdventurersGuildConfig.getBaseKillsForRankUp() + AdventurersGuildConfig.getAdditionalKillsForRankUpPerTier() * (tier - 1);
        return (int)((double)(tier - 1) * 10.0 / 2.0 * eliteMobsToKillBeforeGuildRankUp * GuildRank.currencyBonusMultiplier(prestigeLevel));
    }

    @EventHandler
    public void onRankSelectorClick(InventoryClickEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        if (!inventories.contains(event.getInventory())) {
            return;
        }
        if (event.getCurrentItem() == null || event.getCurrentItem().getType() == Material.AIR) {
            return;
        }
        event.setCancelled(true);
        if (event.getSlot() == 49) {
            GuildRankMenuHandler.selectPrestigeUnlock(player);
            return;
        }
        Integer selectedRank = null;
        for (int i = 0; i < rankSlots.size(); ++i) {
            if (rankSlots.get(i).intValue() != event.getSlot() || AdventurersGuildConfig.isDisableCommonerRank() && i == 4) continue;
            selectedRank = i;
            break;
        }
        if (selectedRank == null) {
            return;
        }
        if (GuildRank.getMaxGuildRank(player) >= selectedRank) {
            GuildRankMenuHandler.selectUnlockedRank(player, selectedRank);
            GuildRankMenuHandler.populateInventory(event.getInventory(), player);
            return;
        }
        if (GuildRank.getMaxGuildRank(player) + 1 == selectedRank) {
            GuildRankMenuHandler.selectRankToUnlock(player, selectedRank);
            GuildRankMenuHandler.populateInventory(event.getInventory(), player);
            return;
        }
        if (GuildRank.getMaxGuildRank(player) < selectedRank) {
            GuildRankMenuHandler.selectPrestigeUnlock(player);
            GuildRankMenuHandler.populateInventory(event.getInventory(), player);
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        inventories.remove(event.getInventory());
    }

    private static enum guildRankStatus {
        UNLOCKED,
        SELECTED,
        NEXT_UNLOCK,
        LOCKED,
        PRESTIGE_LOCKED,
        PRESTIGE_NEXT_UNLOCK;

    }
}

