/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.adventurersguild;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.config.AdventurersGuildConfig;
import com.magmaguy.elitemobs.playerdata.ElitePlayerInventory;
import com.magmaguy.elitemobs.playerdata.database.PlayerData;
import com.magmaguy.magmacore.util.AttributeManager;
import com.magmaguy.magmacore.util.Round;
import java.util.UUID;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class GuildRank {
    private GuildRank() {
    }

    public static void setGuildPrestigeRank(Player player, int prestigeRank) {
        PlayerData.setGuildPrestigeLevel(player.getUniqueId(), prestigeRank);
        ElitePlayerInventory.playerInventories.get(player.getUniqueId()).getFullPlayerTier(true);
    }

    public static int getGuildPrestigeRank(Player player) {
        return GuildRank.getGuildPrestigeRank(player.getUniqueId());
    }

    public static int getGuildPrestigeRank(UUID player) {
        return PlayerData.getGuildPrestigeLevel(player);
    }

    public static int getGuildPrestigeRank(Player player, boolean databaseAccess) {
        return PlayerData.getGuildPrestigeLevel(player.getUniqueId(), databaseAccess);
    }

    public static void setMaxGuildRank(Player player, int maxGuildRank) {
        PlayerData.setMaxGuildLevel(player.getUniqueId(), maxGuildRank);
    }

    public static int getMaxGuildRank(Player player) {
        return PlayerData.getMaxGuildLevel(player.getUniqueId());
    }

    public static int getMaxGuildRank(Player player, boolean databaseAccess) {
        return PlayerData.getMaxGuildLevel(player.getUniqueId(), databaseAccess);
    }

    public static void setActiveGuildRank(Player player, int activeGuildRank) {
        PlayerData.setActiveGuildLevel(player.getUniqueId(), activeGuildRank);
        GuildRank.setMaxHealth(player, activeGuildRank, GuildRank.getGuildPrestigeRank(player));
    }

    public static int getActiveGuildRank(Player player) {
        return PlayerData.getActiveGuildLevel(player.getUniqueId());
    }

    public static int getActiveGuildRank(Player player, boolean databaseAccess) {
        return PlayerData.getActiveGuildLevel(player.getUniqueId(), databaseAccess);
    }

    public static boolean isWithinMaxGuildRank(Player player, int prestigeLevel, int maxGuildLevel) {
        return GuildRank.getGuildPrestigeRank(player) >= prestigeLevel && GuildRank.getMaxGuildRank(player) >= maxGuildLevel;
    }

    public static boolean isWithinMaxGuildRankIgnorePrestige(Player player, int maxGuildLevel) {
        return GuildRank.getMaxGuildRank(player) >= maxGuildLevel;
    }

    public static boolean isAtOrAboveGuildRank(Player player, int prestigeLevel, int activeGuildLevel) {
        return GuildRank.getGuildPrestigeRank(player) <= prestigeLevel && GuildRank.getActiveGuildRank(player) <= activeGuildLevel;
    }

    public static boolean isAtOrAboveGuildRank(Player player, int activeGuildLevel) {
        return GuildRank.getActiveGuildRank(player) >= activeGuildLevel;
    }

    public static String getRankName(int prestige, int rank) {
        return AdventurersGuildConfig.getRankName(prestige, rank);
    }

    public static void setMaxHealth(Player player, int activeGuildRank, int prestigeRank) {
        if (!AdventurersGuildConfig.isAddMaxHealth()) {
            return;
        }
        if (AdventurersGuildConfig.getWorldsWithoutAGBonuses().contains(player.getWorld().getName())) {
            return;
        }
        double guildRankBonus = GuildRank.healthBonusValue(prestigeRank, activeGuildRank);
        double newMaxHealth = 20.0 + guildRankBonus;
        AttributeManager.setAttribute((LivingEntity)player, (String)"generic_max_health", (double)newMaxHealth);
    }

    public static void setMaxHealth(Player player) {
        GuildRank.setMaxHealth(player, PlayerData.getActiveGuildLevel(player.getUniqueId()), PlayerData.getGuildPrestigeLevel(player.getUniqueId()));
    }

    public static double lootTierValue(int activeGuildRank) {
        return activeGuildRank * 10;
    }

    public static double currencyBonusMultiplier(int prestigeLevel) {
        return 1.0 + (double)(prestigeLevel * 5);
    }

    public static double currencyBonusMultiplier(UUID player) {
        return GuildRank.currencyBonusMultiplier(GuildRank.getGuildPrestigeRank(player));
    }

    public static double healthBonusValue(int prestigeLevel, int guildRank) {
        if (!AdventurersGuildConfig.isAddMaxHealth()) {
            return 0.0;
        }
        double prestigeBonus = 0.0;
        switch (prestigeLevel) {
            case 0: {
                prestigeBonus = 0.0;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                prestigeBonus = AdventurersGuildConfig.getHealth1();
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                prestigeBonus = AdventurersGuildConfig.getHealth2();
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                prestigeBonus = AdventurersGuildConfig.getHealth3();
                break;
            }
            case 10: {
                prestigeBonus = AdventurersGuildConfig.getHealth4();
            }
        }
        return prestigeBonus * (double)guildRank;
    }

    public static double dodgeBonusValue(int prestigeLevel, int guildRank) {
        if (!AdventurersGuildConfig.isAddDodge()) {
            return 0.0;
        }
        double prestigeBonus = 0.0;
        switch (prestigeLevel) {
            case 0: 
            case 1: 
            case 2: {
                prestigeBonus = 0.0;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                prestigeBonus = AdventurersGuildConfig.getDodge1();
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                prestigeBonus = AdventurersGuildConfig.getDodge2();
                break;
            }
            case 9: 
            case 10: {
                prestigeBonus = AdventurersGuildConfig.getDodge3();
            }
        }
        return Round.twoDecimalPlaces((double)((double)guildRank / (10.0 + (double)prestigeLevel) * prestigeBonus));
    }

    public static double critBonusValue(int prestigeLevel, int guildRank) {
        if (!AdventurersGuildConfig.isAddCrit()) {
            return 0.0;
        }
        double prestigeBonus = 0.0;
        switch (prestigeLevel) {
            case 0: 
            case 1: {
                prestigeBonus = 0.0;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                prestigeBonus = AdventurersGuildConfig.getCrit1();
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                prestigeBonus = AdventurersGuildConfig.getCrit2();
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                prestigeBonus = AdventurersGuildConfig.getCrit3();
            }
        }
        return Round.twoDecimalPlaces((double)((double)guildRank / (10.0 + (double)prestigeLevel) * prestigeBonus));
    }

    public static class GuildRankEvents
    implements Listener {
        @EventHandler
        public void onPlayerJoin(final PlayerJoinEvent event) {
            new BukkitRunnable(){

                public void run() {
                    if (event.getPlayer().isOnline()) {
                        GuildRank.setMaxHealth(event.getPlayer(), GuildRank.getActiveGuildRank(event.getPlayer(), true), GuildRank.getGuildPrestigeRank(event.getPlayer(), true));
                    }
                }
            }.runTaskLater((Plugin)MetadataHandler.PLUGIN, 60L);
        }
    }
}

