/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.magmacore.util;

import com.magmaguy.magmacore.MagmaCore;
import com.magmaguy.magmacore.util.Logger;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Random;
import java.util.logging.Filter;
import org.apache.commons.io.FileUtils;
import org.bukkit.Bukkit;
import org.bukkit.Difficulty;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.generator.WorldInfo;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class TemporaryWorldManager {
    public static World loadVoidTemporaryWorld(String worldName, World.Environment environment) {
        if (Bukkit.getWorld((String)worldName) != null) {
            return Bukkit.getWorld((String)worldName);
        }
        File folder = new File(Bukkit.getWorldContainer().getAbsolutePath());
        if (!Files.exists(Paths.get(folder.getAbsolutePath() + File.separatorChar + worldName, new String[0]), new LinkOption[0])) {
            Logger.warn("File  " + folder.getAbsolutePath() + File.separatorChar + worldName + " does not exist!");
            return null;
        }
        Logger.info("Loading world " + worldName + " !");
        Filter filter = newFilter -> false;
        Filter previousFilter = Bukkit.getLogger().getFilter();
        Bukkit.getLogger().setFilter(filter);
        try {
            WorldCreator worldCreator = new WorldCreator(worldName);
            worldCreator.environment(environment);
            worldCreator.keepSpawnInMemory(false);
            worldCreator.generator((ChunkGenerator)new VoidGenerator());
            World world = Bukkit.createWorld((WorldCreator)worldCreator);
            if (world != null) {
                world.setKeepSpawnInMemory(false);
            }
            world.setDifficulty(Difficulty.HARD);
            world.setAutoSave(false);
            Bukkit.getLogger().setFilter(previousFilter);
            return world;
        }
        catch (Exception exception) {
            Bukkit.getLogger().setFilter(previousFilter);
            Logger.warn("Failed to load world " + worldName + " !");
            exception.printStackTrace();
            return null;
        }
    }

    public static void asyncPermanentlyDeleteWorld(final World world, final File worldDirectory) {
        if (!Bukkit.unloadWorld((World)world, (boolean)false)) {
            Logger.warn("Failed to unload world " + world.getName() + " ! This is bad, report this to the developer!");
        }
        new BukkitRunnable(){

            public void run() {
                try {
                    FileUtils.deleteDirectory(worldDirectory);
                    Logger.info("Successfully deleted temporary world " + world.getName());
                }
                catch (Exception e) {
                    Logger.warn("Failed to delete " + worldDirectory.toString() + " ! This is bad, report this to the developer!");
                }
            }
        }.runTaskAsynchronously((Plugin)MagmaCore.getInstance().getRequestingPlugin());
    }

    public static void permanentlyDeleteWorld(World world, File worldDirectory) {
        if (MagmaCore.getInstance().getRequestingPlugin().isEnabled()) {
            TemporaryWorldManager.asyncPermanentlyDeleteWorld(world, worldDirectory);
        } else {
            TemporaryWorldManager.syncPermanentlyDeleteWorld(world, worldDirectory);
        }
    }

    public static void syncPermanentlyDeleteWorld(World world, File worldDirectory) {
        if (!Bukkit.unloadWorld((World)world, (boolean)false)) {
            Logger.warn("Failed to unload world " + world.getName() + " ! This is bad, report this to the developer!");
        }
        try {
            FileUtils.deleteDirectory(worldDirectory);
            Logger.info("Successfully deleted temporary world " + world.getName());
        }
        catch (Exception e) {
            Logger.warn("Failed to delete " + worldDirectory.toString() + " ! This is bad, report this to the developer!");
        }
    }

    private static class VoidGenerator
    extends ChunkGenerator {
        private VoidGenerator() {
        }

        public void generateSurface(WorldInfo info, Random random, int x, int z, ChunkGenerator.ChunkData data) {
        }

        public boolean shouldGenerateNoise() {
            return false;
        }

        public boolean shouldGenerateBedrock() {
            return false;
        }

        public boolean shouldGenerateCaves() {
            return false;
        }
    }
}

