/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.wormhole;

import com.magmaguy.elitemobs.config.WormholesConfig;
import com.magmaguy.elitemobs.dungeons.EMPackage;
import com.magmaguy.elitemobs.entitytracker.EntityTracker;
import com.magmaguy.elitemobs.mobconstructor.PersistentObject;
import com.magmaguy.elitemobs.mobconstructor.PersistentObjectHandler;
import com.magmaguy.elitemobs.utils.ChunkLocationChecker;
import com.magmaguy.elitemobs.utils.ConfigurationLocation;
import com.magmaguy.elitemobs.wormhole.Wormhole;
import com.magmaguy.magmacore.util.ChatColorConverter;
import com.magmaguy.magmacore.util.Logger;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class WormholeEntry
implements PersistentObject {
    private static final Set<WormholeEntry> wormholeEntries = new HashSet<WormholeEntry>();
    private final Wormhole wormhole;
    private final int wormholeNumber;
    private Location location;
    private String locationString;
    private String armorStandText;
    private ArmorStand text = null;
    private String worldName;
    private String portalMissingMessage = null;
    private String opMessage = null;
    private PersistentObjectHandler persistentObjectHandler = null;

    public WormholeEntry(Wormhole wormhole, String locationString, int wormholeNumber) {
        this.wormhole = wormhole;
        this.wormholeNumber = wormholeNumber;
        this.locationString = locationString;
        if (locationString == null) {
            Logger.warn("Wormhole " + wormhole.getWormholeConfigFields().getFilename() + " is missing a wormhole location! Fix this!");
            return;
        }
        this.setLocationFromConfiguration();
        this.armorStandText = wormholeNumber == 1 ? wormhole.getWormholeConfigFields().getLocation1Text() : wormhole.getWormholeConfigFields().getLocation2Text();
        this.persistentObjectHandler = new PersistentObjectHandler(this);
        wormholeEntries.add(this);
        if (ChunkLocationChecker.locationIsLoaded(this.location)) {
            this.chunkLoad();
        }
    }

    private Location getDungeonLocation() {
        Location teleportLocation;
        EMPackage emPackage = EMPackage.getEmPackages().get(this.locationString);
        if (emPackage == null) {
            Logger.warn("Dungeon " + this.locationString + " is not a valid dungeon packager name! Wormhole " + this.wormhole.getWormholeConfigFields().getFilename() + " will not lead anywhere.");
            this.setPortalMissingMessage(WormholesConfig.getDefaultPortalMissingMessage());
            return null;
        }
        if (!emPackage.isDownloaded() || !emPackage.isInstalled()) {
            this.setPortalMissingMessage(WormholesConfig.getDungeonNotInstalledMessage().replace("$dungeonID", emPackage.getContentPackagesConfigFields().getName()));
            this.opMessage = ChatColorConverter.convert("&8[EliteMobs - OP-only message] &fDownload links are available on &9https://magmaguy.itch.io/ &f(free and premium) and &9https://www.patreon.com/magmaguy &f(premium). You can check the difference between the two and get support here: https://discord.gg/9f5QSka");
        }
        if ((teleportLocation = emPackage.getContentPackagesConfigFields().getTeleportLocation()) == null) {
            return null;
        }
        this.worldName = emPackage.getContentPackagesConfigFields().getWorldName();
        return teleportLocation.clone();
    }

    private void setLocationFromConfiguration() {
        if (this.locationString.contains(",")) {
            this.worldName = ConfigurationLocation.worldName(this.locationString);
            this.location = ConfigurationLocation.serialize(this.locationString);
        } else {
            this.location = this.getDungeonLocation();
        }
    }

    public void onDungeonInstall() {
        this.location = this.getDungeonLocation();
        if (this.persistentObjectHandler != null) {
            this.persistentObjectHandler = new PersistentObjectHandler(this);
        }
        this.persistentObjectHandler = new PersistentObjectHandler(this);
        this.chunkLoad();
    }

    public void onDungeonUninstall() {
        if (this.text != null && this.text.isValid()) {
            this.text.remove();
            this.text = null;
        }
        this.location = null;
    }

    @Override
    public void chunkLoad() {
        if (this.text == null || !this.text.isValid()) {
            this.initializeTextDisplay();
        }
        if (this.location == null) {
            this.setLocationFromConfiguration();
        }
    }

    @Override
    public void chunkUnload() {
        if (this.text != null && this.text.isValid()) {
            this.text.remove();
            this.text = null;
        }
    }

    @Override
    public void worldLoad(World world) {
        this.setLocationFromConfiguration();
        if (this.location != null && this.location.getWorld() != null && ChunkLocationChecker.locationIsLoaded(this.location)) {
            this.chunkLoad();
        }
    }

    @Override
    public void worldUnload() {
        this.location.setWorld(null);
        if (this.text != null && this.text.isValid()) {
            this.text.remove();
            this.text = null;
        }
    }

    @Override
    public Location getPersistentLocation() {
        return this.location;
    }

    @Override
    public String getWorldName() {
        return this.worldName;
    }

    public void stop() {
        if (this.text != null && this.text.isValid()) {
            this.text.remove();
            this.text = null;
        }
    }

    public void updateLocation(Player player) {
        this.locationString = ConfigurationLocation.deserialize(player.getLocation());
        this.location = player.getLocation().add(new Vector(0.0, 1.0 * this.wormhole.getWormholeConfigFields().getSizeMultiplier(), 0.0));
        this.wormhole.getWormholeConfigFields().setWormholeEntryLocation(this.location, this.wormholeNumber);
        if (this.persistentObjectHandler != null) {
            this.persistentObjectHandler.remove();
        }
        this.persistentObjectHandler = new PersistentObjectHandler(this);
    }

    public void initializeTextDisplay() {
        if (this.text != null && this.text.isValid() && !this.text.isEmpty()) {
            return;
        }
        if (this.armorStandText == null) {
            return;
        }
        if (this.location == null || this.location.getWorld() == null) {
            return;
        }
        this.text = (ArmorStand)this.location.getWorld().spawn(this.location.clone().add(new Vector(0.0, 1.2, 0.0).multiply(this.wormhole.getWormholeConfigFields().getSizeMultiplier())), ArmorStand.class, (Consumer)new org.bukkit.util.Consumer<ArmorStand>(){

            public void accept(ArmorStand armorStand) {
                armorStand.setCustomName(ChatColorConverter.convert(WormholeEntry.this.armorStandText));
                armorStand.setCustomNameVisible(true);
                armorStand.setMarker(true);
                armorStand.setVisible(false);
                armorStand.setGravity(false);
                armorStand.setPersistent(false);
                armorStand.setRemoveWhenFarAway(false);
            }
        });
        EntityTracker.registerVisualEffects((Entity)this.text);
    }

    @Generated
    public static Set<WormholeEntry> getWormholeEntries() {
        return wormholeEntries;
    }

    @Generated
    public Wormhole getWormhole() {
        return this.wormhole;
    }

    @Generated
    public Location getLocation() {
        return this.location;
    }

    @Generated
    public String getLocationString() {
        return this.locationString;
    }

    @Generated
    public String getArmorStandText() {
        return this.armorStandText;
    }

    @Generated
    public ArmorStand getText() {
        return this.text;
    }

    @Generated
    public void setText(ArmorStand text) {
        this.text = text;
    }

    @Generated
    public String getPortalMissingMessage() {
        return this.portalMissingMessage;
    }

    @Generated
    public void setPortalMissingMessage(String portalMissingMessage) {
        this.portalMissingMessage = portalMissingMessage;
    }

    @Generated
    public String getOpMessage() {
        return this.opMessage;
    }

    @Generated
    public void setOpMessage(String opMessage) {
        this.opMessage = opMessage;
    }
}

