/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.powers;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.api.EliteMobDamagedByPlayerEvent;
import com.magmaguy.elitemobs.config.powers.PowersConfig;
import com.magmaguy.elitemobs.events.BossCustomAttackDamage;
import com.magmaguy.elitemobs.mobconstructor.EliteEntity;
import com.magmaguy.elitemobs.powers.meta.BossPower;
import com.magmaguy.elitemobs.powers.meta.ElitePower;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class FlamePyre
extends BossPower
implements Listener {
    public FlamePyre() {
        super(PowersConfig.getPower("flame_pyre.yml"));
    }

    @EventHandler
    public void onHit(EliteMobDamagedByPlayerEvent event) {
        FlamePyre flamePyre = (FlamePyre)event.getEliteMobEntity().getPower(this);
        if (flamePyre == null) {
            return;
        }
        if (!FlamePyre.eventIsValid(event, (ElitePower)flamePyre)) {
            return;
        }
        if (ThreadLocalRandom.current().nextDouble() > 0.25) {
            return;
        }
        flamePyre.doGlobalCooldown(400, event.getEliteMobEntity());
        this.doFlamePyrePhase1(event.getEliteMobEntity());
    }

    private void doFlamePyrePhase1(final EliteEntity eliteEntity) {
        eliteEntity.getLivingEntity().setAI(false);
        new BukkitRunnable(){
            int counter = 0;

            public void run() {
                ++this.counter;
                if (!eliteEntity.isValid()) {
                    this.cancel();
                    return;
                }
                FlamePyre.this.spawnPhase1Particle(eliteEntity.getLivingEntity().getLocation().clone(), Particle.SMOKE);
                if (this.counter < 40) {
                    return;
                }
                this.cancel();
                FlamePyre.this.doFlamePyrePhase2(eliteEntity);
            }
        }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 0L, 1L);
    }

    private void spawnPhase1Particle(Location location, Particle particle) {
        for (int i = 0; i < 10; ++i) {
            location.getWorld().spawnParticle(particle, new Location(location.getWorld(), (ThreadLocalRandom.current().nextDouble() - 0.5) * 0.5 + location.getX(), location.getY(), (ThreadLocalRandom.current().nextDouble() - 0.5) * 0.5 + location.getZ()), 0, 0.0, 1.0, 0.0, ThreadLocalRandom.current().nextDouble() * 2.0);
        }
    }

    private void doFlamePyrePhase2(final EliteEntity eliteEntity) {
        new BukkitRunnable(){
            int counter = 0;

            public void run() {
                if (!eliteEntity.isValid()) {
                    this.cancel();
                    return;
                }
                ++this.counter;
                FlamePyre.this.spawnPhase1Particle(eliteEntity.getLivingEntity().getLocation().clone(), Particle.FLAME);
                FlamePyre.this.doDamage(eliteEntity, 0.5, 50.0, 0.5);
                FlamePyre.this.spawnPhase2Particle(eliteEntity.getLivingEntity().getLocation().clone(), Particle.SMOKE);
                if (this.counter < 40) {
                    return;
                }
                this.cancel();
                FlamePyre.this.doFlamePyrePhase3(eliteEntity);
            }
        }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 0L, 1L);
    }

    private void spawnPhase2Particle(Location location, Particle particle) {
        for (int i = 0; i < 10; ++i) {
            location.getWorld().spawnParticle(particle, new Location(location.getWorld(), (ThreadLocalRandom.current().nextDouble() - 0.5) * 3.0 + location.getX(), location.getY(), (ThreadLocalRandom.current().nextDouble() - 0.5) * 3.0 + location.getZ()), 0, 0.0, 1.0, 0.0, ThreadLocalRandom.current().nextDouble() * 2.0);
        }
    }

    private void doDamage(EliteEntity eliteEntity, double range1, double range2, double range3) {
        for (Entity entity : eliteEntity.getLivingEntity().getNearbyEntities(range1, range2, range3)) {
            if (!(entity instanceof LivingEntity)) continue;
            BossCustomAttackDamage.dealCustomDamage(eliteEntity.getLivingEntity(), (LivingEntity)entity, 1.0);
        }
    }

    private void doFlamePyrePhase3(final EliteEntity eliteEntity) {
        new BukkitRunnable(){
            int counter = 0;

            public void run() {
                if (!eliteEntity.isValid()) {
                    this.cancel();
                    return;
                }
                ++this.counter;
                FlamePyre.this.spawnPhase2Particle(eliteEntity.getLivingEntity().getLocation().clone(), Particle.FLAME);
                FlamePyre.this.doDamage(eliteEntity, 3.0, 50.0, 3.0);
                FlamePyre.this.spawnPhase3Particle(eliteEntity.getLivingEntity().getLocation().clone(), Particle.SMOKE);
                if (this.counter < 40) {
                    return;
                }
                this.cancel();
                FlamePyre.this.doFlamePyrePhase4(eliteEntity);
            }
        }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 0L, 1L);
    }

    private void spawnPhase3Particle(Location location, Particle particle) {
        location.getWorld().spawnParticle(particle, location, 50, 0.01, 0.01, 0.01, 0.1);
    }

    private void doFlamePyrePhase4(final EliteEntity eliteEntity) {
        new BukkitRunnable(){
            int counter = 0;

            public void run() {
                if (!eliteEntity.isValid()) {
                    this.cancel();
                    return;
                }
                ++this.counter;
                FlamePyre.this.spawnPhase3Particle(eliteEntity.getLivingEntity().getLocation().clone(), Particle.FLAME);
                FlamePyre.this.doDamage(eliteEntity, 5.0, 50.0, 5.0);
                if (this.counter < 40) {
                    return;
                }
                this.cancel();
                eliteEntity.getLivingEntity().setAI(true);
            }
        }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 0L, 1L);
    }
}

