/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.playerdata.statusscreen;

import com.magmaguy.elitemobs.adventurersguild.GuildRank;
import com.magmaguy.elitemobs.config.AdventurersGuildConfig;
import com.magmaguy.elitemobs.config.menus.premade.PlayerStatusMenuConfig;
import com.magmaguy.elitemobs.economy.EconomyHandler;
import com.magmaguy.elitemobs.playerdata.database.PlayerData;
import com.magmaguy.elitemobs.playerdata.statusscreen.CoverPage;
import com.magmaguy.elitemobs.playerdata.statusscreen.PlayerStatusScreen;
import java.util.HashSet;
import java.util.Set;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class StatsPage {
    private StatsPage() {
    }

    protected static TextComponent statsPage(Player targetPlayer) {
        TextComponent textComponent = new TextComponent();
        for (int i = 0; i < 13; ++i) {
            if (PlayerStatusMenuConfig.getStatsTextLines()[i] == null) continue;
            TextComponent line = new TextComponent(PlayerStatusMenuConfig.getStatsTextLines()[i].replace("$money", "" + EconomyHandler.checkCurrency(targetPlayer.getUniqueId())).replace("$guildtier", PlayerStatusScreen.convertLightColorsToBlack(AdventurersGuildConfig.getShortenedRankName(GuildRank.getGuildPrestigeRank(targetPlayer), GuildRank.getActiveGuildRank(targetPlayer)))).replace("$kills", "" + PlayerData.getKills(targetPlayer.getUniqueId())).replace("$highestkill", "" + PlayerData.getHighestLevelKilled(targetPlayer.getUniqueId())).replace("$deaths", "" + PlayerData.getDeaths(targetPlayer.getUniqueId())).replace("$quests", "" + PlayerData.getQuestsCompleted(targetPlayer.getUniqueId())).replace("$score", "" + PlayerData.getScore(targetPlayer.getUniqueId())) + "\n");
            if (PlayerStatusMenuConfig.getStatsHoverLines() != null && PlayerStatusMenuConfig.getStatsHoverLines()[i] != null && !PlayerStatusMenuConfig.getStatsHoverLines()[i].isEmpty()) {
                PlayerStatusScreen.setHoverText(line, PlayerStatusMenuConfig.getStatsHoverLines()[i]);
            }
            if (PlayerStatusMenuConfig.getStatsCommandLines() != null && PlayerStatusMenuConfig.getStatsCommandLines()[i] != null && !PlayerStatusMenuConfig.getStatsCommandLines()[i].isEmpty()) {
                line.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, PlayerStatusMenuConfig.getStatsCommandLines()[i]));
            }
            textComponent.addExtra((BaseComponent)line);
        }
        return textComponent;
    }

    protected static void statsPage(Player targetPlayer, Player requestingPlayer) {
        Inventory inventory = Bukkit.createInventory((InventoryHolder)requestingPlayer, (int)27, (String)PlayerStatusMenuConfig.getStatsChestMenuName());
        inventory.setItem(PlayerStatusMenuConfig.getStatsMoneySlot(), StatsPage.replaceItemNamePlaceholder(PlayerStatusMenuConfig.getStatsMoneyItem().clone(), "$money", "" + EconomyHandler.checkCurrency(targetPlayer.getUniqueId())));
        inventory.setItem(PlayerStatusMenuConfig.getStatsGuildTierSlot(), StatsPage.replaceItemNamePlaceholder(PlayerStatusMenuConfig.getStatsGuildTierItem().clone(), "$tier", AdventurersGuildConfig.getShortenedRankName(GuildRank.getGuildPrestigeRank(targetPlayer), GuildRank.getActiveGuildRank(targetPlayer))));
        inventory.setItem(PlayerStatusMenuConfig.getStatsEliteKillsSlot(), StatsPage.replaceItemNamePlaceholder(PlayerStatusMenuConfig.getStatsEliteKillsItem().clone(), "$kills", "" + PlayerData.getKills(targetPlayer.getUniqueId())));
        inventory.setItem(PlayerStatusMenuConfig.getStatsMaxEliteLevelKilledSlot(), StatsPage.replaceItemNamePlaceholder(PlayerStatusMenuConfig.getStatsMaxEliteLevelKilledItem().clone(), "$maxKill", "" + PlayerData.getHighestLevelKilled(targetPlayer.getUniqueId())));
        inventory.setItem(PlayerStatusMenuConfig.getStatsEliteDeathsSlot(), StatsPage.replaceItemNamePlaceholder(PlayerStatusMenuConfig.getStatsEliteDeathsItem().clone(), "$deaths", "" + PlayerData.getDeaths(targetPlayer.getUniqueId())));
        inventory.setItem(PlayerStatusMenuConfig.getStatsQuestsCompletedSlot(), StatsPage.replaceItemNamePlaceholder(PlayerStatusMenuConfig.getStatsQuestsCompletedItem().clone(), "$questsCompleted", "" + PlayerData.getQuestsCompleted(targetPlayer.getUniqueId())));
        inventory.setItem(PlayerStatusMenuConfig.getStatsScoreSlot(), StatsPage.replaceItemNamePlaceholder(PlayerStatusMenuConfig.getStatsScoreItem().clone(), "$score", "" + PlayerData.getScore(targetPlayer.getUniqueId())));
        inventory.setItem(26, PlayerStatusMenuConfig.getBackItem());
        requestingPlayer.openInventory(inventory);
        StatsPageEvents.pageInventories.add(inventory);
    }

    private static ItemStack replaceItemNamePlaceholder(ItemStack itemStack, String placeholder, String replacement) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.setDisplayName(itemMeta.getDisplayName().replace(placeholder, replacement));
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    public static class StatsPageEvents
    implements Listener {
        private static final Set<Inventory> pageInventories = new HashSet<Inventory>();

        @EventHandler
        public void onInventoryInteract(InventoryClickEvent event) {
            Player player = ((Player)event.getWhoClicked()).getPlayer();
            if (!pageInventories.contains(event.getInventory())) {
                return;
            }
            event.setCancelled(true);
            if (event.getSlot() == 26) {
                player.closeInventory();
                CoverPage.coverPage(player);
            }
        }

        @EventHandler
        public void onInventoryClose(InventoryCloseEvent event) {
            pageInventories.remove(event.getInventory());
        }
    }
}

