/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.npcs;

import com.google.common.collect.ArrayListMultimap;
import com.magmaguy.elitemobs.EliteMobs;
import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.api.internal.RemovalReason;
import com.magmaguy.elitemobs.config.ItemSettingsConfig;
import com.magmaguy.elitemobs.config.npcs.NPCsConfig;
import com.magmaguy.elitemobs.config.npcs.NPCsConfigFields;
import com.magmaguy.elitemobs.entitytracker.EntityTracker;
import com.magmaguy.elitemobs.instanced.dungeons.DungeonInstance;
import com.magmaguy.elitemobs.mobconstructor.PersistentMovingEntity;
import com.magmaguy.elitemobs.mobconstructor.PersistentObject;
import com.magmaguy.elitemobs.mobconstructor.PersistentObjectHandler;
import com.magmaguy.elitemobs.npcs.NPCInteractions;
import com.magmaguy.elitemobs.npcs.chatter.NPCChatBubble;
import com.magmaguy.elitemobs.thirdparty.custommodels.CustomModel;
import com.magmaguy.elitemobs.thirdparty.libsdisguises.DisguiseEntity;
import com.magmaguy.elitemobs.thirdparty.worldguard.WorldGuardSpawnEventBypasser;
import com.magmaguy.elitemobs.utils.ChunkLocationChecker;
import com.magmaguy.elitemobs.utils.ConfigurationLocation;
import com.magmaguy.elitemobs.utils.NonSolidBlockTypes;
import com.magmaguy.magmacore.util.AttributeManager;
import com.magmaguy.magmacore.util.ChatColorConverter;
import com.magmaguy.magmacore.util.Logger;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Villager;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.world.WorldUnloadEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Consumer;
import org.bukkit.util.Vector;

public class NPCEntity
implements PersistentObject,
PersistentMovingEntity {
    private static final ArrayListMultimap<String, InstancedNPCContainer> instancedNPCEntities = ArrayListMultimap.create();
    public final NPCsConfigFields npCsConfigFields;
    private final UUID uuid = UUID.randomUUID();
    private boolean isInstancedDuplicate = false;
    private PersistentObjectHandler persistentObjectHandler;
    private Villager villager = null;
    private Location spawnLocation;
    private boolean isTalking = false;
    private ArmorStand roleDisplay;
    private boolean isDisguised = false;
    private String locationString;

    public NPCEntity(NPCsConfigFields npCsConfigFields, String locationString) {
        this.npCsConfigFields = npCsConfigFields;
        this.locationString = locationString;
        if (!npCsConfigFields.isEnabled()) {
            return;
        }
        if (npCsConfigFields.isInstanced()) {
            Location location = ConfigurationLocation.serialize(locationString);
            String blueprintWorldName = locationString.split(",")[0];
            instancedNPCEntities.put((Object)blueprintWorldName, (Object)new InstancedNPCContainer(location, this));
            return;
        }
        if (locationString == null || locationString.equalsIgnoreCase("null")) {
            return;
        }
        this.setSpawnLocation();
        this.spawn();
        this.persistentObjectHandler = new PersistentObjectHandler(this);
    }

    public NPCEntity(NPCsConfigFields npCsConfigFields, Location location) {
        this.npCsConfigFields = npCsConfigFields;
        this.isInstancedDuplicate = true;
        if (!npCsConfigFields.isEnabled()) {
            return;
        }
        this.spawnLocation = location;
        this.spawn();
        this.persistentObjectHandler = new PersistentObjectHandler(this);
    }

    public NPCEntity(Location location) {
        this.npCsConfigFields = NPCsConfig.getNpcEntities().get("travelling_merchant.yml");
        if (!this.npCsConfigFields.isEnabled()) {
            return;
        }
        Location potentialLocation = location.clone();
        potentialLocation.add(potentialLocation.getDirection().normalize()).setY(location.getY());
        this.spawnLocation = NonSolidBlockTypes.isPassthrough(potentialLocation.getBlock().getType()) ? potentialLocation : location.clone();
        this.spawnLocation.setDirection(this.spawnLocation.getDirection().multiply(-1));
        this.spawn();
    }

    public static void shutdown() {
        instancedNPCEntities.clear();
    }

    public static void initializeInstancedNPCs(String blueprintWorldName, World newWorld, int playerCount, DungeonInstance dungeonInstance) {
        List rawNPCs = instancedNPCEntities.get((Object)blueprintWorldName);
        for (InstancedNPCContainer instancedNPCContainer : rawNPCs) {
            Location newLocation = instancedNPCContainer.getLocation();
            newLocation.setWorld(newWorld);
            new NPCEntity(instancedNPCContainer.getNpcEntity().getNPCsConfigFields(), newLocation);
        }
    }

    public static void initializeNPCs(NPCsConfigFields npCsConfigFields) {
        if (npCsConfigFields.getLocations() != null && !npCsConfigFields.getLocations().isEmpty()) {
            for (String locationString : npCsConfigFields.getLocations()) {
                new NPCEntity(npCsConfigFields, locationString);
            }
        } else if (npCsConfigFields.getSpawnLocation() != null && !npCsConfigFields.getSpawnLocation().isEmpty()) {
            new NPCEntity(npCsConfigFields, npCsConfigFields.getSpawnLocation());
        }
    }

    public void remove(RemovalReason removalReason) {
        if (this.roleDisplay != null) {
            this.roleDisplay.remove();
        }
        if (this.villager != null) {
            this.villager.remove();
            EntityTracker.getNpcEntities().remove(this.villager.getUniqueId());
            this.villager = null;
        }
        if (removalReason.equals((Object)RemovalReason.WORLD_UNLOAD) && this.isInstancedDuplicate) {
            this.persistentObjectHandler.remove();
            return;
        }
        if (removalReason.equals((Object)RemovalReason.REMOVE_COMMAND)) {
            if (this.npCsConfigFields.getLocations() != null && !this.npCsConfigFields.getLocations().isEmpty()) {
                this.npCsConfigFields.removeNPC(this.locationString);
                this.locationString = null;
                this.spawnLocation = null;
            } else {
                this.npCsConfigFields.setEnabled(false);
                this.spawnLocation = null;
            }
            if (this.persistentObjectHandler != null) {
                this.persistentObjectHandler.remove();
            }
        } else if (this.persistentObjectHandler != null) {
            if (!removalReason.equals((Object)RemovalReason.SHUTDOWN)) {
                this.persistentObjectHandler.updatePersistentLocation(this.getPersistentLocation());
            } else {
                this.persistentObjectHandler.remove();
            }
        }
    }

    private void spawn() {
        if (this.spawnLocation == null || this.spawnLocation.getWorld() == null || !ChunkLocationChecker.locationIsLoaded(this.spawnLocation)) {
            return;
        }
        if (this.villager != null && this.villager.isValid()) {
            return;
        }
        if (this.npCsConfigFields.getInteractionType().equals((Object)NPCInteractions.NPCInteractionType.SCROLL_APPLIER) && !ItemSettingsConfig.isUseEliteItemScrolls()) {
            return;
        }
        if (EliteMobs.worldGuardIsEnabled) {
            WorldGuardSpawnEventBypasser.forceSpawn();
        }
        this.villager = (Villager)this.spawnLocation.getWorld().spawn(this.spawnLocation, Villager.class, villagerInstance -> {
            villagerInstance.setAI(false);
            villagerInstance.setPersistent(false);
            villagerInstance.setRemoveWhenFarAway(false);
            villagerInstance.setCustomName(ChatColorConverter.convert(this.npCsConfigFields.getName()));
            villagerInstance.setCustomNameVisible(true);
            villagerInstance.setProfession(this.npCsConfigFields.getProfession());
            AttributeManager.setAttribute((LivingEntity)villagerInstance, "generic_scale", this.npCsConfigFields.getScale());
            if (this.getNPCsConfigFields().getCustomModel() != null && !this.getNPCsConfigFields().getCustomModel().isEmpty()) {
                this.setCustomModel((LivingEntity)villagerInstance);
            } else {
                this.setDisguise((LivingEntity)villagerInstance);
            }
        });
        EntityTracker.registerNPCEntity(this);
        this.initializeRole();
        this.setTimeout();
    }

    private void setDisguise(LivingEntity livingEntity) {
        if (this.npCsConfigFields.getDisguise() == null) {
            return;
        }
        if (!Bukkit.getPluginManager().isPluginEnabled("LibsDisguises")) {
            return;
        }
        try {
            DisguiseEntity.disguise(this.npCsConfigFields.getDisguise(), (Entity)livingEntity, this.npCsConfigFields.getCustomDisguiseData(), this.npCsConfigFields.getFilename());
            DisguiseEntity.setDisguiseNameVisibility(true, (Entity)livingEntity, this.npCsConfigFields.getName());
            livingEntity.setCustomNameVisible(true);
            this.isDisguised = true;
        }
        catch (Exception ex) {
            Logger.warn("Failed to load LibsDisguises disguise correctly!");
            ex.printStackTrace();
        }
    }

    private void setCustomModel(LivingEntity livingEntity) {
        CustomModel.generateCustomModel(livingEntity, this.getNPCsConfigFields().getCustomModel(), this.getNPCsConfigFields().getName());
    }

    public Villager getVillager() {
        return this.villager;
    }

    public boolean isValid() {
        if (this.villager == null) {
            return false;
        }
        return this.villager.isValid();
    }

    public NPCsConfigFields getNPCsConfigFields() {
        return this.npCsConfigFields;
    }

    public Location getSpawnLocation() {
        return this.spawnLocation;
    }

    public boolean setSpawnLocation() {
        Location location = ConfigurationLocation.serialize(this.locationString);
        if (location == null) {
            return false;
        }
        this.spawnLocation = location;
        return true;
    }

    public boolean getIsTalking() {
        return this.isTalking;
    }

    @Override
    public void chunkLoad() {
        this.spawn();
    }

    @Override
    public void chunkUnload() {
        this.remove(RemovalReason.CHUNK_UNLOAD);
    }

    @Override
    public void worldLoad(World world) {
        this.setSpawnLocation();
    }

    @Override
    public void worldUnload() {
        this.spawnLocation.setWorld(null);
        this.remove(RemovalReason.WORLD_UNLOAD);
    }

    @Override
    public Location getPersistentLocation() {
        return this.getSpawnLocation();
    }

    @Override
    public String getWorldName() {
        if (this.getSpawnLocation() != null && this.getSpawnLocation().getWorld() != null) {
            return this.getSpawnLocation().getWorld().getName();
        }
        String world = null;
        if (this.locationString != null && !this.locationString.isEmpty()) {
            world = this.locationString.split(",")[0];
        }
        return world;
    }

    private void initializeRole() {
        Vector offSet = !this.isDisguised ? new Vector(0.0, 1.72, 0.0) : new Vector(0.0, 1.55, 0.0);
        this.roleDisplay = (ArmorStand)this.villager.getWorld().spawn(this.villager.getLocation().add(offSet), ArmorStand.class, (java.util.function.Consumer)new Consumer<ArmorStand>(){

            public void accept(ArmorStand armorStand) {
                armorStand.setCustomName(ChatColorConverter.convert(NPCEntity.this.npCsConfigFields.getRole()));
                armorStand.setCustomNameVisible(true);
                armorStand.setMarker(true);
                armorStand.setVisible(false);
                armorStand.setGravity(false);
                armorStand.setPersistent(false);
            }
        });
        EntityTracker.registerVisualEffects((Entity)this.roleDisplay);
    }

    public void startTalkingCooldown() {
        this.isTalking = true;
        new BukkitRunnable(){

            public void run() {
                NPCEntity.this.isTalking = false;
            }
        }.runTaskLater((Plugin)MetadataHandler.PLUGIN, 60L);
    }

    public void setTimeout() {
        if (this.npCsConfigFields.getTimeout() <= 0.0) {
            return;
        }
        new BukkitRunnable(){

            public void run() {
                NPCEntity.this.remove(RemovalReason.NPC_TIMEOUT);
            }
        }.runTaskLater((Plugin)MetadataHandler.PLUGIN, (long)(this.npCsConfigFields.getTimeout() * 20.0 * 60.0));
    }

    public void sayGreeting(Player player) {
        new NPCChatBubble(this.selectString(this.npCsConfigFields.getGreetings()), this, player);
    }

    public void sayDialog(Player player) {
        new NPCChatBubble(this.selectString(this.npCsConfigFields.getDialog()), this, player);
    }

    public void sayFarewell(Player player) {
        new NPCChatBubble(this.selectString(this.npCsConfigFields.getFarewell()), this, player);
    }

    private String selectString(List<String> strings) {
        if (strings != null && !strings.isEmpty()) {
            return strings.get(ThreadLocalRandom.current().nextInt(strings.size()));
        }
        return null;
    }

    @Generated
    public UUID getUuid() {
        return this.uuid;
    }

    private class InstancedNPCContainer {
        private final Location location;
        private final NPCEntity npcEntity;

        public InstancedNPCContainer(Location location, NPCEntity npcEntity) {
            this.location = location;
            this.npcEntity = npcEntity;
        }

        @Generated
        public Location getLocation() {
            return this.location;
        }

        @Generated
        public NPCEntity getNpcEntity() {
            return this.npcEntity;
        }
    }

    public static class NPCEntityEvents
    implements Listener {
        @EventHandler
        public void worldUnloadEvent(WorldUnloadEvent event) {
            for (NPCEntity npcEntity : EntityTracker.getNpcEntities().values()) {
                if (npcEntity.getSpawnLocation() == null || npcEntity.getSpawnLocation().getWorld() != event.getWorld()) continue;
                npcEntity.worldUnload();
            }
        }
    }
}

