/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.mobconstructor.custombosses;

import com.google.common.collect.ArrayListMultimap;
import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.api.internal.RemovalReason;
import com.magmaguy.elitemobs.config.ItemSettingsConfig;
import com.magmaguy.elitemobs.config.custombosses.CustomBossesConfig;
import com.magmaguy.elitemobs.config.custombosses.CustomBossesConfigFields;
import com.magmaguy.elitemobs.easyminecraftgoals.NMSManager;
import com.magmaguy.elitemobs.entitytracker.EntityTracker;
import com.magmaguy.elitemobs.mobconstructor.PersistentMovingEntity;
import com.magmaguy.elitemobs.mobconstructor.PersistentObject;
import com.magmaguy.elitemobs.mobconstructor.custombosses.CustomBossEntity;
import com.magmaguy.elitemobs.mobconstructor.custombosses.InstancedBossEntity;
import com.magmaguy.elitemobs.mobconstructor.custombosses.transitiveblocks.TransitiveBlock;
import com.magmaguy.elitemobs.pathfinding.Navigation;
import com.magmaguy.elitemobs.powers.SpiritWalk;
import com.magmaguy.elitemobs.utils.ChunkLocationChecker;
import com.magmaguy.elitemobs.utils.ConfigurationLocation;
import com.magmaguy.magmacore.util.AttributeManager;
import com.magmaguy.magmacore.util.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class RegionalBossEntity
extends CustomBossEntity
implements PersistentObject,
PersistentMovingEntity {
    private static final ArrayListMultimap<CustomBossesConfigFields, RegionalBossEntity> regionalBossesFromConfigFields = ArrayListMultimap.create();
    private final double leashRadius;
    private String rawString;
    private String rawLocationString;
    private long ticksBeforeRespawn = 0L;
    private long unixRespawnTime;
    private int respawnCoolDownInMinutes = -1;
    private boolean isRespawning = false;
    private BukkitTask leashTask;
    private List<TransitiveBlock> onSpawnTransitiveBlocks;
    private List<TransitiveBlock> onRemoveTransitiveBlocks;
    private boolean removed = false;
    private BukkitTask respawnTask = null;

    public RegionalBossEntity(CustomBossesConfigFields customBossesConfigFields, String rawString) {
        super(customBossesConfigFields);
        this.rawString = rawString;
        this.rawLocationString = rawString.split(":")[0];
        this.respawnCoolDownInMinutes = customBossesConfigFields.getSpawnCooldown();
        this.leashRadius = customBossesConfigFields.getLeashRadius();
        this.onSpawnTransitiveBlocks = TransitiveBlock.serializeTransitiveBlocks(customBossesConfigFields.getOnSpawnBlockStates(), customBossesConfigFields.getFilename());
        this.onRemoveTransitiveBlocks = TransitiveBlock.serializeTransitiveBlocks(customBossesConfigFields.getOnRemoveBlockStates(), customBossesConfigFields.getFilename());
        regionalBossesFromConfigFields.put((Object)customBossesConfigFields, (Object)this);
        this.unixRespawnTime = 0L;
        if (rawString.contains(":")) {
            this.unixRespawnTime = Long.parseLong(rawString.split(":")[1]);
        }
        this.ticksBeforeRespawn = 0L;
        if (this.unixRespawnTime > 0L) {
            this.ticksBeforeRespawn = (this.unixRespawnTime - System.currentTimeMillis()) / 1000L * 20L < 0L ? 0L : (this.unixRespawnTime - System.currentTimeMillis()) / 1000L * 20L;
        }
        this.worldName = this.rawLocationString.split(",")[0];
        this.spawnLocation = ConfigurationLocation.serialize(this.rawLocationString);
        super.setPersistent(true);
    }

    public RegionalBossEntity(CustomBossesConfigFields customBossesConfigFields, Location location, boolean permanent, boolean persistent) {
        super(customBossesConfigFields);
        this.onSpawnTransitiveBlocks = TransitiveBlock.serializeTransitiveBlocks(customBossesConfigFields.getOnSpawnBlockStates(), customBossesConfigFields.getFilename());
        this.onRemoveTransitiveBlocks = TransitiveBlock.serializeTransitiveBlocks(customBossesConfigFields.getOnRemoveBlockStates(), customBossesConfigFields.getFilename());
        this.onSpawnTransitiveBlocks = TransitiveBlock.serializeTransitiveBlocks(customBossesConfigFields.getOnSpawnBlockStates(), customBossesConfigFields.getFilename());
        this.onRemoveTransitiveBlocks = TransitiveBlock.serializeTransitiveBlocks(customBossesConfigFields.getOnRemoveBlockStates(), customBossesConfigFields.getFilename());
        super.setPersistent(persistent);
        this.spawnLocation = location;
        this.leashRadius = customBossesConfigFields.getLeashRadius();
        if (permanent) {
            this.rawString = ConfigurationLocation.deserialize(location);
            this.rawLocationString = this.rawString.split(":")[0];
            this.unixRespawnTime = 0L;
            this.respawnCoolDownInMinutes = customBossesConfigFields.getSpawnCooldown();
            regionalBossesFromConfigFields.put((Object)customBossesConfigFields, (Object)this);
            this.saveNewLocation();
        }
    }

    @Nullable
    public static RegionalBossEntity SpawnRegionalBoss(String configurationFilename, Location spawnLocation) {
        CustomBossesConfigFields thisCustomBossConfigurationField = CustomBossesConfig.getCustomBoss(configurationFilename);
        if (thisCustomBossConfigurationField == null) {
            return null;
        }
        if (spawnLocation == null) {
            return null;
        }
        return new RegionalBossEntity(thisCustomBossConfigurationField, spawnLocation, true, true);
    }

    public static void regionalBossesShutdown() {
        regionalBossesFromConfigFields.clear();
    }

    public static List<RegionalBossEntity> getRegionalBossEntities(CustomBossesConfigFields customBossesConfigFields) {
        return regionalBossesFromConfigFields.get((Object)customBossesConfigFields);
    }

    public static Collection<RegionalBossEntity> getRegionalBossEntities() {
        return regionalBossesFromConfigFields.values();
    }

    public static void regionalDataSaver() {
        new BukkitRunnable(){

            public void run() {
                RegionalBossEntity.save();
            }
        }.runTaskTimerAsynchronously((Plugin)MetadataHandler.PLUGIN, 100L, 100L);
    }

    public static void save() {
        for (CustomBossesConfigFields customBossesConfigFields : regionalBossesFromConfigFields.keySet()) {
            if (!customBossesConfigFields.isFilesOutOfSync()) continue;
            customBossesConfigFields.setFilesOutOfSync(false);
            ArrayList<String> spawnLocations = new ArrayList<String>();
            for (RegionalBossEntity regionalBossEntity : regionalBossesFromConfigFields.get((Object)customBossesConfigFields)) {
                if (regionalBossEntity.removed) continue;
                spawnLocations.add(regionalBossEntity.rawString);
            }
            customBossesConfigFields.getFileConfiguration().set("spawnLocations", spawnLocations);
            try {
                customBossesConfigFields.getFileConfiguration().save(customBossesConfigFields.getFile());
            }
            catch (Exception ex) {
                Logger.warn("Failed to save respawn timer for " + customBossesConfigFields.getFileConfiguration().getName() + " !");
            }
        }
    }

    public static RegionalBossEntity getRegionalBoss(CustomBossesConfigFields customBossesConfigFields, Location spawnLocation) {
        for (RegionalBossEntity regionalBossEntity : regionalBossesFromConfigFields.get((Object)customBossesConfigFields)) {
            if (!Objects.equals(regionalBossEntity.getSpawnLocation(), spawnLocation)) continue;
            return regionalBossEntity;
        }
        return null;
    }

    public static List<RegionalBossEntity> getRegionalBossEntitySet() {
        return new ArrayList<RegionalBossEntity>(regionalBossesFromConfigFields.values());
    }

    @Nullable
    public static RegionalBossEntity createTemporaryRegionalBossEntity(String filename, Location spawnLocation) {
        CustomBossesConfigFields customBossesConfigFields = CustomBossesConfig.getCustomBoss(filename);
        if (customBossesConfigFields == null) {
            return null;
        }
        return new RegionalBossEntity(customBossesConfigFields, spawnLocation, false, false);
    }

    public static RegionalBossEntity createPermanentRegionalBossEntity(CustomBossesConfigFields customBossesConfigFields, Location spawnLocation) {
        RegionalBossEntity regionalBossEntity = new RegionalBossEntity(customBossesConfigFields, spawnLocation, true, true);
        regionalBossEntity.initialize();
        return regionalBossEntity;
    }

    public boolean isRespawning() {
        return this.isRespawning;
    }

    public void saveNewLocation() {
        if (this.spawnLocation == null) {
            Logger.warn("Failed to save regional boss because it failed to spawn correctly!");
        }
        this.customBossesConfigFields.setFilesOutOfSync(true);
        this.rawString = ConfigurationLocation.deserialize(this.spawnLocation);
    }

    public void initialize() {
        this.queueSpawn(false);
    }

    public void queueSpawn(final boolean silent) {
        final RegionalBossEntity regionalBossEntity = this;
        this.isRespawning = true;
        this.respawnTask = new BukkitRunnable(){

            public void run() {
                if (RegionalBossEntity.this.phaseBossEntity != null) {
                    RegionalBossEntity.this.phaseBossEntity.silentReset();
                }
                RegionalBossEntity.this.ticksBeforeRespawn = 0L;
                regionalBossEntity.spawn(silent);
                regionalBossEntity.getDamagers().clear();
            }
        }.runTaskLater((Plugin)MetadataHandler.PLUGIN, this.ticksBeforeRespawn);
    }

    public void forceRespawn() {
        if (this.respawnTask == null) {
            return;
        }
        this.respawnTask.cancel();
        this.ticksBeforeRespawn = 0L;
        this.spawn(false);
        this.getDamagers().clear();
    }

    public void respawn() {
        if (this.respawnCoolDownInMinutes < 0) {
            return;
        }
        this.isRespawning = true;
        this.unixRespawnTime = (long)this.respawnCoolDownInMinutes * 60L * 1000L + System.currentTimeMillis();
        this.ticksBeforeRespawn = (long)this.respawnCoolDownInMinutes * 60L * 20L;
        this.rawString = this.rawLocationString + ":" + this.unixRespawnTime;
        if (this.phaseBossEntity != null) {
            this.phaseBossEntity.getPhase1Config().setFilesOutOfSync(true);
        } else {
            this.customBossesConfigFields.setFilesOutOfSync(true);
        }
        this.queueSpawn(false);
    }

    public void checkLeash() {
        if (this.leashRadius < 1.0) {
            return;
        }
        RegionalBossEntity regionalBossEntity = this;
        if (this.leashTask != null) {
            this.leashTask.cancel();
        }
        this.leashTask = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)MetadataHandler.PLUGIN, () -> {
            try {
                if (!this.isValid()) {
                    this.cancelLeash();
                    return;
                }
                if (this.getLivingEntity().getLocation().distanceSquared(this.spawnLocation) > Math.pow(this.leashRadius, 2.0)) {
                    SpiritWalk.spiritWalkRegionalBossAnimation(regionalBossEntity, this.getLivingEntity().getLocation(), this.getSpawnLocation());
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                Logger.warn("Async leash task errored!");
            }
        }, 60L, 60L);
    }

    private void cancelLeash() {
        if (this.leashTask == null) {
            return;
        }
        this.leashTask.cancel();
        this.leashTask = null;
    }

    public void setLeashRadius(int leashRadius) {
        this.getCustomBossesConfigFields().setLeashRadius(leashRadius);
        this.getCustomBossesConfigFields().setFilesOutOfSync(true);
    }

    @Override
    public void spawn(boolean silent) {
        super.spawn(silent);
        this.isRespawning = false;
        if (!ItemSettingsConfig.isRegionalBossesDropVanillaLoot()) {
            this.vanillaLoot = false;
        }
        if (NMSManager.isEnabled()) {
            if (this.livingEntity != null && this.leashRadius > 0.0) {
                Navigation.addSoftLeashAI(this);
                Navigation.addHardLeashAI(this);
            }
        } else if (this.livingEntity != null) {
            this.checkLeash();
        }
    }

    @Override
    public void remove(RemovalReason removalReason) {
        this.cancelLeash();
        super.remove(removalReason);
        switch (removalReason) {
            case REMOVE_COMMAND: {
                this.permanentlyRemove();
                break;
            }
            case DEATH: 
            case BOSS_TIMEOUT: {
                if (this.customBossesConfigFields.isRemoveAfterDeath()) {
                    this.permanentlyRemove();
                    break;
                }
                if (this instanceof InstancedBossEntity) break;
                this.respawn();
                break;
            }
            case CHUNK_UNLOAD: {
                if (!ChunkLocationChecker.locationIsLoaded(this.spawnLocation)) break;
                this.respawn();
            }
        }
    }

    private void permanentlyRemove() {
        if (this.phaseBossEntity != null) {
            this.phaseBossEntity.silentReset();
        }
        EntityTracker.getEliteMobEntities().remove(this.eliteUUID);
        this.removed = true;
        this.getCustomBossesConfigFields().setFilesOutOfSync(true);
    }

    @Override
    public void chunkLoad() {
        super.chunkLoad();
    }

    public void removeSlow() {
        if (this.getCustomBossesConfigFields().isAlert() || this.getLivingEntity() == null) {
            return;
        }
        AttributeManager.setAttribute(this.getLivingEntity(), "generic_follow_range", this.getFollowDistance());
        AttributeManager.setAttribute(this.getLivingEntity(), "generic_movement_speed", this.getMovementSpeedAttribute());
    }

    @Generated
    public double getLeashRadius() {
        return this.leashRadius;
    }

    @Generated
    public List<TransitiveBlock> getOnSpawnTransitiveBlocks() {
        return this.onSpawnTransitiveBlocks;
    }

    @Generated
    public void setOnSpawnTransitiveBlocks(List<TransitiveBlock> onSpawnTransitiveBlocks) {
        this.onSpawnTransitiveBlocks = onSpawnTransitiveBlocks;
    }

    @Generated
    public List<TransitiveBlock> getOnRemoveTransitiveBlocks() {
        return this.onRemoveTransitiveBlocks;
    }

    @Generated
    public void setOnRemoveTransitiveBlocks(List<TransitiveBlock> onRemoveTransitiveBlocks) {
        this.onRemoveTransitiveBlocks = onRemoveTransitiveBlocks;
    }

    @Generated
    public boolean isRemoved() {
        return this.removed;
    }
}

