/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.config.powers;

import com.magmaguy.elitemobs.config.CustomConfigFields;
import com.magmaguy.elitemobs.powers.meta.ElitePower;
import com.magmaguy.elitemobs.powers.scripts.caching.EliteScriptBlueprint;
import com.magmaguy.magmacore.util.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;

public class PowersConfigFields
extends CustomConfigFields {
    private String effect;
    private int powerCooldown = 0;
    private int globalCooldown = 0;
    private ConfigurationSection scripts = null;
    private Map<String, Object> rawScripts = new HashMap<String, Object>();
    private List<EliteScriptBlueprint> eliteScriptBlueprints = new ArrayList<EliteScriptBlueprint>();
    private Class<? extends ElitePower> elitePowerClass = null;
    private PowerType powerType;

    public PowersConfigFields(String fileName, boolean isEnabled, String material, Class<? extends ElitePower> elitePowerClass, PowerType powerType) {
        super(fileName, isEnabled);
        this.effect = material;
        this.elitePowerClass = elitePowerClass;
        this.powerType = powerType;
    }

    public PowersConfigFields(String fileName, boolean isEnabled, String material, Map<String, Object> rawScripts, PowerType powerType) {
        super(fileName, isEnabled);
        this.effect = material;
        this.rawScripts = rawScripts;
        this.powerType = powerType;
    }

    public PowersConfigFields(String fileName, boolean isEnabled, String material, int powerCooldown, int globalCooldown, Class<? extends ElitePower> elitePowerClass, PowerType powerType) {
        super(fileName, isEnabled);
        this.effect = material;
        this.powerCooldown = powerCooldown;
        this.globalCooldown = globalCooldown;
        this.elitePowerClass = elitePowerClass;
        this.powerType = powerType;
    }

    public PowersConfigFields(String fileName, boolean isEnabled) {
        super(fileName, isEnabled);
    }

    protected static Map<String, Object> addScriptEntry(String scriptName, List<String> events, List<String> conditions, List<Map<String, Object>> actions, Map<String, Object> cooldowns) {
        HashMap<String, Object> defaults = new HashMap<String, Object>();
        defaults.put("eliteScript." + scriptName + ".Events", events);
        defaults.put("eliteScript." + scriptName + ".Conditions", conditions);
        defaults.put("eliteScript." + scriptName + ".Actions", actions);
        defaults.put("eliteScript." + scriptName + ".Cooldowns", cooldowns);
        return defaults;
    }

    @Override
    public void processConfigFields() {
        this.isEnabled = this.processBoolean("isEnabled", this.isEnabled, true, true);
        this.effect = this.processString("effect", this.effect, null, false);
        this.powerCooldown = this.processInt("powerCooldown", this.powerCooldown, 0, false);
        this.globalCooldown = this.processInt("globalCooldown", this.globalCooldown, 0, false);
        this.rawScripts = this.processMap("eliteScript", this.rawScripts);
        this.scripts = this.processConfigurationSection("eliteScript", this.rawScripts);
        this.powerType = this.processEnum("powerType", this.powerType, null, PowerType.class, false);
        this.processAdditionalFields();
    }

    public void initializeScripts() {
        try {
            if (this.scripts != null) {
                this.eliteScriptBlueprints = EliteScriptBlueprint.parseBossScripts(this.scripts, this);
            }
        }
        catch (Exception exception) {
            Logger.warn("You have a script with invalid data! Script in " + this.filename + " is not valid.");
            exception.printStackTrace();
        }
    }

    public void processAdditionalFields() {
    }

    @Generated
    public String getEffect() {
        return this.effect;
    }

    @Generated
    public void setEffect(String effect) {
        this.effect = effect;
    }

    @Generated
    public int getPowerCooldown() {
        return this.powerCooldown;
    }

    @Generated
    public void setPowerCooldown(int powerCooldown) {
        this.powerCooldown = powerCooldown;
    }

    @Generated
    public int getGlobalCooldown() {
        return this.globalCooldown;
    }

    @Generated
    public void setGlobalCooldown(int globalCooldown) {
        this.globalCooldown = globalCooldown;
    }

    @Generated
    public ConfigurationSection getScripts() {
        return this.scripts;
    }

    @Generated
    public void setScripts(ConfigurationSection scripts) {
        this.scripts = scripts;
    }

    @Generated
    public Map<String, Object> getRawScripts() {
        return this.rawScripts;
    }

    @Generated
    public void setRawScripts(Map<String, Object> rawScripts) {
        this.rawScripts = rawScripts;
    }

    @Generated
    public List<EliteScriptBlueprint> getEliteScriptBlueprints() {
        return this.eliteScriptBlueprints;
    }

    @Generated
    public void setEliteScriptBlueprints(List<EliteScriptBlueprint> eliteScriptBlueprints) {
        this.eliteScriptBlueprints = eliteScriptBlueprints;
    }

    @Generated
    public Class<? extends ElitePower> getElitePowerClass() {
        return this.elitePowerClass;
    }

    @Generated
    public PowerType getPowerType() {
        return this.powerType;
    }

    public static enum PowerType {
        OFFENSIVE,
        DEFENSIVE,
        MISCELLANEOUS,
        MAJOR_ZOMBIE,
        MAJOR_SKELETON,
        MAJOR_BLAZE,
        MAJOR_ENDERMAN,
        MAJOR_GHAST,
        UNIQUE;

    }
}

