/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.config.customquests;

import com.magmaguy.elitemobs.config.CustomConfigFields;
import com.magmaguy.magmacore.util.Logger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;

public class CustomQuestsConfigFields
extends CustomConfigFields {
    protected Map<String, Map<String, Object>> customObjectives = new HashMap<String, Map<String, Object>>();
    List<String> temporaryPermissions = new ArrayList<String>();
    List<String> questAcceptDialog = new ArrayList<String>();
    private int questLevel = 0;
    private List<String> customRewardsList = new ArrayList<String>();
    private String questAcceptPermission = "";
    private List<String> questAcceptPermissions = null;
    private String questLockoutPermission = "";
    private int questLockoutMinutes = -1;
    private String questName = "";
    private List<String> questLore = new ArrayList<String>();
    private List<String> questCompleteDialog = new ArrayList<String>();
    private List<String> questCompleteCommands = new ArrayList<String>();
    private String turnInNPC = "";
    private boolean trackable = true;
    private String questAcceptSound;
    private String questCompleteSound;

    public CustomQuestsConfigFields(String filename, boolean isEnabled, Map<String, Map<String, Object>> customQuestObjective, List<String> customQuestReward, int questLevel, String questName, List<String> questLore) {
        super(filename, isEnabled);
        this.customObjectives = customQuestObjective;
        this.customRewardsList = customQuestReward;
        this.questLevel = questLevel;
        this.questName = questName;
        this.questLore = questLore;
    }

    public CustomQuestsConfigFields(String filename, boolean isEnabled) {
        super(filename, isEnabled);
    }

    public void setQuestLockoutPermission() {
        this.questLockoutPermission = "elitequest." + this.getFilename();
    }

    @Override
    public void processConfigFields() {
        this.isEnabled = this.processBoolean("isEnabled", this.isEnabled, true, true);
        if (this.fileConfiguration.contains("customObjectives") && this.fileConfiguration.get("customObjectives") instanceof List) {
            this.updateOldStringFormat(this.fileConfiguration.getStringList("customObjectives"));
        }
        this.customObjectives = this.processQuestObjectives();
        this.customRewardsList = this.processStringList("customRewards", this.customRewardsList, new ArrayList<String>(), true);
        this.questAcceptPermission = this.processString("questAcceptPermission", this.questAcceptPermission, null, false);
        this.questAcceptPermissions = this.processStringList("questAcceptPermissions", this.questAcceptPermissions, null, false);
        this.questLockoutPermission = this.processString("questLockoutPermission", this.questLockoutPermission, null, false);
        this.questLockoutMinutes = this.processInt("questLockoutMinutes", this.questLockoutMinutes, -1, false);
        this.questName = this.translatable(this.filename, "name", this.processString("name", this.questName, this.filename, true));
        this.questLore = this.translatable(this.filename, "questLore", this.processStringList("questLore", this.questLore, new ArrayList<String>(), false));
        this.temporaryPermissions = this.processStringList("temporaryPermissions", this.temporaryPermissions, new ArrayList<String>(), false);
        this.questAcceptDialog = this.translatable(this.filename, "questAcceptDialog", this.processStringList("questAcceptDialog", this.questAcceptDialog, new ArrayList<String>(), false));
        this.questCompleteDialog = this.translatable(this.filename, "questCompleteMessage", this.processStringList("questCompleteMessage", this.questCompleteDialog, new ArrayList<String>(), false));
        this.questCompleteCommands = this.processStringList("questCompleteCommands", this.questCompleteCommands, new ArrayList<String>(), false);
        this.turnInNPC = this.processString("turnInNPC", this.turnInNPC, "", false);
        this.trackable = this.processBoolean("trackable", this.trackable, true, false);
        this.questLevel = this.processInt("questLevel", this.questLevel, 0, false);
        this.questAcceptSound = this.processString("questAcceptSound", this.questAcceptSound, "", false);
        this.questCompleteSound = this.processString("questCompleteSound", this.questCompleteSound, "", false);
    }

    private void updateOldStringFormat(List<String> oldList) {
        HashMap<String, Map<String, Object>> parsedObjectives = new HashMap<String, Map<String, Object>>();
        int counter = 0;
        for (String questObjectiveEntry : oldList) {
            String[] individualEntries;
            ++counter;
            HashMap<String, String> parsedEntry = new HashMap<String, String>();
            for (String keyAndValue : individualEntries = questObjectiveEntry.split(":")) {
                String[] keyAndValueArray = keyAndValue.split("=");
                String key = keyAndValueArray[0];
                Object value = null;
                if (keyAndValueArray.length > 1) {
                    value = keyAndValueArray[1];
                }
                if (value == null) {
                    switch (key.toUpperCase(Locale.ROOT)) {
                        case "KILL_CUSTOM": 
                        case "FETCH_ITEM": 
                        case "DIALOG": 
                        case "ARENA": {
                            value = key;
                            key = "objectiveType";
                            break;
                        }
                        default: {
                            Logger.warn("Failed to correctly parse key " + key + " in " + this.filename + " while updating the old quest configuration format!");
                        }
                    }
                }
                if (key.equalsIgnoreCase("dialog")) {
                    value = Arrays.stream(((String)value).split("\\n")).toList();
                }
                parsedEntry.put(key, (String)value);
                Logger.info("Converted quest old entry to " + key + ": " + value);
            }
            parsedObjectives.put("Objective" + counter, parsedEntry);
        }
        this.fileConfiguration.set("customObjectives", parsedObjectives);
        this.customObjectives = parsedObjectives;
        try {
            this.fileConfiguration.save(this.file);
        }
        catch (Exception ex) {
            Logger.warn("Failed to save new custom objective format!");
        }
    }

    private Map<String, Map<String, Object>> processQuestObjectives() {
        if (this.fileConfiguration.getConfigurationSection("customObjectives") == null && !this.customObjectives.isEmpty()) {
            this.fileConfiguration.set("customObjectives", this.customObjectives);
            HashMap<String, Map<String, Object>> rawMap = new HashMap<String, Map<String, Object>>(this.customObjectives);
            HashMap<String, Map<String, Object>> parsedObjectives = new HashMap<String, Map<String, Object>>();
            for (Map.Entry<String, Map<String, Object>> maps : this.customObjectives.entrySet()) {
                HashMap<String, Object> parsedMap = new HashMap<String, Object>();
                for (Map.Entry<String, Object> entry : maps.getValue().entrySet()) {
                    if (entry.getKey().equals("dialog")) {
                        parsedMap.put(entry.getKey(), this.translatable(this.filename, "customObjectives." + maps.getKey() + "." + entry.getKey(), (List)entry.getValue()));
                        continue;
                    }
                    parsedMap.put(entry.getKey(), entry.getValue());
                }
                parsedObjectives.put(maps.getKey(), parsedMap);
            }
            return parsedObjectives;
        }
        Map rawMap = this.fileConfiguration.getConfigurationSection("customObjectives").getValues(false);
        if (rawMap == null) {
            Logger.warn("Failed to parse custom objectives for " + this.filename);
            return new HashMap<String, Map<String, Object>>();
        }
        HashMap<String, Map<String, Object>> parsedObjectives = new HashMap<String, Map<String, Object>>();
        for (Map.Entry maps : rawMap.entrySet()) {
            HashMap<String, List<String>> parsedMap = new HashMap<String, List<String>>();
            for (Map.Entry entry : ((ConfigurationSection)maps.getValue()).getValues(false).entrySet()) {
                if (entry.getKey().equals("dialog")) {
                    parsedMap.put((String)entry.getKey(), this.translatable(this.filename, "customObjectives." + (String)maps.getKey() + "." + entry.getKey(), (List)entry.getValue()));
                    continue;
                }
                parsedMap.put((String)entry.getKey(), (List<String>)entry.getValue());
            }
            parsedObjectives.put((String)maps.getKey(), parsedMap);
        }
        return parsedObjectives;
    }

    @Generated
    public Map<String, Map<String, Object>> getCustomObjectives() {
        return this.customObjectives;
    }

    @Generated
    public void setCustomObjectives(Map<String, Map<String, Object>> customObjectives) {
        this.customObjectives = customObjectives;
    }

    @Generated
    public List<String> getTemporaryPermissions() {
        return this.temporaryPermissions;
    }

    @Generated
    public void setTemporaryPermissions(List<String> temporaryPermissions) {
        this.temporaryPermissions = temporaryPermissions;
    }

    @Generated
    public List<String> getQuestAcceptDialog() {
        return this.questAcceptDialog;
    }

    @Generated
    public void setQuestAcceptDialog(List<String> questAcceptDialog) {
        this.questAcceptDialog = questAcceptDialog;
    }

    @Generated
    public int getQuestLevel() {
        return this.questLevel;
    }

    @Generated
    public void setQuestLevel(int questLevel) {
        this.questLevel = questLevel;
    }

    @Generated
    public List<String> getCustomRewardsList() {
        return this.customRewardsList;
    }

    @Generated
    public void setCustomRewardsList(List<String> customRewardsList) {
        this.customRewardsList = customRewardsList;
    }

    @Generated
    public String getQuestAcceptPermission() {
        return this.questAcceptPermission;
    }

    @Generated
    public void setQuestAcceptPermission(String questAcceptPermission) {
        this.questAcceptPermission = questAcceptPermission;
    }

    @Generated
    public List<String> getQuestAcceptPermissions() {
        return this.questAcceptPermissions;
    }

    @Generated
    public void setQuestAcceptPermissions(List<String> questAcceptPermissions) {
        this.questAcceptPermissions = questAcceptPermissions;
    }

    @Generated
    public String getQuestLockoutPermission() {
        return this.questLockoutPermission;
    }

    @Generated
    public int getQuestLockoutMinutes() {
        return this.questLockoutMinutes;
    }

    @Generated
    public void setQuestLockoutMinutes(int questLockoutMinutes) {
        this.questLockoutMinutes = questLockoutMinutes;
    }

    @Generated
    public String getQuestName() {
        return this.questName;
    }

    @Generated
    public void setQuestName(String questName) {
        this.questName = questName;
    }

    @Generated
    public List<String> getQuestLore() {
        return this.questLore;
    }

    @Generated
    public void setQuestLore(List<String> questLore) {
        this.questLore = questLore;
    }

    @Generated
    public List<String> getQuestCompleteDialog() {
        return this.questCompleteDialog;
    }

    @Generated
    public void setQuestCompleteDialog(List<String> questCompleteDialog) {
        this.questCompleteDialog = questCompleteDialog;
    }

    @Generated
    public List<String> getQuestCompleteCommands() {
        return this.questCompleteCommands;
    }

    @Generated
    public void setQuestCompleteCommands(List<String> questCompleteCommands) {
        this.questCompleteCommands = questCompleteCommands;
    }

    @Generated
    public String getTurnInNPC() {
        return this.turnInNPC;
    }

    @Generated
    public void setTurnInNPC(String turnInNPC) {
        this.turnInNPC = turnInNPC;
    }

    @Generated
    public boolean isTrackable() {
        return this.trackable;
    }

    @Generated
    public void setTrackable(boolean trackable) {
        this.trackable = trackable;
    }

    @Generated
    public String getQuestAcceptSound() {
        return this.questAcceptSound;
    }

    @Generated
    public void setQuestAcceptSound(String questAcceptSound) {
        this.questAcceptSound = questAcceptSound;
    }

    @Generated
    public String getQuestCompleteSound() {
        return this.questCompleteSound;
    }

    @Generated
    public void setQuestCompleteSound(String questCompleteSound) {
        this.questCompleteSound = questCompleteSound;
    }
}

