/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.commands.admin;

import com.magmaguy.elitemobs.EliteMobs;
import com.magmaguy.elitemobs.adventurersguild.GuildRank;
import com.magmaguy.elitemobs.entitytracker.EntityTracker;
import com.magmaguy.elitemobs.mobconstructor.custombosses.RegionalBossEntity;
import com.magmaguy.elitemobs.playerdata.ElitePlayerInventory;
import com.magmaguy.magmacore.util.ChatColorConverter;
import com.magmaguy.magmacore.util.Round;
import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class StatsCommand {
    public static void statsHandler(CommandSender commandSender) {
        int aggressiveCount = 0;
        int passiveCount = 0;
        HashMap<EntityType, Integer> entitiesCounted = new HashMap<EntityType, Integer>();
        for (World world : EliteMobs.validWorldList) {
            for (LivingEntity livingEntity : world.getLivingEntities()) {
                if (!EntityTracker.isEliteMob((Entity)livingEntity)) continue;
                ++aggressiveCount;
                if (!entitiesCounted.containsKey(livingEntity.getType())) {
                    entitiesCounted.put(livingEntity.getType(), 1);
                    continue;
                }
                entitiesCounted.put(livingEntity.getType(), (Integer)entitiesCounted.get(livingEntity.getType()) + 1);
            }
        }
        StringBuilder breakdownString = new StringBuilder("&2Breakdown: &a");
        for (EntityType entityType : entitiesCounted.keySet()) {
            breakdownString.append(entitiesCounted.get(entityType)).append(" ").append(entityType).append("&2, &a");
        }
        double d = 0.0;
        String highestThreatUser = "";
        double threatAverage = 0.0;
        int highestGuildRank = 0;
        String highestGuildUser = "";
        double guildRankAverage = 0.0;
        Player highestGuildRankPlayer = null;
        for (Player player : Bukkit.getOnlinePlayers()) {
            double currentTier = ElitePlayerInventory.playerInventories.get(player.getUniqueId()).getFullPlayerTier(true);
            threatAverage += currentTier;
            int currentGuildRank = GuildRank.getActiveGuildRank(player);
            guildRankAverage += (double)currentGuildRank;
            if (currentTier > d) {
                d = currentTier;
                highestThreatUser = player.getDisplayName();
            }
            if (currentGuildRank <= highestGuildRank) continue;
            highestGuildRankPlayer = player;
            highestGuildRank = currentGuildRank;
            highestGuildUser = player.getDisplayName();
        }
        threatAverage /= (double)Bukkit.getOnlinePlayers().size();
        guildRankAverage /= (double)Bukkit.getOnlinePlayers().size();
        commandSender.sendMessage(ChatColorConverter.convert("\u00a75\u00a7m-----------------------------------------------------"));
        commandSender.sendMessage(ChatColorConverter.convert("&7[EM] \u00a7a\u00a7lEliteMobs v. " + Bukkit.getPluginManager().getPlugin("EliteMobs").getDescription().getVersion() + " stats:"));
        commandSender.sendMessage(ChatColorConverter.convert("&7[EM] &2There are currently \u00a7l\u00a76" + (aggressiveCount + passiveCount) + " \u00a7f\u00a72EliteMobs mobs entities in the world, of which &a" + aggressiveCount + " &2are Elite Mobs and &a" + passiveCount + " &2are Super Mobs."));
        commandSender.sendMessage(ChatColorConverter.convert(breakdownString.toString()));
        if (highestGuildRankPlayer == null) {
            return;
        }
        commandSender.sendMessage(ChatColorConverter.convert("&7[EM] &2Highest online threat tier: &a" + highestThreatUser + " &2at total threat tier &a" + d));
        commandSender.sendMessage(ChatColorConverter.convert("&7[EM] &2Average threat tier: &a" + Round.twoDecimalPlaces(threatAverage)));
        commandSender.sendMessage(ChatColorConverter.convert("&7[EM] &2Highest adventurer's guild tier: &a" + highestGuildUser + " &2at guild rank &a" + GuildRank.getRankName(GuildRank.getGuildPrestigeRank(highestGuildRankPlayer), highestGuildRank) + " &2(&a" + highestGuildRank + "&2)"));
        commandSender.sendMessage(ChatColorConverter.convert("&7[EM] &2Average guild rank: &a" + Round.twoDecimalPlaces(guildRankAverage)));
        commandSender.sendMessage(ChatColorConverter.convert("\u00a75\u00a7m-----------------------------------------------------"));
        commandSender.sendMessage("Tracked boss count: " + EntityTracker.getEliteMobEntities().size());
        commandSender.sendMessage("Tracked NPC count: " + EntityTracker.getNpcEntities().size());
        int loadedCounter = 0;
        for (RegionalBossEntity regionalBossEntity : RegionalBossEntity.getRegionalBossEntities()) {
            if (!regionalBossEntity.isValid()) continue;
            ++loadedCounter;
        }
        commandSender.sendMessage(ChatColorConverter.convert("&7[EM] &2There are &c" + RegionalBossEntity.getRegionalBossEntities().size() + " &2Regional Bosses installed, of which &c" + loadedCounter + " &2are currently loaded."));
    }
}

