/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.combatsystem.displays;

import com.magmaguy.elitemobs.api.EliteMobDamagedByPlayerEvent;
import com.magmaguy.elitemobs.config.MobCombatSettingsConfig;
import com.magmaguy.elitemobs.utils.DialogArmorStand;
import org.bukkit.ChatColor;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;

public class HealthDisplay
implements Listener {
    private static ChatColor setHealthColor(int currentHealth, int maxHealth) {
        if (maxHealth <= 0) {
            return ChatColor.WHITE;
        }
        double healthPercentage = (double)(currentHealth * 100) / (double)maxHealth;
        if (healthPercentage > 75.0) {
            return ChatColor.DARK_GREEN;
        }
        if (healthPercentage > 50.0) {
            return ChatColor.GREEN;
        }
        if (healthPercentage > 25.0) {
            return ChatColor.RED;
        }
        if (healthPercentage > 0.0) {
            return ChatColor.DARK_RED;
        }
        return ChatColor.DARK_RED;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onHit(EliteMobDamagedByPlayerEvent event) {
        if (!MobCombatSettingsConfig.isDisplayHealthOnHit()) {
            return;
        }
        int maxHealth = (int)event.getEliteMobEntity().getMaxHealth();
        int currentHealth = (int)(event.getEliteMobEntity().getHealth() - event.getDamage());
        DialogArmorStand.createDialogArmorStand(event.getEliteMobEntity().getLivingEntity(), HealthDisplay.setHealthColor(currentHealth, maxHealth) + currentHealth + "/" + maxHealth);
    }
}

