/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.wormhole;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.config.WormholesConfig;
import com.magmaguy.elitemobs.economy.EconomyHandler;
import com.magmaguy.elitemobs.quests.playercooldowns.PlayerQuestCooldowns;
import com.magmaguy.elitemobs.wormhole.WormholeEntry;
import com.magmaguy.magmacore.util.ChatColorConverter;
import com.magmaguy.magmacore.util.ChunkLocationChecker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class WormholeManager {
    private static final long COOLDOWN_DURATION_SECONDS = 5L;
    private static final double PARTICLE_RENDER_DISTANCE = 30.0;
    private static final double SAFE_DISTANCE = 2.0;
    private static final double TELEPORT_DISTANCE_MULTIPLIER = 1.5;
    private static WormholeManager instance;
    private final Map<UUID, PlayerWormholeData> playerTeleportData = new HashMap<UUID, PlayerWormholeData>();
    private BukkitTask wormholeTask;
    private static final int TELEPORT_CHECK_INTERVAL = 5;
    private int tickCounter = 0;

    private WormholeManager() {
        this.startWormholeTask();
    }

    public static WormholeManager getInstance(boolean shuttingDown) {
        if (shuttingDown) {
            return instance;
        }
        if (instance == null) {
            instance = new WormholeManager();
        }
        if (WormholeManager.instance.wormholeTask == null || WormholeManager.instance.wormholeTask.isCancelled()) {
            instance.startWormholeTask();
        }
        return instance;
    }

    private List<Player> getNearbyPlayers(WormholeEntry wormholeEntry) {
        ArrayList<Player> nearbyPlayers = new ArrayList<Player>();
        Location wormholeLocation = wormholeEntry.getLocation();
        if (wormholeLocation == null || wormholeLocation.getWorld() == null) {
            return nearbyPlayers;
        }
        double maxDistanceSquared = 900.0;
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!player.getWorld().equals((Object)wormholeLocation.getWorld()) || !(player.getLocation().distanceSquared(wormholeLocation) <= maxDistanceSquared)) continue;
            nearbyPlayers.add(player);
        }
        return nearbyPlayers;
    }

    private void checkForTeleports(WormholeEntry wormholeEntry, List<Player> nearbyPlayers) {
        double teleportDistanceSquared = Math.pow(1.5 * wormholeEntry.getWormhole().getWormholeConfigFields().getSizeMultiplier(), 2.0);
        for (Player player : nearbyPlayers) {
            if (player.getLocation().distanceSquared(wormholeEntry.getLocation()) > teleportDistanceSquared || !this.canPlayerTeleport(wormholeEntry, player)) continue;
            this.teleportPlayer(wormholeEntry, player);
        }
    }

    private boolean canPlayerTeleport(WormholeEntry wormholeEntry, Player player) {
        PlayerWormholeData playerWormholeData;
        if (!(PlayerQuestCooldowns.getBypassedPlayers().contains(player) || wormholeEntry.getWormhole().getWormholeConfigFields().getPermission() == null || wormholeEntry.getWormhole().getWormholeConfigFields().getPermission().isEmpty() || player.hasPermission(wormholeEntry.getWormhole().getWormholeConfigFields().getPermission()))) {
            return false;
        }
        if (wormholeEntry.getWormhole().getWormholeConfigFields().getCoinCost() > 0.0) {
            double coinCost = wormholeEntry.getWormhole().getWormholeConfigFields().getCoinCost();
            if (EconomyHandler.checkCurrency(player.getUniqueId()) < coinCost) {
                player.sendMessage(ChatColorConverter.convert(WormholesConfig.getInsufficientCurrencyForWormholeMessage()).replace("$amount", "" + coinCost));
                return false;
            }
            EconomyHandler.subtractCurrency(player.getUniqueId(), coinCost);
        }
        return (playerWormholeData = this.playerTeleportData.get(player.getUniqueId())) == null || playerWormholeData.canTeleport();
    }

    private void teleportPlayer(WormholeEntry sourceEntry, Player player) {
        WormholeEntry destinationEntry = sourceEntry == sourceEntry.getWormhole().getWormholeEntry1() ? sourceEntry.getWormhole().getWormholeEntry2() : sourceEntry.getWormhole().getWormholeEntry1();
        Location destination = destinationEntry.getLocation();
        if (destination == null || destination.getWorld() == null) {
            if (sourceEntry.getPortalMissingMessage() == null) {
                player.sendMessage(ChatColorConverter.convert(WormholesConfig.getDefaultPortalMissingMessage()));
            } else {
                player.sendMessage(sourceEntry.getPortalMissingMessage());
                if (player.isOp() || player.hasPermission("elitemobs.*")) {
                    player.sendMessage(sourceEntry.getOpMessage());
                }
            }
            return;
        }
        this.addPlayerToCooldown(player, destinationEntry);
        Location finalDestination = destination.clone();
        if (sourceEntry.getWormhole().getWormholeConfigFields().isBlindPlayer()) {
            player.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, 40, 0));
        }
        player.teleport(finalDestination);
        player.playSound(player.getLocation(), Sound.BLOCK_RESPAWN_ANCHOR_CHARGE, 1.0f, 1.0f);
        player.setFlying(false);
    }

    public void addPlayerToCooldown(Player player, @NonNull WormholeEntry destinationEntry) {
        if (destinationEntry == null) {
            throw new NullPointerException("destinationEntry is marked non-null but is null");
        }
        this.playerTeleportData.put(player.getUniqueId(), new PlayerWormholeData(player, destinationEntry, System.currentTimeMillis()));
    }

    public void addPlayerToCooldown(Player player, Location destination) {
        WormholeEntry destinationEntry = null;
        for (WormholeEntry wormholeEntry : WormholeEntry.getWormholeEntries()) {
            if (wormholeEntry.getLocation() == null || wormholeEntry.getLocation().getWorld() == null || !wormholeEntry.getLocation().getWorld().equals((Object)destination.getWorld()) || !(destination.distanceSquared(wormholeEntry.getLocation()) <= Math.pow(1.5 * wormholeEntry.getWormhole().getWormholeConfigFields().getSizeMultiplier(), 2.0))) continue;
            destinationEntry = wormholeEntry;
            break;
        }
        if (destinationEntry == null) {
            return;
        }
        this.addPlayerToCooldown(player, destinationEntry);
    }

    public void shutdown() {
        if (this.wormholeTask != null) {
            this.wormholeTask.cancel();
            this.wormholeTask = null;
        }
        for (WormholeEntry wormholeEntry : WormholeEntry.getWormholeEntries()) {
            if (wormholeEntry == null) continue;
            wormholeEntry.stop();
        }
        this.playerTeleportData.clear();
        instance = null;
    }

    private void startWormholeTask() {
        this.wormholeTask = new BukkitRunnable(){

            public void run() {
                WormholeManager.this.processWormholes();
            }
        }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 0L, 1L);
    }

    private void processWormholes() {
        ++this.tickCounter;
        Collection<PlayerWormholeData> values = this.playerTeleportData.values();
        for (PlayerWormholeData value : values) {
            value.tick();
        }
        for (WormholeEntry wormholeEntry : WormholeEntry.getWormholeEntries()) {
            List<Player> nearbyPlayers;
            if (wormholeEntry.getLocation() == null || wormholeEntry.getLocation().getWorld() == null || !ChunkLocationChecker.chunkAtLocationIsLoaded(wormholeEntry.getLocation()) || (nearbyPlayers = this.getNearbyPlayers(wormholeEntry)).isEmpty()) continue;
            wormholeEntry.tick(nearbyPlayers);
            if (this.tickCounter % 5 != 0) continue;
            this.checkForTeleports(wormholeEntry, nearbyPlayers);
        }
    }

    @Generated
    public Map<UUID, PlayerWormholeData> getPlayerTeleportData() {
        return this.playerTeleportData;
    }

    private class PlayerWormholeData {
        private final Player player;
        private final Location destination;
        private final long timeStamp;
        private final WormholeEntry wormholeEntry;
        private boolean hasLeftTeleportRadius = false;

        public PlayerWormholeData(Player player, WormholeEntry destinationWormhole, long timeStamp) {
            this.player = player;
            this.destination = destinationWormhole.getLocation();
            this.timeStamp = timeStamp;
            this.wormholeEntry = destinationWormhole;
        }

        public boolean canTeleport() {
            return this.timeStamp + 5000L < System.currentTimeMillis() && this.isHasLeftTeleportRadius();
        }

        public void tick() {
            if (this.isHasLeftTeleportRadius() && this.enoughTimeHasPassed()) {
                WormholeManager.this.playerTeleportData.remove(this.player.getUniqueId());
            }
        }

        private boolean enoughTimeHasPassed() {
            return this.timeStamp + 5000L < System.currentTimeMillis();
        }

        private boolean isHasLeftTeleportRadius() {
            if (this.hasLeftTeleportRadius) {
                return true;
            }
            if (!this.player.getWorld().equals((Object)this.destination.getWorld())) {
                return false;
            }
            if (this.destination.distanceSquared(this.player.getLocation()) > Math.pow(1.5 * this.wormholeEntry.getWormhole().getWormholeConfigFields().getSizeMultiplier() + 2.0, 2.0)) {
                this.hasLeftTeleportRadius = true;
                return true;
            }
            return false;
        }
    }
}

