/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.wormhole;

import com.magmaguy.elitemobs.config.WormholesConfig;
import com.magmaguy.elitemobs.dungeons.EMPackage;
import com.magmaguy.elitemobs.mobconstructor.PersistentObject;
import com.magmaguy.elitemobs.mobconstructor.PersistentObjectHandler;
import com.magmaguy.elitemobs.utils.ConfigurationLocation;
import com.magmaguy.elitemobs.wormhole.Wormhole;
import com.magmaguy.magmacore.DrawLine;
import com.magmaguy.magmacore.util.ChatColorConverter;
import com.magmaguy.magmacore.util.ChunkLocationChecker;
import com.magmaguy.magmacore.util.Logger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import lombok.Generated;
import org.bukkit.Color;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.entity.BlockDisplay;
import org.bukkit.entity.Display;
import org.bukkit.entity.Player;
import org.bukkit.entity.TextDisplay;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;

public class WormholeEntry
implements PersistentObject {
    private static final Set<WormholeEntry> wormholeEntries = new HashSet<WormholeEntry>();
    private static final float LINE_WIDTH = 0.04f;
    private static final Material[] CONCRETE_COLORS_BY_RGB = new Material[]{Material.WHITE_CONCRETE, Material.ORANGE_CONCRETE, Material.MAGENTA_CONCRETE, Material.LIGHT_BLUE_CONCRETE, Material.YELLOW_CONCRETE, Material.LIME_CONCRETE, Material.PINK_CONCRETE, Material.GRAY_CONCRETE, Material.LIGHT_GRAY_CONCRETE, Material.CYAN_CONCRETE, Material.PURPLE_CONCRETE, Material.BLUE_CONCRETE, Material.BROWN_CONCRETE, Material.GREEN_CONCRETE, Material.RED_CONCRETE, Material.BLACK_CONCRETE};
    private static final int[] CONCRETE_RGB_VALUES = new int[]{0xFFFFFF, 16738816, 0xFF00FF, 0x6699FF, 0xFFFF00, 0x80FF00, 16738740, 0x808080, 0xC0C0C0, 65535, 0x800080, 255, 9127187, 65280, 0xFF0000, 0};
    private final Wormhole wormhole;
    private final int wormholeNumber;
    private final List<DrawLine.LineData> lineDataList = new ArrayList<DrawLine.LineData>();
    private final boolean isInitializing = false;
    private Location location;
    private String locationString;
    private String armorStandText;
    private TextDisplay textDisplay = null;
    private String worldName;
    private String portalMissingMessage = null;
    private String opMessage = null;
    private PersistentObjectHandler persistentObjectHandler = null;
    private long[] cachedEdges = null;
    private Material concreteColor = null;
    private boolean linesInitialized = false;
    private int rotationIndex = 0;
    private static final long LINES_RECREATION_COOLDOWN_MS = 500L;
    private volatile boolean isProcessingChunkEvent = false;
    private long lastLinesClearTime = 0L;
    private int particleTickCounter = 0;

    public WormholeEntry(Wormhole wormhole, String locationString, int wormholeNumber) {
        this.wormhole = wormhole;
        this.wormholeNumber = wormholeNumber;
        this.locationString = locationString;
        if (locationString == null) {
            Logger.warn("Wormhole " + wormhole.getWormholeConfigFields().getFilename() + " is missing a wormhole location! Fix this!");
            return;
        }
        this.setLocationFromConfiguration();
        this.armorStandText = wormholeNumber == 1 ? wormhole.getWormholeConfigFields().getLocation1Text() : wormhole.getWormholeConfigFields().getLocation2Text();
        this.persistentObjectHandler = new PersistentObjectHandler(this);
        wormholeEntries.add(this);
    }

    private static long encodeEdge(int p1, int p2) {
        if (p1 < p2) {
            return (long)p1 << 32 | (long)p2;
        }
        return (long)p2 << 32 | (long)p1;
    }

    private Location getDungeonLocation() {
        Location teleportLocation;
        EMPackage emPackage = EMPackage.getEmPackages().get(this.locationString);
        if (emPackage == null) {
            Logger.warn("Dungeon " + this.locationString + " is not a valid dungeon packager name! Wormhole " + this.wormhole.getWormholeConfigFields().getFilename() + " will not lead anywhere.");
            this.setPortalMissingMessage(WormholesConfig.getDefaultPortalMissingMessage());
            return null;
        }
        if (!emPackage.isDownloaded() || !emPackage.isInstalled()) {
            this.setPortalMissingMessage(WormholesConfig.getDungeonNotInstalledMessage().replace("$dungeonID", emPackage.getContentPackagesConfigFields().getName()));
            this.opMessage = ChatColorConverter.convert("&8[EliteMobs - OP-only message] &fDownload links are available on &9https://magmaguy.itch.io/ &f(free and premium) and &9https://www.patreon.com/magmaguy &f(premium). You can check the difference between the two and get support here: https://discord.gg/9f5QSka");
        }
        if ((teleportLocation = emPackage.getContentPackagesConfigFields().getTeleportLocation()) == null) {
            return null;
        }
        this.worldName = emPackage.getContentPackagesConfigFields().getWorldName();
        return teleportLocation.clone();
    }

    private void setLocationFromConfiguration() {
        if (this.locationString.contains(",")) {
            this.worldName = ConfigurationLocation.worldName(this.locationString);
            this.location = ConfigurationLocation.serialize(this.locationString);
        } else {
            this.location = this.getDungeonLocation();
        }
    }

    public void onDungeonInstall() {
        this.location = this.getDungeonLocation();
        if (this.persistentObjectHandler != null) {
            this.persistentObjectHandler.remove();
        }
        this.persistentObjectHandler = new PersistentObjectHandler(this);
        this.chunkLoad();
    }

    public void onDungeonUninstall() {
        this.clearLines();
        this.location = null;
    }

    @Override
    public void chunkLoad() {
    }

    @Override
    public void chunkUnload() {
        this.isProcessingChunkEvent = true;
        try {
            this.clearLines();
            if (this.textDisplay != null) {
                this.textDisplay.remove();
                this.textDisplay = null;
            }
        }
        finally {
            this.isProcessingChunkEvent = false;
        }
    }

    @Override
    public void worldLoad(World world) {
        this.setLocationFromConfiguration();
        if (this.location != null && this.location.getWorld() != null && ChunkLocationChecker.chunkAtLocationIsLoaded(this.location)) {
            this.chunkLoad();
        }
    }

    @Override
    public void worldUnload() {
        if (this.location != null) {
            this.location.setWorld(null);
        }
        this.remove();
    }

    @Override
    public Location getPersistentLocation() {
        return this.location;
    }

    @Override
    public String getWorldName() {
        return this.worldName;
    }

    public void stop() {
        this.remove();
    }

    private void remove() {
        if (this.textDisplay != null) {
            this.textDisplay.remove();
        }
        this.clearLines();
    }

    public void updateLocation(Player player) {
        this.locationString = ConfigurationLocation.deserialize(player.getLocation());
        this.location = player.getLocation().add(new Vector(0.0, 1.0 * this.wormhole.getWormholeConfigFields().getSizeMultiplier(), 0.0));
        this.wormhole.getWormholeConfigFields().setWormholeEntryLocation(this.location, this.wormholeNumber);
        if (this.persistentObjectHandler != null) {
            this.persistentObjectHandler.remove();
        }
        this.persistentObjectHandler = new PersistentObjectHandler(this);
    }

    public void tick(List<Player> nearbyPlayers) {
        if (this.isProcessingChunkEvent) {
            return;
        }
        if (this.location == null || this.location.getWorld() == null || !ChunkLocationChecker.chunkAtLocationIsLoaded(this.location)) {
            return;
        }
        if (!(this.armorStandText == null || this.textDisplay != null && this.textDisplay.isValid())) {
            this.initializeTextDisplay();
        }
        if (!WormholesConfig.isNoParticlesMode() && this.wormhole.getWormholeConfigFields().getStyle() != Wormhole.WormholeStyle.NONE && this.anyPlayerHasLineOfSight(nearbyPlayers)) {
            this.updateVisualEffects();
        }
    }

    private boolean anyPlayerHasLineOfSight(List<Player> players) {
        if (players.isEmpty() || this.location == null || this.location.getWorld() == null) {
            return false;
        }
        World world = this.location.getWorld();
        for (Player player : players) {
            Location playerEyes = player.getEyeLocation();
            Vector direction = this.location.toVector().subtract(playerEyes.toVector());
            double distance = direction.length();
            if (distance < 0.1) {
                return true;
            }
            direction.normalize();
            RayTraceResult result = world.rayTraceBlocks(playerEyes, direction, distance, FluidCollisionMode.NEVER, true);
            if (result != null) continue;
            return true;
        }
        return false;
    }

    public void initializeTextDisplay() {
        if (this.armorStandText == null) {
            return;
        }
        if (this.location == null || this.location.getWorld() == null) {
            return;
        }
        try {
            this.textDisplay = (TextDisplay)this.location.getWorld().spawn(this.location.clone().add(new Vector(0.0, 1.2, 0.0).multiply(this.wormhole.getWormholeConfigFields().getSizeMultiplier())), TextDisplay.class, (Consumer)((org.bukkit.util.Consumer)textDisplay -> {
                textDisplay.setBillboard(Display.Billboard.VERTICAL);
                textDisplay.setText(ChatColorConverter.convert(this.armorStandText));
                textDisplay.setPersistent(false);
            }));
        }
        catch (Exception e) {
            this.textDisplay = null;
        }
    }

    private void updateVisualEffects() {
        List<List<Vector>> cachedRotations = this.wormhole.getCachedRotations();
        if (cachedRotations.isEmpty()) {
            return;
        }
        if (this.rotationIndex >= cachedRotations.size()) {
            this.rotationIndex = 0;
        }
        this.updateLines(cachedRotations.get(this.rotationIndex));
        ++this.particleTickCounter;
        if (this.particleTickCounter >= 5) {
            this.spawnMinimalParticles(cachedRotations.get(this.rotationIndex));
            this.particleTickCounter = 0;
        }
        ++this.rotationIndex;
    }

    private void clearNearbyDisplayBlocks() {
        if (this.location == null || this.location.getWorld() == null) {
            return;
        }
        World world = this.location.getWorld();
        double clearRadius = 5.0 * this.wormhole.getWormholeConfigFields().getSizeMultiplier();
        world.getNearbyEntities(this.location, clearRadius, clearRadius, clearRadius).stream().filter(entity -> entity instanceof Display).filter(entity -> !entity.equals((Object)this.textDisplay)).forEach(entity -> {
            Display display = (Display)entity;
            if (display instanceof BlockDisplay) {
                display.remove();
            }
        });
    }

    private void updateLines(List<Vector> currentFrame) {
        boolean needsRecreation;
        if (currentFrame.size() < 2) {
            return;
        }
        World world = this.location.getWorld();
        if (world == null) {
            return;
        }
        boolean bl = needsRecreation = !this.linesInitialized || this.cachedEdges == null || this.areLinesDeleted();
        if (needsRecreation) {
            if (System.currentTimeMillis() - this.lastLinesClearTime < 500L) {
                return;
            }
            if (!this.lineDataList.isEmpty()) {
                this.clearLines();
                return;
            }
            this.clearNearbyDisplayBlocks();
            this.concreteColor = this.getConcreteColorForWormhole();
            this.cachedEdges = this.getEdgesForShape(currentFrame);
            try {
                for (long edge : this.cachedEdges) {
                    Location loc2;
                    int p1 = (int)(edge >>> 32);
                    int p2 = (int)(edge & 0xFFFFFFFFL);
                    if (p1 >= currentFrame.size() || p2 >= currentFrame.size()) continue;
                    Vector v1 = currentFrame.get(p1);
                    Vector v2 = currentFrame.get(p2);
                    Location loc1 = this.location.clone().add(v1);
                    DrawLine.LineData line = DrawLine.drawLine(loc1, loc2 = this.location.clone().add(v2), 0.04f, this.concreteColor, -1);
                    if (line == null) continue;
                    this.lineDataList.add(line);
                }
                this.linesInitialized = true;
            }
            catch (Exception e) {
                this.clearLines();
                return;
            }
        } else {
            int lineIndex = 0;
            for (long edge : this.cachedEdges) {
                int p1 = (int)(edge >>> 32);
                int p2 = (int)(edge & 0xFFFFFFFFL);
                if (p1 >= currentFrame.size() || p2 >= currentFrame.size()) continue;
                if (lineIndex >= this.lineDataList.size()) break;
                Vector v1 = currentFrame.get(p1);
                Vector v2 = currentFrame.get(p2);
                Location loc1 = this.location.clone().add(v1);
                Location loc2 = this.location.clone().add(v2);
                DrawLine.LineData line = this.lineDataList.get(lineIndex);
                if (line != null) {
                    DrawLine.updateLine(line, loc1, loc2);
                }
                ++lineIndex;
            }
        }
    }

    private boolean areLinesDeleted() {
        if (this.lineDataList.isEmpty()) {
            return true;
        }
        if (this.location == null || this.location.getWorld() == null || !ChunkLocationChecker.chunkAtLocationIsLoaded(this.location)) {
            return true;
        }
        for (DrawLine.LineData line : this.lineDataList) {
            if (line != null && line.getDisplay().isValid()) continue;
            return true;
        }
        return false;
    }

    private void spawnMinimalParticles(List<Vector> currentFrame) {
        World world = this.location.getWorld();
        if (world == null) {
            return;
        }
        int particleInterval = Math.max(1, currentFrame.size() / 8);
        for (int i = 0; i < currentFrame.size(); i += particleInterval) {
            Vector v = currentFrame.get(i);
            Location particleLoc = this.location.clone().add(v);
            world.spawnParticle(Particle.DUST, particleLoc, 1, 0.25, 0.25, 0.25, 0.0, (Object)new Particle.DustOptions(this.wormhole.getParticleColor(), 0.5f));
        }
    }

    private long[] getEdgesForShape(List<Vector> allPoints) {
        Wormhole.WormholeStyle style = this.wormhole.getWormholeConfigFields().getStyle();
        double sizeMultiplier = this.wormhole.getWormholeConfigFields().getSizeMultiplier();
        switch (style) {
            case CUBE: {
                return this.getCubeEdges(allPoints, sizeMultiplier);
            }
            case CRYSTAL: {
                return this.getCrystalEdges(allPoints, sizeMultiplier);
            }
            case ICOSAHEDRON: {
                return this.getIcosahedronEdges(allPoints, sizeMultiplier);
            }
        }
        return new long[0];
    }

    private long[] getCubeEdges(List<Vector> allPoints, double sizeMultiplier) {
        HashSet<Long> edgeSet = new HashSet<Long>();
        double tolerance = 0.1 * sizeMultiplier;
        Integer topIdx = this.findVertexIndex(allPoints, new Vector(0, 1, 0).multiply(sizeMultiplier), tolerance);
        Integer bottomIdx = this.findVertexIndex(allPoints, new Vector(0, -1, 0).multiply(sizeMultiplier), tolerance);
        Integer frontIdx = this.findVertexIndex(allPoints, new Vector(1, 0, 0).multiply(sizeMultiplier), tolerance);
        Integer sideIdx = this.findVertexIndex(allPoints, new Vector(0, 0, 1).multiply(sizeMultiplier), tolerance);
        Integer backIdx = this.findVertexIndex(allPoints, new Vector(-1, 0, 0).multiply(sizeMultiplier), tolerance);
        Integer leftIdx = this.findVertexIndex(allPoints, new Vector(0, 0, -1).multiply(sizeMultiplier), tolerance);
        if (topIdx != null && frontIdx != null) {
            edgeSet.add(WormholeEntry.encodeEdge(topIdx, frontIdx));
        }
        if (bottomIdx != null && frontIdx != null) {
            edgeSet.add(WormholeEntry.encodeEdge(bottomIdx, frontIdx));
        }
        if (frontIdx != null && sideIdx != null) {
            edgeSet.add(WormholeEntry.encodeEdge(frontIdx, sideIdx));
        }
        if (topIdx != null && backIdx != null) {
            edgeSet.add(WormholeEntry.encodeEdge(topIdx, backIdx));
        }
        if (bottomIdx != null && backIdx != null) {
            edgeSet.add(WormholeEntry.encodeEdge(bottomIdx, backIdx));
        }
        if (backIdx != null && leftIdx != null) {
            edgeSet.add(WormholeEntry.encodeEdge(backIdx, leftIdx));
        }
        if (frontIdx != null && leftIdx != null) {
            edgeSet.add(WormholeEntry.encodeEdge(frontIdx, leftIdx));
        }
        if (topIdx != null && sideIdx != null) {
            edgeSet.add(WormholeEntry.encodeEdge(topIdx, sideIdx));
        }
        if (topIdx != null && leftIdx != null) {
            edgeSet.add(WormholeEntry.encodeEdge(topIdx, leftIdx));
        }
        if (bottomIdx != null && sideIdx != null) {
            edgeSet.add(WormholeEntry.encodeEdge(bottomIdx, sideIdx));
        }
        if (bottomIdx != null && leftIdx != null) {
            edgeSet.add(WormholeEntry.encodeEdge(bottomIdx, leftIdx));
        }
        if (frontIdx != null && backIdx != null) {
            edgeSet.add(WormholeEntry.encodeEdge(frontIdx, backIdx));
        }
        if (sideIdx != null && leftIdx != null) {
            edgeSet.add(WormholeEntry.encodeEdge(sideIdx, leftIdx));
        }
        return edgeSet.stream().mapToLong(Long::longValue).toArray();
    }

    private long[] getCrystalEdges(List<Vector> allPoints, double sizeMultiplier) {
        HashSet<Long> edgeSet = new HashSet<Long>();
        double tolerance = 0.1 * sizeMultiplier;
        Integer topIdx = this.findVertexIndex(allPoints, new Vector(0, 1, 0).multiply(sizeMultiplier), tolerance);
        Integer bottomIdx = this.findVertexIndex(allPoints, new Vector(0, -1, 0).multiply(sizeMultiplier), tolerance);
        Integer frontIdx = this.findVertexIndex(allPoints, new Vector(0.5, 0.0, 0.0).multiply(sizeMultiplier), tolerance);
        Integer sideIdx = this.findVertexIndex(allPoints, new Vector(0.0, 0.0, 0.5).multiply(sizeMultiplier), tolerance);
        if (topIdx != null && frontIdx != null) {
            edgeSet.add(WormholeEntry.encodeEdge(topIdx, frontIdx));
        }
        if (bottomIdx != null && frontIdx != null) {
            edgeSet.add(WormholeEntry.encodeEdge(bottomIdx, frontIdx));
        }
        if (frontIdx != null && sideIdx != null) {
            edgeSet.add(WormholeEntry.encodeEdge(frontIdx, sideIdx));
        }
        Integer backIdx = this.findVertexIndex(allPoints, new Vector(-0.5, 0.0, 0.0).multiply(sizeMultiplier), tolerance);
        Integer leftIdx = this.findVertexIndex(allPoints, new Vector(0.0, 0.0, -0.5).multiply(sizeMultiplier), tolerance);
        if (topIdx != null && backIdx != null) {
            edgeSet.add(WormholeEntry.encodeEdge(topIdx, backIdx));
        }
        if (bottomIdx != null && backIdx != null) {
            edgeSet.add(WormholeEntry.encodeEdge(bottomIdx, backIdx));
        }
        if (backIdx != null && leftIdx != null) {
            edgeSet.add(WormholeEntry.encodeEdge(backIdx, leftIdx));
        }
        if (frontIdx != null && leftIdx != null) {
            edgeSet.add(WormholeEntry.encodeEdge(frontIdx, leftIdx));
        }
        if (topIdx != null && sideIdx != null) {
            edgeSet.add(WormholeEntry.encodeEdge(topIdx, sideIdx));
        }
        if (topIdx != null && leftIdx != null) {
            edgeSet.add(WormholeEntry.encodeEdge(topIdx, leftIdx));
        }
        if (bottomIdx != null && sideIdx != null) {
            edgeSet.add(WormholeEntry.encodeEdge(bottomIdx, sideIdx));
        }
        if (bottomIdx != null && leftIdx != null) {
            edgeSet.add(WormholeEntry.encodeEdge(bottomIdx, leftIdx));
        }
        if (frontIdx != null && backIdx != null) {
            edgeSet.add(WormholeEntry.encodeEdge(frontIdx, backIdx));
        }
        if (sideIdx != null && leftIdx != null) {
            edgeSet.add(WormholeEntry.encodeEdge(sideIdx, leftIdx));
        }
        return edgeSet.stream().mapToLong(Long::longValue).toArray();
    }

    private long[] getIcosahedronEdges(List<Vector> allPoints, double sizeMultiplier) {
        int i;
        HashSet<Long> edgeSet = new HashSet<Long>();
        double tolerance = 0.2 * sizeMultiplier;
        Integer topIdx = this.findVertexIndex(allPoints, new Vector(0, 1, 0).multiply(sizeMultiplier), tolerance);
        Integer bottomIdx = this.findVertexIndex(allPoints, new Vector(0, -1, 0).multiply(sizeMultiplier), tolerance);
        ArrayList<Integer> topPentagonIndices = new ArrayList<Integer>();
        ArrayList<Integer> bottomPentagonIndices = new ArrayList<Integer>();
        Vector topOffset = new Vector(1.0, 0.5, 0.0).multiply(sizeMultiplier);
        Vector bottomOffset = new Vector(1.0, -0.5, 0.0).multiply(sizeMultiplier);
        bottomOffset.rotateAroundY(0.6283185307179586);
        for (i = 0; i < 5; ++i) {
            Vector topVec = topOffset.clone().rotateAroundY(1.2566370614359172 * (double)i);
            Vector bottomVec = bottomOffset.clone().rotateAroundY(1.2566370614359172 * (double)i);
            Integer topPentIdx = this.findVertexIndex(allPoints, topVec, tolerance);
            Integer bottomPentIdx = this.findVertexIndex(allPoints, bottomVec, tolerance);
            if (topPentIdx != null) {
                topPentagonIndices.add(topPentIdx);
            }
            if (bottomPentIdx == null) continue;
            bottomPentagonIndices.add(bottomPentIdx);
        }
        if (topIdx != null) {
            for (Integer pentIdx : topPentagonIndices) {
                edgeSet.add(WormholeEntry.encodeEdge(topIdx, pentIdx));
            }
        }
        if (bottomIdx != null) {
            for (Integer pentIdx : bottomPentagonIndices) {
                edgeSet.add(WormholeEntry.encodeEdge(bottomIdx, pentIdx));
            }
        }
        for (i = 0; i < topPentagonIndices.size(); ++i) {
            int next = (i + 1) % topPentagonIndices.size();
            edgeSet.add(WormholeEntry.encodeEdge((Integer)topPentagonIndices.get(i), (Integer)topPentagonIndices.get(next)));
        }
        for (i = 0; i < bottomPentagonIndices.size(); ++i) {
            int next = (i + 1) % bottomPentagonIndices.size();
            edgeSet.add(WormholeEntry.encodeEdge((Integer)bottomPentagonIndices.get(i), (Integer)bottomPentagonIndices.get(next)));
        }
        for (i = 0; i < Math.min(topPentagonIndices.size(), bottomPentagonIndices.size()); ++i) {
            edgeSet.add(WormholeEntry.encodeEdge((Integer)topPentagonIndices.get(i), (Integer)bottomPentagonIndices.get(i)));
            if (i + 1 >= topPentagonIndices.size() - 1) continue;
            edgeSet.add(WormholeEntry.encodeEdge((Integer)topPentagonIndices.get(i + 1), (Integer)bottomPentagonIndices.get(i)));
        }
        if (!topPentagonIndices.isEmpty() && !bottomPentagonIndices.isEmpty()) {
            edgeSet.add(WormholeEntry.encodeEdge((Integer)topPentagonIndices.get(0), (Integer)bottomPentagonIndices.get(4 % bottomPentagonIndices.size())));
        }
        return edgeSet.stream().mapToLong(Long::longValue).toArray();
    }

    private Integer findVertexIndex(List<Vector> points, Vector target, double tolerance) {
        for (int i = 0; i < points.size(); ++i) {
            if (!(points.get(i).distance(target) <= tolerance)) continue;
            return i;
        }
        return null;
    }

    private void clearLines() {
        for (DrawLine.LineData line : this.lineDataList) {
            if (line == null) continue;
            line.remove();
        }
        this.lineDataList.clear();
        this.linesInitialized = false;
        this.cachedEdges = null;
        this.lastLinesClearTime = System.currentTimeMillis();
    }

    private Material getConcreteColorForWormhole() {
        Color wormholeColor = this.wormhole.getParticleColor();
        int targetRGB = wormholeColor.getRed() << 16 | wormholeColor.getGreen() << 8 | wormholeColor.getBlue();
        int closestIndex = 0;
        double minDistance = Double.MAX_VALUE;
        for (int i = 0; i < CONCRETE_RGB_VALUES.length; ++i) {
            int concreteRGB = CONCRETE_RGB_VALUES[i];
            double distance = this.colorDistance(targetRGB, concreteRGB);
            if (!(distance < minDistance)) continue;
            minDistance = distance;
            closestIndex = i;
        }
        return CONCRETE_COLORS_BY_RGB[closestIndex];
    }

    private double colorDistance(int rgb1, int rgb2) {
        int r1 = rgb1 >> 16 & 0xFF;
        int g1 = rgb1 >> 8 & 0xFF;
        int b1 = rgb1 & 0xFF;
        int r2 = rgb2 >> 16 & 0xFF;
        int g2 = rgb2 >> 8 & 0xFF;
        int b2 = rgb2 & 0xFF;
        int dr = r1 - r2;
        int dg = g1 - g2;
        int db = b1 - b2;
        return Math.sqrt(dr * dr + dg * dg + db * db);
    }

    @Generated
    public static Set<WormholeEntry> getWormholeEntries() {
        return wormholeEntries;
    }

    @Generated
    public Wormhole getWormhole() {
        return this.wormhole;
    }

    @Generated
    public Location getLocation() {
        return this.location;
    }

    @Generated
    public String getLocationString() {
        return this.locationString;
    }

    @Generated
    public String getArmorStandText() {
        return this.armorStandText;
    }

    @Generated
    public String getPortalMissingMessage() {
        return this.portalMissingMessage;
    }

    @Generated
    public void setPortalMissingMessage(String portalMissingMessage) {
        this.portalMissingMessage = portalMissingMessage;
    }

    @Generated
    public String getOpMessage() {
        return this.opMessage;
    }

    @Generated
    public void setOpMessage(String opMessage) {
        this.opMessage = opMessage;
    }
}

